/*
    Correct in header of .EXE file MaxMemory == MinMemory

    Usage : MAXeqMIN.EXE filename.EXE

    Compile:
        bcc -ms -v- -d -O1 MAXeqMIN.C

    13-11-98 02:05:58 (c) Tornado
*/

#include <stdio.h>
#include <stdlib.h>

void fatal( char *name ) { perror( name ); exit(1); }

int  main( int argc, char *argv[] ) {
	int ch1, ch2;
	FILE *f;

    if ( argc != 2 )
        printf( "Correct in header of .EXE file MaxMemory == MinMemory\n"
                "Usage : MAXeqMIN.EXE filename\n" );
    else {

        f = fopen( argv[1], "r+b" );

        if (!f) fatal( argv[1] );

        if ( fseek( f, 0x0, SEEK_SET ) == -1L )     fatal( argv[1] );

        ch1 = fgetc( f );  ch2 = fgetc( f );

        if (!( (ch1 == 'M' && ch2 == 'Z') || (ch1 == 'Z' && ch2 == 'M')) )
            fatal( "Error format .EXE file !" );

        if ( fseek( f, 0x0A, SEEK_SET ) == -1L )
            fatal( argv[1] );

		ch1 = fgetc( f );
		ch2 = fgetc( f );

        if ( fseek( f, 0x0C, SEEK_SET ) == -1L )    fatal( argv[1] );

        if ( fputc( ch1, f ) == EOF || fputc( ch2, f ) == EOF )
            fatal( "Error write to file !" );

        fclose(f);
        printf( "%s : Correct Ok!\n", argv[1] );
	}
    return 0;
}
