/* -- File:     example.c                                                   *
   --                                                                       *
   -- Author:   Anthony Lander                                              *
   -- Date:     January 10, 1989.                                           *
   --                                                                       *
   -- Description:                                                          *
   --           This is a small example program which uses the linked list  *
   --           functions in LINE.C.  It creates a set of text lines, and   *
   --           joins them together in a linked list.  It then demonstrates *
   --           the sort of manipulations possible with the LINE.C library. *
   --                                                                       */


   
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>

#include "f_prot.h"
#include "line.h"
























void main()
{
                            /* First, delcare some pointers of type _line   */
    struct  _line *cur_line, *tmp_line;
    char    txt[90];
    int     x;


    /* Start of by creating 20 lines, and adding them to the end of the list */

    for(x = 1; x <= 20; x++)  {
        cur_line = get_new_line();      /* Get space to a ptr to line       */

        if(cur_line == NULL)  {     /* If no space, then stop allocating    */
            break;                  /* having <20 lines makes no difference */
        }

            /* Now create a line of text, and allocate space for it         */
        sprintf(txt, "This is line number %d", x);
        cur_line->string = malloc(strlen(txt)+1);

            /* place a copy in line->string, and save the length            */
        strcpy(cur_line->string, txt);
        cur_line->length = strlen(txt);

            /* -- To add cur_line to the end of the list, we first have to  *
               -- figure out where the end of the list is!  That's done     *
               -- with a call to get_last_line().                           *
               --
               -- No matter what get_last_line() returns (NULL or otherwise)*
               -- it's a valid value, so we don't have to check to see that *
               -- any of the list already exists                            */
        tmp_line = get_last_line();

            /* Now add cur_line to the end of the list.                     */
        insert_after_line(cur_line, tmp_line);
     }


    /* -------------------------------------------------------------------- */
    /* OK, let's list all of the elements in the list (forwards, first)     */

    puts("\n\nAll the elements, listed forwards:\n");
    cur_line = get_first_line();        /* get the first line               */

    /* -- The while() makes sure that we go until we're at the end of the   *
       -- list                                                              */

    while(cur_line != NULL)  {
        printf("%s, len=%d\n", cur_line->string, cur_line->length);

        /* -- This is an important line, it sets cur_line to point to the   *
           -- element that follows it.  Pay close attention <grin>          */

        cur_line = (cur_line->next_line);
    }

    printf("\n      Press any key to continue...");
    getch();


    /* -------------------------------------------------------------------- */
    /* -- List everything backwards.  This is the same as the above while() *
       -- except that we go                                                 *
       --                       cur_line = (cur_line->prev_line);           *
       --       instead of      cur_line = (cur_line->prev_line);           *
       --                                                                   */
 
    puts("\n\nAll the elements, listed in reverse:\n");
    cur_line = get_last_line();         /* get the LAST line this time      */

    while(cur_line != NULL)  {
        printf("%s, len=%d\n", cur_line->string, cur_line->length);

        cur_line = (cur_line->prev_line);
            /*                ^^^^                                          */
    }

    printf("\n      Press any key to continue...");
    getch();

    /* -------------------------------------------------------------------- */
    /* -- Now let's delete the first line, and move the last line to be     *
       -- the new first line (kid's stuff)                                  */

    cur_line = get_first_line();
    delete_line(cur_line);

    cur_line = get_last_line();
    tmp_line = get_first_line();

    move_before_line(cur_line, tmp_line);

    /* now here's the list again... */

    puts("\n\nFirst line deleted, last line moved to first position:\n");
    cur_line = get_first_line();        /* get the first line               */

    while(cur_line != NULL)  {
        printf("%s, len=%d\n", cur_line->string, cur_line->length);

        cur_line = (cur_line->next_line);
    }

    printf("\n      Press any key to continue...");
    getch();

    /* -------------------------------------------------------------------- */
    /* -- ok, now let's delete all lines, and list again                    */

    delete_all_lines();

    puts("\n\nAll lines deleted:\n");
    cur_line = get_first_line();        /* get the first line               */

    while(cur_line != NULL)  {
        printf("%s, len=%d\n", cur_line->string, cur_line->length);

        cur_line = (cur_line->next_line);
    }

    printf("\n      End of demonstration, Press any key to continue...");
    getch();
}

