//////////////////////////////////////////////////////////
//                                                      //
//           ******************************             //
//           ****  Browning's Classes  ****             //
//           ******************************             //
//                                                      //
//                  Class DL_3.Hpp                      //
//                                                      //
//       Public Domain           Roy G. Browning        //
//       December 1989           The Fulcrum's Edge     //
//                                                      //
//       Zortech C/C++           version 2.01           //
//                                                      //
//       Ztc -o -mti DL_3                               //
//                                                      //
//       Initiated               05-01-1989             //
//////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////
//                                                      //
//                   Charity Request                    //
//                                                      //
//       If benefit is derived in any fashion from      //
//       this public code it is requested that a        //
//       donation be made to a children's charity       //
//       if sufficient funds are available.             //
//                                                      //
//////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////
//                                                      //
//                  C++ing How Series                   //
//                                                      //
//////////////////////////////////////////////////////////

#include <stream.hpp>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>

#define MAXFILES 2048

extern "C" {
            extern int Cmp_FileName(const FIND **p1,
                                    const FIND **p2);
            extern int Cmp_FileExt(const FIND **p1,
                                   const FIND **p2);
            extern int Cmp_FileDate(const FIND **p1,
                                    const FIND **p2);
            extern int Cmp_FileSize(const FIND **p1,
                                    const FIND **p2);
           };

extern void First_Object();
extern void Second_Object();
extern void Third_Object();
extern void Fourth_Object();

enum logic {
            error = (-1),
            false,
            true
           };

enum numbers {
              minusone = (-1),
              zero,
              one,
              two,
              three,
              four,
              five,
              six,
              seven,
              eight,
              nine,
              ten,
              eleven,
              twelve
             };

// Directory entry attributes

//      FA_RDONLY      0x01
//      FA_HIDDEN      0x02
//      FA_SYSTEM      0x04
//      FA_LABEL       0x08
//      FA_DIREC       0x10
//      FA_ARCH        0x20


//////////////////////////////////////////////////////////
//                                                      //
//                   Class FileList                     //
//                                                      //
//       Reads and stores a disk directory in an        //
//       array of structure pointers.  The default      //
//       arguments are used if none are specified       //
//       when the class is created.                     //
//                                                      //
//       If `num_files' equals minus one an error       //
//       occurred.                                      //
//                                                      //
//       Element()  returns a reference to the          //
//                  element number indicated            //
//                  by the index passed                 //
//                                                      //
//       FileName_Match()     returns a pointer to      //
//                            an index array of         //
//                            matching directory        //
//                            FileNames                 //
//                                                      //
//       Number()   returns the number of files         //
//                  listed                              //
//                                                      //
//       Print()    prints a formatted directory        //
//                  listing to the stdout (display)     //
//                                                      //
//////////////////////////////////////////////////////////

class FileList {

protected:

     int num_files;
     int *match_numbers;
     int match_numbers_allocated;

     FIND **F;

public:

     FileList(const char* name = "*.*",
              const int attrib = zero);

     ~FileList();

     FIND& Element(const int i) const { return *F[i]; }

     int* FileName_Match(char* string = NULL) const;

     int Number() const { return num_files; } 

     void Print() const;
};

//////////////////////////////////////////////////////////
//                                                      //
//                   Class FileName                     //
//                                                      //
//       "Derived" from FileList which is con-          //
//       structed prior to sorting the directory        //
//       listing via File Names.  The default argu-     //
//       ments are used if none are given.              //
//                                                      //
//////////////////////////////////////////////////////////

class FileName : public FileList {

public:

     FileName(const char* = "*.*", const int = zero);

     ~FileName() {}
};

//////////////////////////////////////////////////////////
//                                                      //
//                   Class FileSize                     //
//                                                      //
//       "Derived" from FileList which is con-          //
//       structed prior to sorting the directory        //
//       listing via File Size.  The default argu-      //
//       ments are used if none are given.              //
//                                                      //
//////////////////////////////////////////////////////////

class FileSize : public FileList {

public:

     FileSize(const char* = "*.*", const int = zero);

     ~FileSize() {}
};

//////////////////////////////////////////////////////////
//                                                      //
//                   Class FileDate                     //
//                                                      //
//       "Derived" from FileList which is con-          //
//       structed prior to sorting the directory        //
//       listing via File Dates.  The default argu-     //
//       ments are used if none are given.              //
//                                                      //
//////////////////////////////////////////////////////////

class FileDate : public FileList {

public:

     FileDate(const char* = "*.*", const int = zero);

     ~FileDate() {}
};

//////////////////////////////////////////////////////////
//                                                      //
//                   Class FileExt                      //
//                                                      //
//       "Derived" from FileList which is con-          //
//       structed prior to sorting the directory        //
//       listing via File Extensions.  The default      //
//       arguments are used if none are given.          //
//                                                      //
//////////////////////////////////////////////////////////

class FileExt : public FileList {

public:

     FileExt(const char* = "*.*", const int = zero);

     ~FileExt() {}
};

