/*
**  C S R . H
**
**  Header file for use with the C Spot Run Library.
**
**  Copyright 1988 Bob Pritchett, New Dimension Software.
**
**  History:
**
**  07/10/88 RDP Modifications for Turbo C v1.5.
**
**  06/28/88 RDP Created and function declarations added.
**
*/

/* ----------------- Include Files ---------------------- */

#include "csrmenu.h"

/* ----------------- Argument Definitions --------------- */

#define SLOW	    8
#define FAST	    1

#define REPLACE     1
#define ERASE	    0

#define SCROLL_UP   0
#define SCROLL_DOWN 1

#define WL_CENTER   0
#define WL_LEFT     1
#define WL_RIGHT    2

#define WM_UP	    1
#define WM_RIGHT    2
#define WM_DOWN     3
#define WM_LEFT     4

/* ----------------- Multiple Compiler Support Stuff ---- */ 

#ifdef M_I86LM
#define LARGE	1
#endif

#ifdef M_I86CM
#define LARGE	1
#endif

#ifdef __COMPACT__
#define LARGE	1
#endif

#ifdef __LARGE__
#define LARGE	1
#endif

#ifdef __TURBOC__

#define inp(p)		inportb(p)
#define outp(p,b)	outportb(p,b)

#endif

/* ----------------- Function Declarations -------------- */

void beep( void );
void border( int );
void box( int, int, int, int, int );
int cbcapt( int * );
void cbox( int, int, int, int, int );
int cbrest( void );
void ccenter( int, char *, int );
int ccls( int );
void ccputs( char *, int );
void center( int, char * );
void centerf( int, char *, ... );
int cfield( int, int, int );
int chk_date( int, int, int );
void chline( int, int, int, int );
void clreol( void );
int cls( void );
int color( int );
int current_page( void );
void cursor_off( void );
void cursor_on( void );
void cursor_read( int *, int * );
void cursor_size( int, int );
void cvline( int, int, int, int );
unsigned int date_sn( int, int, int );
void dirwin( char *, char * );
void dma( int );
int dt_diff( int, int, int, int, int, int );
void fbreakon( int );
int fchar( int );
int fcolor( int );
void ffill( int, int, int );
int ffirst( char *, char *, char *, int );
int fnext( char *, char *, char *, int );
int finptint( int, int, int, int * );
int finptintd( int, int, int, int *, int );
int finptintr( int, int, int, int *, int, int );
int finptintrd( int, int, int, int *, int, int, int );
char *finptstr( int, int, int, char * );
char *finptstrd( int, int, int, char *, char * );
void finptstre( int, int, int, char * );
int finptstred( int, int, int, char *, char * );
int finptyn( int, int );
int finptynd( int, int, int );
void fixcolor( int * );
int gback( int );
void gbox( int, int, int, int, int );
void gcircle( int, int, int, int );
int gdot( int, int, int );
void get_date( int *, int *, int * );
int get_dow( void );
int get_drive( void );
int get_mode( void );
int getpw( char * );
void get_time( int *, int *, int *, int * );
long get_timer( void );
void gfbox( int, int, int, int, int );
int ginit( void );
void gline( int, int, int, int, int );
int gotoxy( int, int );
int gpal( int );
void init_tmr( void );
int inptint( char * );
int inptintd( char *, int );
int inptintr( char *, int, int );
int inptintrd( char *, int, int, int );
char *inptstr( char * );
char *inptstrd( char *, char * );
int inptyn( char * );
int inptynd( char *, int );
int isleap( int );
int istemplate( char * );
char *itofa( int, char * );
void lprint( char * );
void lprintf( char *, ... );
void lputchar( int );
char *ltofa( long, char * );
int match( char, char, int );
void mcolor( int, int );
int message( char *, int );
void month_day( int, int, int *, int * );
int num_days( int, int );
int num_drives( void );
int play( char * );
void pmclose( int );
void pmcolor( int, int, int );
int pmenu( MENU );
void pmfunc( );
int pmopen( int, int, char *, int, char *[], int );
int pmrun( int );
int pop_menu( int, int, int, char *, char *, int );
void print_screen( void );
int prtrns( int );
void putat( int, int, char * );
void putatf( int, int, char *, ... );
int putchc( int, int );
int putchci( int, int );
unsigned read_tmr( int );
void reset_tmr( int );
void restore( int, int, int, int, char * );
void restore_cursor( int );
void restore_screen( void );
void retrace( int );
void save( int, int, int, int, char * );
int save_cursor( void );
void save_screen( void );
void scroll( int, int, int, int, int, int, int );
void setbeep( int, int );
int set_date( int, int, int );
void set_drive( int );
void set_mode( int );
void set_time( int, int, int, int );
void sndout( void );
void sndsetint( void );
void sndrstint( void );
unsigned int sn_date( unsigned int, int *, int *, int * );
#ifndef __TURBOC__
void sound( long, long );
#endif
void sound_done( void );
void sound_init( void );
int sound_left( void );
void sound_quiet( void );
int soundex( char *, char * );
void spkr_freq( long );
void spkr_off( void );
void spkr_on( void );
void start_tmr( int );
unsigned stop_tmr( int );
char *strcen( char *, char *, int );
char *strght( char *, char *, int );
char *strlft( char *, char *, int );
int strtrm( char *, char * );
int timer( void );
unsigned int valid_date( int, int, int );
int vidblt( int, int, int, int, int );
int wactivate( int );
int wait_hs( int );
void wblank( int, int );
int wborder( int, int );
void wcenter( int, int, char * );
void wcenterf( int, int, char *, ... );
int wclose( int );
void wcloseall( void );
void wcls( int );
int wcol( int );
void wcolor( int, int );
int wdelete( int, int, int );
void wfbreakon( int );
int wfchar( int );
int wfcolor( int );
void wffill( int, int, int, int );
int wfinptint( int, int, int, int, int * );
int wfinptintd( int, int, int, int, int *, int );
int wfinptintr( int, int, int, int, int *, int, int );
int wfinptintrd( int, int, int, int, int *, int, int, int );
char *wfinptstr( int, int, int, int, char * );
char *wfinptstrd( int, int, int, int, char *, char * );
void wfinptstre( int, int, int, int, char * );
char *wfinptstred( int, int, int, int, char *, char * );
int wfinptyn( int, int, int );
int wfinptynd( int, int, int, int );
void wfreeze( int, int, int );
void wgotoxy( int, int, int );
void whline( int, int );
void whome( int );
int winptint( int, char * );
int winptintd( int, char *, int );
int winptintr( int, char *, int, int );
int winptintrd( int, char *, int, int, int );
char *winptstr( int, char * );
char *winptstrd( int, char *, char * );
int winptyn( int, char * );
int winptynd( int, char *, int );
int winsert( int, int, int );
void wjump( int, int, int );
void wmessage( int, char *, int );
void wmove( int, int );
int wopen( int, int, int, int, int );
int wprint( int, char * );
void wprintc( int, char *, int );
void wprintf( int, char *, ... );
void wputat( int, int, int, char * );
void wputatf( int, int, int, char *, ... );
void wputchar( int, int );
int wrow( int );
void wscolor( int, int, int );
void wscroll( int, int, int );
void wtitle( int, char *, int );
void wvline( int, int );
void zero_tmr( int );
