;   This include file should be placed immediately after the .STARTUP
;statement.  The code resizes the memory block into which DOS loaded the
;program so that DOS memory will be freed for allocation by XLIB.  The
;code assumes that SS:SP points to the end of the program.  This will be
;the case under both MASM and TASM if FARSTACK is used as a modifier to
;the .MODEL statement.  This file is not necessary under MASM if LINK
;is used with the CPARM:1 parameter.

               MOV            AX,SP          ;SS:SP = end of program
               SHR            AX,4
               MOV            BX,SS
               ADD            BX,AX
               INC            BX             ;BX = first para. beyond program
               MOV            AX,ES          ;ES:0000 = first para. of program
               SUB            BX,AX          ;BX = program size in para.
               MOV            AH,4AH         ;Function to resize memory block
               INT            21H            ;Carry will be set if failure
               JNC            RESIZED
               PUSH           CS             ;Print error message
               POP            DS
               MOV            BX,0007H
               MOV            SI,OFFSET RESIZEFAILMSG
               MOV            AH,0EH
RESIZEMSGLOOP: MOV            AL,[SI]
               OR             AL,AL
               JZ             RESIZESTOP
               INT            10H
               INC            SI
               JMP            RESIZEMSGLOOP
RESIZESTOP:    MOV            AX,4C01H      ;Terminate
               INT            21H
RESIZEFAILMSG:
               DB "Error: DOS cannot resize program memory block.",13,10,0
RESIZED:
