/***************************************************************************
*   emstest.h                                                              *
*   HEADER FOR tester for EMSIF                                            *
*   OS:      DOS                                                           *
*   VERSION: 1.1                                                           *
*   DATE:    12/01/91                                                      *
*                                                                          *
*   Copyright (c) 1991 James W. Birdsall. All Rights Reserved.             *
*                                                                          *
*   Compiles under Borland C++ 2.0, TC 2.0, and MSC 6.00A.                 *
*                                                                          *
*   Header file for EMSTEST.                                               *
*                                                                          *
***************************************************************************/

#ifndef EMSIF_H
    **** ERROR **** MUST INCLUDE EMSIF.H BEFORE EMSTEST.H
#endif

#ifndef EMSTEST_H
#define EMSTEST_H

/*
** system includes <>
*/

/*
** custom includes ""
*/

/*
** local #defines
*/

/* at least 8 EMS pages must be free for all tests to be performed */
#define MINFREE          8L

/* header and trailer messages for each test */
#define TESTHEADER()     printf(">>>TEST #%d: %s\n", testno++, gblmsg)
#define TESTTAILER()     printf("Test passed.\n")

/*
** This macro is for return checking for functions which are expected
** to succeed. It makes function calls to check if
**      1) the function returned EMMOOPS
**      2) the function returned a value that isn't EMMOOPS or 0
**      3) the function set _EMMerror to an unexpected value
** The parameters are:
**      fu  - char *, name of the function
**      st  - status value returned by the function
**      ex  - expected value of _EMMerror
**      fr1 - conventional memory pointer to be freed on emergency exit
**      fr2 - EMS handle to be freed on emergency exit
**      fr3 - another EMS handle to be freed on emergency exit
*/
#define TRIPLECHECK(fu, st, ex, fr1, fr2, fr3) \
                         failcheck((fu), (st), (fr1), (fr2), (fr3)); \
                         weirdretchk((fu), (st), (fr1), (fr2), (fr3)); \
                         weirdcodechk((fu), (ex), (fr1), (fr2), (fr3))


/*
** misc: copyright strings, version macros, etc.
*/

/*
** typedefs
*/

/*
** global variables
*/

/*
** static globals
*/

/*
** function prototypes
*/

extern void do_alloc_tests(unsigned long bytes);
extern void do_frame_tests(void);
extern void do_name_tests(void);
extern void do_map_tests(void);
extern void do_realloc_tests(void);
extern void do_sr_tests(void);
extern void do_shortcopy_tests(void);
extern void do_longcopy_tests(void);

extern unsigned long test_EMMcoreleft(void);
extern int test_EMMalloc(unsigned long bytes);
extern int test_EMMallocpages(int pages);
extern int test_EMMrealloc(int handle, unsigned long bytes);
extern void test_EMMfree(int handle);
extern void test_EMMmappage(int frameno, int handle, int logpage);

extern void weirdretchk(char *function, int status, void *tofree1, int tofree2,
                                                                  int tofree3);
extern void weirdcodechk(char *function, int expected, void *tofree1,
                                                     int tofree2, int tofree3);
extern void failcheck(char *function, int status, void *tofree1, int tofree2,
                                                                  int tofree3);
extern void nofailcheck(char *function, int status, void *tofree1, int tofree2,
                                                                  int tofree3);

#endif

