/* example 1: initialize flat real mode and show all information
   available
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

/* #include flat real mode for C/C++ header file */
#include "../flat.h"

/* this is an array of pointers to the possible error reasons */
char *errmsg[] =
{
  NULL,
  "80386 or better CPU not detected",
  "CPU is in V86-mode",
  "Extended memory couldn't be allocated",
  "Unable to lock extended memory"
};

/* the cpu types recognized by init_flat */
char *cpuname[] =
{
  "8088/8086", "80286", "80386", "80486 or better"
};

/* exit with error code */
void errexit (const char *,...);

int
main (void)
{
  int foo;

  /* init flat real mode */
  foo = init_flat ();

  /* atexit (exit_flat) could be called here. This works only in large code
     models, as exit_flat is a far function.
   */

  /* abort on error */
  if (foo)
    errexit (errmsg[foo]);

  /* give out everything important we know */
  printf ("flat real mode status information\n"
          "*********************************\n"
          "CPU type: %s\n"
          "Available extended memory: %ld bytes\n"
          "Extended memory base adress: 0x%lx\n"
          "Extended memory top adress: 0x%lx\n"
          "Memory mode: %s\n",
          cpuname[cpu_type], em_avail, em_base, em_top,
          mem_mode == 0 ? "RAW" : "XMM"
    );

  exit_flat ();
  return (0);
}

void
errexit (const char *fmt,...)
{
  va_list v;
  char s[513];
  va_start (v, fmt);

  vsprintf (s, fmt, v);
  fprintf (stderr, "%s\n", s);
  exit_flat ();
  exit (1);
}
