#ifndef _FXVMM_API_HEADERFILE
#define _FXVMM_API_HEADERFILE

#include <stdio.h>

#ifndef __LARGE__
#error Sorry, Only the large model is supported 
#endif

/*
 a pretty pointless define, since this is the first one wich is gonna
 be ripped ;(
*/

#define FXVMM_BANNER "\n\r" \
                     "\n\r FXVM Manager version %u.%u (c) copyright flux@stack.urc.tue.nl 1987,1995  "  \
                     "\n\r" \

#define TRUE   1
#define FALSE  0
#define ERROR -1

/* Some easy macros  */

#define       _fxvmm_size(buffer)    ( (buffer)->bufsize  )
#define       _fxvmm_curpos(buffer)  ( (buffer)->bufptr   )
#define	      _fxvmm_source(buffer)  ( (buffer)->f.source )
#define	      _fxvmm_isused(buffer)  ( (buffer)->f.in_use )

/* node codes */

#define FXVMM_ISVALID	    0xFEDC
#define FXVMM_ISDELETED	    0xEDCB

/* Various heap error-codes */

#define	FXVMM_HEAPOK	    0
#define FXVMM_HEAPEMPTY	    1
#define FXVMM_HEAPBADBEGIN  2
#define FXVMM_HEAPBADNODE   3

/* Various error-codes */

#define FXVMM_XMM_ERR	    1
#define FXVMM_VIRT_ERR	    2
#define FXVMM_EMM_ERR	    3

/* various API values */

#define FXVMM_MAXITEM      150
#define FXVMM_MAXVECTOR    100
#define FXVMM_MAXDRIVE     20
#define FXVMM_MAXHANDLES   255

#define FXVMM_MTNONE       0
#define FXVMM_MTSYSCODE    1
#define FXVMM_MTSYSDATA    2
#define FXVMM_MTAPP        3
#define FXVMM_MTDEV        4
#define FXVMM_MTENV        5
#define FXVMM_MTDATA       6
#define FXVMM_MTFREE       7
#define FXVMM_MTMAP        8

/*
   Memory priority definitions, going from high-priority to low-priority
*/

#define FXVMM_PRIORITY1     0
#define FXVMM_PRIORITY2     1
#define FXVMM_PRIORITY3     2
#define FXVMM_PRIORITY4     3

/*
   Various CPU and FPU/NPU types
*/

#define   FXVMM_8086_CPU     0
#define   FXVMM_80186_CPU    1
#define   FXVMM_80286_CPU    2
#define   FXVMM_80386_CPU    3
#define   FXVMM_80486_CPU    4
#define   FXVMM_80586_CPU    5

#define   FXVMM_FPU_NONE     0
#define   FXVMM_FPU_UNKNOWN  1
#define   FXVMM_FPU_287      2
#define   FXVMM_FPU_387      3

/*
    Various DOS Extenders
*/

#define   FXVMM_DOS_REALMODE   0 /* DOS in realmode */
#define   FXVMM_ERGO_OS286     1 /* ERGO 286 Extender */
#define   FXVMM_ERGO_OS386     2 /* ERGO 286 Extender */
#define   FXVMM_PHARLAP_386    3 /* PHARLAP|386 Extender  */

/*
   Windows definitions
*/

#define   FXVMM_WINDOWS_NONE    0 /* No Windows active             */
#define   FXVMM_WINDOWS_386_1x  1 /* Windows/386 1.x               */
#define   FXVMM_WINDOWS_386_3xE 2 /* Windows 3.x in Enhanced mode  */
#define   FXVMM_WINDOWS_386_4xE 3 /* Windows 4.x in Enhanced mode  */
#define   FXVMM_WINDOWS_386_2x  4 /* Windows/386 2.x               */
#define   FXVMM_WINDOWS_386_31S 5 /* Windows 3.1+ in Standard mode */
#define   FXVMM_WINDOWS_386_30S 6 /* Windows 3.0 in Standard mode  */
#define   FXVMM_WINDOWS_95      7 /* Windows95 - yuk !             */
#define   FXVMM_WINDOWS_NT      8 /* Windows NT (No thanx ;)       */

/*
   Protected & real Mode definitions
*/

#define   FXVMM_DOSV86          0
#define   FXVMM_PROTMODE        1
#define   FXVMM_PROTMODE_WIN    2

/*
   The following define determins wether a swapfile created by the
   memory manager should be wiped (i.e. made unrecoverable), note
   that this operation may take some time on larger swapfiles, the
   function was only intended for programs wich might contain
   sensitive data in memory and need to be erased properly.
*/

#undef  FXVMM_WIPESWAP

/*
   For debugging purposes
*/

#undef FXVMM_DEBUG

/* Structure definitions */

typedef struct
{
  unsigned int memory_handle ;
} emm_handleblock;

typedef struct
{
  unsigned int memory_handle ;
} xmm_handleblock;

typedef struct
{
  char far *memory_pointer ;
} dos_handleblock;

typedef union
{
  xmm_handleblock xmmhb  ;
  emm_handleblock emmhb  ;
  dos_handleblock doshb  ;
  long fox ;
} fxvhandle_type ;

typedef struct
{
   unsigned int source : 7 ;
   unsigned int in_use : 1 ;
} fxvmm_buffertype_flags;

typedef struct fxvmm_buftype
{
   unsigned                bufmagic    ;
   unsigned long           bufsize     ;
   unsigned long           bufptr      ;
   long                    bufoffset   ;
   fxvmm_buffertype_flags  flags       ;
   fxvhandle_type          htype       ;
   struct fxvmm_buftype   *next        ;
   struct fxvmm_buftype   *prev        ;
} fxvmm_buffertype;

typedef struct
{
   int is_enabled ;
   int	(*_alloc)( unsigned long nbytes , fxvmm_buffertype *ptr );
   void (*_free )( fxvmm_buffertype *ptr );
   unsigned long(*_absread) ( void far *buf, fxvmm_buffertype *uf, unsigned long offs, unsigned long nbytes );
   unsigned long(*_abswrite)( fxvmm_buffertype *uf, unsigned long offs, void far *buf, unsigned long nbytes );
   void(*_deinit )(void);
   int *priority;
} fxvmm_buffertype_source;


////////////////////////
typedef struct fxvmm_dos_deviceheader
{
   struct        fxvmm_dos_deviceheader *next ;
   unsigned int  attribute                    ;
   unsigned int  strategy_rutin               ;
   unsigned int  interrupt_rutin              ;
   unsigned char name[8]                      ;
} FXVMM_DOSDEV_HEADER;

typedef struct
{
   struct         fxvmm_dos_deviceheader *addr;
   unsigned char  device_name[9]              ;
   unsigned char  progname[9]                 ;
   unsigned int   attribute                   ;
   unsigned char  drive_num                   ;
   unsigned char  drives[FXVMM_MAXDRIVE]      ;
} FXVMM_DOSINFO;

/* Structure of DOS DPB */
typedef struct fxvmm_dpb
{
   unsigned char        drive_num        ;
   unsigned char        unit_number      ;
   unsigned int         bytes_in_sector  ;
   unsigned char        lsec_num         ;
   unsigned char        log_base         ;
   unsigned int         reserved_num     ;
   unsigned char        fatnum           ;
   unsigned int         rootentry_num    ;
   unsigned int         first_sector     ;
   unsigned int         largest_cluster  ;
   unsigned int         sectors_in_fat   ;
   unsigned int         root_firstsector ;
   FXVMM_DOSDEV_HEADER *device_addr      ;
   unsigned char        media_desc       ;
   unsigned char        block_flag       ;
   struct   fxvmm_dpb  *next_dpb         ;
} FXVMM_DPB;

/* Internal structure of DOS DATA blocks */
typedef struct
{
   unsigned char type       ;
   unsigned int  start      ;
   unsigned int  size       ;
   unsigned char unused[3]  ;
   unsigned char name[8]    ;
} FXVMM_SDHEAD;

/* Stucture of MCB header */
typedef struct
{
   unsigned char  type      ;
   unsigned int   owner     ;
   unsigned int   size      ;
   unsigned char  unused[3] ;
   unsigned char  name[8]   ;
} FXVMM_MCBHEAD;

/* Structure of programs, device drivers, memory blocks information */
typedef struct
{
   unsigned char type                     ;
   unsigned int  seg                      ;
   unsigned int  owner                    ;
   unsigned int  environment              ;
   unsigned char name[10]                 ;
   unsigned long size                     ;
   unsigned char vecnum                   ;
   unsigned char vectors[FXVMM_MAXVECTOR] ;
} FXVMM_MEMINFO;

/* Structure of allocated EMS handles */
typedef struct
{
   unsigned int handle ;
   unsigned int pages  ;
} FXVMM_EMSHANDLE;

/* Structure of allocated XMS handles */
typedef struct
{
   unsigned int   handle ;
   unsigned long  size   ;
   unsigned int   locks  ;
} FXVMM_XMSHANDLE;

/*
   Externally declared variables, note that these are _all_ read-only
   well, okay their not, but only experienced users should write to 'm !
*/
extern          int             fxvmm_error_code           ;
extern unsigned int             fxvmm_emm_segment          ;
extern          int             fxvmm_emm_swaphandle       ;
extern unsigned int             fxvmm_emm_pointer          ;
extern unsigned int             fxvmm_xmm_control          ;
extern          int             fxvmm_xmm_inited           ;
extern unsigned int             fxvmm_vrt_swapsize         ;
extern          int             fxvmm_vrt_inithandle       ;
extern          int             fxvmm_vrt_swaphandle       ;
extern unsigned int             fxvmm_vrt_swapdisk         ;
extern unsigned char            fxvmm_vrt_swapname[80]     ;

extern fxvmm_buffertype        *fxvmm_firstblk             ;
extern fxvmm_buffertype_source  fxvmm_bufsource[4]         ;

extern int                      fxvmm_global_xms_handle    ;
extern int                      fxvmm_global_ems_handle    ;
extern int                      fxvmm_global_dos_handle    ;
extern int                      fxvmm_global_vrt_handle    ;

extern fxvmm_buffertype_source *fxvmm_strat_xms_handle     ;
extern fxvmm_buffertype_source *fxvmm_strat_ems_handle     ;
extern fxvmm_buffertype_source *fxvmm_strat_dos_handle     ;
extern fxvmm_buffertype_source *fxvmm_strat_vrt_handle     ;

extern unsigned char            fxvmm_cputype              ;
extern unsigned char            fxvmm_fputype              ;
extern unsigned char            fxvmm_fxapi_active         ;
extern unsigned char            fxvmm_ems_api_installed    ;
extern unsigned char            fxvmm_ems_api_name[]       ;
extern unsigned int             fxvmm_ems_api_frame        ;
extern unsigned char            fxvmm_ems_api_vermajor     ;
extern unsigned char            fxvmm_ems_api_verminor     ;
extern unsigned long            fxvmm_ems_api_size         ;
extern unsigned long            fxvmm_ems_api_free         ;
extern unsigned int             fxvmm_ems_api_totalhandle  ;
extern unsigned int             fxvmm_ems_api_freehandle   ;
extern unsigned int             fxvmm_ems_api_usehandle    ;
extern unsigned char            fxvmm_xms_api_installed    ;
extern unsigned long            fxvmm_xms_api_free         ;
extern unsigned long            fxvmm_xms_api_largest      ;
extern unsigned char            fxvmm_xms_api_vermajor     ;
extern unsigned char            fxvmm_xms_api_verminor     ;
extern unsigned char            fxvmm_xms_api_hma          ;
extern unsigned char            fxvmm_xms_api_a20          ;
extern unsigned int             fxvmm_xms_api_usehandle    ;
extern unsigned int             fxvmm_xms_api_freehandle   ;
extern unsigned char            fxvmm_umb_api_installed    ;
extern unsigned long            fxvmm_umb_api_free         ;
extern unsigned long            fxvmm_umb_api_large        ;
extern unsigned int             fxvmm_umb_api_index        ;
extern unsigned long            fxvmm_vrt_api_free         ;
extern unsigned long            fxvmm_dos_api_free         ;
extern unsigned char            fxvmm_dosextender          ;
extern unsigned char            fxvmm_protmode             ;
extern unsigned char            fxvmm_windows              ;

#ifdef __cplusplus
extern "C" {
#endif
/*
  The functions, note that most of these functions are for internal
  use only, they can, however, be accessed from anywhere.
*/

/* Open the FXVMM API - Call _before_ any other allocation procedures ! */

char              _fxvmm_open_api( void );

/* Close the FXVMM API - Call _before_ terminating the application ! */

char              _fxvmm_close_api( void );

/* Allocate a buffer wich may be located either in XMS,EMS,DOS or Virtual */

fxvmm_buffertype *_fxvmm_alloc              ( unsigned long nbytes );

/* ReAllocate a buffer wich may be located either in XMS,EMS,DOS or Virtual */

fxvmm_buffertype *_fxvmm_realloc            ( fxvmm_buffertype *ptr, unsigned long nbytes );

/* Free a buffer wich may be located either in XMS,EMS,DOS or Virtual */

int               _fxvmm_free               ( fxvmm_buffertype *ptr );

/* Read from a buffer wich may be located either in XMS,EMS,DOS or Virtual */

unsigned long     _fxvmm_read               ( void far *buf, fxvmm_buffertype *fxvmmuf, unsigned long nbytes );

/* Write to a buffer wich may be located either in XMS,EMS,DOS or Virtual */

unsigned long     _fxvmm_write              ( fxvmm_buffertype *fxvmmuf, void far *buf, unsigned long nbytes );

/* Do a absolute read from a buffer wich may be located either in XMS,EMS,DOS or Virtual */

unsigned long     _fxvmm_absread            ( void far *buf, fxvmm_buffertype *fxvmmuf, unsigned long fxvmmoffs, unsigned long nbytes );

/* Do a absolute write from a buffer wich may be located either in XMS,EMS,DOS or Virtual */

unsigned long     _fxvmm_abswrite           ( fxvmm_buffertype *fxvmmuf, unsigned long fxvmmoffs, void far *buf, unsigned long nbytes );

/* Do a absolute move from a buffer wich may be located either in XMS,EMS,DOS or Virtual
   to another buffer wich also may be located either in XMS,EMS,DOS or Virtual*/

unsigned long     _fxvmm_absmove            ( fxvmm_buffertype *dest, unsigned long doffs, fxvmm_buffertype *src, unsigned long soffs, unsigned long nbytes );

/* Do a move from a buffer wich may be located either in XMS,EMS,DOS or Virtual
   to another buffer wich also may be located either in XMS,EMS,DOS or Virtual*/

unsigned long     _fxvmm_move               ( fxvmm_buffertype *dest, fxvmm_buffertype *src, unsigned long nbytes );

/* Set the position within a buffer wich may be located either in XMS,EMS,DOS or Virtual */

int 	          _fxvmm_setpos             ( fxvmm_buffertype *p, unsigned long n );

/* Error handling */

int               _fxvmm_error              ( void );

/* Set memory allocation strategy */

int               _fxvmm_set_strategy       ( fxvmm_buffertype_source *src, int priority );

/* Debug current handles */

#ifdef FXVMM_DEBUG
int               _fxvmm_debugfx            ( FILE *f );
#endif

/* Initialize FXVMM API */

char              _fxvmm_initialize         ( void );

/* Deinitialize FXVMM API */

void              _fxvmm_deinitialize       ( void );

/* Get the upper XVMM API version */

unsigned char     _fxvmm_vermajor           ( void );

/* Get the lower XVMM API version */

unsigned char     _fxvmm_verminor           ( void );

/* DOS memory based calls */

/* Allocate a DOS memory-handle */

int               _fxvmm_dos_handle_alloc   ( unsigned long nbytes, fxvmm_buffertype *p );

/* Deallocate a DOS memory-handle */

void              _fxvmm_dos_handle_free    ( fxvmm_buffertype *ptr );

/* Do a absolute read on a DOS memory-handle */

unsigned long     _fxvmm_dos_handle_absread ( void far *buf, fxvmm_buffertype *uf, unsigned long offs, unsigned long nbytes );

/* Do a absolute write on a DOS memory-handle */

unsigned long     _fxvmm_dos_handle_abswrite( fxvmm_buffertype *uf, unsigned long offs, void far *buf, unsigned long nbytes );

/* Deinitialize a DOS memory-handle */

void              _fxvmm_dos_handle_deinit  ( void );

/* Allocate a XMS memory-handle */

int               _fxvmm_xms_handle_alloc   ( unsigned long nbytes, fxvmm_buffertype *p );

/* Deallocate a XMS memory-handle */

void              _fxvmm_xms_handle_free    ( fxvmm_buffertype *ptr );

/* Do a absolute read on a XMS memory-handle */

unsigned long     _fxvmm_xms_handle_absread ( void far *buf, fxvmm_buffertype *uf, unsigned long offs, unsigned long nbytes );

/* Do a absolute write on a XMS memory-handle */

unsigned long     _fxvmm_xms_handle_abswrite( fxvmm_buffertype *uf, unsigned long offs, void far *buf, unsigned long nbytes );

/* Deinitialize a XMS memory-handle */

void              _fxvmm_xms_handle_deinit  ( void );

/* Allocate a Virtual memory-handle */

int               _fxvmm_vrt_handle_alloc   ( unsigned long nbytes, fxvmm_buffertype *p );

/* Deallocate a Virtual memory-handle */

void              _fxvmm_vrt_handle_free    ( fxvmm_buffertype *ptr );

/* Do a absolute read on a Virtual memory-handle */

unsigned long     _fxvmm_vrt_handle_absread ( void far *buf, fxvmm_buffertype *uf, unsigned long offs, unsigned long nbytes );

/* Do a absolute write on a Virtual memory-handle */

unsigned long     _fxvmm_vrt_handle_abswrite( fxvmm_buffertype *uf, unsigned long offs, void far *buf, unsigned long nbytes );

/* Deinitialize a Virtual memory-handle */

void              _fxvmm_vrt_handle_deinit  ( void );

/* Build a Virtual swapfile name */

char             *_fxvmm_vrt_handle_buildswap( void );

/* Wipe a Virtual swapfile */

int              _fxvmm_vrt_handle_swapwipe  ( const char *filename );

/* Unlink a Virtual swapfile */

int              _fxvmm_vrt_handle_swapunlink( const char *swapname );

/* Allocate a EMS memory-handle */

int	          _fxvmm_ems_handle_alloc   ( unsigned long nbytes, fxvmm_buffertype *p );

/* Deallocate a EMS memory-handle */

void  	          _fxvmm_ems_handle_free    ( fxvmm_buffertype *ptr );

/* Do a absolute read on a EMS memory-handle */

unsigned long     _fxvmm_ems_handle_absread ( void far *buf, fxvmm_buffertype *uf, unsigned long offs, unsigned long nbytes );

/* Do a absolute write on a EMS memory-handle */

unsigned long     _fxvmm_ems_handle_abswrite( fxvmm_buffertype *uf, unsigned long offs, void far *buf, unsigned long nbytes );

/* Deinitialize a EMS memory-handle */

void 	          _fxvmm_ems_handle_deinit  ( void );

/* Check all allocated nodes */

int 	          _fxvmm_checkall           ( void );

/* Check one specific node */

int	          _fxvmm_chk_fxnode         ( fxvmm_buffertype *p );

/* Check VIRTUAL for corruption & existence */

char             _fxvmm_check_vrt( void );

/* Check DOS for corruption & existence */

char             _fxvmm_check_dos( void );

/* Check EMS for corruption & existence */

char             _fxvmm_check_ems( void );

/* Check XMS for corruption & existence */

char             _fxvmm_check_xms( void );

/* Check UMB's for corruption & existence */

char             _fxvmm_check_umb( void );

/* Get a Upper Memmory Block link */

unsigned char    _fxvmm_get_umblink( void );

/* Set a Upper Memory Block link */

int              _fxvmm_set_umblink( unsigned char );

/* Search the DOS vector table  */

void             _fxvmm_search_vectors( FXVMM_MEMINFO * );

/* Search the DOS data block table  */

void             _fxvmm_searchsd( FXVMM_MCBHEAD * );

/* Register a DOS Memory Chain Block */

void             _fxvmm_regmcb( FXVMM_MCBHEAD * );

/* Return _psp for MCB */

int              _fxvmm_ispsp( FXVMM_MCBHEAD * );

/* Return environment segment for MCB */

unsigned int     _fxvmm_envseg( FXVMM_MCBHEAD * );

/* Make a list of all valid MCB's  */

void             _fxvmm_make_mcblist( void );

/* Display DOS memory  */

void             _fxvmm_display_dosmem( void );

/* Display EMS memory  */

void             _fxvmm_display_emsmem( void );

/* Display XMS memory  */

void             _fxvmm_display_xmsmem( void );

/* Display Virtual memory  */

void             _fxvmm_display_vrtmem( void );

/* Display All types of memory  */

void            _fxvmm_display_allmem( void );

/* Identify the CPU and FPU/NPU */

void            _fxvmm_cpuid( void );

/* Identify the active DOS Extender */

void            _fxvmm_getdosextender( void );

/* Identify Windows version (if present) */

int             _fxvmm_detwin( void );

/* Internal Subroutine */

int             _fxvmm_detwinproc( void );

/* Detect protected mode/ V86 Mode */

int             _fxvmm_detprotmode( void );

/* Mark stack at starting of application */

void            _fxvmm_markstack( void );

/* Internal atexit() called function */

void            _fxvmm_exitstack( void );

#ifdef __cplusplus
 }
#endif

#endif