/*
 * dllPower v2.70 source code, for use with idllPower v3.01+
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Copyright (c) 1996, Tony Toole
 *
 * This source is provided for educational purposes only.
 * Do not distribute modified versions of this source code.
 *
 * Don't forget to read the order form.
 */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include "idpower.h"

char *stripPath(char *name)
  {
  char drive[ _MAX_DRIVE ];
  char dir[ _MAX_DIR ];
  char fname[ _MAX_FNAME ];
  char ext[ _MAX_EXT ];
  static char wholeFile[128];

  _splitpath( name, drive, dir, fname, ext );

  strcpy(wholeFile, fname);
  strcat(wholeFile, ext);
  return wholeFile;
  }

void printBeta()
  {
  // Used for distribution to dllPower beta testers.
  printf("This is a BETA version, do not distribute.\n");
  }

void printPublicDomain()
  {
  printf("This loader is public domain.\n");
  }

void printBanner()
  {
  printf("dllPower v2.70, using idllPower version %d.%.2d.\n",
          idllGetHighVer(), idllGetLowVer());
  printf("Copyright (c) 1996 by Tony Toole. ttoole@cancom.net\n");
  }

int main(int argc, char *argv[], char *argvp[])
  {
  int retCode, errCode;
  char *thisName = stripPath(argv[0]);
  struct tagExtErrorRec errRec;


  // stand alone loader.
  if (!stricmp (thisName, "dllpower.exe"))
     {
     idllSetArgs(argc - 1, argv + 1, argvp);
     if (argc < 2)
        {
        printBanner();
        printPublicDomain();
        printf("Syntax: dllPower <executable.xxx>\n");
        exit(-100);
        }
     errCode = idllExecApplication(argv[1], argc - 1, argv + 1, argvp, &retCode);
     if (errCode) printf("Unable to load %s\n", argv[1]);
     }
  else // bound loader, assume main program is within the version table.
     {
     printBanner();
     printf("\n");  // Give an extra line for your program's output, stops the
                    // cluttering
     idllSetArgs(argc, argv, argvp);
     errCode = idllExecApplication(thisName, argc, argv, argvp, &retCode);
     if (errCode) printf("Unable to load %s\n", argv[0]);
     }


// This demonstrates the proper use of idllGetExtErrorInfo.
  if (errCode)
     {
     idllGetExtErrorInfo (&errRec);

     if (errRec.modName[0] != 0)
        {
        printf("> %s, %s", stripPath(errRec.modName), errRec.errMessage);
        }
     else printf("> %s", errRec.errMessage);
     if (errRec.errCode == idllInvalidVersion)
        {
        int wholeVer = errRec.highVer * 100 + errRec.lowVer;
        
        if (wholeVer == 0) printf(" -> (modual below version 1.05)\n");
        else printf(" -> (modual version %d.%.2d)\n", errRec.highVer, errRec.lowVer);

        if (wholeVer < 213)
           {
           printf("Modual version too low, I can't execute anything below v2.13\n");
           }
        else
           {
           printf("Sorry, your application or one of it's libraries require a newer\n");
           printf("version of dllPower.\n");
           }
        } else printf("\n");
     if (errRec.expName[0] != 0)
        {
        printf("Missing export: %s\n", errRec.expName);
        }
     return -errCode;
     }
  return retCode;
  }
