INCLUDE CLIB_16.INC

;strchr() -- Search string for char
;char __far *  __far strchr(const char __far * const,const int);

; GIVEN:
;   p_str	pointer to string to search
;   chr 	the character to search for
; RETURNS:
;   pointer	to the ending '\0' if char not found
;   pointer	to the character if found
; NOTES:
;   may search for '\0', then will return pointing to '\0'

_TEXT SEGMENT
strchr PROC FAR16 C USES ds si, p_str:FAR16 PTR BYTE, chr:WORD

	    lds si, [p_str]	    ;ds:si = string pointer
	    mov ah, BYTE PTR [chr]  ;AH = char

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    test al,al		    ;Null, not found
	    jz @@done
            cmp al,ah               ;Loop while not equal
	    jne @@loop

@@done:     dec si
	    mov dx, es
	    mov ax, si
	    ret
strchr	ENDP
_TEXT ENDS
END
