INCLUDE CLIB_16.INC

;strncat() -- Append strings, max length
;char __far * __far strncat(char __far * const, const char __far * const, const int);

_TEXT SEGMENT
strncat PROC FAR16 C USES es ds si di,
	    p_str1:FAR16 PTR BYTE, p_str2:FAR16 PTR BYTE, num:WORD

	    lds si, [p_str2]
	    les di, [p_str1]
	    mov ax, ds
	    mov bx, es
	    cmp ax, bx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    mov ax, di
	    mov dx, es
	    jmp @@exit
@@cont:
	    ; find end of str1
	    les di, [p_str1]	    ;es:di = destination
	    xor ax, ax		    ; look for null
	    mov cx, ax
	    dec cx		    ; set cx to max strlen length
	    repne scas BYTE PTR es:[di]
	    dec di
	    ; es:[di] points to place to start adding str2

	    lds si, [p_str2]
	    mov cx, num
@@loopa:
	    jcxz @@addnull
	    dec cx
	    lods BYTE PTR ds:[si]    ;Load char
	    stos BYTE PTR es:[di]   ; store char
            test al,al              ;Loop while not zero
	    jz @@done
	    jmp @@loopa
@@addnull:
	    mov BYTE PTR es:[di], 0

@@done:
	    lds si, [p_str1]
	    mov ax, si
	    mov dx, ds
@@exit:
	    ret
strncat ENDP
_TEXT ENDS
END
