INCLUDE CLIB_16.INC

;isalnum() - Alphanumeric ('A'-'Z','a'-'z','0'-'9')
;int __far isalnum(const int);
; RETURNS:
;   0	    if NOT a alphanumeric character
;   1	    if	   a alphanumeric character

_TEXT SEGMENT
isalnum PROC FAR16 C, num:WORD
    xor ax, ax
    mov bx, [num]
    cmp bl, '0'
    jb @@done
    cmp bl, '9'
    jbe @@yes
    cmp bl, 'A'
    jb @@done
    cmp bl, 'Z'
    jbe @@yes
    cmp bl, 'a'
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
isalnum ENDP

; __fastcall
;   AX	    nchar
;int __fastcall __far isalnum(const int);
@isalnum PROC FAR16 USES bx
    mov bl, al
    xor ax, ax
    cmp bl, '0'
    jb @@done
    cmp bl, '9'
    jbe @@yes
    cmp bl, 'A'
    jb @@done
    cmp bl, 'Z'
    jbe @@yes
    cmp bl, 'a'
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
@isalnum ENDP
_TEXT ENDS
END
