INCLUDE CLIB_16.INC


;strstr() -- Search string for substring
;char __far *  __far strstr(const char __far * const p_str1, const char __far * const p_str2);

_TEXT SEGMENT
strstr PROC FAR16 C USES es ds si di, p_str1:FAR16 PTR BYTE, p_str2:FAR16 PTR BYTE
    LOCAL p_temp:FAR16 PTR BYTE

    les di, [p_str1]
    lds si, [p_str2]
    mov ax, es
    mov bx, ds
    cmp ax, bx
    jne @@cont
    cmp si, di
    jne @@cont
    mov ax, di
    mov dx, es
    jmp @@exit
@@cont:
    ; get string length of p_str2 (substring)

    les di,[p_str2]
    xor ax, ax
    mov cx, ax
    dec cx
    repne scas BYTE PTR es:[di]
    not cx
    dec cx
    mov bx, cx ;cx = len substring

    ; get string length of p_str1 (string)
    les di, [p_str1]
    mov cx, ax
    dec cx
    repne scas BYTE PTR es:[di]
    not cx
    dec cx

    dec di
    mov dx, di
    mov WORD PTR [p_temp], dx
    mov dx, es
    mov WORD PTR [p_temp+2], dx
    xchg cx, bx
    ; bx = len str1, cx= len str2
    cmp cx, bx
    jle @F
    ; cannot be, substring longer than string
    mov dx, es
    mov ax, di
    jmp @@exit

@@:
    dec cx
    ; bx = strlen(str1), cx=strlen(str2)
    sub bx, cx
    inc bx
    ; bx = number of chars in str1 to check

    les di, [p_str2]	    ;es:di = substring pointer
    lds si, [p_str1]	    ; ds:si = string pointer
    mov al, es:[di]	; first char of substring
    ; match the first character
@@loop:
    mov ah, es:[si]	; next char of string
    cmp al, ah
    jne @@notequal
    ; first chars are equal, maybe the rest of the string is also
    ;  es:[si] points to char in string, that is equal to first char in sub
    ;  cx length of substring
	push cx ; save substring strlength
	push si ; save current pointer into string
	push ds
	repe cmps BYTE PTR ds:[si], es:[di]
	jcxz @F
	jmp @@notfoundit
	@@:
	jz @@foundit
@@notfoundit:
	; not found
	    pop ds
	    pop si
	    pop cx ; restore old pointer
	    inc si
	    les di, [p_str2]	; restore pointer to substring
	    mov al, es:[di]	; first char of substring
	    dec bx
	    jz @@done
	    jmp @@loop
@@foundit:
	    ; found the string
	    pop dx
	    pop ax
	    pop cx ; restore old pointer
	    jmp @@exit
@@notequal:
    dec bx
    jz @@done
    inc si
    jmp @@loop

@@done:
    mov ax, WORD PTR [p_temp]
    mov dx, WORD PTR [p_temp+2]
@@exit:
    ret
strstr	    ENDP
_TEXT ENDS
END
