/* memset.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"memset.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(memset)
#endif

// memset() -- Set memory block.
//  void * memset(void * const, const int, const int); 
// GIVEN:
//	p_m	pointer to memory block.
//	chr	value to set to (LSB significant).
//	cnt	number of bytes to set to chr.
// RETURNS: (r8)
//	p_m	pointer to memory block.
// NOTES:
//  Sets the memory beginning at p_m, increasing to higher address, up to cnt.
//  At this time, no optimization, just krunch it.
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(memset)
ilibc_64_proc_prologue
ilibc_64_proc_body
p_m==r32
chr==r33
cnt==r34
ret_ptr==r8
tmp==r11
	mov ret_ptr=p_m
	mov ar.lc=cnt
.Loop:
	st1 [p_m]=chr,1
	br.cloop.sptk.few .Loop
ilibc_64_proc_epilogue
	br.ret.sptk.many.clr b0
ilibc_64_proc_end(memset)
