INCLUDE CLIBC_16.INC

;strcat() -- Concatenate strings
; appends string2 to end of string1
;char __near * __near strcat(char __near * const, const char __near * const);
; GIVEN:
;   p_str1	near pointer, offset from ss
;   p_str2	near pointer, offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss (p_str1)

_TEXT SEGMENT
strcat PROC NEAR16 C uses es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ss
	    mov es, ax

	    mov bx, ds
	    cmp ax, bx
	    jne @@cont
	    mov si, [p_str2]
	    mov di, [p_str1]
	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    ; find end of p_str1
;	    mov di,[p_str1]	    ;es:di = destination
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = destination

	    mov si, [p_str2]	    ; ds:si = source

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, [p_str1]
@@exit:
	    ret
strcat ENDP

; __fastcall
;   bx	    p_str1
;   ax	    p_str2
;char __near * __fastcall __near strcat(char __near * const, const char __near * const);
@strcat PROC NEAR16 USES es si di bx cx dx

	    mov si, ax	; ds:si = p_str2
	    mov di, bx	; es/ss:di = p_str1
	    mov ax, ss
	    mov es, ax

	    mov bx, ds
	    cmp ax, bx
	    jne @@cont
	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx  ; cx = -1
	    mov dx, si	    ; dx = p_str2

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = destination

	    mov si, dx	    ; ds:si = source
	    mov dx, di	    ; dx = p_str1
@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, dx
@@exit:
	    ret
@strcat ENDP
_TEXT ENDS
END
