INCLUDE CLIBC_16.INC


;memset() -- Set memory block
;void __near * __near memset(void __near * const, const int, const int);
;GIVEN:
;   p_m 	near pointer, (source) offset from ds
;   chr 	value to set to
;   cnt 	number of bytes to set to chr
;RETURNS:
;   pointer	near pointer, offset from ds (p_m)
_TEXT SEGMENT
memset PROC NEAR16 C uses es di, p_m:NEAR16 PTR, chr:WORD, cnt:WORD

	    mov ax, ds
	    mov es, ax

	    mov di, [p_m]	    ;es:DI = block
	    mov cx, [cnt]	     ;CX = count
	    mov ax, [chr]
	    xor ah, ah		     ;al = char

	    rep stos BYTE PTR es:[di]	   ;Set memory

	    mov ax, [p_m]
	    ret
memset ENDP

; __fastcall
;   bx	    p_m, (source) offset from ss
;   ax	    chr
;   dx	    cnt
;void __near * __fastcall __near memset(void __near * const, const int, const int);
@memset PROC NEAR16 USES es si di bx cx dx

	    mov di, bx	    ;es:di = p_m
	    mov cx, dx	     ;cx = count
			    ; ax = char
	    mov dx, ds
	    mov es, dx

	    xor ah, ah	    ;al = char

	    rep stos BYTE PTR es:[di]	   ;Set memory

	    mov ax, bx	; return p_m
	    ret

@memset ENDP

;memset_sss() -- Set memory block
;void __near * __near memset_sss(void __near * const, const int, const int);
;GIVEN:
;   p_m 	near pointer, (source) offset from ss
;   chr 	value to set to
;   cnt 	number of bytes to set to chr
;RETURNS:
;   pointer	near pointer, offset from ss (p_m)
memset_sss PROC NEAR16 C uses es di, p_m:NEAR16 PTR, chr:WORD, cnt:WORD

	    mov ax, ss
	    mov es, ax

	    mov di, [p_m]	    ;es:DI = block
	    mov cx, [cnt]	     ;CX = count
	    mov ax, [chr]
	    xor ah, ah		     ;al = char

	    rep stos BYTE PTR es:[di]	   ;Set memory

	    mov ax, [p_m]
	    ret
memset_sss ENDP

; __fastcall
;   bx	    p_m, (source) offset from ss
;   ax	    chr
;   dx	    cnt
;void __near * __fastcall __near memset_sss(void __near * const, const int, const int);
@memset_sss PROC NEAR16 USES es si di bx cx dx

	    mov di, bx	    ;es:di = p_m
	    mov cx, dx	     ;cx = count
			    ; ax = char
	    mov dx, ss
	    mov es, dx

	    xor ah, ah	    ;al = char

	    rep stos BYTE PTR es:[di]	   ;Set memory

	    mov ax, bx	; return p_m
	    ret

@memset_sss ENDP

_TEXT ENDS
END
