INCLUDE CLIBC_16.INC

;strrchr() -- Search string for char, in reverse
;char __near * __near strrchr(const char __near * const, const int chr);
; GIVEN:
;   p_str	near pointer, offset from ds
;   chr 	character to search for
;RETURNS: (char *)
;   pointer	near pointer, offset from ds
;		to '\0' if character not found
;		to character if found
; NOTES:
;   will search for '\0', and find it at end of string

_TEXT SEGMENT
strrchr PROC NEAR16 C USES si, p_str:NEAR16 PTR BYTE, chr:WORD
	    mov si, [p_str]	    ;ds:si = p_Str, source
	    mov ax, [chr]
	    xchg al, ah
	    mov bx, -1

@@loop:     lods BYTE PTR ds:[si]   ;Load char
            cmp al,ah               ;Is it the char?
	    jne @F
		mov bx,si		    ;BX = position
	    @@:
	    test al,al	     ;Loop while not zero
	    jnz @@loop

	    dec si
	    mov ax, si

	    cmp bx, -1
	    je @F
		dec bx	; because lods incs si
		mov ax, bx
@@:	    ret
strrchr ENDP

; __fastcall
;   bx	    p_str, (source) offset from ds
;   ax	    chr
;char __near * __fastcall __near strrchr(const char __near * const, const int chr);
@strrchr PROC NEAR16 USES si bx
	    mov si, bx	    ;ds:si = p_Str, source
			    ; ax = chr
	    xchg al, ah
	    mov bx, -1

@@loop:     lods BYTE PTR ds:[si]   ;Load char
            cmp al,ah               ;Is it the char?
	    jne @F
		mov bx,si		    ;BX = position
	    @@:
	    test al,al	     ;Loop while not zero
	    jnz @@loop

	    dec si
	    mov ax, si

	    cmp bx, -1
	    je @F
		dec bx	; because lods incs si
		mov ax, bx
@@:	    ret
@strrchr ENDP

;strrchr_sss() -- Search string for char, in reverse
;char __near * __near strrchr_sss(const char __near * const, const int chr);
; GIVEN:
;   p_str	near pointer, offset from ss
;   chr 	character to search for
;RETURNS: (char *)
;   pointer	near pointer, offset from ss
;		to '\0' if character not found
;		to character if found
; NOTES:
;   will search for '\0', and find it at end of string
strrchr_sss PROC NEAR16 C USES ds si, p_str:NEAR16 PTR BYTE, chr:WORD
	    mov ax, ss
	    mov ds, ax

	    mov si, [p_str]	    ;ds/ss:si = p_Str
	    mov ax, [chr]
	    xchg al, ah
	    mov bx, -1

@@loop:     lods BYTE PTR ds:[si]   ;Load char
            cmp al,ah               ;Is it the char?
	    jne @F
		mov bx,si		    ;BX = position
	    @@:
	    test al,al	     ;Loop while not zero
	    jnz @@loop

	    dec si
	    mov ax, si

	    cmp bx, -1
	    je @F
		dec bx	; because lods incs si
		mov ax, bx
@@:	    ret
strrchr_sss ENDP

; __fastcall
;   bx	    p_str, (source) offset from ss
;   ax	    chr
;char __near * __fastcall __near strrchr(const char __near * const, const int chr);
@strrchr_sss PROC NEAR16 USES ds si bx
	    mov si, bx	    ;ds/ss:si = p_Str
			    ; ax = chr
	    mov bx, ss
	    mov ds, bx

	    xchg al, ah
	    mov bx, -1

@@loop:     lods BYTE PTR ds:[si]   ;Load char
            cmp al,ah               ;Is it the char?
	    jne @F
		mov bx,si		    ;BX = position
	    @@:
	    test al,al	     ;Loop while not zero
	    jnz @@loop

	    dec si
	    mov ax, si

	    cmp bx, -1
	    je @F
		dec bx	; because lods incs si
		mov ax, bx
@@:	    ret
@strrchr_sss ENDP

_TEXT ENDS
END
