#Makefile.g
#Global include makefile for entire project

DEBUG_YES=1
DEBUG_NO=0
CLIBC_16_NEARCALL= 0
CLIBC_16_FARCALL= 1
CLIBC_16_FC_EXT_PTRS_NO= 0
CLIBC_16_FC_EXT_PTRS_YES= 1

# ===========================================================================
# configurable parameters

# =======================
# DIR_C_INCLUDE
#  set to location to copy *.h files into
#  will create directory clibc_16 in this directory
#  may be exactly equal to DIR_ASM_INCLUDE
#  no trailing backslash
DIR_C_INCLUDE=c:\dev\sharedide\include

# ===============
# DIR_ASM_INCLUDE
#  set to location to copy *.inc files into
#  will create directory clibc_16 in this directory
#  may be exactly equal to DIR_C_INCLUDE
#  no trailing backslash
DIR_ASM_INCLUDE=c:\dev\sharedide\include

# ======
# DIRLIB
#  the directory to copy built library into
#  no trailing backslash
DIRLIB=c:\dev\sharedide\lib

# =====
# DEBUG
# set DEBUG=1(DEBUG_YES) for debug library
# set DEBUG=0(DEBUG_NO) for release library
DEBUG=0
#DEBUG=1

# =======
# CLC16_C
#  the call type for each function in the library
#  either 0=CLIBC_16_NEARCALL, or 1=CLIBC_16_FARCALL
CLC16_C=0
#CLC16_C=1

# ==================
# CLIBC_16_FC_EXT_PTRS
#  0=CLIBC_16_FC_EXT_PTRS_NO does not include pointers to fastcall functions
#  1=CLIBC_16_FC_EXT_PTRS_YES includes pointers to fastcall functions in _DATA
CLIBC_16_FC_EXT_PTRS=0
#CLIBC_16_FC_EXT_PTRS=1

# rest of global makefile
ASM=ml.exe
AFLAGS_G  = /DCLC16_C=$(CLC16_C) /DDEBUG=$(DEBUG) /DCLIBC_16_FC_EXT_PTRS=$(CLIBC_16_FC_EXT_PTRS) /I$(DIR_PROJ) /W2 /WX
AFLAGS_D  = /Cx /Sa /Sc /Fl /Zi
AFLAGS_R  = /nologo
DIR_C_INCLUDE=$(DIR_C_INCLUDE)\clibc_16
DIR_ASM_INCLUDE=$(DIR_ASM_INCLUDE)\clibc_16
