INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_isxdigit:FN_CALL PTR
p_fn_fc_isxdigit P_FN_CALL @isxdigit
_DATA ENDS

 ENDIF
ENDIF

;isxdigit() - Hexadecimal digit ('A'-'F', 'a'-'f', '0'-'9')
;int fn_call isxdigit(const int);

;RETURNS:
;   0	    if NOT a hex digit
;   1	    if	   a hex digit

CLIBC_16_CS SEGMENT
isxdigit PROC FN_CALL C, num:WORD
    xor ax, ax
    mov bx, num

    cmp bl, '0' ; digit?
    jb @@done
    cmp bl, '9'
    jbe @@yes

    cmp bl, 'A' ; Hex letter?
    jb @@done
    cmp bl, 'F'
    jbe @@yes

    cmp bl, 'a' ; Hex letter?
    jb @@done
    cmp bl, 'f'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
isxdigit ENDP

; __fastcall
;   AX	    num
;int __fastcall fn_call isxdigit(const int);
@isxdigit PROC FN_CALL USES bx
    mov bx, ax
    xor ax, ax

    cmp bl, '0' ; digit?
    jb @@done
    cmp bl, '9'
    jbe @@yes

    cmp bl, 'A' ; Hex letter?
    jb @@done
    cmp bl, 'F'
    jbe @@yes

    cmp bl, 'a' ; Hex letter?
    jb @@done
    cmp bl, 'f'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
@isxdigit ENDP
CLIBC_16_CS ENDS
END
