; isalpha
;   AAA=mis
;   BBB=002
;   F=
;   O=0
; str002.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_isalpha:FN_CALL PTR
p_fn_isalpha P_FN_CALL isalpha
EXTERNDEF C p_fn_fc_isalpha:FN_CALL PTR
p_fn_fc_isalpha P_FN_CALL @isalpha
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF


;isalpha() - Letter('A'-'Z' or 'a'-'z')
;int fn_call isalpha(const int);
;RETURNS:
;   0	    if is NOT a letter
;   1	    if is     a letter
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
isalpha PROC FN_CALL C, num:WORD
    xor ax, ax
    mov bx, [num]

    cmp bl, 'A' ; uppercase
    jb @@done
    cmp bl, 'Z'
    jbe @@yes

    cmp bl, 'a' ; lowercase
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
isalpha ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;isalpha() - Letter('A'-'Z' or 'a'-'z')
;int__fastcall fn_call isalpha(const int);
; __fastcall
;   AX	    nchar
;RETURNS:
;   AX
;   0	    if is NOT a letter
;   1	    if is     a letter
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@isalpha PROC FN_CALL USES bx
    mov bx, ax
    xor ax, ax

    cmp bl, 'A' ; uppercase
    jb @@done
    cmp bl, 'Z'
    jbe @@yes

    cmp bl, 'a' ; lowercase
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
@isalpha ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
