/* misc.h, clibc_16.lib */
/* Byron Young, 2002 */

#ifndef CLIBC_16_MISC_H
#define CLIBC_16_MISC_H

/*
*
* EXPECTED DEFINED MACROS
* NOTE:
*   if none of the following are defined, defaults to:
*	DEBUG_YES, CLIBC_16_FN_CALL_NEARCALL, CLIBC_16_EXTERN_PTRS_NO
*	CLIBC_16_FUNCTION_SEG_NAME _TEXT, CLIBC_16_EXTERN_PTRS_SEG_NAME _DATA.
*
* DEBUG - Determines if some debug info is generated.
*		     DEBUG_NO=0
*		     DEBUG_YES=1 (Default)
* CLIBC_16_FN_CALL - Near or far function calls.
*		     CLIBC_16_FN_CALL_NEARCALL=0 (Default)
*		     CLIBC_16_FN_CALL_FARCALL=1
* CLIBC_16_EXTERN_PTRS - If generate pointers to functions
*		     CLIBC_16_EXTERN_PTRS_NO=0 (Default)
*		     CLIBC_16_EXTERN_PTRS_YES=1
* CLIBC_16_FN_CALL_FARCALL_SEG - Combine method for far call functions.
*		     CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE=0 (Default)
*		     CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE=1
* CLIBC_16_FUNCTION_SEG_NAME - (base) name of function code segment.
*		     Defaults to either _TEXT or _CLIBC_16.
* CLIBC_16_EXTERN_PTRS_SEG_NAME - Data seg name for pointers.
*		     Defaults to _DATA.
*/

/* some values */
#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;
#define _SIZE_T_DEFINED
#endif

#ifndef DEBUG_YES
# define DEBUG_YES 1
#endif

#ifndef DEBUG_NO
# define DEBUG_NO 0
#endif

#ifndef CLIBC_16_FN_CALL_FARCALL
# define CLIBC_16_FN_CALL_FARCALL 1
#endif

#ifndef CLIBC_16_FN_CALL_NEARCALL
# define CLIBC_16_FN_CALL_NEARCALL 0
#endif

#ifndef CLIBC_16_EXTERN_PTRS_YES
# define  CLIBC_16_EXTERN_PTRS_YES 1
#endif

#ifndef CLIBC_16_FC_EXT_PTRS_NO
# define CLIBC_16_FC_EXT_PTRS_NO 0
#endif

#ifndef CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE
# define CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE 0
#endif

#ifndef CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE
# define CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE 1
#endif

/* defaults */
#ifndef DEBUG
# define DEBUG DEBUG_YES
#endif

#ifndef CLIBC_16_FN_CALL
# define CLIBC_16_FN_CALL CLIBC_16_FN_CALL_NEARCALL
#endif

#ifndef CLIBC_16_EXTERN_PTRS
# define CLIBC_16_EXTERN_PTRS CLIBC_16_EXTERN_PTRS_NO
#endif

/* set up defaults */
#if CLIBC_16_FN_CALL==CLIBC_16_FN_CALL_FARCALL
# ifndef CLIBC_16_FUNCTION_SEG_NAME
#  define CLIBC_16_FUNCTION_SEG_NAME _CLIBC_16
# endif
# ifndef CLIBC_16_FN_CALL_FARCALL_SEG
#  define CLIBC_16_FN_CALL_FARCALL_SEG CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE
# elif CLIBC_16_FN_CALL_FARCALL_SEG!=CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE
#  undef CLIBC_16_FN_CALL_FARCALL_SEG
#  define CLIBC_16_FN_CALL_FARCALL_SEG CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE
# endif
#elif CLIBC_16_FN_CALL==CLIBC_16_FN_CALL_NEARCALL
# ifdef CLIBC_16_FN_CALL_FARCALL_SEG
#  undef CLIBC_16_FN_CALL_FARCALL_SEG
#  pragma message("Undefined CLIBC_16_FN_CALL_FARCALL_SEG")
# endif
# ifndef CLIBC_16_FUNCTION_SEG_NAME
#  define CLIBC_16_FUNCTION_SEG_NAME _TEXT
# endif
#else
# error CLIBC_16_FN_CALL Invalid.
#endif

#if CLIBC_16_EXTERN_PTRS==CLIBC_16_EXTERN_PTRS_NO
# ifdef CLIBC_16_EXTERN_PTRS_SEG_NAME
#  undef CLIBC_16_EXTERN_PTRS_SEG_NAME
#  pragma message("Undefined CLIBC_16_EXTERN_PTRS_SEG_NAME.")
# endif
#elif CLIBC_16_EXTERN_PTRS==CLIBC_16_EXTERN_PTRS_YES
# ifndef CLIBC_16_EXTERN_PTRS_SEG_NAME
#  define CLIBC_16_EXTERN_PTRS_SEG_NAME _DATA
# endif
#else
# error CLIBC_16_EXTERN_PTRS Invalid.
#endif

/* stringizing substitution macros */
#ifndef stringeyes_x
# define stringeyes_x(aabb) #aabb
#endif

#ifndef stringeyes
# define stringeyes(bbaa) stringeyes_x(bbaa)
#endif

#ifndef stringeyes_mult
# define stringeyes_mult(bbaa) "MISC"stringeyes_x(bbaa)
#endif

/* this should never happen! */
#ifdef fn_call_misc
# undef fn_call_misc
# pragma message("Redefined fn_call_misc")
#endif

/* this should never happen! */
#ifdef CLIBC_16_FUNCTION_SEG_NAME_MISC
# undef CLIBC_16_FUNCTION_SEG_NAME_MISC
# pragma message("Undefined CLIBC_16_FUNCTION_SEG_NAME_MISC")
#endif

/* this should never happen! */
#  ifdef CLIBC_16_CS_MISC
#   undef CLIBC_16_CS_MISC
#   pragma message("Undefined CLIBC_16_CS_MISC")
#  endif

/* more settings */
#if CLIBC_16_FN_CALL==CLIBC_16_FN_CALL_NEARCALL
# ifndef fn_call_dist
#  define fn_call_dist __near
# endif
# define fn_call_misc __near __based(__segname(stringeyes(CLIBC_16_FUNCTION_SEG_NAME)))
# ifndef CLIBC_16_CS
#  define CLIBC_16_CS code_seg(stringeyes(CLIBC_16_FUNCTION_SEG_NAME),"CODE")
# endif
#else /* CLIBC_16_FN_CALL_FARCALL */
# ifndef fn_call_dist
#  define fn_call_dist __far
# endif
# if CLIBC_16_FN_CALL_FARCALL_SEG==CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE
#  define fn_call_misc __far __based(__segname(stringeyes(CLIBC_16_FUNCTION_SEG_NAME)))
#  ifndef CLIBC_16_CS
#   define CLIBC_16_CS code_seg(stringeyes(CLIBC_16_FUNCTION_SEG_NAME)),"CODE")
#  endif
# else /* CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE */
#  define fn_call_misc __far __based(__segname(stringeyes_mult(CLIBC_16_FUNCTION_SEG_NAME)))
#  define CLIBC_16_CS_MISC code_seg(stringeyes_mult(CLIBC_16_FUNCTION_SEG_NAME)),"CODE")
#  define CLIBC_16_FUNCTION_SEG_NAME_MISC stringeyes_mult(CLIBC_16_FUNCTION_SEG_NAME))
# endif
#endif

/* end of "standard" part */
/* begin misc.h */

#ifdef FASTCALL_MISC_ALL
# define FASTCALL_ISSPACE
# define FASTCALL_ISALNUM
# define FASTCALL_ISALPHA
# define FASTCALL_ISASCII
# define FASTCALL_ISCNTRL
# define FASTCALL_ISCSYM
# define FASTCALL_ISCSYMF
# define FASTCALL_ISDIGIT
# define FASTCALL_ISLOWER
# define FASTCALL_ISUPPER
# define FASTCALL_ISXDIGIT
#endif

/* isspace */
#ifdef FASTCALL_ISSPACE
int __fastcall fn_call_misc isspace(const int);
#else
int fn_call_misc isspace(const int);
#endif

#ifndef DEFINED_P_FN_ISSPACE
# define DEFINED_P_FN_ISSPACE
  typedef int (fn_call_dist * P_FN_ISSPACE)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISSPACE
# define DEFINED_P_FN_FC_ISSPACE
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISSPACE)(const int);
#endif

/* isalnum */
#ifdef FASTCALL_ISALNUM
int __fastcall fn_call_misc isalnum(const int);
#else
int fn_call_misc isalnum(const int);
#endif

#ifndef DEFINED_P_FN_ISALNUM
# define DEFINED_P_FN_ISALNUM
  typedef int (fn_call_dist * P_FN_ISALNUM)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISALNUM
# define DEFINED_P_FN_FC_ISALNUM
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISALNUM)(const int);
#endif

/* isalpha */
#ifdef FASTCALL_ISALPHA
int __fastcall fn_call_misc isalpha(const int);
#else
int fn_call_misc isalpha(const int);
#endif

#ifndef DEFINED_P_FN_ISALPHA
# define DEFINED_P_FN_ISALPHA
  typedef int (fn_call_dist * P_FN_ISALPHA)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISALPHA
# define DEFINED_P_FN_FC_ISALPHA
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISALPHA)(const int);
#endif

/* isascii */
#ifdef FASTCALL_ISASCII
int __fastcall fn_call_misc isascii(const int);
#else
int fn_call_misc isascii(const int);
#endif

#ifndef DEFINED_P_FN_ISASCII
# define DEFINED_P_FN_ISASCII
  typedef int (fn_call_dist * P_FN_ISASCII)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISASCII
# define DEFINED_P_FN_FC_ISASCII
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISASCII)(const int);
#endif

/* iscntrl */
#ifdef FASTCALL_ISCNTRL
int __fastcall fn_call_misc iscntrl(const int);
#else
int fn_call_misc iscntrl(const int);
#endif

#ifndef DEFINED_P_FN_ISCNTRL
# define DEFINED_P_FN_ISCNTRL
  typedef int (fn_call_dist * P_FN_ISCNTRL)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISCNTRL
# define DEFINED_P_FN_FC_ISCNTRL
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISCNTRL)(const int);
#endif

/* iscsym */
#ifdef FASTCALL_ISCSYM
int __fastcall fn_call_misc iscsym(const int);
#else
int fn_call_misc iscsym(const int);
#endif

#ifndef DEFINED_P_FN_ISCSYM
# define DEFINED_P_FN_ISCSYM
  typedef int (fn_call_dist * P_FN_ISCSYM)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISCSYM
# define DEFINED_P_FN_FC_ISCSYM
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISCSYM)(const int);
#endif

/* iscsymf */
#ifdef FASTCALL_ISCSYMF
int __fastcall fn_call_misc iscsymf(const int);
#else
int fn_call_misc iscsymf(const int);
#endif

#ifndef DEFINED_P_FN_ISCSYMF
# define DEFINED_P_FN_ISCSYMF
  typedef int (fn_call_dist * P_FN_ISCSYMF)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISCSYMF
# define DEFINED_P_FN_FC_ISCSYMF
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISCSYMF)(const int);
#endif

/* isdigit */
#ifdef FASTCALL_ISDIGIT
int __fastcall fn_call_misc isdigit(const int);
#else
int fn_call_misc isdigit(const int);
#endif

#ifndef DEFINED_P_FN_ISDIGIT
# define DEFINED_P_FN_ISDIGIT
  typedef int (fn_call_dist * P_FN_ISDIGIT)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISDIGIT
# define DEFINED_P_FN_FC_ISDIGIT
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISDIGIT)(const int);
#endif

/* islower */
#ifdef FASTCALL_ISLOWER
int __fastcall fn_call_misc islower(const int);
#else
int fn_call_misc islower(const int);
#endif

#ifndef DEFINED_P_FN_ISLOWER
# define DEFINED_P_FN_ISLOWER
  typedef int (fn_call_dist * P_FN_ISLOWER)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISLOWER
# define DEFINED_P_FN_FC_ISLOWER
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISLOWER)(const int);
#endif

/* isupper */
#ifdef FASTCALL_ISUPPER
int __fastcall fn_call_misc isupper(const int);
#else
int fn_call_misc isupper(const int);
#endif

#ifndef DEFINED_P_FN_ISUPPER
# define DEFINED_P_FN_ISUPPER
  typedef int (fn_call_dist * P_FN_ISUPPER)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISUPPER
# define DEFINED_P_FN_FC_ISUPPER
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISUPPER)(const int);
#endif

/* isxdigit */
#ifdef FASTCALL_ISXDIGIT
int __fastcall fn_call_misc isxdigit(const int);
#else
int fn_call_misc isxdigit(const int);
#endif

#ifndef DEFINED_P_FN_ISXDIGIT
# define DEFINED_P_FN_ISXDIGIT
  typedef int (fn_call_dist * P_FN_ISXDIGIT)(const int);
#endif

#ifndef DEFINED_P_FN_FC_ISXDIGIT
# define DEFINED_P_FN_FC_ISXDIGIT
  typedef int (fn_call_dist __fastcall * P_FN_FC_ISXDIGIT)(const int);
#endif

/* external function pointers */
#if CLIBC_16_EXTERN_PTRS==CLIBC_16_EXTERN_PTRS_YES

/* isspace */
extern P_FN_ISSPACE const p_fn_isspace;
extern P_FN_FC_ISSPACE const p_fn_fc_isspace;

/* isalnum */
extern P_FN_ISALNUM const p_fn_isalnum;
extern P_FN_FC_ISALNUM const p_fn_fc_isalnum;

/* isalpha */
extern P_FN_ISALPHA const p_fn_isalpha;
extern P_FN_FC_ISALPHA const p_fn_fc_isalpha;

/* isascii */
extern P_FN_ISASCII const p_fn_isascii;
extern P_FN_FC_ISASCII const p_fn_fc_isascii;

/* iscntrl */
extern P_FN_ISCNTRL const p_fn_iscntrl;
extern P_FN_FC_ISCNTRL const p_fn_fc_iscntrl;

/* iscsym */
extern P_FN_ISCSYM const p_fn_iscsym;
extern P_FN_FC_ISCSYM const p_fn_fc_iscsym;

/* iscsymf */
extern P_FN_ISCSYMF const p_fn_iscsymf;
extern P_FN_FC_ISCSYMF const p_fn_fc_iscsymf;

/* isdigit */
extern P_FN_ISDIGIT const p_fn_isdigit;
extern P_FN_FC_ISDIGIT const p_fn_fc_isdigit;

/* islower */
extern P_FN_ISLOWER const p_fn_islower;
extern P_FN_FC_ISLOWER const p_fn_fc_islower;

/* isupper */
extern P_FN_ISUPPER const p_fn_isupper;
extern P_FN_FC_ISUPPER const p_fn_fc_isupper;

/* isxdigit */
extern P_FN_ISXDIGIT const p_fn_isxdigit;
extern P_FN_FC_ISXDIGIT const p_fn_fc_isxdigit;

#endif /* external pointers */

/*
* MACROS DEFINED FOR USE UPON EXIT
* CLIBC_16_CS
*   Defined only if CLIBC_16_CS_MISC is not defined.
*   Defined only if CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE, or CLIBC_16_FN_CALL_NEARCALL
*   Contains the segment name containing all the functions.
* CLIBC_16_CS_MISC
*   Defined for use in #pragma code_seg CLIBC_16_CS_MISC
*   Defined only if CLIBC_16_CS is not defined.
*   Defined only if CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE.
* CLIBC_16_FUNCTION_SEG_NAME_MISC
*   Defined as a concat of strings to be used in __segname().
*   Defined only if CLIBC_16_CS is not defined.
*   Defined only if CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE.
* fn_call_misc
*    call distance and base for functions in misc group
*    equals all other fn_call_*, iff seg combine type is not multiple, and
*      function call distance is not far
* fn_call_dist
*    call distance for functions (__near, or __far)
*/
#endif /* CLIBC_16_MISC_H */
