; strcat
;   AAA=str
;   BBB=004
;   F=0
;   O=0
; str00400.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strcat:FN_CALL PTR
p_fn_strcat P_FN_CALL strcat
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strcat() -- Concatenate strings
; appends string2 to end of string1
;char __near * fn_call strcat(char __near * const, const char __near * const);
; GIVEN:
;   p_str1	near pointer, (destination) offset from ds
;   p_str2	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ds (p_str1)
; NOTES:
;   if p_str1 == p_str2, then just returns p_str1
BEGIN_CODE_SEGMENT <STRING>
strcat PROC FN_CALL C uses es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE

	    mov ax, ds
	    mov es, ax

	    mov si, [p_str2]	    ; ds:si = source
	    mov di, [p_str1]	    ;es:di = destination
	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    mov bx, di		    ; save destination pointer
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
strcat ENDP
END_CODE_SEGMENT <STRING>
END
