; @strcat
;   AAA=str
;   BBB=004
;   F=1
;   O=0
; str00410.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_strcat:FN_CALL PTR
p_fn_fc_strcat P_FN_CALL @strcat
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF
;strcat() -- Concatenate strings
; appends string2 to end of string1
; __fastcall
; GIVEN:
;   BX	    p_str1, (destination) offset from ds
;   AX	    p_str2, (source) offset from ds
; RETURNS:
;   AX	    p_str1, offset from ds
;char __near * __fastcall fn_call strcat(char __near * const, const char __near * const);
BEGIN_CODE_SEGMENT <STRING>
@strcat PROC FN_CALL USES es si di cx

	    mov si, ax	; ds:si = p_str2, source
	    mov di, bx	; es:di = p_str1, destination

	    mov ax, ds
	    mov es, ax

	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
@strcat ENDP
END_CODE_SEGMENT <STRING>
END
