; strcmp_dss
;   AAA=str
;   BBB=005
;   F=0
;   O=2
; str00502.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strcmp_dss:FN_CALL PTR
p_fn_strcmp_dss P_FN_CALL strcmp_dss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strcmp_dss() -- Compare strings
;int fn_call strcmp_dss(const char __near * const, char __near * const);
; GIVEN:
;   p_str1	near pointer, (dest) offset from ss
;   p_str2	near pointer, (source) offset from ds
; RETURNS:
;   <0	if str1 < str2
;   0	if str1 = str2 (identical)
;   >0	if str1 > str2
BEGIN_CODE_SEGMENT <STRING>
strcmp_dss PROC FN_CALL C USES ds es si di, p_str1:NEAR16 PTR BYTE, p_str2:NEAR16 PTR BYTE
	    mov bx, ss
	    mov es, bx

	    mov di,[p_str1]	    ;es:di = destination
	    mov si,[p_str2]	    ;ds:si = source

@@loop:     lods BYTE PTR ds:[si]   ;Load str2 char al
	    mov ah, es:[di]	    ;Load str1 char ah
            inc di
	    cmp ah,al		   ;Not equal?
	    jne @@done
	    test al, al
	    jnz @@loop
	    ; equal
	    xor ax, ax
	    jmp @@exit
@@done:
	    jl @@less
	    ; str1 > str2
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    ; str1 < str2
	    xor ax, ax
	    dec ax
@@exit:
	    ret
strcmp_dss ENDP
END_CODE_SEGMENT <STRING>
END
