; strchr
;   AAA=str
;   BBB=006
;   F=0
;   O=0
; str00600.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strchr:FN_CALL PTR
p_fn_strchr P_FN_CALL strchr
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strchr() -- Search string for char
;char __near *	fn_call strchr(const char __near * const,const int);
; GIVEN:
;   p_str	near pointer, offset from ds
;   chr 	the character to search for
; RETURNS: (char *)
;   pointer	near pointer, offset from ds
;		to the ending '\0' if char not found
;		to the character if found
; NOTES:
;   may search for '\0', then will return pointing to '\0'
BEGIN_CODE_SEGMENT <STRING>
strchr PROC FN_CALL C USES si, p_str:NEAR16 PTR BYTE, chr:WORD
	    mov si, [p_str]	    ;ds:si = string pointer
	    mov ah, BYTE PTR [chr]  ;AH = char

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    test al,al		    ;Null, not found
	    jz @@done
            cmp al,ah               ;Loop while not equal
	    jne @@loop

@@done:
	    dec si
	    mov ax, si
	    ret
strchr	ENDP
END_CODE_SEGMENT <STRING>
END
