; strchr_sss
;   AAA=str
;   BBB=006
;   F=0
;   O=1
; str006.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strchr_sss:FN_CALL PTR
p_fn_strchr_sss P_FN_CALL strchr_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strchr_sss() -- Search string for char
;char __near *	fn_call strchr_sss(const char __near * const,const int);
; GIVEN:
;   p_str	near pointer, offset from ss
;   chr 	the character to search for
; RETURNS: (char *)
;   pointer	near pointer, offset from ss
;		to the ending '\0' if char not found
;		to the character if found
; NOTES:
;   may search for '\0', then will return pointing to '\0'
BEGIN_CODE_SEGMENT <STRING>
strchr_sss PROC FN_CALL C USES ds si, p_str:NEAR16 PTR BYTE, chr:WORD
	    mov ax, ss
	    mov ds, ax

	    mov si, [p_str]	    ;ds:si = string pointer
	    mov ah, BYTE PTR [chr]  ;AH = char

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    test al,al		    ;Null, not found
	    jz @@done
            cmp al,ah               ;Loop while not equal
	    jne @@loop

@@done:     dec si
	    mov ax, si
	    ret
strchr_sss	ENDP
END_CODE_SEGMENT <STRING>
END
