; @skipspr_sss
;   AAA=str
;   BBB=010
;   F=1
;   O=1
; str01011.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_skipspr:FN_CALL PTR
p_fn_fc_skipspr_sss P_FN_CALL @skipspr_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

; skipspr_sss - skip white space reverse
; char __near * __fastcall fn_call skipspr_sss(const char __near * const);
; __fastcall
; GIVEN:
;   BX	    p_str, offset from ss
; RETURNS:
;   AX		near pointer, offset from ss
;		to the last non white space character in the string
;		if no more non white space characters in the string,
;		   then points to terminating '\0'
BEGIN_CODE_SEGMENT <STRING>
@skipspr_sss PROC FN_CALL USES es di dx cx bx
    mov ax, ss
    mov es, ax

    mov di, bx ; es/ss:di = p_str

    xor ax, ax	; zero out ax
    mov cx, ax
    dec cx	; cx = -1
    mov dx, cx	; dx = -1

    ; skipspr(p_str)
    repne scas BYTE PTR es:[di]
    not cx
    dec cx
    ; cx = skipspr(p_str)
    dec di
    dec di
    mov bx, di
@@luup:
    jcxz @@allspaces
    dec cx
    mov al, BYTE PTR es:[di]
    dec di
    cmp al, 20h
    je @@luup
    cmp al, 09h
    jl @@nonspace
    cmp al, 0Dh
    jle @@luup
@@nonspace:
    jmp @@done
@@allspaces:	; or null, so use bx
    mov di, bx
@@done:
    inc di
    mov ax, di
    ret
@skipspr_sss ENDP
END_CODE_SEGMENT <STRING>
END
