; @memmove_sss
;   AAA=str
;   BBB=016
;   F=1
;   O=1
; str01611.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_memmove_sss:FN_CALL PTR
p_fn_fc_memmove_sss P_FN_CALL @memmove_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;memmove_sss() -- Copy memory block
;void __near * __farcall fn_call memmove_sss(void __near * const, void __near * const, const int);
; __fastcall
; GIVEN:
;   BX	    p_m1, (dest) offset from ds
;   AX	    p_m2, (source) offset from ss
;   DX	    num
;RETURNS:
;   pointer	near pointer, offset from ds (p_m1)
;NOTES:
;   assumes that the pointer segments will never overlap or are equal
;   makes no assumptions concerning DF
;   returns without altering DF
BEGIN_CODE_SEGMENT <STRING>
@memmove_sss PROC FN_CALL USES ds es si di bx cx dx
	    pushf

	    mov di, bx		    ;es:DI = p_m1
	    mov si, ax		    ;ds:SI = p_m2
	    mov cx, dx		    ;cx = count
	    mov dx, bx		    ; dx = p_m1

	    mov ax, ds
	    mov es, ax

	    mov bx, ss
	    mov ds, bx
	    cmp ax, bx
	    je @@possiblerev
	    jmp @@doit
@@possiblerev:
	    cmp di,si		    ;Make forward moves
	    jb @@normal		   ;normal
	    je @@done
	    ; reverse
	    std
	    add si, cx
	    add di, cx
	    dec si
	    dec di
	    jmp @@doit
@@normal:
	    cld
@@doit:
	    rep movs BYTE PTR es:[di], ds:[si]
	    ; done
@@done:
	    mov ax, dx
	    popf
	    ret
@memmove_sss ENDP
END_CODE_SEGMENT <STRING>
END
