; strlen
;   AAA=str
;   BBB=001
;   F=
;   O=
; str001.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strlen:FN_CALL PTR
p_fn_strlen P_FN_CALL strlen
EXTERNDEF C p_fn_fc_strlen:FN_CALL PTR
p_fn_fc_strlen P_FN_CALL @strlen
EXTERNDEF C p_fn_strlen_sss:FN_CALL PTR
p_fn_strlen_sss P_FN_CALL strlen_sss
EXTERNDEF C p_fn_fc_strlen:FN_CALL PTR
p_fn_fc_strlen_sss P_FN_CALL @strlen_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

; strlen() -- Get length of string
; size_t fn_call strlen(const char __near * const);
; GIVEN:
;   p_str	near pointer (source) offset from ds
; RETURNS: (int)
;   #		length of p_strg, excluding terminating null
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strlen PROC FN_CALL C PUBLIC USES di es, p_str:NEAR16 PTR BYTE
	    mov ax, ds
	    mov es, ax

	    mov di, [p_str]	    ; es:di = string pointer
	    xor ax, ax
	    mov cx, ax
	    dec cx

	    repne scas BYTE PTR es:[di]
	    not cx
	    dec cx

	    mov ax, cx

	    ret
strlen ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

CLIBC_16_FUNCTION_SEG_NAME SEGMENT
; strlen() -- Get length of string
; size_t __fastcall fn_call strlen(const char __near * const);
; __fastcall
; GIVEN:
;   BX		p_str, (source) offset from ds
; RETURNS:
;   AX		length
@strlen PROC FN_CALL USES cx es di
	    mov di, bx	    ; es:di = string pointer
	    mov ax, ds
	    mov es, ax

	    xor ax, ax
	    mov cx, ax
	    dec cx

	    repne scas BYTE PTR es:[di]
	    not cx
	    dec cx
	    mov ax, cx
	    ret
@strlen ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

; strlen_sss() -- Get length of string
; size_t fn_call strlen_sss(const char __near * const);
; GIVEN:
;   p_str	near pointer (source) offset to ss
; RETURNS: (int)
;   #		length of p_strg, excluding terminating null
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strlen_sss PROC FN_CALL C PUBLIC USES di es, p_str:NEAR16 PTR BYTE
	    mov ax, ss
	    mov es, ax

	    mov di, [p_str]	    ; es:di = string pointer
	    xor ax, ax
	    mov cx, ax
	    dec cx

	    repne scas BYTE PTR es:[di]
	    not cx
	    dec cx

	    mov ax, cx

	    ret
strlen_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

; strlen_sss() -- Get length of string
; size_t __fastcall fn_call strlen_sss(const char __near * const);
; __fastcall
; GIVEN:
;   BX		p_str, (source) offset from ss
; RETURNS:
;   AX		length
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strlen_sss PROC FN_CALL USES cx es di
	    mov di, bx	    ; es:di = string pointer
	    mov ax, ss
	    mov es, ax

	    xor ax, ax
	    mov cx, ax
	    dec cx

	    repne scas BYTE PTR es:[di]
	    not cx
	    dec cx
	    mov ax, cx
	    ret
@strlen_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
