/*************************************************************************
** interpcom-1.1  (command interpreter)                                  **
** command.c : Some commands                                             **
**                                                                       **
** Copyright (C) 1998  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**									 **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details. 			 **
**									 **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free		 **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France								 **
**                                                                       **
 *************************************************************************/

#include "interp.h"
char	h[200];



/*--------------------------------------------------------------------
    Commande 'exit'.
    Fonction terminant l'execution de l'interpreteur de
    commandes. 'exit_prog()' doit etre fourni par l'utilisateur
--------------------------------------------------------------------*/
int
exit_cmd(int argc, char *argv[])
{
    exit_prog();
    return 0;
}
/*------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande permettant de creer un fichier de commande appelant
    plusieurs fois un meme fichier de commandes, avec des parametres
    reels flottants en progression arithmetique. Syntaxe :
	bouclef ....
        (loopf en version anglaise) 
    (voir le manuel d'utilisation)
----------------------------------------------------------------------*/
int 
bouclex_f(int argc, char *argv[])
{
    FILE           *stream;
    char            g[50],
                    h[150];
    int             i,
                    j,
                    inb;
    float           deb,
                    incr;

    strcpy(g, "<");
    strcpy(h, command_rep);
    strcat(h, argv[1]);
    stream = fopen(h, "w");
    if (stream == NULL) {
	err_mess(1);
	return 1;
    }
    strcat(g, argv[2]);
    inb = convert_int(argv[3]);
    deb = convert_float(argv[4]);
    incr = convert_float(argv[5]);

    for (i = 0; i < inb; i++) {
	fprintf(stream, "%s %f ", g, i * incr + deb);
	for (j = 6; j < argc; j++)
	    fprintf(stream, "%s ", argv[j]);
	fprintf(stream, "\n");
    }

    fclose(stream);
    return 0;
}
/*-------------------------------------------------------------------*/



/*---------------------------------------------------------------------
    Meme commande que precedemment, mais avec des parametres entiers
---------------------------------------------------------------------*/
int 
bouclex(int argc, char *argv[])
{
    FILE           *stream;
    char            g[50],
                    h[150];
    int             i,
                    j,
                    inb,
                    deb,
                    incr;

    strcpy(g, "<");
    strcpy(h, command_rep);
    strcat(h, argv[1]);
    stream = fopen(h, "w");
    if (stream == NULL) {
	err_mess(1);
	return 1;
    }
    strcat(g, argv[2]);
    inb = convert_int(argv[3]);
    deb = convert_int(argv[4]);
    incr = convert_int(argv[5]);

    for (i = 0; i < inb; i++) {
	fprintf(stream, "%s %d ", g, i * incr + deb);
	for (j = 6; j < argc; j++)
	    fprintf(stream, "%s ", argv[j]);
	fprintf(stream, "\n");
    }

    fclose(stream);
    return 0;
}
/*--------------------------------------------------------------------*/




/*----------------------------------------------------------------------
    Commande permettant de creer un fichier de commandes appelant
    plusieurs fois un autre fichier de commandes. Syntaxe :
    	repete com1 com2 nnn x1... xnnn
    ou 'com1' est le nom du fichier cree, 'com2' celui qui sera
    appele par 'com2', 'nnn' le nombre de fois ou 'com2' sera appele
    dans 'com1', et 'x1',...,'xnnn' les parametres sucessifs de
    'com2' (reels flottants). Si ces parametres sont en progression
    arithmetique, il revient au meme d'utiliser les commandes
    'boucle...' ou 'bouclef...'.
----------------------------------------------------------------------*/ 
int 
repetex(int argc, char *argv[])
{
    FILE           *stream;
    char            g[50],
                    h[150];
    int             i,
                    j,
                    inb;

    strcpy(h, command_rep);
    strcat(h, argv[1]);
    stream = fopen(h, "w");
    if (stream == NULL) {
	err_mess(1);
	return 1;
    }
    strcpy(g, "<");
    strcat(g, argv[2]);
    inb = convert_int(argv[3]);
    if (inb < 1) {
	err_mess(2);
	return 1;
    }
    if (argc < 4 + inb) {
	err_mess(0);
	return 1;
    }

    for (i = 0; i < inb; i++) {
	fprintf(stream, "%s %f ", g, convert_float(argv[4 + i]));
	for (j = 4 + inb; j < argc; j++)
	    fprintf(stream, "%s ", argv[j]);
	fprintf(stream, "\n");
    }

    fclose(stream);
    return 0;
}
/*--------------------------------------------------------------------*/



/*---------------------------------------------------------------------
    Commande permettant d'afficher des chaines de caracteres a
    l'ecran. Syntaxe :
 	echo xxx1 .... xxxn
    Cette commande permet de passer outre a la commande 'silence 0'.
---------------------------------------------------------------------*/  
int
echo_cmd(int argc, char *argv[])
{
    int 	    i,
                    j;
    char 	    h[3];

    h[0] = 92;
    h[1] = 110;
    h[2] = 0;
    j = prlevel;
    prlevel = -1;

    for (i = 1; i < argc; i++) {
        if (comp(argv[i], h) == 1) {
	    print("\n");
	    fflush(stdout);
	}
        else {
	    print("%s ", argv[i]);
	    fflush(stdout);
	}
    }

    prlevel = j;
    return 0;
}
/*-------------------------------------------------------------------*/



/*---------------------------------------------------------------------
    Meme commande que precedemment, mais pour afficher des entiers.
---------------------------------------------------------------------*/
int
echo_int_cmd(int argc, char *argv[])
{
    int 	    i,
		    j,
		    k;
    char 	    h[3];

    k = prlevel;
    prlevel = -1;
    h[0] = 92;
    h[1] = 110;
    h[2] = 0;

    for (i = 1; i < argc; i++) {
        if (comp(argv[i], h) == 1) {
	    print("\n");
	    fflush(stdout);
        }
        else {
            j = convert_int(argv[i]);
	    print("%d ",j);
	    fflush(stdout);
	}
    }

    prlevel = k;
    return 0;
}
/*-------------------------------------------------------------------*/



/*---------------------------------------------------------------------
    Meme commande que precedemment, mais pour afficher des flottants.
---------------------------------------------------------------------*/
int
echo_float_cmd(int argc, char *argv[])
{
    int 	    i,
		    j;
    float	    x;
    char 	    h[3];

    h[0] = 92;
    h[1] = 110;
    h[2] = 0;
    j = prlevel;
    prlevel = -1;

    for (i = 1; i < argc; i++) {
        if (comp(argv[i], h) == 1) {
	    print("\n");
	    fflush(stdout);
	}
        else {
            x = convert_float(argv[i]);
	    print("%f ", x);
	    fflush(stdout);
	}
    }

    prlevel = j;
    return 0;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande permettant d'ecrire un fichier de commandes.
    Syntaxe :
	editeur com
        (editor com  en version anglaise)
    ou 'com' est le nom du fichier de commandes.
---------------------------------------------------------------------*/
int
editeur(int argc, char *argv[])
{
    char 	    h[2000],
		    w[200];
    int 	    i,
		    ilev;
    FILE 	   *s;

    strcpy(w, command_rep);
    strcat(w, argv[1]);
    s = fopen(w, "w");
    if (s == NULL) {
	err_mess(1);
	return 0;
    }

xxx : memset(h, 0, 2000);
    fgets(h, 1999, inp[curvoice]);
    ilev = 0;
    i = 0;
    while (h[i] == 92) {
        i++;
	ilev++;
    }
    if (ilev == curvoice + 1) {
	fclose(s);
	return 1;
    }
    fputs(h, s);
    goto xxx;
}
/*-------------------------------------------------------------------*/



/*---------------------------------------------------------------------
    Commande permettant de detruire un fichier de commandes. 
    Syntaxe :
	delcom com
    ou 'com' est le nom du fichier de commandes.
---------------------------------------------------------------------*/
int
delcom(int argc, char *argv[])
{
#ifndef _MSDOS_VERSION
    char 	    w[200];

    memset(w, 0, 200);
    strcpy(w, "rm -f ");
    strcat(w, command_rep);
    strcat(w, argv[1]);
    system(w);
#endif
    return 0;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande permettant de detruire un fichier de resultats. 
    Syntaxe :
	delres fic
    ou 'fic' est le nom du fichier de commandes.
---------------------------------------------------------------------*/
int
delres(int argc, char *argv[])
{
#ifndef _MSDOS_VERSION
    char 	    w[200];

    memset(w, 0, 200);
    strcpy(w, "rm -f ");
    strcat(w, result_rep);
    strcat(w, argv[1]);
    system(w);
#endif
    return 0;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande permettant de detruire un fichier de donnees. 
    Syntaxe :
	deldon fic
	(deldat fic  en version anglaise)
    ou 'fic' est le nom du fichier de commandes.
---------------------------------------------------------------------*/
int
deldon(int argc, char *argv[])
{
#ifndef _MSDOS_VERSION
    char 	    w[200];

    memset(w, 0, 200);
    strcpy(w, "rm -f ");
    strcat(w, data_rep);
    strcat(w, argv[1]);
    system(w);
#endif
    return 0;
}
/*-------------------------------------------------------------------*/



/*---------------------------------------------------------------------
    Commande permettant l'execution conditionnelle des 
    commandes suivantes. Syntaxe :
        si xxx
    ou
        si non xxx
    'xxx' etant un nom de variable.
    Dans le premier cas, les instructions qui suivent seront
    executees si le flottant xxx est > 0., et ne le seront pas dans
    le cas contraire, jusqu'a ce que la commande 'is xxx' soit
    rencontree. Dans le cas contraire on teste si xxx <= 0.
---------------------------------------------------------------------*/
int si_cmd(int argc, char *argv[])
{
    int		    i;

    if (argc > 2 && comp(argv[1],"non") != 1) {
	err_mess(3);
        return 1;
    }
    if (n_cond == __nbcond - 1) {
	err_mess(4);
	return 1;
    }
    n_cond++;
    memset(v_cond[n_cond], 0, 100);
    if (argc == 2) {
	s_cond[n_cond] = 1;
	i = 1;
    }
    else {
	s_cond[n_cond] = -1;
        i = 2;
    }
    strcpy(v_cond[n_cond], argv[i]);
    return 0;
}
/*--------------------------------------------------------------------*/



/*----------------------------------------------------------------------
    Voir la commande precedente
----------------------------------------------------------------------*/
int is_cmd(int argc, char *argv[])
{
    if (n_cond < 0)
	return 0;
    if (comp(v_cond[n_cond], argv[1]) != 1) {
        return 0;
    }
    n_cond--;
        return 0;
}
/*--------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande permettant d'ecrire un ou des nombres dans un 
    fichier. Syntaxe :
  	ecrit fic <-bin> xxx1 .... xxxn
        (write... en version anglaise)
    ou 'fic' est un nom de fichier (qui est ou sera dans le 
    repertoire de resultats), 'xxx1',...., 'xxxn' des noms de variables.
    Si le fichier existe, on ecrit a la suite, sinon il est cree.
    Si '-bin' est present, le fichier est en format binaire, et sinon en
    mode texte, et une ligne est ecrite.
    La commande
	ecrit _ligne
    ecrit une ligne vide.
---------------------------------------------------------------------*/
int 
file_cmd(int argc, char *argv[])
{
    int		    i,
		    i0;
    char	    h[200];
    float	    x;

    i0 = -1;

    for (i = 0; i < __nss; i++) {
	if (sS[i] != NULL) {
	    if (comp(sS_nom[i], argv[1]) == 1) {
		i0 = i;
	        if (sS_i_o[i0] != 1) {
		    err_mess(29);
		    return 1;
		}
	    }
	}
    }

    if (i0 < 0) {
        for (i = 0; i < __nss; i++) {
	    if (sS[i] == NULL) {
		i0 = i;
                break;
            }
        }

        if (i0 < 0) {
	    err_mess(5);
            return 1;
        }
        memset(h, 0, 200);
        sprintf(h, "%s%s", result_rep, argv[1]);
   	sS[i0] = fopen(h, "a");
  	if (sS[i0] == NULL) {
	    err_mess(1);
	    return 1;
        }
        sS_nom[i0] = (char *) malloc( 100 * sizeof(char));
        sprintf(sS_nom[i0], "%s", argv[1]);  
	sS_i_o[i0] = 1;
    }

    if (comp(argv[2],"_ligne") == 1) {
	fprintf(sS[i0], "\n");
        return 0;
    }
    if (comp(argv[2],"-bin") == 1) {
	for (i = 3; i < argc; i++) {
	    x = convert_float(argv[i]);
            fwrite(&x, sizeof(float), 1 , sS[i0]);
        }
    }
    else {
        for (i = 2; i < argc; i++) {
            fprintf(sS[i0], "%f    ", convert_float(argv[i]));
            sS_cmpt[i0]++;
            if (sS_cmpt[i0] > 9)
	        fflush(sS[i0]);
        }
    
        fprintf(sS[i0], "\n");
    }  

    return 0;
}
/*--------------------------------------------------------------------*/



/*---------------------------------------------------------------------
    Commande permettant de lire la valeur d'une variable dans
    un fichier (situe dans le repertoire de resultats). Syntaxe :
	lit fic xxx
        (read fic xxx  en version anglaise)
    ou 'fic' est le nom du fichier, 'xxx' le nom de la variable.
---------------------------------------------------------------------*/
int 
fread_cmd(int argc, char *argv[])
{
    int		    i,
		    i0,
		    ind;
    char	    h[200];
    float	    x;

    i0 = -1;

    for (i = 0; i < __nss; i++) {
	if (sS[i] != NULL) {
	    if (comp(sS_nom[i], argv[1]) == 1) {
		i0 = i;
	        if (sS_i_o[i0] != -1) {
		    err_mess(30);
		    return 1;
		}
	    }
	}
    }

    if (i0 < 0) {
        for (i = 0; i < __nss; i++) {
	    if (sS[i] == NULL) {
		i0 = i;
                break;
            }
        }

        if (i0 < 0) {
	    err_mess(5);
            return 1;
        }
        memset(h, 0, 200);
        sprintf(h, "%s%s", result_rep, argv[1]);
   	sS[i0] = fopen(h, "r");
  	if (sS[i0] == NULL) {
	    err_mess(1);
	    return 1;
        }
        sS_nom[i0] = (char *) malloc( 100 * sizeof(char));
        sprintf(sS_nom[i0], "%s", argv[1]); 
	sS_i_o[i0] = -1; 
    }

    x = 0.0;
    if (argc <= 3 || comp(argv[2],"-bin") != 1) { 
        fscanf(sS[i0], "%f", &x);
        memset(h, 0, 200);
        ind = 0;
    }
    else {
	fread(&x, 4, 1, sS[i0]);
	ind = 1;
    }
    sprintf(h, "%s=%f", argv[2 + ind], x);
    convert_float(h);
    return 0;
}
/*--------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande permettant de fermer un fichier precedemment 
    ouvert par une commande 'lit...' ou 'ecrit...'. Syntaxe :
  	close fic
    ou 'fic' est le nom du fichier.
----------------------------------------------------------------------*/
int
close_file_cmd(int argc, char *argv[])
{
    int		    i,
		    i0;

    i0 = -1;

    for (i = 0; i < __nss; i++) {
	if (sS[i] != NULL) {
	    if (comp(sS_nom[i], argv[1]) == 1)
		i0 = i;
	}
    }

    if (i0 < 0) {
	err_mess(6);
        return 1;
    }
    fclose(sS[i0]);
    sS[i0] = NULL;
    free(sS_nom[i0]);
    sS_cmpt[i0] = 0;
    sS_i_o[i0] = 0;
    return 0;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande permettant d'executer un fichier de questions.
    Syntaxe :
	question fic
    ou 'fic' est le nom du fichier de questions.
---------------------------------------------------------------------*/
int
question_cmd(int argc, char *argv[])
{
    int		    ii,
		    j,
		    n_quest;
    FILE 	   *s;
    char 	    h[100],
		    k[300],
		    k2[300],
                   *v;
    float	    x;

    if (argc >= 2) {
        memset(h, 0, 100);
        strcpy(h, command_rep);
        strcat(h, argv[1]);
        s = fopen(h, "r");
        if (s == NULL) {
	    err_mess(1);
	    return 1;
        }
        if (fscanf(s, "%d", &n_quest) == EOF) {
	    err_mess(7);
	    return 1;
        }
        if (n_quest < 1) {
  	    err_mess(2);
	    return 1;
        }
        fgets(k, 299, s);

        for (j = 0; j < n_quest; j++) {
            memset(k, 0, 300);
            memset(k2, 0, 300);

  	    if (fgets(k, 299, s) == NULL) {
	        err_mess(7);
                fclose(s);
	        return 1;
            }
            if ((int) strlen(k) < 2) {
	        err_mess(7);
                fclose(s);
	        return 1;
            }
            nettoie(k);
            if (prlevel <= 0) {
                print("%s ", k);
            }
            memset(k, 0, 100);
	    if (fgets(k, 299, s) == NULL) {
	        err_mess(7);
                fclose(s);
	        return 1;
            }
            nettoie(k);
            if (k[0] != '$') {
                scanf("%f", &x);
                sprintf(k2, "%s=%f", k, x);
                convert_float(k2);
            }
            else {
	        if ((int) strlen(k) < 2) {
	            err_mess(7);
                    fclose(s);
	            return 1;
                }
                v = k + 1;
	        ii = convert_int(v);
	        if (ii < 0 || ii > __max_quest) {
	            err_mess(7);
                    fclose(s);
	            return 1;
                }
                memset(h, 0, 100);
                fgets(h, 299, inp[curvoice]);
                nettoie(h);
                if (strlen(h) > 0) {
     		    memset(ques[ii], 0, 300);
		    strcpy(ques[ii], h);
		}
            }
        }

        fclose(s);
        return 0;
    }
    else {
	read_int(&n_quest);
   	if (n_quest <= 0) {
	    err_mess(7);
	    return 1;
 	}

        for (j = 0; j < n_quest; j++) {
            memset(h, 0, 100);
            read_char(h);
	    memset(k, 0, 100);
            read_char(k);
            v = k + 1;
            ii = convert_int(v);
	    if (ii < 0 || ii > __max_quest) {
	        err_mess(7);
	        return 1;
            }
            if (strlen(h) > 0) {
     		memset(ques[ii], 0, 300);
		strcpy(ques[ii], h);
	    }
	}
    }
    return 0;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande permettant d'afficher la liste des variables 
    utilisees et leur valeur. Syntaxe :
	varlist
----------------------------------------------------------------------*/
int
var_list_cmd(int argc, char *argv[])
{
    int 	    i;

    for (i = 0; i < MAXXVARS; i++) {
	if ((int) strlen(Vars[i].name) > 0) {
	    if (prlevel <= 0 && Vars[i].name[0] != 127) {
		print("%s = %f\n", Vars[i].name, (float)Vars[i].value);
            }
	}
    }

    return 0;
}
/*--------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande permettant de supprimer une variable. Syntaxe :
	undef xxx
    ou 'xxx' est le nom d'une variable.
----------------------------------------------------------------------*/
int
undef_cmd(int argc, char *argv[])
{
    int 	    i,
		    j;

    for (i = 0; i < MAXXVARS; i++) {
	if (comp(argv[1], Vars[i].name) == 1) 
	    for (j = 0; j <= XVARLEN; j++)
	 	Vars[i].name[j] = 0;

    }

    return 0;
}
/*-------------------------------------------------------------------*/




/*--------------------------------------------------------------------
	Commande supprimant les affichages du programme 
        (sauf les messages d'erreur), ou les retablissant. Syntaxe :
 	    silence <nnn>
        Si nnn=0, les affichages seront supprimes, ils seront retablis
        si nnn est non nul.
--------------------------------------------------------------------*/
int 
silence_cmd(int argc, char *argv[])
{
    if (convert_int(argv[1]) == 0) 
	prlevel = 1;
    else prlevel = 0;

    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Commande.
    Determine si il faut afficher le temps d'execution des commandes.
    Syntaxe :
        horloge nnn
        (time nnn en version anglaise)
    ou nnn est un entier. Si nnn=0 les temps d'execution ne sont pas 
    affiches, et dans le cas contraire ils le sont. La valeur par defaut
    est 0. 
---------------------------------------------------------------------*/
int
temps(int argc, char *argv[])
{
    int             i;

    i = convert_int(argv[1]);
    horloge = 0;
    if (i != 0)
	horloge = 1;
    return 0;
}
/*--------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Commande. Syntaxe :
	progliste <arg>
        (proglist <arg>  en version anglaise)
    Sans argument, donne la liste des programmes. Avec un argument, 
    donne la liste des instructions du programme dont le nom est cet 
    argument. 
---------------------------------------------------------------------*/
int
proglist_cmd(int argc, char *argv[])
{
    int             i,
		    j,
		    l;
    char	    h[200],
		    k[20],
		   *v;

    if (prlevel > 0)
        return 0;
    if (argc == 1) {
	for (i = 0; i < nb_com; i++) {
	    print("%s\n", nom_com[i]);
        }
        return 0;
    }

    for (i = 0; i < nb_com; i++) {
	if (comp(nom_com[i], argv[1]) == 1) {
            for (j = 0; j < nb_lignes[i]; j++) {
                memset(h, 0, 200);

		for (l = 0; l < nb_label[i]; l++) 
                    if (num_label[i][l] == j) {
                        memset(k, 0, 20);
                        sprintf(k, "%d: \n", l);
                       /* strcat(h, k);*/
                        printf(k);
		    }
        
                v = ligne_com[i][j];
                if (ligne_com[i][j][0] == _GOTO) {
 		    v = ligne_com[i][j] + 1;
		    strcat(h, "goto ");
                }
                if (ligne_com[i][j][0] == _IFGT) {
 		    v = ligne_com[i][j] + 1;
		    strcat(h, "if>");
                }
                if (ligne_com[i][j][0] == _IFLT) {
 		    v = ligne_com[i][j] + 1;
		    strcat(h, "if<");
                }
                if (ligne_com[i][j][0] == _IFEQ) {
 		    v = ligne_com[i][j] + 1;
		    strcat(h, "if=");
                }
                if (ligne_com[i][j][0] == _EVAL) {
 		    v = ligne_com[i][j] + 1;
                }
                strcat(h, v);
                print("%s\n", h);
            }
            
            memset(h, 0, 200);

            for (l = 0; l < nb_label[i]; l++)
                if (num_label[i][l] >= nb_lignes[i]) {
		    memset(k, 0, 20);
                    sprintf(k, "%d: ", l);
                    strcat(h, k);
                }

            if ((int) strlen(h) > 0) {
		print("%s\n", h);
            }
            return 0;
        }
    }
    err_mess(24);
    return 0;
}
/*--------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Commande. Syntaxe :
	load <fic>
    Charge le fichier de programmes <fic> du repertoire de commandes. 
---------------------------------------------------------------------*/
int 
load_cmd(int argc, char *argv[])
{
    char	    h[200];
    
    memset(h, 0, 200);
    strcpy(h, command_rep);
    strcat(h, argv[1]);
    charge_com(h, NULL, 0);
    traite_label();
    return 0;
}
/*-------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Commande. Syntaxe :
	shell <char>
    Execute la commande du shell contenue dans la chaine de caracteres
    <char>, pouvant eventuellement contenir des blancs. 
---------------------------------------------------------------------*/
int 
shell_cmd(int argc, char *argv[])
{
    char	    h[300];
    int		    i;    

    memset(h, 0, 300);
    for (i = 1; i < argc; i++) {   
	strcat(h, argv[i]);
        strcat(h, " ");
    }

    system(h);
    return 0;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Fonction rendant accessibles les variables cachees
---------------------------------------------------------------------*/
void
init_var(void)
{
    int 	    i;
    char	    h[100],
		   *k;

    for (i = 0; i < MAXXVARS; i++) {
	if ((int) strlen(Vars[i].name) > 0) {
	    if (Vars[i].name[0] == 127) {
                memset(h, 0, 100);
	   	k = Vars[i].name + 1;
                strcpy(h, k);
                strcat(h, "=");
                strcat(h, Vars[i].name);
                convert_int(h);
            }
        }
    }
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande rendant accessibles les variables cachees. Syntaxe :
	initvar.
---------------------------------------------------------------------*/
int
init_var_cmd(int argc, char *argv[])
{
    init_var();
    return 0;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande activant l'affichage des numeros de commandes.
    Syntaxe :
	numcom 1
    provoque l'affichage des numeros de commandes, et
	numcom 0
    provoque la suppression de cet affichage.
---------------------------------------------------------------------*/
int
num_com(int argc, char *argv[])
{
    if (convert_int(argv[1]) != 0)
	pr_com = 1;
    else
	pr_com = 0;
    return 0;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande activant l'affichage des numeros de commandes. Syntaxe :
	hist
    Le nombre de commandes affichees est un parametre du fichier
    'interp.ini'.
---------------------------------------------------------------------*/
int
hist_cmd(int argc, char *argv[])
{
    int		    i,
		    j;

    j = i_com + 1;

    for (i = 0; i < __n_com_prec; i++) {
	j--;
        if (j < 0)
	    j = __n_com_prec - 1;
	if (ix_com - i > 0 && prlevel <= 0) {
	    print("    %d    %s\n", ix_com - i - 1, com_prec[j]);
	}
    }

    return 0;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande d'ouverture d'un fichier contenant les contenant les 
    commandes et les reponses du programme ulterieures. Syntaxe :
	mon <fic>
    ou <fic> est un nom de fichier.
---------------------------------------------------------------------*/
int
mon_cmd(int argc, char *argv[])
{
    if (Mon_File != NULL)
	fclose(Mon_File);
    Mon_File = fopen(argv[1], "w");
    return 0;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande de fermeture du fichier contenant les commandes et les 
    reponses du programme ulterieures. Syntaxe :
	fin_mon
---------------------------------------------------------------------*/
int
fin_mon_cmd(int argc, char *argv[])
{
    if (Mon_File != NULL)
	fclose(Mon_File);
    Mon_File = NULL;
    return 0;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    routine d'impression permettant l'ecriture simultanee dans
    le fichier 'MonFile'.
---------------------------------------------------------------------*/
void
print(char *fo, ...)
{
    va_list 	    ap;
    int		    i,
		    i_val,
                    icmpt,
                    icmpt2,
                    n_arg,
                    len;
    float	    f_val;
    char 	   *pr,
                    h[100];
    
    va_start(ap, fo);
    pr = NULL;
    if (prlevel > 0)
	goto fin;
    len = strlen(fo);
    n_arg = 0;
    for (i = 0; i < len; i++)
	if (fo[i] == '%')
	    n_arg++;
    if (n_arg == 0) {
	pr = ch_copy(fo);
        goto impr;
    }
    pr = (char *) malloc(250 * sizeof(char));
    memset(pr, 0, 250);
    icmpt = 0;
    icmpt2 = 0;

    for (i = 0; i < n_arg; i++) {
        while (fo[icmpt] != '%') {
	    pr[icmpt2++] = fo[icmpt++];
        }

        icmpt++;
        if (icmpt > len)
	    goto fin;

        if (fo[icmpt] !=  's' && fo[icmpt] != 'd' && fo[icmpt] != 'f')
	    goto fin;
        if (fo[icmpt] == 's') {
	    memset(h, 0, 100);
            sprintf(h, "%s", va_arg(ap, char*));
        }
	if (fo[icmpt] == 'd') {
	    memset(h, 0, 100);
            i_val = va_arg(ap, int);
            sprintf(h, "%d", i_val);
        }
	if (fo[icmpt] == 'f') {
	    memset(h, 0, 100);
            f_val = va_arg(ap, double);
            sprintf(h, "%g", f_val);
        }
        icmpt++;
        strcat(pr, h);
        icmpt2 += strlen(h);
    }

    for (i = icmpt; i < len; i++) {
        pr[icmpt2] = fo[i];
	icmpt2++;
    }

impr : printf(pr);
    if (Mon_File != NULL)
	fprintf(Mon_File, pr);

fin : if (pr != NULL)
	free(pr);
    va_end(ap);
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande d'ecriture immediate du fichier moniteur. Syntaxe :
	flush_cmd
---------------------------------------------------------------------*/
int
flush_cmd(int argc, char *argv[])
{
    if (Mon_File != NULL)
	fflush(Mon_File);
    return 0;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande d'ecriture immediate du fichier moniteur. Syntaxe :
	flush_cmd
---------------------------------------------------------------------*/
int
greetb_cmd(int argc, char *argv[])
{
    int 	    i;

    for (i = 0; i < i_greet; i++)
         if (prlevel <= 0)
	     printf("%s\n", greet[i]);
    return 0;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Routine d'affichage d'un message
----------------------------------------------------------------------*/
void
error_mess(int i)
{
    printf("                      ; %s\n", mess[i]);
    if (Mon_File != NULL)
        fprintf(Mon_File, "                      ; %s\n", mess[i]);
}
/*--------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Ouverture d'un fichier dont le nom est composite (1)
---------------------------------------------------------------------*/
FILE
*Copen(char *debut, char *fin, char *format)
{
    memset(h, 0, 200);
    strcpy(h, debut);
    strcat(h, fin);
    return fopen(h, format);
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Ouverture d'un fichier dont le nom est composite (2)
---------------------------------------------------------------------*/
FILE
*CCopen(char *debut, char *milieu, char *fin, char *format)
{
    memset(h, 0, 200);
    sprintf(h, "%s%s%s", debut, milieu, fin);
    return fopen(h, format);
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Ouverture d'un fichier dont le nom est composite (4)
---------------------------------------------------------------------*/
FILE
*CIopen(char *debut, char *fin, char *format, int i)
{
    memset(h, 0, 200);
    sprintf(h, "%s.%s.%d", debut, fin, i);
    return fopen(h, format);
}
/*-------------------------------------------------------------------*/
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
---------------------------------------------------------------------*/
int
time_cmd(int argc, char *argv[])
{
    long	    i;

    if (argc > 1)
	time(&i_time_x);
    else {
        time(&i);
#ifdef _ENG_LANG
	print("Time : %d s\n", i - i_time_x);
#else
	print("Temps : %d s\n", i - i_time_x);
#endif
    }
    return 0;
}
/*-------------------------------------------------------------------*/
