/*************************************************************************
** interpcom-1.1 (command interpreter)                                   **
** objdef.c : Creation and manipulation of 'objects' and 'structures'    **
**                                                                       **
** Copyright (C) 1998  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**									 **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details. 			 **
**									 **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free		 **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France								 **
**                                                                       **
 *************************************************************************/

#include "interp.h"



/*-------------------------------------------------------------------
    Commande systeme de creation de types d'objets (commande 'def')
-------------------------------------------------------------------*/
int
objdef_cmd(FILE *s, char *name_c)
{
    int		    slen,
		    i,
		    j,
		    l,
                   *n_o,
		    ntyp,
                   *nb_dim,
                   *categ;
    char	    h_ligne[100],
		  **comment,
		  **name_com,
		 ***n_dim,
		    k[100];
                     
    ntyp = -1;
 
    n_o = int_alloc1(__nbtypmax);
    nb_dim = int_alloc1(__nbtypmax);
    categ = int_alloc1(__nbtypmax);

    comment = (char **)malloc((size_t) __nbtypmax * sizeof(char *));
    comment[0] = (char *)malloc((size_t) __nbtypmax * 100 * sizeof(char));
    for (i = 1; i < __nbtypmax; i++)
	comment[i] = comment[i - 1] + 100;
    name_com = (char **)malloc((size_t) __nbtypmax * sizeof(char *));
    name_com[0] = (char *)malloc((size_t) __nbtypmax * 100 * sizeof(char));
    for (i = 1; i < __nbtypmax; i++)
	name_com[i] = name_com[i - 1] + 100;
    n_dim = (char ***)malloc((size_t) __nbtypmax * sizeof(char **));
    mode_com_obj = int_alloc2(__nbtypmax, __nmode_fonc);

    for (i = 0; i < __nbtypmax; i++) {
        memset(comment[i], 0, 100);
        memset(name_com[i], 0, 100);
    }

    memset(h_ligne, 0, 100);

    while (fgets(h_ligne, 99, s) != NULL) {
        if (h_ligne[0] == '.')
	    goto xxx;
        if (h_ligne[0] != ';') {

/*-------------------------------------
    Nom de la commande creant l'objet
-------------------------------------*/
	    slen = strlen(h_ligne) - 1;
            if (slen < 2) 
		exit_interp("def");
            ntyp++;
            h_ligne[slen] = 0;
            memcpy(name_com[ntyp], h_ligne, slen + 1);

/*-------------------------------------
    Modes de fonctionnement
-------------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets(h_ligne, 99, s) == NULL) 
		exit_interp("def");
            nettoie(h_ligne);
	    slen = strlen(h_ligne);
            i = 0;
            j = -1;
            memset(k, 0, 100);

            while (i < slen) {
	        if (h_ligne[i] != ' ') {
	   	    j++;
                    k[j] = h_ligne[i];
                    i++;
                }
                if (h_ligne[i] == ' ' || i == slen) {
                    if ((int) strlen(k) > 0) {
	                j = convert_int(k);
                        if (j < 0)
		            for (l = 0; l < __nmode_fonc; l++)
		                mode_com_obj[ntyp][l] = 1;
                        else
		            if (j < __nmode_fonc)
			        mode_com_obj[ntyp][j] = 1;
	                memset(k, 0, 100);
                        j = -1;
		    }
                    i++;
                }
            }



/*------------------------------------
    Type de variable
------------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets(h_ligne, 99, s) == NULL) 
		exit_interp("def");
            nettoie(h_ligne);
            categ[ntyp] = convert_int(h_ligne);
            if (categ[ntyp] < 0 || categ[ntyp] > 7) 
		exit_interp("def");


/*------------------------------------
    Nombre de dimensions
------------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets(h_ligne, 99, s) == NULL) 
		exit_interp("def");
            nettoie(h_ligne);
            nb_dim[ntyp] = convert_int(h_ligne);
            if (nb_dim[ntyp] < 0 || (categ[ntyp] == 7 && nb_dim[ntyp] != 1)) 
		exit_interp("def");


/*------------------------------------
    Description de l'objet
------------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets(h_ligne, 99, s) == NULL) 
		exit_interp("def");
            memcpy(comment[ntyp], h_ligne, strlen(h_ligne) - 1);


/*------------------------------------
    Noms des dimensions 
------------------------------------*/
	    n_dim[ntyp] = (char **) malloc((size_t) nb_dim[ntyp] *
		sizeof(char *));
        
	    for (i = 0; i < nb_dim[ntyp]; i++) {
	        memset(h_ligne, 0, 100);
                if (fgets(h_ligne, 99, s) == NULL) 
		    exit_interp("def");
                nettoie(h_ligne);
                n_dim[ntyp][i] = ch_copy(h_ligne);
 	    }
 

/*-----------------------------------
    Nombre d'objets maximal
-----------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets(h_ligne, 99, s) == NULL) 
		exit_interp("def");
            nettoie(h_ligne);
            n_o[ntyp] = S_convert_int(h_ligne);
            memset(h_ligne, 0, 100);
        }
    }

xxx: ntyp++;
        Obj_typ = (obj_typ *) malloc((size_t) ntyp * sizeof(obj_typ));
        Obj = (obj **) malloc((size_t) ntyp * sizeof(obj *));
        
        nb_typ = ntyp;

    for (i = 0; i < ntyp; i++) {
/*-------- Nombre d'objets numero i ----------------*/
        Obj_typ[i].nombre = n_o[i];
/*--------------------------------------------------*/  

/*-------- Nombre de dimensions des objets i -------*/
	Obj_typ[i].nbdim = nb_dim[i];
/*--------------------------------------------------*/     

/*------ Type de l'objet numero i ------------------*/
        Obj_typ[i].type = categ[i];
/*--------------------------------------------------*/     
  
/*--- Noms des dimensions --------------------------*/
        Obj_typ[i].nom_dim = (char **) malloc((size_t) nb_dim[i]
	    * sizeof(char *));
        for (j = 0; j < nb_dim[i]; j++)
            (Obj_typ[i].nom_dim)[j] = ch_copy(n_dim[i][j]);
/*-------------------------------------------------*/       


/*---------- Nom des objets numero i --------------*/
        Obj_typ[i].nom = ch_copy(name_com[i]);
/*-------------------------------------------------*/


/*---------- Commentaire --------------------------*/
        Obj_typ[i].comment = ch_copy(comment[i]);
/*-------------------------------------------------*/


/*---------- Creation du tableau d'objets ---------*/
        Obj[i] = (obj *) malloc((size_t) n_o[i] * sizeof(obj));
/*-------------------------------------------------*/


/*---------- Caracteristiques communes a tous les
             objets numero i ----------------------*/
	for (j = 0; j < n_o[i]; j++) {
	    Obj[i][j].typ_obj = &Obj_typ[i];
            Obj[i][j].occup = 0;         /* objet non alloue */
        }
/*-------------------------------------------------*/


/*---------- Creation du programme de
             creation d'un objet numero i ---------*/
        make_com(name_com[i], i, mode_com_obj[i]);
/*-------------------------------------------------*/
    }

    free(comment[0]);
    free(comment);
    free(name_com[0]);
    free(name_com);

    for (i = 0; i < ntyp; i++) {
	for (j = 0; j < nb_dim[i]; j++)
	    free(n_dim[i][j]);
        free(n_dim[i]);
    }

    free(n_dim);
    XFREE(n_o);
    XFREE(nb_dim);
    XFREE(categ);
    return 0;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Nettoyage d'une chaine de caracteres (supprime le \n de la fin)
-------------------------------------------------------------------*/
void
nettoie(char *h)
{
    h[strlen(h) - 1] = 0;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Creation d'une chaine de caractere identique a une autre
-------------------------------------------------------------------*/
char *
ch_copy(char *s) 
{
    char  	   *t;
    int		    slen;

    slen = strlen(s);
    t = (char *) malloc((size_t) (slen + 1) * sizeof(char));
    memcpy(t, s, slen);
    t[slen] = 0;
    return t;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Fonction appelee par objdef_cmd. Cree le programme
    de creation de l'objet 'ind', en utilisant le nom 'name_c'
-------------------------------------------------------------------*/
void
make_com(char *name_c, int ind, int *mode_c)
{
    int		    n,
		    i;
    char	    h[10];

    memset(h, 0, 10);
    nb_com++;
    nom_com[nb_com - 1] = ch_copy(name_c);
    nb_par[nb_com - 1] = 1;
    sil_com[nb_com - 1] = 0;
    nb_lignes[nb_com - 1] = 1;
    for (i = 0; i < __nmode_fonc; i++)
	mode_com_int[nb_com - 1][i] = mode_c[i];
    ligne_com[nb_com - 1][0] = (char *) malloc((size_t) 80 * sizeof(char));
    memset(ligne_com[nb_com - 1][0], 0, 80);
    sprintf(ligne_com[nb_com - 1][0],"objdef");
    ligne_com[nb_com - 1][0][6] = 32;
    sprintf(h, "%d", ind);
    strcat(ligne_com[nb_com - 1][0], h);
    n = strlen(h) + 6;
    ligne_com[nb_com - 1][0][++n] = 32;
    ligne_com[nb_com - 1][0][++n] = '#';
    ligne_com[nb_com - 1][0][++n] = '1';
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Commande creant un objet. Cette commande ne doit pas etre 
    appelee directement. Les objets sont crees par des programmes 
    generes automatiquement a la lecture du fichier 'interp.ini'.
-------------------------------------------------------------------*/
int
obj_create(int argc, char *argv[])
{
    int             iw,
		    j,
		    k,
		    l,
		    nb,
		    typ;
    char	    nom[100],
		    h[100];

    
    nb = 0;
    typ = convert_int(argv[1]);
    l = -1;

    for (k = 2; k < 3; k++) {
        if (argv[k][0] != '#' && (int) strlen(argv[k]) > 0) {
            memset(nom, 0, 30);
            iw = parse_def(argv[k], &nb, nom);
            if (iw == 0) {
	        err_mess(8);
	        return -1;
            }
            if (iw == 2) {
		l = test_nom_obj(argv[k], typ);
	        if (l == -1)
		    return -1;
 	    } 
            else {
	        for (j = 1; j <= nb; j++) {
                    memset(h, 0, 100);
	            sprintf(h, "%s[%d]", nom, j);
		    l = test_nom_obj(h, typ);
                    if (l == -1)
			return -1;
	        }
            }
        }
    }

    return l;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Fonction appelee par la precedente. Cree l'objet si son
    nom est correct (pas deja utilise).
-------------------------------------------------------------------*/
int
test_nom_obj(char *h, int typ)
{
    int 	    i,
		    j,
		    k,
		    nb,
		    nbdim,
		    slen;
    memm	   *M;

    nb = Obj_typ[typ].nombre;
    slen = strlen(h);
    
    if (slen > 20) {
	err_mess(9);
        return -1;
    }


/*----------------------------------------------------
    On verifie d'abord s'il reste de la place
----------------------------------------------------*/
    j = 0;

    for (i = 0; i < nb; i++) {
	if (Obj[typ][i].occup == 1)
	    j++;
	else
	    break;
    }

    if (j == nb) {
	err_mess(10);
        return -1;
    }
    j = i;    /* numero de la premiere place 
                 inoccupee pour l'objet */
/*--------------------------------------------------*/



/*----------------------------------------------------
    On verifie ensuite si le nom de l'objet
    n'a pas deja ete utilise
----------------------------------------------------*/
    for (i = 0; i < nb_typ; i++) {
        for (k = 0; k < Obj_typ[i].nombre; k++) {
	    if (Obj[i][k].occup == 1) {
	        if (comp(Obj[i][k].nom_obj, h) == 1) {
		    err_mess(11);
                    return -1;
                }
            }
        }
    }
/*--------------------------------------------------*/


/*----------------------------------------------------
    Creation de l'objet
----------------------------------------------------*/
    Obj[typ][j].occup = 1;  
    Obj[typ][j].nom_obj = ch_copy(h);
    nbdim = Obj_typ[typ].nbdim;
    Obj[typ][j].dim = (int *) malloc((size_t) nbdim * sizeof(int));
    if (Obj_typ[typ].type < 7) {
        for (i = 0; i < nbdim; i++)
	    (Obj[typ][j].dim)[i] = S_convert_int((Obj_typ[typ].nom_dim)[i]);
        M = memm_alloc(Obj[typ][j].dim, nbdim, Obj_typ[typ].type);
    }
    else {
	(Obj[typ][j].dim)[0] = 10;
        M = memm_alloc(Obj[typ][j].dim, nbdim, 0);
    }
    Obj[typ][j].adresse = (char *) M[0].ad;
    return j;

/*--------------------------------------------------*/

}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Commande de destruction d'un objet ou d'une structure. 
    Syntaxe :
    	detruit <objet>
        (destroy en version anglaise)
-------------------------------------------------------------------*/
int
detruit_obj(int argc, char *argv[])
{
    int		    i,
		    j,
		    typ;

    for (i = 1; i < argc; i++) {
 	for (typ = 0; typ < nb_typ; typ++) {
	    for (j = 0; j < Obj_typ[typ].nombre; j++) {
		if (Obj[typ][j].occup == 1) {
                    if (comp(Obj[typ][j].nom_obj, argv[i]) == 1) {
		        free(Obj[typ][j].nom_obj);
                        Obj[typ][j].occup = 0;
			dest_prop(typ, j);
			XFREE(Obj[typ][j].adresse);
                        free(Obj[typ][j].dim);
                        return 0;
		    }
		}
	    }
	}
    }

    for (i = 1; i < argc; i++) {
 	for (typ = 0; typ < nb_struc; typ++) {
	    for (j = 0; j < Struc_typ[typ].nombre; j++) {
		if (Struc[typ][j].occup == 1) {
                    if (comp(Struc[typ][j].nom_struc, argv[i]) == 1) {
		        free(Struc[typ][j].nom_struc);
                        Struc[typ][j].occup = 0;
                        free((Struc[typ][j].nom_mb)[0]);
                        free(Struc[typ][j].nom_mb);
                        return 0;
		    }
		}
	    }
	}
    }

    err_mess(12);
    return 1;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Commande d'affichage du nom de tous les objets. Syntaxe :
    	liste
	(list en version anglaise)
-------------------------------------------------------------------*/
int
liste_obj(int argc, char *argv[])
{
    int 	    i,
		    typ;

    if (prlevel > 0)
	return 0;

    for (typ = 0; typ < nb_typ; typ++) {
        if (mode_com_obj[typ][mode_fonct_] == 1) {
	    print("                    %s\n", Obj_typ[typ].comment);

            for (i = 0; i < Obj_typ[typ].nombre; i++) {
	        if (Obj[typ][i].occup == 1) {
		    print("                        %s\n",
 			Obj[typ][i].nom_obj);
                }
	    }
        }
    }

    for (typ = 0; typ < nb_struc; typ++) {
        if (mode_com_str[typ][mode_fonct_] == 1) {
	    print("                    %s\n", Struc_typ[typ].comment);

            for (i = 0; i < Struc_typ[typ].nombre; i++) {
	        if (Struc[typ][i].occup == 1) {
		    print("                        %s\n",
 			Struc[typ][i].nom_struc);
                }
	    }
        }
    }

    return 0;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Fonction de destruction de tous les objets de type 'typ'
-------------------------------------------------------------------*/
void
init_obj(int typ)
{
    int		    i;

    if (typ < 0 || typ >= nb_typ) {
	err_mess(13);
        return;
    }
    
    for (i = 0; i < Obj_typ[typ].nombre; i++) {
	if (Obj[typ][i].occup == 1) {
            dest_prop(typ, i);
	    XFREE(Obj[typ][i].adresse);
            free(Obj[typ][i].nom_obj);
	    Obj[typ][i].occup = 0;
            free(Obj[typ][i].dim);
	}
    }
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Fonction de determination du type de l'objet nomme w.
    Retourne 1+(numero de type). Retourne 0 si l'objet n'existe
    pas. En cas d'existence, 'i0' contient le numero de l'objet.
-------------------------------------------------------------------*/
int
sketch_obj(char *w, int *i0)
{
    int 	    typ,
		    i;

    *i0 = -1;

    for (typ = 0; typ < nb_typ; typ++) {
	for (i = 0; i < Obj_typ[typ].nombre; i++) {
	    if (Obj[typ][i].occup == 1) {
		if (comp(w, Obj[typ][i].nom_obj) == 1) {
		    *i0 = i;
		    return (typ + 1);
		}
	    }
	}
    }

    for (typ = 0; typ < nb_struc; typ++) {
	for (i = 0; i < Struc_typ[typ].nombre; i++) {
	    if (Struc[typ][i].occup == 1) {
		if (comp(w, Struc[typ][i].nom_struc) == 1) {
		    *i0 = i;
		    return (- typ - 1);
		}
	    }
	}
    }

    return 0;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Fonction de determination du type de l'objet nomme w.
    Retourne i1 si c'est un objet de type i1-1. Retourne 0 dans le 
    cas contraire. En cas d'existence, 'i0' contient le numero de 
    l'objet. C'est une version plus rapide de la fonction
    precedente, ou on connait a priri le type de l'objet.
-------------------------------------------------------------------*/
int
sketch_obj_restr(char *w, int *i0, int i1)
{
    int 	    typ, 
		    i;

    *i0 = -1;
    typ = i1 - 1;
    if (i1 < 0) 
	typ = -i1 - 1;

    if (i1 > 0) {
	for (i = 0; i < Obj_typ[typ].nombre; i++) {
	    if (Obj[typ][i].occup == 1) {
		if (comp(w, Obj[typ][i].nom_obj) == 1) {
		    *i0 = i;
		    return (typ + 1);
		}
	    }
	}
    }

    else {
	for (i = 0; i < Struc_typ[typ].nombre; i++) {
	    if (Struc[typ][i].occup == 1) {
		if (comp(w, Struc[typ][i].nom_struc) == 1) {
		    *i0 = i;
		    return (- typ - 1);
		}
	    }
	}
    }

    return 0;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Fonction de determination du type de deux objets nommes w1 et
    w2. Retourne 1+(numero de type) si les deux objets existent et
    sont de meme type. Retourne 0 dans le cas contraire.
    Si les objets existent et sont de meme type, 'i1' contient le 
    numero du premier objet, et 'i2' celui du second.
-------------------------------------------------------------------*/
int
sketch_obj2(char *w1, char *w2, int *i1, int *i2)
{
    int 	    typ,
                    j1,
                    j2,
		    i,
                    ind;

    *i1 = -1;
    *i2 = -1;
    j1 = -1;
    j2 = -1;
    ind = 0;

    for (typ = 0; typ < nb_typ; typ++) {
        for (i = 0; i < Obj_typ[typ].nombre; i++) {
            if (Obj[typ][i].occup == 1) {
		if (comp(w1, Obj[typ][i].nom_obj) == 1) {
		    j1 = typ;
                    *i1 = i;
                    break;
                }
	    }
        }
    }

    if (*i1 == -1) {
        ind = 1;
 
        for (typ = 0; typ < nb_struc; typ++) {
            for (i = 0; i < Struc_typ[typ].nombre; i++) {
                if (Struc[typ][i].occup == 1) {
		    if (comp(w1, Struc[typ][i].nom_struc) == 1) {
		        j1 = typ;
                        *i1 = i;
                        break;
                    }
	        }
            }
        }
    }

    if (*i1 == -1) 
	return 0;
     
    if (ind == 0) {
        for (typ = 0; typ < nb_typ; typ++) {
            for (i = 0; i < Obj_typ[typ].nombre; i++) {
                if (Obj[typ][i].occup == 1) {
		    if (comp(w2, Obj[typ][i].nom_obj) == 1) {
		        j2 = typ;
                        *i2 = i;
                        break;
                    }
	        }
            }
        }
    }

    else {
        for (typ = 0; typ < nb_struc; typ++) {
            for (i = 0; i < Struc_typ[typ].nombre; i++) {
                if (Struc[typ][i].occup == 1) {
		    if (comp(w2, Struc[typ][i].nom_struc) == 1) {
		        j2 = typ;
                        *i2 = i;
                        break;
                    }
	        }
            }
        } 
    }

    if (*i2 == -1) 
	return 0;
    if (j1 != j2)
        return 0;
    if (ind == 0)
	return (j1 + 1);
    else
    	return (-j1 - 1);
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Meme chose que precedemment, mais avec 3 objets.
-------------------------------------------------------------------*/
int
sketch_obj3(char *w1, char *w2, char *w3,int *i1, int *i2, int *i3)
{
    int	 	    iw,
		    j3,
		    typ,
		    i;

    j3 = -1;
    iw = sketch_obj2(w1, w2, i1, i2);
    if (iw == 0)
 	return 0;
    
    if (iw > 0) {
        for (typ = 0; typ < nb_typ; typ++) {
            for (i = 0; i < Obj_typ[typ].nombre; i++) {
                if (Obj[typ][i].occup == 1) {
		    if (comp(w3, Obj[typ][i].nom_obj) == 1) {
		        j3 = typ;
                        *i3 = i;
                        break;
                    }
	        }
            }
        }
    }

    else {
        for (typ = 0; typ < nb_struc; typ++) {
            for (i = 0; i < Struc_typ[typ].nombre; i++) {
                if (Struc[typ][i].occup == 1) {
		    if (comp(w3, Struc[typ][i].nom_struc) == 1) {
		        j3 = typ;
                        *i3 = i;
                        break;
                    }
	        }
            }
        }
    }

    if (*i3 == -1)
	return 0; 
    if ((iw > 0 && j3 != iw - 1) || (iw < 0 && iw != (-j3 - 1)))
        return 0;
    return iw;   
}
/*-----------------------------------------------------------------*/




/*------------------------------------------------------------------
    Commande d'addition de deux objets
    Syntaxe :
	ajoute <objet1> <objet2> <objet3>
        (add... en version anglaise)
    objet3 contient alors la somme de objet1 et objet2. Il y a
    un test de verification de la nature identique des 3 objets.
    2 ou tous les objets peuvent etre les memes.
------------------------------------------------------------------*/
int 
add_objet(int argc,char *argv[])
{
    int 	    i0,
		    i1,
		    i2,
		    typ;

    typ = sketch_obj3(argv[1], argv[2], argv[3], &i0, &i1, &i2) - 1;
    if (typ <= -1) {
	err_mess(14);
	return 1;
	}
    if (Obj[typ][i0].typ_obj->type < 7)
        ajoute_tab(_M((char **) Obj[typ][i0].adresse), 
	    _M((char **) Obj[typ][i1].adresse),
	    _M((char **) Obj[typ][i2].adresse));
    return 0;
}
/*------------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Commande de soustraction de deux objets
    Syntaxe :
	soustrait <objet1> <objet2> <objet3>
        (sub... en version anglaise)
    objet3 contient alors la difference de objet1 et objet2. Il y a
    un test de verification de la nature identique des 3 objets.
    2 ou tous les objets peuvent etre les memes.
-------------------------------------------------------------------*/
int 
sub_objet(int argc, char *argv[])
{
    int 	    i0,
		    i1,
		    i2,
		    typ;

    typ = sketch_obj3(argv[1], argv[2], argv[3], &i0, &i1, &i2) - 1;
    if (typ <= -1) {
	err_mess(14);
	return 1;
	}
    if (Obj[typ][i0].typ_obj->type < 7)
        soustrait_tab(_M((char **) Obj[typ][i1].adresse), 
	    _M((char **) Obj[typ][i0].adresse), 
	    _M((char **) Obj[typ][i2].adresse));
    return 0;
}
/*----------------------------------------------------------------------*/




/*------------------------------------------------------------------------
    Commande de multiplication d'un objet par un scalaire.
    Syntaxe :
	multiplie <objet1> <scalaire> <objet2>
        (multiply.... en version anglaise)
    objet2 contient alors la multiplication d'objet1 par scalaire.
    Il y a un test du caractere identique (pressions ou vitesses) 
    des objets. Les deux objets peuvent etre les memes.
-------------------------------------------------------------------------*/
int 
mult_objet(int argc, char *argv[])
{
    int 	    i0,
		    i2,
		    typ;
    double	    facteur;

    facteur = convert_float(argv[2]);

    typ = sketch_obj(argv[1], &i0);
    if (typ <= 0 || typ != sketch_obj(argv[3], &i2)) {
	err_mess(14);
        return 1;
    }
    typ--;
    if (Obj[typ][i0].typ_obj->type < 7)
        Rmul_tab(_M((char **) Obj[typ][i0].adresse), facteur,
 	    _M((char **) Obj[typ][i2].adresse));
    return 0;
}
/*----------------------------------------------------------------------*/




/*------------------------------------------------------------------------
    Commande de multiplication d'un objet par un scalaire
    complexe. Syntaxe :
	cmultiplie <objet1> <scalaire.r> <scalaire.i> <objet2>
        (cmultiply... en version anglaise)
    objet2 contient alors la multiplication d'objet1 par scalaire.
    Il y a un test du caractere identique (pressions ou vitesses) 
    des objets. Les deux objets peuvent etre les memes.
-------------------------------------------------------------------------*/
int 
Cmult_objet(int argc, char *argv[])
{
    int 	    i0,
		    i2,
		    typ;
    dcomplex	    facteur;

    facteur.r = convert_float(argv[2]);
    facteur.i = convert_float(argv[3]);

    typ = sketch_obj(argv[1], &i0);
    if (typ <= 0 || typ != sketch_obj(argv[4], &i2)) {
	err_mess(14);
        return 1;
    }
    typ--;
    if (Obj[typ][i0].typ_obj->type < 7)
        Cmul_tab(_M((char **) Obj[typ][i0].adresse), facteur,
 	    _M((char **) Obj[typ][i2].adresse));
    return 0;
}
/*----------------------------------------------------------------------*/





/*------------------------------------------------------------------------
    Commande de copie d'un objet dans un autre
    Syntaxe :
	copie <objet1> <objet2>
        (copy... en version anglaise)
    objet2 contient alors les memes valeurs que objet1. Il y a une 
    verification du fait que les deux objets sont definis
    et de meme nature.
------------------------------------------------------------------------*/
int 
copie_objet(int argc, char *argv[])
{
    int             i0,
                    i1,
                    typ;

    typ = sketch_obj2(argv[1], argv[2], &i0, &i1);

    if (typ <= 0) {
	err_mess(14);
	return 1;
    }
    typ--;

    if (Obj[typ][i0].typ_obj->type < 7)
        copie_tab(_M((char **) Obj[typ][i0].adresse), 
	    _M((char **) Obj[typ][i1].adresse));
    return 0;
}
/*-----------------------------------------------------------------------*/






/*-------------------------------------------------------------------------
    Commande mettant une valeur reelle constante dans un objet 
    Syntaxe :
 	const <objet> <valeur> <i1> <i2> <j1> <j2> <k1> <k2>...
    Il y a un test de l'existence de l'objet. Dans le cas d'un
    objet complexe, <valeur> est remplace par <Re(valeur)> <Im(valeur)> .
--------------------------------------------------------------------------*/
int 
cnst(int argc, char *argv[])
{
    int             typ,
                    i0;
    double	    val;

    typ = sketch_obj(argv[1], &i0);
    if (typ <= 0) {
	err_mess(12);
	return 1;
    }
    typ--;
    val = convert_float(argv[2]);

    if (Obj[typ][i0].typ_obj->type < 7)
        cnst_tab(_M((char **) Obj[typ][i0].adresse), val);

    return 0;
}
/*-----------------------------------------------------------------------*/






/*-------------------------------------------------------------------------
    Commande mettant une valeur complexe constante dans 
    un objet. Syntaxe :
	cconst <objet> <valeur.r> <valeur.i> <i1> <i2> <j1> <j2> <k1> <k2>...
    Il y a un test de l'existence de l'objet. Dans le cas d'un
    objet complexe, <valeur> est remplace par
    <Re(valeur)> <Im(valeur)> .
--------------------------------------------------------------------------*/
int 
Ccnst_cmd(int argc, char *argv[])
{
    int             typ,
                    i0;
    dcomplex	    val;

    typ = sketch_obj(argv[1], &i0);
    if (typ <= 0) {
	err_mess(12);
	return 1;
    }
    typ--;

    val.r = convert_float(argv[2]);
    val.i = convert_float(argv[3]);

    if (Obj[typ][i0].typ_obj->type < 3 || Obj[typ][i0].typ_obj->type > 6)
        Ccnst_tab(_M((char **) Obj[typ][i0].adresse), val);

    return 0;
}
/*-----------------------------------------------------------------------*/






/*-------------------------------------------------------------------------
    Commande imposant un module constant aux nombres d'un 
    objet. Syntaxe :
	const_r <objet> <valeur> <i1> <i2> <j1> <j2> <k1> <k2>...
    Il y a un test de l'existence de l'objet. Dans le cas d'un objet 
    complexe, <valeur> est remplace par <Re(valeur)> <Im(valeur)> .
--------------------------------------------------------------------------*/
int 
RPolcnst(int argc, char *argv[])
{
    int             typ,
                    i0;
    double	    val;

    typ = sketch_obj(argv[1], &i0);
    if (typ <= 0) {
	err_mess(12);
	return 1;
    }
    typ--;

    val = convert_float(argv[2]);
    if (val <= 0.)
	return 1;

    if (Obj[typ][i0].typ_obj->type < 3 || Obj[typ][i0].typ_obj->type > 6)
        RPolcnst_tab(_M((char **) Obj[typ][i0].adresse), val);

    return 0;
}
/*-----------------------------------------------------------------------*/






/*-------------------------------------------------------------------------
    Commande mettant une valeur reelle constante dans un objet 
    Syntaxe :
 	const_th <objet> <valeur> <i1> <i2> <j1> <j2> <k1> <k2>...
    Il y a un test de l'existence de l'objet. Dans le cas d'un objet 
    complexe, <valeur> est remplace par <Re(valeur)> <Im(valeur)> .
--------------------------------------------------------------------------*/
int 
ThPolcnst(int argc, char *argv[])
{
    int             typ,
                    i0;
    double	    val;

    typ = sketch_obj(argv[1], &i0);
    if (typ <= 0) {
	err_mess(12);
	return 1;
    }
    typ--;

    val = convert_float(argv[2]);

    if (Obj[typ][i0].typ_obj->type < 3 || Obj[typ][i0].typ_obj->type > 6)
       ThPolcnst_tab(_M((char **) Obj[typ][i0].adresse), val);

    return 0;
}
/*-----------------------------------------------------------------------*/




/*-------------------------------------------------------------------------
    Commande de sauvegarde totale d'un objet, en fichier 
    binaire. Syntaxe :
 	svg <objet> <Nom de fichier>
    avec 
	<objet> : Nom de l'objet. Il y a un test de son existence.
	<Nom de fichier> : Fichier contenant l'objet.
    Il y a un test de l'existence de l'objet, et le type de l'objet
    est aussi sauvegarde. 
--------------------------------------------------------------------------*/
int 
svg_cmd(int argc, char *argv[])
{
    int             iw,
		    i0;
    char            h[200];
    FILE           *s;

    iw = sketch_obj(argv[1], &i0);
    if (iw <= 0) {
	err_mess(12);
	return 1;
    }
    iw--;
    if (Obj[iw][i0].typ_obj->type == 7)
	return 1;
    
    strcpy(h, result_rep);
    strcat(h, argv[2]);
    s = fopen(h, "wb");
    if (s == NULL) {
	err_mess(1);
	return 1;
    }
    fwrite(&iw, sizeof(int), 1, s);
    svg_tab(s, Obj[iw][i0].adresse, 0);
    fclose(s);
    return 0;
}
/*-----------------------------------------------------------------------*/




/*-------------------------------------------------------------------------
    Commande de restauration d'un objet sauvegarde. 
    Syntaxe :
	restore <objet> <Nom de fichier>
    avec
	<objet> : Nom de l'objet a remplir. Il y a un test de 
	          de son existence.
	<Nom de fichier> : fichier avec lequel on veut remplir l'objet.
    On teste si la nature de l'objet sauvegarde est la meme que
    celle de celui qu'on veut remplir. 
-------------------------------------------------------------------------*/
int 
restore_cmd(int argc, char *argv[])
{
    int             iw,
		    i,
		    i0;
    char            h[200];
    FILE           *s;

    iw = sketch_obj(argv[1], &i0);
    if (iw <= 0) {
	err_mess(12);
	return 1;
    }
    iw--;
    if (Obj[iw][i0].typ_obj->type < 7)
    
    strcpy(h, result_rep);
    strcat(h, argv[2]);
    s = fopen(h, "rb");
    if (s == NULL) {
	err_mess(1);
	return 1;
    }
    fread(&i, sizeof(int), 1, s);
    if (i != iw) 
	err_mess(14);
    if (svg_tab(s, Obj[iw][i0].adresse, 1) == 0) 
    	err_mess(15);
    fclose(s);
    return 0;
}
/*-----------------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Fonction de destruction de toutes les structures de type 'typ'
-------------------------------------------------------------------*/
void
init_str(int typ)
{
    int		    i;

    if (typ < 0 || typ >= nb_struc) {
	err_mess(13);
        return;
    }
    
    for (i = 0; i < Struc_typ[typ].nombre; i++) {
	if (Struc[typ][i].occup == 1) {
	    free(Struc[typ][i].nom_struc);
            Struc[typ][i].occup = 0;
            free((Struc[typ][i].nom_mb)[0]);
            free(Struc[typ][i].nom_mb);
	}
    }
}
/*-----------------------------------------------------------------*/





/*-------------------------------------------------------------------------
    Commande systeme de creation de structures
-------------------------------------------------------------------------*/
int
struct_cmd(FILE *s, char *name_c)
{
    int		    nbstruc,
		    i,
		    j,
		    l,
		    slen,
		    ind,
                   *nb_mb,
                   *n_o;
    char	    h_ligne[100],
		    k[100],
                  **name_str,
                  **comment,
		 ***nom_mbs,
		 ***mb_id;
   
    nbstruc = -1;
    ind = 0;
    memset(h_ligne, 0, 100);
    n_o = int_alloc1(__nbstrucmax);
    nb_mb = int_alloc1(__nbstrucmax);

    mode_com_str = int_alloc2(__nbstrucmax, __nmode_fonc);
    comment = (char **)malloc((size_t) __nbstrucmax * sizeof(char *));
    comment[0] = (char *)malloc((size_t) __nbstrucmax * 100 * sizeof(char));
    for (i = 1; i < __nbstrucmax; i++)
	comment[i] = comment[i - 1] + 100;
    name_str = (char **)malloc((size_t) __nbstrucmax * sizeof(char *));
    name_str[0] = (char *)malloc((size_t) __nbstrucmax * 100 * sizeof(char));
    for (i = 1; i < __nbstrucmax; i++)
	name_str[i] = name_str[i - 1] + 100;
    nom_mbs = (char ***)malloc((size_t) __nbstrucmax * sizeof(char **));
    mb_id = (char ***)malloc((size_t) __nbstrucmax * sizeof(char **));

    for (i = 0; i < __nbstrucmax; i++) {
        memset(comment[i], 0, 100);
        memset(name_str[i], 0, 100);
    }

    while (fgets(h_ligne, 99, s) != NULL) {
        if (h_ligne[0] == '.')
	    goto xxx;
        if (h_ligne[0] != ';') {

/*-------------------------------------
    Nom de la commande creant la structure
-------------------------------------*/
	    slen = strlen(h_ligne) - 1;
            if (slen < 2) 
		exit_interp("struc");
            nbstruc++;
            h_ligne[slen] = 0;
            memcpy(name_str[nbstruc], h_ligne, slen + 1);


 /*-----------------------------------
    Nombre de membres
-----------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets(h_ligne, 99, s) == NULL) 
		exit_interp("struc");
            nettoie(h_ligne);
            nb_mb[nbstruc] = convert_int(h_ligne);
            if (nb_mb[nb_struc] <= 0) 
		exit_interp("struc");
            nom_mbs[nbstruc] = (char **) malloc((size_t) nb_mb[nbstruc]
                * sizeof(char *));
            mb_id[nbstruc] = (char **) malloc((size_t) nb_mb[nbstruc]
                * sizeof(char *));


 /*-----------------------------------
    types et noms des membres
-----------------------------------*/
	    for (i = 0; i < nb_mb[nbstruc]; i++) {
                memset(h_ligne, 0, 100);
                if (fgets(h_ligne, 99, s) == NULL) 
		    exit_interp("struc");
                nettoie(h_ligne);
                mb_id[nbstruc][i] = ch_copy(h_ligne);
                memset(h_ligne, 0, 100);
                if (fgets(h_ligne, 99, s) == NULL) 
		    exit_interp("struc");
                nettoie(h_ligne);
		nom_mbs[nbstruc][i] = ch_copy(h_ligne);
	    }


/*------------------------------------
    Description de la structure
------------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets(h_ligne, 99, s) == NULL) 
		exit_interp("struc");
            memcpy(comment[nbstruc], h_ligne, strlen(h_ligne) - 1);
 

/*-------------------------------------
    Modes de fonctionnement
-------------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets(h_ligne, 99, s) == NULL) 
		exit_interp("struc");
            nettoie(h_ligne);
	    slen = strlen(h_ligne);
            i = 0;
            j = -1;
            memset(k, 0, 100);

            while (i < slen) {
	        if (h_ligne[i] != ' ') {
	   	    j++;
                    k[j] = h_ligne[i];
                    i++;
                }
                if (h_ligne[i] == ' ' || i == slen) {
                    if ((int) strlen(k) > 0) {
	                j = convert_int(k);
                        if (j < 0)
		            for (l = 0; l < __nmode_fonc; l++)
		                mode_com_str[nbstruc][l] = 1;
                        else
		            if (j < __nmode_fonc)
			        mode_com_str[nbstruc][j] = 1;
	                memset(k, 0, 100);
                        j = -1;
		    }
                    i++;
                }
            }


/*-----------------------------------
    Nombre maximal de structures
-----------------------------------*/
            memset(h_ligne, 0, 100);
            if (fgets(h_ligne, 99, s) == NULL) 
		exit_interp("struc");
            nettoie(h_ligne);
            n_o[nbstruc] = S_convert_int(h_ligne);
            memset(h_ligne, 0, 100);
        }
    }

xxx: nbstruc++;
        Struc_typ = (struc_typ *) malloc((size_t) nbstruc *
 	    sizeof(struc_typ));
        Struc = (strucb **) malloc((size_t) nbstruc * sizeof(strucb *));
        
        nb_struc = nbstruc;

    for (i = 0; i < nbstruc; i++) {
/*-------- Nombre de structures numero i ----------*/
        Struc_typ[i].nombre = n_o[i];
/*-------------------------------------------------*/


/*-------- Nombre de membres des structures 
				numero i ----------*/
        Struc_typ[i].nb_membres = nb_mb[i];
        Struc_typ[i].type_mb = int_alloc1(nb_mb[i]); 
/*-------------------------------------------------*/


/*---------- Nom des membres de la structure i ----*/
        Struc_typ[i].membre_id = (char **) malloc((size_t) nb_mb[i] *
 	    sizeof(char *));
/*-------------------------------------------------*/


/*---------- Types des membres de la structure
	    		numero i ------------------*/
        for (l = 0; l < nb_mb[i]; l++) {
            (Struc_typ[i].membre_id)[l] = ch_copy(mb_id[i][l]);
            (Struc_typ[i].type_mb)[l] = -1;

	    for (j = 0; j < nb_typ; j++) {
	        if (comp(nom_mbs[i][l], Obj_typ[j].nom) == 1)
		    (Struc_typ[i].type_mb)[l] = j;
            }
        }
/*-------------------------------------------------*/


/*---------- Nom des structures numero i ----------*/
        Struc_typ[i].nom = ch_copy(name_str[i]);
/*-------------------------------------------------*/


/*---------- Commentaire --------------------------*/
        Struc_typ[i].comment = ch_copy(comment[i]);
/*-------------------------------------------------*/


/*---------- Creation du tableau de structures ----*/
        Struc[i] = (strucb *) malloc((size_t) n_o[i] * sizeof(strucb));
/*-------------------------------------------------*/


/*---------- Caracteristiques communes a toutes les
             structures numero i ------------------*/
	for (j = 0; j < n_o[i]; j++) {
	    Struc[i][j].type = &Struc_typ[i];
	    Struc[i][j].occup = 0;

        }
/*-------------------------------------------------*/


/*---------- Creation du programme de
             creation d'une structure numero i ----*/
        make_com_str(name_str[i], i, mode_com_str[i]);
/*-------------------------------------------------*/
    }

    for (i = 0; i < nbstruc; i++) 
  	for (l = 0; l < nb_mb[i]; l++)
	    if ((Struc_typ[i].type_mb)[l] == -1) {
                ind = 0;

		for (j = 0; j < nbstruc; j++) {
		    if (comp(nom_mbs[i][l], Struc_typ[j].nom) == 1) {
			(Struc_typ[i].type_mb)[l] = -j - 1;
                        ind = 1;
		        break;
		    }
	 	}

	        if (ind == 0) 
		    exit_interp("struc");
   	}
    
    free(comment[0]);
    free(comment);
    free(name_str[0]);
    free(name_str);

    for (i = 0; i < nbstruc; i++) {
        for (j = 0; j < nb_mb[i]; j++) {
            free(nom_mbs[i][j]);
            free(mb_id[i][j]);
        }

        free(nom_mbs[i]);
        free(mb_id[i]);
    }

    free(nom_mbs);
    free(mb_id);
    XFREE(n_o);
    XFREE(nb_mb);
    return 1;
}
/*-----------------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Fonction appelee par struct_cmd. Cree le programme
    de creation de la structure 'ind', en utilisant le nom 'name_c'
-------------------------------------------------------------------*/
void
make_com_str(char *name_c, int ind, int *mode_c)
{
    int		    n,
		    i;
    char	    h[10];

    memset(h, 0, 10);
    nb_com++;
    nom_com[nb_com - 1] = ch_copy(name_c);
    nb_par[nb_com - 1] = 1;
    sil_com[nb_com - 1] = 0;
    nb_lignes[nb_com - 1] = 1;
    for (i = 0; i < __nmode_fonc; i++)
	mode_com_int[nb_com - 1][i] = mode_c[i];
    ligne_com[nb_com - 1][0] = (char *) malloc((size_t) 80 * sizeof(char));
    memset(ligne_com[nb_com - 1][0], 0, 80);
    sprintf(ligne_com[nb_com - 1][0],"strucdef");
    ligne_com[nb_com - 1][0][8] = 32;
    sprintf(h, "%d", ind);
    strcat(ligne_com[nb_com - 1][0], h);
    n = strlen(h) + 8;
    ligne_com[nb_com - 1][0][++n] = 32;
    ligne_com[nb_com - 1][0][++n] = '#';
    ligne_com[nb_com - 1][0][++n] = '1';
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Commande creant une structure. Cette commande ne doit pas etre 
    appelee directement. Les structures sont creees par des programmes 
    generes automatiquement a la lecture du fichier 'interp.ini'.
-------------------------------------------------------------------*/
int
struc_create(int argc, char *argv[])
{
    int             iw,
		    j,
		    k,
		    nb,
		    typ;
    char	    nom[100],
		    h[100];

    
    nb = 0;
    typ = convert_int(argv[1]);

    for (k = 2; k < 3; k++) {
        if (argv[k][0] != '#' && (int) strlen(argv[k]) > 0) {
            memset(nom, 0, 30);
            iw = parse_def(argv[k], &nb, nom);
            if (iw == 0) {
	        err_mess(21);
	        return -1;
            }
            if (iw == 2) 
	        test_nom_str(argv[k], typ); 
            else {
	        for (j = 1; j <= nb; j++) {
                    memset(h, 0, 100);
	            sprintf(h, "%s[%d]", nom, j);
                    test_nom_str(h, typ);
	        }
            }
        }
    }

    return 0;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Fonction appelee par la precedente. Cree la structure si son
    nom est correct (pas deja utilise).
-------------------------------------------------------------------*/
int
test_nom_str(char *h, int typ)
{
    int 	    i,
		    j,
		    k,
		    nb,
		    slen;

    nb = Struc_typ[typ].nombre;
    slen = strlen(h);
    
    if (slen > 20) {
	err_mess(16);
        return -1;
    }


/*----------------------------------------------------
    On verifie d'abord s'il reste de la place
----------------------------------------------------*/
    j = 0;

    for (i = 0; i < nb; i++) {
	if (Struc[typ][i].occup == 1)
	    j++;
	else
	    break;
    }

    if (j == nb) {
	err_mess(17);
        return -1;
    }
    j = i;    /* numero de la premiere place 
                 inoccupee pour la structure */
/*--------------------------------------------------*/



/*----------------------------------------------------
    On verifie ensuite si le nom de la structure
    n'a pas deja ete utilise
----------------------------------------------------*/
    for (i = 0; i < nb_struc; i++) {
        for (k = 0; k < Struc_typ[i].nombre; k++) {
	    if (Struc[i][k].occup == 1) {
	        if (comp(Struc[i][k].nom_struc, h) == 1) {
		    err_mess(11);
                    return -1;
                }
            }
        }
    }
/*--------------------------------------------------*/


/*----------------------------------------------------
    Creation de la structure
----------------------------------------------------*/
    Struc[typ][j].occup = 1;  
    Struc[typ][j].nom_struc = ch_copy(h);
    Struc[typ][j].nom_mb = (char **) malloc((size_t) 
	Struc_typ[typ].nb_membres * sizeof(char *));
    (Struc[typ][j].nom_mb)[0] = (char *) malloc((size_t) 
	Struc_typ[typ].nb_membres * 22 * sizeof(char));
    memset((Struc[typ][j].nom_mb)[0], 0, Struc_typ[typ].nb_membres * 22);
    for (i = 1; i < Struc_typ[typ].nb_membres; i++)
	(Struc[typ][j].nom_mb)[i] = (Struc[typ][j].nom_mb)[i - 1] + 22;

/*--------------------------------------------------*/
    return 0;
}
/*-----------------------------------------------------------------*/





/*-------------------------------------------------------------------
    Commande d'assignation d'un objet a un membre de structure.
    Syntaxe :
	assign <struc> <membre> <nom>
    avec
	<struc>  = nom de la structure
	<membre> = nom du membre
 	<nom>    = nom de l'objet ou de la structure assignee
                   au membre
-------------------------------------------------------------------*/
int
assign_membre(int argc, char *argv[])
{
    int		    iw,
                    iw1,
                    j,
                    k,
		    i0,
		    i,
		    i1;

    iw = sketch_obj(argv[1], &i0);
    if (iw >= 0) {
	err_mess(18);
	return 0;
    }
    iw = -1 - iw;
    j = -1;

    for (i = 0; i < Struc_typ[iw].nb_membres; i++) {
        if (comp(argv[2], (Struc_typ[iw].membre_id)[i]) == 1) {
	    j = i;
            break;
        }
    }

    if (j == -1) {
	err_mess(19);
        return 0;
    }
    k = (Struc_typ[iw].type_mb)[j];  
    iw1 = sketch_obj(argv[3], &i1);
    if ((k >= 0 && iw1 != k + 1) || (k < 0 && iw1 != k)) {
	err_mess(19);
        return 0;
    }
    if (k >= 0)
        memcpy((Struc[iw][i0].nom_mb)[j], Obj[k][i1].nom_obj,
	    strlen(Obj[k][i1].nom_obj));
    else 
        memcpy((Struc[iw][i0].nom_mb)[j], Struc[-k - 1][i1].nom_struc,
	    strlen(Struc[-k -1][i1].nom_struc));
    return 1;
}
/*-----------------------------------------------------------------*/





/*-------------------------------------------------------------------
    Desassignation d'un objet a un membre de structure. Syntaxe :
	desassign <struc> <membre>
-------------------------------------------------------------------*/
int
desassign_membre(int argc, char *argv[])
{
    int		    iw,
                    j,
		    i0,
		    i;

    iw = sketch_obj(argv[1], &i0);
    if (iw >= 0) {
	err_mess(18);
	return 0;
    }
    iw = -1 - iw;
    j = -1;

    for (i = 0; i < Struc_typ[iw].nb_membres; i++) {
        if (comp(argv[2], (Struc_typ[iw].membre_id)[i]) == 1) {
	    j = i;
            break;
        }
    }

    if (j == -1) {
	err_mess(19);
        return 0;
    }
    memset((Struc[iw][i0].nom_mb)[j], 0, 22);
    return 1;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Description d'une structure. Syntaxe :
	desc <struc>
    La commande se traduit par l'affichage des noms des membres
    de la structure.
-------------------------------------------------------------------*/
int
desc_struct(int argc, char *argv[]) 
{
    int		    iw,
		    i,
		    j,
		    i0;

    if (prlevel > 0)
	return 1;
    iw = sketch_obj(argv[1], &i0);
    if (iw >= 0) {
	err_mess(21);
	return 0;
    }
    iw = -1 -iw;
    print(" Structure %s : \n", Struc_typ[iw].nom);

    for (i = 0; i < Struc_typ[iw].nb_membres; i++) {
        print("%s (", (Struc_typ[iw].membre_id)[i]);
        j = (Struc_typ[iw].type_mb)[i];
        if (j >= 0) 
	    print("objet %s) :  ", Obj_typ[j].nom);
        else
            print("structure %s) :  ", Struc_typ[-j - 1].nom);
	if ((int) strlen((Struc[iw][i0].nom_mb)[i]) > 0) 
	    print("%s\n", (Struc[iw][i0].nom_mb)[i]);
	else
	    print("(null)\n");
    }
    return 1;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Retourne le type d'objet + 1 correspondant a la structure de type
    'typ' numero 'ik' dont le membre a le nom 'nom' si ce membre est
    un objet. Si c'est une structure de type j, retourne -j-1. En
    cas d'erreur, retourne 0. L'entier i0 contient le numero de la
    structure ou de l'objet en question si le membre a ete assigne,
    -1 sinon.
-------------------------------------------------------------------*/
int
sketch_struc(int typ, int ik, char *nom, int *i0)
{
    int		    i,
		    iw0,
		    i00,
		    j;

    if (typ < 0 || typ > nb_struc) 
        return 0;
    j = -1;

    for (i = 0; i < Struc_typ[typ].nb_membres; i++) {
	if (comp((Struc_typ[typ].membre_id)[i], nom) == 1) {
	    j = i;
            break;
        }
    }

    if (j == -1) 
	return 0;
    *i0 = -1;
    if (strlen((Struc[typ][ik].nom_mb)[j]) == 0)
	return 0;
    iw0 = sketch_obj((Struc[typ][ik].nom_mb)[j], &i00);
    if ((Struc_typ[typ].type_mb)[j] >= 0) {
        if (iw0 == (Struc_typ[typ].type_mb)[j] + 1)
	    *i0 = i00;
        else 
	    return 0;    
        return ((Struc_typ[typ].type_mb)[j] + 1);
    }
    else {
	if (iw0 == (Struc_typ[typ].type_mb)[j])
	    *i0 = i00;
   	else
	    return 0;
        return (Struc_typ[typ].type_mb)[j];
    }
}
/*-----------------------------------------------------------------*/

