#include "stdafx.h"
#include <stdio.h>
#include "iport.h"      // IPORT header file

// MyDisconnectCallback - this function is executed after
//                        the remote user disconnected.
int MyDisconnectCallback ( void* Param )
{
    IIpConnection* conn;

    conn = (IIpConnection*) Param;      // get the pointer to IIpConnection

    printf( "Disconnected\r\n" ); // print the connection unique identifier
    return NULL;       // This function shouls always return NULL
}

// MyMsgCallback - this function is executed each time when data package
//                 arrives. Put your package processing code here.
int MyMsgCallback ( void* Param )
{
    IIpConnection* conn;

    conn = (IIpConnection*) Param;      // get the pointer to IIpConnection

    if ( conn->GetData() )              // if got any input...
        printf ( "GOT : %s\r\n", conn->GetData() ); // print it

    return NULL;             // This function shouls always return NULL
}


int main(int argc, char* argv[])
{
    IIpConnection* connection;
    char str[255];

    // Initialize Windows Sockets.
    if ( IP_OPEN() == -1 )
    {
        puts ("error: Can't initialize WinSock.");
        return 0;

    }

    puts("Starting client.");

    // Start the connection
    if ( OpenConnection ( "localhost", 10723, 
                          TRANS_TCP, MyMsgCallback,
                          MyDisconnectCallback, &connection ) == -1 )
    {
        puts ( "error: Can't start service." );
        IP_CLOSE ();
        return 0;
    }


    puts("Receiving...\r\n***************\r\n");

    // Wait for any keyboard input
    while ( 1 )
    {
        gets ( str );
        if ( str[0] == '`' )
            break;
            
        // use SendPKT with TRANS_TCP
        connection->SendPKT( str, strlen ( str ) );
    }

    puts("Finishing...");

    // Close connection
    CloseConnection( connection );

    // Uninitialize Windows Sockets.
    IP_CLOSE();

    // quit from program
    return 0;
}

