#include <stdlib.h>;
#include <stdio.h>;
#include "vgalib.h";
#include "animlib.h";
#include "vga18.h";

#define uchar unsigned char
#define VGA256 19
#define VGA18 18
#define TEXTMODE 3

int SPRMAX;                  /* Number of sprites in table */
			     /* Nombre de sprites dans la table */

/* Error message for loading function */
/* Message d'erreur de chargement */

void nofound(char *name)
{
 printf("File no found %s",name);
 exit(0);
}


/*
   Replace function in ANIMLIB for VGA 18
   Remplace une fonction en ANIMLIB pour VGA 18
*/

void sprite256(int x, int y, char *adr)
{
 sp256(x, y, adr);
}

void main()
{
 int sprite;
 int x, y;

/* First, allocation of memory buffer */
/* Allocation d'un tampon pour les sprites en mmoire d'abord */

 sprite_alloc();

/* Loading sprites  */
/* Chargement des sprites */

 printf("Loading sprites...");
 SPRMAX = sprites_load("spdemo1.dat", 32768U);
 if(!SPRMAX) nofound("spdemo1.dat");

/* Setting VGA 256 colors screen */
/* On passe en MCGA */

 BIOSscreen(VGA18);

/* Full screen window for the red background */
/* On efface l'cran en rouge */

 cls18(4);

/* Now, setting window's limits left, top, right, bottom */
/* On dfinit les limites de la fentre graphique */

 window18(48, 48, 591, 431);

/* Black background inside the windows */

 cls18(0);

/* Animation example */
/* Exemple d'animation */

 print18(2, 2, "Windows, cls18, sprites and animation test...");

 x = 300;
 y = 20;
 sprite = 4;

 while(y < 460)
 {
  waitrefresh();
  csp256c(x, y, (char *) SPVECTOR[sprite]);

  delay(60);       /* Slow down and set all computers same speed */
		   /* Ralentissement pour uniformiser la vitesse */

  if(kbhit()) goto bye;
  if(++sprite > 8) sprite = 4;
  y++;

}

/* Restoring DOS text screen and exits */
/* Restauration de l'cran de texte et sortie */

bye:
 BIOSscreen(TEXTMODE);
 exit(0);
}
