Comment *
Ŀ
 Title   : intr							     
 Purpose : Allow a interrupt call similar to the Turbo Pascal intr call.    
									     
 Notes   : You must define a structure:				     
	    struct treg { unsigned int ax,bx,cx,dx,si,di,ds,es,flags;};      
									     
	    It is important to define the registers in exactly this order or 
	    you will get unpredictable results !!!!			     
									     
Usage	  : intr(0x10,&register);					     
									     
 Hints    : you may also find the following macro useful:		     
	     #define msdos(_wreg) intr(0x21,_wreg)			     
									     
	Written by Jack Zucker - 75766,1336    301-794-5950  on 2-10-86      

 *
	assume cs:_text
_text	segment public byte 'code'
	public _intr

_intr	proc near

	push bp
	mov bp,sp
	push si
	push di
	push es
	push ds
	mov bx,[bp+6]		; get address of register record
	mov ax,[bx+0]		; reg.ax
	mov cx,[bx+4]		; reg.cx
	mov dx,[bx+6]		; reg.dx
	mov si,[bx+8]		; reg.si
	mov di,[bx+10]		; reg.di
	mov es,[bx+14]		; reg.es
	push [bx+2]		; save reg.bx
	push bx 		; save real bx value
	mov bl,[bp+4]		; get interrupt number in bl
	mov byte ptr cs:intlabel+1,bl ; put int into code segment
	pop bx			; restore actual bx value
	push [bx+12]		; push reg.ds on stack
	pop ds			; get value into ds
	pop bx			; set real bx from reg.bx
	push bp 		; Save Base Pointer
intlabel	label near
	int 0FFh
	pop bp
	mov cs:saveds,ds	; save the interrupt version of ds in word stor
	pop ds			; get original ds back
	pushf			; save flags
	push bx 		; save bx locally
	mov bx,[bp+6]		; get address of register record
	mov [bx+0],ax		; set reg.ax
	mov [bx+4],cx		; set reg.cx
	mov [bx+6],dx		; set reg.dx
	mov [bx+8],si		; set reg.si
	mov [bx+10],di		; set reg.di
	push ax 		; save ax locally
	mov ax,cs:saveds
	mov [bx+12],ax		; set reg.ds from saved variable
	pop ax			; restore ax
	mov [bx+14],es		; set reg.es
	pop [bx+2]		; set reg.bx
	pop [bx+16]		; set reg.flags
	pop es
	pop di
	pop si
	mov sp,bp
	pop  bp
	cld
	ret
_intr	endp
saveds	dw	0
_text	ends
end
