Comment *
Ŀ
title	 : jzscrprn							     
Purpose : print directly to the screen buffer without snow		     
ds:si	 points to the string to write					     
bh	contains the attribute						     
ah	contains the column, al contains the row			     
written by Jack A. Zucker on 1/30/86 (301) 794-5950 75766,1336 	     

 *
title	print directly to screen buffer
name	jzscrprn

	assume cs:_text
_text	segment public byte 'code'
	public _jzscrprn

_jzscrprn	 proc	 near
	push bp
	mov bp,sp
	push si
	push di
	push ds
	push es
	mov al,[bp+6]		; get row
	mov bx,50h		; 50 columns (hex)
	mul bl			; row offset = # columns * row
	mov bx,ax		; put value back in bx
	add bx,[bp+8]		; add column
	shl bx,1		; multiply by 2
	mov di,bx		; screen seg:di = offset for writing

	mov bh,[bp+0Ah] 	; get attribute back in bh

	push ds 		; save ds for mode check
	mov ax,40h		; low memory information segment
	mov ds,ax
	mov si,49h		; screen mode
	cmp byte ptr [si],7	; 7 = mono mode
	mov si,[bp+4]		; get offset of first character
	pop es			; restore our data into extra segment
	jz mono 		; [si] = 7 means mono mode
	mov ax,0b800h		; color screen segment
	mov ds,ax
next:
	mov bl,es:[si]
	or bl,bl
	jz endofdsp		; 0 = end of string
	mov dx,3dah		; address of 6845 Status register

Comment *
Ŀ
 This next section which only gets executed in color mode checks the status 
 register of the 6845 crt controller chip. When bit 0 is set to 1 we can    
 update the screen without snow. The process is to check to see if it's set 
 to one and loop until it's not. Then loop until it's High and fall out of  
 the loop and write the character. The reason it's done this way is in case 
 you initially check the status and it's at the very end of a retrace. In   
 that case, you would think that it is safe to write to the screen buffer   
 but my way takes care of a partially complete retrace on the first try.    
 Examine the code on pertaining to bios int 9 in the Ibm technical reference
 manual. Note that this code is unnecessary for many compatibles as they do 
 not have the same bug in their displays as the Ibm pc does.		     

 *

status_low:
	in al,dx		; get vertical retrace status
	ror al,1		; faster than test
	jc status_low		; wait for partially done retrace
	cli			; don't allow any more interrupts
status_high:
	in al,dx		; wait for beginning of new retrace
	ror al,1
	jnc status_high 	; retrace not started

	sti			; interrupt allowed now
	mov [di],bx		; place character and attribute in screen buf
	inc di			; point to next position (attribute)
	inc di			; point to next position (character)
	inc si
	jmp next

mono:
	mov ax,0b000h		; Mono screen segment
	mov ds,ax
next2:
	mov bl,es:[si]		   ; character to print
	or bl,bl		; 0 = end of string
	jz endofdsp
	mov [di],bx		; place character and attribute in screen buf
	inc di			; point to next position (attribute)
	inc di			; point to next position (character)
	inc si
	jmp next2
endofdsp:
	pop es
	pop ds
	pop di
	pop si
	mov sp,bp
	pop bp
	ret
_jzscrprn endp
_text ends
end
