
/*
Ŀ
literal.c								     
Translate a string with tokens in it according to several conventions:      
 1.	  delineate comments						     
 2. \x1b translates to char(0x1b)					     
 3. \27  translates to char(27)					     
 4. \"   translates to "                                                    
 5. \'   translates to '                                                    
 6. \\   translates to \						     
									     
 Synopsis								     
    *s = "this\x20is\32a test of \\MSC\\JAZ\7"                              
    literal(s,d);							     
									     
    ( d now equals "this is a test of \MSC\JAZ")                           

*/

#include <ctype.h>

#define HEX "0123456789ABCDEF"

literal(fsource,fdestin)
char *fsource;		/* original string */
char *fdestin;		/* returned string */
{

  int wpos,w;
  int x;
  int winquote;
  int wincomment;
  unsigned char wchar;

  winquote = 0;
  wincomment = 0;

  *fdestin = 0; 		/* start out with NULL string */
  w = 0;			/* set index to first character */
  while (fsource[w]) {		/* until end of string */
    switch(fsource[w]) {
      case '"' :                /* check quotes */
      case '\\':
	if ( ! wincomment )
	  switch(fsource[w+1]) {
	    case 'x' :                    /* Hexidecimal */
	      wchar = 0;
	      w++;			  /* get past "\" */
	      w++;			  /* get past "x" */
	      if (index(HEX,toupper(fsource[w])) != -1)
		while ((wpos = index(HEX,toupper(fsource[w]))) != -1) {
		  wchar = (wchar << 4) + wpos;
		  w++;
		}
	      else			/* just an x */
		wchar = 'x';
	      w --;
	      *fdestin ++ = wchar;
	      break;
	    case '\\' :                 /* we want a "\" */
	      w ++;
	      *fdestin++ = '\\';
	      break;
	    case 't' :                  /* tab char */
	      w ++;
	      *fdestin++ = 9;
	      break;
	    case 'n' :                  /* new line */
	      w ++;
	      *fdestin++ = 13;
	      *fdestin++ = 10;
	      break;
	    case 'r' :                  /* carr return */
	      w ++;
	      *fdestin++ = 13;
	      break;
	    case 'b' :                  /* back space */
	      w ++;
	      *fdestin++ = 8;
	      break;
	    case '\'' :                 /* single quote */
	      w ++;
	      *fdestin++ = '\'';
	      break;
	    case '\"' :                 /* double quote */
	      w ++;
	      *fdestin++ = '\"';
	      break;
	    default :			  /* DECIMAL */
	      w ++;			  /* get past "\" */
	      wchar = 0;
	      if (index("0123456789",fsource[w]) != -1) {
		do
		  wchar = wchar * 10 + (fsource[w++] - 48); /* cnv to binary */
		while (index("0123456789",fsource[w]) != -1);
		w --;
	      }
	      else
		wchar = fsource[w];
	      *fdestin ++ = wchar;
	      break;
	  }
      case '\'':
	winquote ^= 1;		/* toggle flag */
	break;
      case '*' :
	if (wincomment)
	  if (fsource[w+1] == '/') {
	      wincomment = 0 ;			  /* toggle the flag */
	      w ++;
	      break;
	  }
      case '/' :              /* beginning of comment perhaps */
	if (fsource[w+1] == '*') {
	    wincomment = 1 ;			/* toggle the flag */
	    w ++;
	    break;
	}
      default :
	if ( ! wincomment) {
	  *fdestin++ = fsource[w];
	  break;
	}
    }
    w ++;
  }
  *fdestin = 0; 		/* terminate the string */
}
