/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

/* this demo shows how to load a .jlb,  use an offscreen buffer and perform
** cheesy vertical scrolling using the library.
*/

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>

int main(void)
{
 int i,x;
 image *jlb_pic;
 buffer_rec *buff;

 JLIB_DEBUG_OFF
 
 screen_set_video_mode(); 

 /* load jlb */
 jlb_pic = image_load_jlb("demo2.jlb");

 /* check that load was OK */
 if(jlb_pic == NULL){
   jlib_exit("JLB load failed.");
 }

 /* init buffer */
 buff = buff_init(IMG_WIDTH(jlb_pic),IMG_HEIGHT(jlb_pic));

 kb_init();

 screen_block_set_pal(IMG_PALETTE(jlb_pic));

 /* put image into buffer */
 buff_blit_img_to(buff,0,0,jlb_pic,0,0,IMG_MAX_X(jlb_pic),IMG_MAX_Y(jlb_pic));

 x=500;
    
 /* do scrolling by moving through the buffer */
 do{
   for(i=0;i<50;i++){
       screen_blit_buff_to(0,0,buff,0,i,IMG_MAX_X(jlb_pic),i+149);
       if(KEYBOARD_AVAILABLE){
          if(kb_key_hit()){
             jlib_exit("Not Really An ERROR!");
          }
       }
   }
   
   for(i=50;i>0;i--){
       screen_blit_buff_toNC(0,0,buff,0,i,IMG_MAX_X(jlb_pic),i+149);
       if(KEYBOARD_AVAILABLE){
          if(kb_key_hit()){
             jlib_exit("Not Really An ERROR!");
          }
       }
   }

 }while(x--);

 kb_closedown();

 /* return to text mode and exit */
 screen_restore_video_mode();
 return 0;
}
