/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */
 
#include <stdlib.h>
#include <jlib.h>

/*+------------------------------------------------------------------------+*/
/*|initialise an offscreen buffer                                          |*/
/*+------------------------------------------------------------------------+*/
buffer_rec *buff_init (int width, int height)
{
   buffer_rec *buff;
   UBYTE *ptr,**index;
   int size;

   JLIB_ENTER("buff_init");

   /* allocate memory for the buffer record */
   buff = (buffer_rec *) malloc(sizeof(buffer_rec));

   if(buff == NULL){
      jlib_exit(jlib_msg(JLIB_EMALLOC));
   }

   buff->width = width;
   buff->height = height;
   size = B_SIZE(buff);

   /* allocate memory for the buffer itself */
   buff->buffer = (UBYTE *) malloc(size * sizeof(UBYTE));

   if(buff->buffer == NULL) {
      jlib_exit(jlib_msg(JLIB_EMALLOC));
   }

   /* allocate memory for the offset itself */
   buff->offset = (UBYTE **)malloc(height * sizeof(UBYTE *));

   if(buff->offset == NULL) {
      jlib_exit(jlib_msg(JLIB_EMALLOC));
   }

   /* create line offset array */
   ptr = B_BUFF_PTR(buff);
   index = buff->offset;

   while (height--){
         *index=ptr;
         index++;
         ptr+=width;
   }

   buff_clear(buff);

   JLIB_LEAVE;
   return buff;
}


/*+------------------------------------------------------------------------+*/
/*|clear a buffer by filling it with zeros.                                |*/
/*+------------------------------------------------------------------------+*/
void buff_clear(buffer_rec * buff)
{
  JLIB_ENTER("buff_clear");

#ifndef JLIB_PRODUCTION
   jlib_check_buffer(buff);
#endif

  buff_fill(buff,0);

  JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+*/
/*|fill the buff with a particular colour.                                 |*/
/*+------------------------------------------------------------------------+*/
void buff_fill (buffer_rec * buff, UBYTE colour)
{
  UBYTE *buffer;
  int size;

  JLIB_ENTER("buff_fill");

#ifndef JLIB_PRODUCTION
   jlib_check_buffer(buff);
#endif

  buffer = B_BUFF_PTR(buff);
  size = B_SIZE(buff);

  MEM_STORE_LONG(buffer,colour,size);

  JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+*/
/*|free the storage used by a buffer to the OS.                            |*/
/*+------------------------------------------------------------------------+*/
buffer_rec *buff_free (buffer_rec * buff)
{
   JLIB_ENTER("buff_free");

   if(buff != NULL){
      if(buff->buffer != NULL){
         free(buff->buffer);
      }
      if(buff->offset != NULL){
         free(buff->offset);
      }
      free(buff);
   }

   JLIB_LEAVE
   return (buffer_rec *)NULL;
}


/*+------------------------------------------------------------------------+*/
/*|Remap the colors in a buffer.                                           |*/
/*+------------------------------------------------------------------------+*/
void buff_remap_colors (buffer_rec * buff, UBYTE *remap)
{
  UBYTE *buffer;
  int size;

  JLIB_ENTER("buff_remap_colors");

#ifndef JLIB_PRODUCTION
  if(remap == NULL) {
     jlib_exit(jlib_msg(JLIB_ENULL));
  }
  jlib_check_buffer(buff);
#endif

  buffer = B_BUFF_PTR(buff);
  size = B_SIZE(buff)-1;

  for(;size >= 0;size--){
      buffer[size] = remap[buffer[size]];
  }

  JLIB_LEAVE;
}

