/*****************************************************************************
** The source code included in the file "lz.c" is a combination of work from
** three places.  Firstly,  the original source code upon which this work is
** based was authoured by Ross Williams (1991).  In an article entitled:
**
**                             Rev 0.1, 07-25-95
**                           LZRW1 WITHOUT HASHING
**                      -=-=-=-=-=-=-=-=-=-=-=-=-=-=-
**                         (c) 1995 George A. Resnick
**
** George A. Resnick expanded upon Ross's work to use a non patented 
** lzw algorithm which utilises a radix search tree rather than a hashing
** table to encode the data.  I have taken 1 form of George's algorithm
** and implemented it as part of the compression stage in an image format.
** George placed his implementation of the algorithm in the public domain,
** as this excerpt details:
** 
**    1. The algorithm described in this article, source code of 
**       the LZRW1-# program, and all the ideas, that can be found 
**       herein I wish to be in the public domain, and used freely,
**       without restriction of any kind.
**    2. In the event if the algorithm described here is not unique,
**       or violates any existing, or filed before July 1, 1995 patents,
**       please let me know.
**    3. Any comments and/or questions concerning this message should
**       be sent to:
**         George A. Resnick   Internet: gar@clark.net,
**         5172-2 Brook Way      gar@ua.net, gar@jam.kiev.ua
**         Columbia, MD 21044  tel/fax: (410) 992-9824
**
**  I first saw Georges article posted to comp.compression on usenet.
** George himself offers the following as places to get hold of his article:
**
** The article is available from my ftp directory:  
**       clark.net://pub/gar/lzrw-h.pst
**
** an alternative source is comp.compression archive at ftp 
** spib.rice.edu.
**
** Best Regards,
**
** George A Resnick
** gar@clark.net , gar@jam.kiev.ua
**
**  In keeping with the generous spirit with which George has donated this
**  implementation,  I wish any changes I may have made to be subject to
**  point 1 above.
**                       Jonathan Griffiths, 11th August, 1995.
*/

/* Radix search algorithm: Copyright (C) George A. Resnick, 1995. */

#ifndef __LZ_H__
#define __LZ_H__

#ifdef __cplusplus
extern "C" {
#endif


/* prototypes */
void lz_compress (UBYTE *p_src_first,long src_len,UBYTE *p_dst_first, long *p_dst_len);

void lz_decompress (UBYTE *p_src_first,long src_len,UBYTE *p_dst_first,long *p_dst_len);


#ifdef __cplusplus
}
#endif 

#endif

