/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

/* target specific includes for DJGPP/GRX2 */

#ifndef __JTARGET_H__
#define __JTARGET_H__

#ifdef __cplusplus
extern "C" {
#endif 

#ifndef DJGPP_V2
#error Wrong Target header file included in build.
#endif

#ifndef GRX2_VARIANT
#error Wrong Target header file included in build.
#endif

/* INPUT */
#define KEYBOARD_AVAILABLE 1    /* keyboard support is available */
#define MOUSE_AVAILABLE 1	/* mouse is available */ 
#define JOYSTICK_AVAILABLE 0    /* no joystick support */

/* mouse */
#define MOUSE_NUM_BUTTONS 3
#define MOUSE_B_LEFT   1
#define MOUSE_B_MIDDLE 2
#define MOUSE_B_RIGHT  4

#define BUTTON_DOWN(status)    (status)
#define BUTTON_CHECK(status,x) (status & (x))

/* joystick */
typedef struct  {
    int joy,xcen,ycen,x1,y1,x2,y2,deadx1,deady1,deadx2,deady2;
} logical_joy;

extern logical_joy __jlib_joys[3];

#define JOY_FIRE1 1
#define JOY_FIRE2 2

#define FIRE_1_DOWN(status) (status & JOY_FIRE1)
#define FIRE_2_DOWN(status) (status & JOY_FIRE2)

/* SCREEN */
#include <grx20.h>

extern GrContext *__jlib_fake_context;  /* globals: in misc.c */
extern GrContext *__jlib_fake_partial_context;
extern int        __jlib_planesize;

#define  SCREEN_NUM_COLORS 256
#define  SCREEN_NUM_PAGES 1

#ifdef GRX2_320x200x256
#define  SCREEN_WIDTH   320
#define  SCREEN_HEIGHT  200
#define  SCREEN_MAX_X   319
#define  SCREEN_MAX_Y   199
#endif 

#ifdef GRX2_640x480x256
#define  SCREEN_WIDTH   640
#define  SCREEN_HEIGHT  480
#define  SCREEN_MAX_X   639
#define  SCREEN_MAX_Y   479
#endif 

#ifdef GRX2_800x600x256
#define  SCREEN_WIDTH   800
#define  SCREEN_HEIGHT  600
#define  SCREEN_MAX_X   799
#define  SCREEN_MAX_Y   599
#endif

#define UCLOCK_TICKS_PER_SECOND 1000000L

/* MEMORY OPERATIONS */
#include <string.h>

JINLINE int get_best_copy_method (void *addr1, void *addr2, unsigned int len);

#define ALIGNMENT_STATE_1   0
#define ALIGNMENT_STATE_2   1
#define ALIGNMENT_STATE_3   2
#define ALIGNMENT_STATE_4   3
#define ALIGNMENT_STATE_5   4
#define ALIGNMENT_STATE_6   5
#define ALIGNMENT_STATE_7   6
#define ALIGNMENT_STATE_8   7

/* some copies are optimised according to alignment */

#define MEM_COPY_ALIGN_1(x,y,z)  _copy_sb( (x) , (y) , (z) )
#define MEM_COPY_ALIGN_2(x,y,z)  _copy_inc_sw( (x) , (y) , (z) )
#define MEM_COPY_ALIGN_3(x,y,z)  _copy_sw( (x) , (y) , (z) )
#define MEM_COPY_ALIGN_4(x,y,z)  _copy_sw_inc( (x) , (y) , (z) )
#define MEM_COPY_ALIGN_5(x,y,z)  _copy_inc_sw_inc( (x) , (y) , (z) )
#define MEM_COPY_ALIGN_6(x,y,z)  _copy_sb( (x) , (y) , (z) )
#define MEM_COPY_ALIGN_7(x,y,z)  _copy_sb( (x) , (y) , (z) )
#define MEM_COPY_ALIGN_8(x,y,z)  _copy_sb( (x) , (y) , (z) )

#define FAST_SHORT_COPY(a,b,len) _copy_sb((a),(b),(len))
#define FAST_LONG_COPY(a,b,len)  _blast((a),(b),(len))
#define FAST_VERY_LONG_COPY(a,b,len)  _blast((a),(b),(len))
#define BYTE_COPY(a,b,len)       _bcopy((a),(b),(len))
#define WORD_COPY(a,b,len)       _copy_sw((a),(b),(len))
#define LONG_COPY(a,b,len)       _blast((a),(b),(len))

/* other copying routines */
void _blast (void *src, void *dest, unsigned int len);

/* ========================================================================
   Try to ignore this mess,  I had to this because the compiler wouldn't   
   inline the assembly.                                                            
   ========================================================================
 */

/* all of these copies are source, dest, len */
#define _copy_sb(src,dest,len) asm volatile(                              "\n\
push %%ecx \n \
movl %0, %%esi \n \
movl %1, %%edi \n \
movl %2, %%ecx \n \
rep \n \
movsb \n \
pop %%ecx "\
:                               /* NOTHING */ \
:" g " (src), " g " (dest), " g " (len) \
:"di", "si", "cx")

#define _copy_sw(src,dest,len) asm volatile(                              "\n\
push %%ecx \n \
movl %0, %%esi \n \
movl %1, %%edi \n \
movl %2, %%ecx \n \
shrl $1, %%ecx \n \
rep \n \
movsw \n \
pop %%ecx "\
:                               /* NOTHING */ \
:" g " (src), " g " (dest), " g " (len) \
:"di", "si", "cx")

#define _copy_sw_inc(src,dest,len) asm volatile(                         "\n\
push %%ecx \n \
movl %0, %%esi \n \
movl %1, %%edi \n \
movl %2, %%ecx \n \
shrl $1, %%ecx \n \
rep \n \
movsw \n \
movl $1, %%ecx \n \
rep \n \
movsb \n \
pop %%ecx "\
:                               /* NOTHING */ \
:" g " (src), " g " (dest), " g " (len) \
:"di", "si", "cx")

#define _copy_inc_sw(src,dest,len) asm volatile(                         "\n\
push %%ecx \n \
movl %0, %%esi \n \
movl %1, %%edi \n \
movl $1, %%ecx \n \
rep \n \
movsb \n \
movl %2, %%ecx \n \
shrl $1, %%ecx \n \
rep \n \
movsw \n \
pop %%ecx "\
:                               /* NOTHING */ \
:" g " (src), " g " (dest), " g " (len) \
:"di", "si", "cx")

#define _copy_inc_sw_inc(src,dest,len) asm volatile(                     "\n\
push %%ecx \n \
movl %0, %%esi \n \
movl %1, %%edi \n \
movl $1, %%ecx \n \
rep \n \
movsb \n \
movl %2, %%ecx \n \
shrl $1, %%ecx \n \
rep \n \
movsw \n \
movl $1, %%ecx \n \
rep \n \
movsb \n \
pop %%ecx "\
:                               /* NOTHING */ \
:" g " (src), " g " (dest), " g " (len) \
:"di", "si", "cx")

/* all of this stuff deals with *dos* memory copies */
#define DOS_MEMCOPY_ALIGN_1(x,y,z)  _dos_copy_sb( (x) , (y) , (z) )
#define DOS_MEMCOPY_ALIGN_2(x,y,z)  _dos_copy_inc_sw( (x) , (y) , (z) )
#define DOS_MEMCOPY_ALIGN_3(x,y,z)  _dos_copy_sw( (x) , (y) , (z) )
#define DOS_MEMCOPY_ALIGN_4(x,y,z)  _dos_copy_sw_inc( (x) , (y) , (z) )
#define DOS_MEMCOPY_ALIGN_5(x,y,z)  _dos_copy_inc_sw_inc( (x) , (y) , (z) )
#define DOS_MEMCOPY_ALIGN_6(x,y,z)  _dos_copy_sb( (x) , (y) , (z) )
#define DOS_MEMCOPY_ALIGN_7(x,y,z)  _dos_copy_sb( (x) , (y) , (z) )
#define DOS_MEMCOPY_ALIGN_8(x,y,z)  _dos_copy_sb( (x) , (y) , (z) )

#define _dos_copy_sb(src,dest,len) asm volatile(                         "\n\
pushw %%es \n \
movw __jlib_sel, %%es \n \
 push %%ecx \n \
 movl %0, %%esi \n \
 addl __jlib_off, %%esi \n \
 movl %1, %%edi \n \
 movl %2, %%ecx \n \
 rep \n \
 movsb \n \
 pop %%ecx \n \
 popw %%es "\
:                               /* NOTHING */ \
:" g " (src), " g " (dest), " g " (len) \
:"di", "si", "cx")

#define _dos_copy_sw(src,dest,len) asm volatile(                         "\n\
pushw %%es \n \
movw __jlib_sel, %%es \n \
 push %%ecx \n \
 movl %0, %%esi \n \
 addl __jlib_off, %%esi \n \
 movl %1, %%edi \n \
 movl %2, %%ecx \n \
 shrl $1, %%ecx \n \
 rep \n \
 movsw \n \
 pop %%ecx \n \
 popw %%es "\
:                               /* NOTHING */ \
:" g " (src), " g " (dest), " g " (len) \
:"di", "si", "cx")

#define _dos_copy_sw_inc(src,dest,len) asm volatile(                     "\n\
pushw %%es \n \
movw __jlib_sel, %%es \n \
 push %%ecx \n \
 movl %0, %%esi \n \
 addl __jlib_off, %%esi \n \
 movl %1, %%edi \n \
 movl %2, %%ecx \n \
 shrl $1, %%ecx \n \
 rep \n \
 movsw \n \
 movl $1, %%ecx \n \
 rep \n \
 movsb \n \
 pop %%ecx \n \
 popw %%es "\
:                               /* NOTHING */ \
:" g " (src), " g " (dest), " g " (len) \
:"di", "si", "cx")

#define _dos_copy_inc_sw(src,dest,len) asm volatile(                     "\n\
pushw %%es \n \
movw __jlib_sel, %%es \n \
 push %%ecx \n \
 movl %0, %%esi \n \
 addl __jlib_off, %%esi \n \
 movl %1, %%edi \n \
 movl $1, %%ecx \n \
 rep \n \
 movsb \n \
 movl %2, %%ecx \n \
 shrl $1, %%ecx \n \
 rep \n \
 movsw \n \
 pop %%ecx \n \
 popw %%es "\
:                               /* NOTHING */ \
:" g " (src), " g " (dest), " g " (len) \
:"di", "si", "cx")

#define _dos_copy_inc_sw_inc(src,dest,len) asm volatile(                     "\n\
pushw %%es \n \
movw __jlib_sel, %%es \n \
 push %%ecx \n \
 movl %0, %%esi \n \
 addl __jlib_off, %%esi \n \
 movl %1, %%edi \n \
 movl $1, %%ecx \n \
 rep \n \
 movsb \n \
 movl %2, %%ecx \n \
 shrl $1, %%ecx \n \
 rep \n \
 movsw \n \
 movl $1, %%ecx \n \
 rep \n \
 movsb \n \
 pop %%ecx \n \
 popw %%es "\
:                               /* NOTHING */ \
:" g " (src), " g " (dest), " g " (len) \
:"di", "si", "cx")


#ifdef __cplusplus
}
#endif 

#endif /* #ifndef __JTARGET_H__ */
