/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <grx20.h>
#include <jlib.h>

static int __jlib_mouse_initted=0;
extern int __jlib_mouse_present;

/*+--------------------------------------------------------------------------+*/
/*|check for the presence of a Mouse.                                        |*/
/*+--------------------------------------------------------------------------+*/
int mouse_present(void)
{
 JLIB_ENTER("mouse_present");

 if(__jlib_mouse_initted){
    JLIB_LEAVE;
    return MOUSE_ABSENT;
 }
 
 __jlib_mouse_initted = 1;
 
 if(__jlib_mouse_present){
    GrMouseDisplayCursor();
    JLIB_LEAVE;
    return MOUSE_PRESENT;
 }
 else{
    JLIB_LEAVE;
    return MOUSE_ABSENT;
 }
}


/*+--------------------------------------------------------------------------+*/
/*|shut down the mouse                                                       |*/
/*+--------------------------------------------------------------------------+*/
void mouse_closedown(void)
{
 JLIB_ENTER("mouse_closedown");

 if(!__jlib_mouse_initted){
    JLIB_LEAVE;
    return;
 }
 
 __jlib_mouse_initted = 0;

 GrMouseEraseCursor();
 JLIB_LEAVE;
}


/*+--------------------------------------------------------------------------+*/
/*|show the pointer                                                          |*/
/*+--------------------------------------------------------------------------+*/
void mouse_show_pointer(void)
{
 JLIB_ENTER("mouse_show_pointer");

 if(!__jlib_mouse_initted){
    JLIB_LEAVE;
    return;
 }

 GrMouseDisplayCursor();
 JLIB_LEAVE;
}


/*+--------------------------------------------------------------------------+*/
/*|hide the pointer                                                          |*/
/*+--------------------------------------------------------------------------+*/
void mouse_hide_pointer(void)
{
 JLIB_ENTER("mouse_hide_pointer");

 if(!__jlib_mouse_initted){
    JLIB_LEAVE;
    return;
 }

 GrMouseEraseCursor();
 JLIB_LEAVE;
}


/*+--------------------------------------------------------------------------+*/
/*|read pointer coordinates                                                  |*/
/*+--------------------------------------------------------------------------+*/
void mouse_get_status(int *x_pos, int *y_pos, int *b_status)
{
 GrMouseEvent event;

 JLIB_ENTER("mouse_get_status");

 if(!__jlib_mouse_initted){
    JLIB_LEAVE;
    return;
 }

 GrMouseGetEvent((GR_M_MOTION|GR_M_BUTTON_CHANGE|GR_M_POLL|GR_M_NOPAINT ),&event);

 *x_pos = event.x;
 *y_pos = event.y;
 *b_status = event.buttons;

 JLIB_LEAVE;
}


/*+--------------------------------------------------------------------------+*/
/*|change pointer coordinates                                                |*/
/*+--------------------------------------------------------------------------+*/
void mouse_set_status( int x, int y)
{
 JLIB_ENTER("mouse_set_status");

 if(!__jlib_mouse_initted){
    JLIB_LEAVE;
    return;
 }

 GrMouseWarp(x,y);
 JLIB_LEAVE;
}


