/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

/* target specific includes for GENERIC */

#ifndef __JTARGET_H__
#define __JTARGET_H__

#ifdef __cplusplus
extern "C" {
#endif 

#ifndef GENERIC
#error Wrong Target header file included in build.
#endif

#include <string.h>

/* INPUT */
#define KEYBOARD_AVAILABLE 0    /* keyboard support not available */
#define MOUSE_AVAILABLE 0       /* mouse not available */ 
#define JOYSTICK_AVAILABLE 0    /* no joystick support */

/* mouse */
#define MOUSE_NUM_BUTTONS 0
#define MOUSE_B_LEFT   1
#define MOUSE_B_MIDDLE 1
#define MOUSE_B_RIGHT  1

#define BUTTON_DOWN(status)    (status)
#define BUTTON_CHECK(status,x) (status & (x))

/* SCREEN */
#define  SCREEN_WIDTH   320
#define  SCREEN_HEIGHT  200
#define  SCREEN_MAX_X   319
#define  SCREEN_MAX_Y   199
#define  SCREEN_NUM_COLORS 256
#define  SCREEN_NUM_PAGES 1

#define UCLOCK_TICKS_PER_SECOND 1000000L

/* MEMORY OPERATIONS */
int get_best_copy_method (void *addr1, void *addr2, unsigned int len);

#define ALIGNMENT_STATE_1   0
#define ALIGNMENT_STATE_2   1
#define ALIGNMENT_STATE_3   2
#define ALIGNMENT_STATE_4   3
#define ALIGNMENT_STATE_5   4
#define ALIGNMENT_STATE_6   5
#define ALIGNMENT_STATE_7   6
#define ALIGNMENT_STATE_8   7

/* every memory copy is done using memcpy */

#define MEM_COPY_ALIGN_1(x,y,z)  memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_2(x,y,z)  memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_3(x,y,z)  memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_4(x,y,z)  memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_5(x,y,z)  memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_6(x,y,z)  memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_7(x,y,z)  memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_8(x,y,z)  memcpy( (y) , (x) , (z) )

#define FAST_SHORT_COPY(s,d,len)     memcpy( (d) , (s) , (len) )
#define FAST_LONG_COPY(s,d,len)      memcpy( (d) , (s) , (len) )
#define FAST_VERY_LONG_COPY(s,d,len) memcpy( (d) , (s) , (len) )
#define BYTE_COPY(s,d,len)           memcpy( (d) , (s) , (len) )
#define WORD_COPY(s,d,len)           memcpy( (d) , (s) , (len) )
#define LONG_COPY(s,d,len)           memcpy( (d) , (s) , (len) )

#ifdef __cplusplus
}
#endif 

#endif /* #ifndef __JTARGET_H__ */
