/********************************************************************
 * SORTEST.C
 ********************************************************************/
#include <stdio.h>
#include <conio.h>

/**********************************************
 * Define Values For Sort Operations
 **********************************************/
#define OK    0
#define TRUE  1
#define FALSE 0
#define FETCHEND   -1

FILE *fst, *ftd;

long fetch();
extern int sorterror;    /* Error Code for Sort */

void main();
void asorterr();

void main()
{
   char line[165];
   char sorttag[31];
   char *lptr, *sptr;
   int itemcount, sortcount;
   long pos;

   clrscr();
   itemcount=0;
   printf("                 Sort Test Program\n\n");
   printf("     LISTS ARE DISPLAYED WITH DELAYED SCROLLING\n\n");
   printf("This Sort Test builds a TEST file from the 'SORTEST.C' source file\n");
   printf("if the test file (STEST.DAT) does not exist in the current directory.\n");
   printf("BE SURE the 'SORTEST.C' file or the 'STEST.DAT' file exists in\n");
   printf("the current directory. For test purposes Spaces are being replaced\n");
   printf("with a  character to better visualize the sort process.\n");
   printf("\n\nPRESS ANY KEY TO BEGIN THE TEST -or- <ESC> to quit ...");
   if(getch() == 27) exit(0);
   clrscr();

   if((fst = fopen("STEST.DAT", "rb"))==NULL)
      {
   printf("Building Sort Test File ...\n\n");

   if((fst = fopen("STEST.DAT", "wb"))==NULL)
      {
      printf("$$ Error Creating SORT TEST File $$");
      exit(0);
      }
   if((ftd = fopen("SORTEST.C", "rt"))==NULL)
      {
      printf("$$ Error Opening SORTTEST.C File $$");
      exit(0);
      }
   while(fgets(line, 160, ftd)!=NULL)
      {
      strcpy(sorttag,"");
      sptr=sorttag;
      lptr=line;
      while(*lptr == ' ') lptr++;  /* skip Leading Spaces */
      while(*lptr)
        {
        if(*lptr == '\n') break;
        *sptr++ = *lptr++;
        }
      fwrite(sorttag,20,1,fst); /* Truncate the Line to 1st 20 chars only */
      itemcount++;
      }
   fclose(ftd);
   printf("\n%d Items Were Written\n",itemcount);
    }

   fclose(fst);
   printf("\n### Press <ENTER> to view UNSORTED LIST ###\n");
   while(getch()!=13);

   if((fst = fopen("STEST.DAT", "rb"))==NULL)
      {
      printf("$$ Error Opening SORT TEST File $$");
      exit(0);
      }
   while(fread(line,20,1,fst)==1)
      {
      line[20]=0;
      printf("%s\n",line);
      delay(70);
      }


   fclose(fst);
   printf("\n>>>> Press <ENTER> to SORT LIST <<<<\n");
   while(getch()!=13);
   clrscr();


   if((fst = fopen("STEST.DAT", "rb"))==NULL)
      {
      printf("$$ Error Opening SORT TEST File $$");
      exit(0);
      }

   printf("\nSORT IN PROGRESS ...\n");
   if(initsort(20)!=OK)  asorterr();  /* Init the sort */

   sortcount = 0;
   pos = 0;
   while(fread(line,20,1,fst)==1)
      {
      line[20]=0;
      if(sort(line,pos) != OK) asorterr();
      pos = ftell(fst); /* Get file position */
      sortcount++;
      }
   printf("SORT COMPLETED - %d Records Passed To Sort\n",sortcount);

   printf("MERGE IN PROGRESS ...\n");
   if(merge()!=OK) asorterr();
   printf("MERGE COMPLETED --\n");
   printf("FETCH IN PROGRESS ...\n");

   printf("\n>>>> NOW -- Press <ENTER> to view SORTED LIST <<<<\n");
   while(getch()!=13);
   clrscr();

   while(TRUE)
      {
      pos = fetch();
      if(pos == FETCHEND) break;  /* End of sorted Records */
      if(pos < 0) asorterr();
      if(fseek(fst,pos,0))
       {
       printf("\n$$ ERROR SEEKING TO RECORD at %ld $$\n",pos);
       exit(0);
       }
      if(fread(line, 20, 1, fst))  /* Read a record */
       {
       line[20]=0;
       printf("%s\n",line);
       delay(100);
       }
      }
 fclose(fst);
 printf("***** SORT TEST CONCLUDED *****\n");
}

/**************************
 * ASORTERR - A sorting Error Occured
 *****************************/
void asorterr()
{
   printf("\n$$$ A SORT ERROR - ERROR CODE = %d $$$\n", sorterror);
   exit(0);
}
