/* Date / Copyright 1994-95 by Kai Hofmann
******* Date/--history-- ****************************************************
*
*   NAME
*	history -- This is the development history of the Date module
*
*   VERSION
*	$VER: Date 33.158 (29.07.95)
*
*   HISTORY
*	16.01.1994 -	Procedures: JulianLeapYear(), GregorianLeapYear() &
*			HeisLeapYear() initiated.
*	22.01.1994 -	Procedures: JulianMonthDays(), GregorianMonthDays(),
*			HeisMonthDays(), JulianYearDays(),
*			GregorianYearDays(), HeisYearDays(), JulianDayDiff(),
*			GregorianDayDiff(), HeisDayDiff(),
*			JulianDaySmaller(), GregorianDaySmaller(),
*			HeisDaySmaller(), JulianWeekday(),
*			GregorianWeekday(), HeisWeekday(),
*			JulianDaysBeforeWeekday(),
*			GregorianDaysBeforeWeekday(),
*			HeisDaysBeforeWeekday(), JulianDaysAfterWeekday(),
*			GregorianDaysAfterWeekday(), HeisDaysAfterWeekday(),
*			JulianDiffDate(), FreeDate() initiated.
*			Types: Weekdays, Date, DatePtr initiated.
*			Vars of Gregorian reform initiated
*			(for changing to different countries)
*	23.01.1994 -	Procedures: JulianDiffDate() finished,
*			GregorianDiffDate(), HeisDiffDate(),
*			JYearToScaliger(), GYearToScaliger(),
*			HYearToScaliger(), ScaligerYearToJ(),
*			ScaligerYearToG(), ScaligerYearToH(), JSYearToJD(),
*			GSYearToJD(), HSYearToJD(), JDtoMJD(), MJDtoJD(),
*			JulianToJD(), GregorianToJD(), HeisToJD(),
*			TimeToJD(), JDToTime(), FreeTime() initiated.
*			Types: Time, TimePtr initiated.
*	28.01.1994 -	Procedures: GregorianMoonAge(), MoonMonthAge(),
*			GregorianEaster() initiated.
*	30.01.1994 -	Procedures: JulianDiffDate(), GregorianDiffDate(),
*			HeisDiffDate(), JDToTime(), GregorianEaster() edited
*			(changing return value from ptr to VAL variables).
*			Procedures: FreeDate(), FreeTime() deleted.
*			Types: Date, DatePtr, Time, TimePtr deleted (not
*			longer needed, because of the procedure changes).
*			Procedures: GregorianMoonAge(), GregorianEaster()
*			changed	year parameter from CARDINAL to INTEGER
*			(this is more consistent to the rest of the library).
*			Bugs removed: GregorianWeekday(), HeisWeekday()
*			(before removing, the weekday for leapyears was
*			wrong)
*			Procedure: GregorianEaster() finished.
*			Ported to Oberon-2
*	31.01.1994 -	Compiled with Oberon-2 V3.11
*	12.02.1994 -	Procedures: TimeZoneFactor(), LMT(), TimeToSec(),
*			SecToTime() initiated.
*			Version-String installed :)
*			Starting translation to SAS C 6.51:
*			Date.h translated
*	13.02.1994 -	Continuation of C translation
*	17.02.1994 -	New Oberon-2 Port, because Daniel Amor gave me a
*			small hint about the SHORT command
*			(I did not know about this!)
*			Small bug in Autodocs removed
*			making this text as Date/--history-- autodoc
*			Continuation of C translation
*	18.02.1994 -	Finished with C translation
*	19.02.1994 -	C bugs removed (thanks to SAS for helping a
*			C greenhorn like me!), some optimizations done also.
*			Oberon-2 version compiled with V40.17 includes
*	21.02.1994 -	Starting to write Modula-II testmodule
*			Vars for the begining of Heis calculation initiated.
*			Fixed small bugs in GregorianWeekday(),
*			HeisWeekday(), TimeToSec(), SecToTime()
*			Return-value of LMT() changed to LONGINT!
*			Converting testmodule to Oberon-2
*	22.02.1994 -	Converting testmodule to C
*	23.02.1994 -	I noticed, that I forgot the 3 functions
*			JulianWeek(), GregorianWeek(), HeisWeek()
*	24.02.1994 -	Initiated the 3 forgotten functions
*	26.02.1994 -	Initiating new GregorianEaster() with
*			Gau-algorithms	but ONLY for 1900-2099!
*	27.02.1994 -	Bug fixed in JulianWeekday()
*			Bugs fixed in JulianDayDiff(), GregorianDayDiff(),
*			HeisDayDiff()
*			JulianDayGreater(), GregorianDayGreater(),
*			HeisDayGreater() Initiated.
*	02.03.1994 -	Small bug fixed in HeisDayDiff()
*			Bugs from 27.02. fixed in Modula-II and Oberon-2
*			versions
*			I found the way to extend GregorianEaster() !
*			Small bug fixed in JulianWeek(), GregorianWeek(),
*			HeisWeek() (~(M2) is not !(C))
*	05.03.1994 -	Some internal bugs removed
*			New internal procedures GregorianSB(),
*			GregorianJHSB(), GregorianJHStartSB() !
*			Extending GregorianEaster() :)
*	11.03.1994 -	Things from 05.03. done in Modula-II and Oberon
*	12.03.1994 -	If __SASC is defined autoinitialization instead of
*			_DateInit() will be used!
*	13.03.1994 -	After studying the SAS C Manual again I decided to
*			check for __SASC_650 instead of __SASC because of
*			the available priorities!
*			Setting the priority of _DateInit() for
*			autoinitialization to 600!
*	15.03.1994 -	Making Date as library
*	16.03.1994 -	Some work on the Autodocs was done,
*			eliminating OldGregorianEaster() by comments
*			(ANSI: STOP bad standards like that there are NO
*			 nested comments possible in C!!!).
*	19.03.1994 -	Some work on the Autodocs was done in the M2 Code.
*	20.03.1994 -	Some work on the Autodocs was done in the Oberon Code
*	22.03.1994 -	In JDtoMJD(), MJDtoJD() an L was added to the
*			constant.
*			In GregorianWeekday(), HeisWeekday(),
*			JulianDiffDate(), GregorianDiffDate(),
*			HeisDiffDate(), JDToTime() I have inserted
*			conversions (found with Borland C++ 4.0).
*	24.03.1994 -	Making SunOS4.1.3, SunOS5.3(Solaris2.3) &
*			RS6000 AIX3.2.? binaries with gcc.
*			Eliminating nested commends by inserting a space
*			between / and * (I hate this ANSI C standard
*			feature for commends :(
*	27.03.1994 -	Adding library register assignments to the autodocs.
*	03.04.1994 -	Small fixes for the SAS C++ Compiler
*			Small bug fixed in the M2 version of
*			GregorianEaster()
*	04.04.1994 -	Adding some 'static' keywords.
*	10.04.1994 -	Changing from Shareware to Gift Ware ;-)
*	02.08.1994 -	Small fixes in the Autodocs (thanks to Rita Reichl
*			for correcting my bad english ;-)
*	11.08.1994 -	Again small fixes in the Autodocs!
*	13.11.1994 -	Small fix in JulianWeek(),GregorianWeek(),HeisWeek().
*			Thanks to Jim Rickman for reporting the bug!
*			Small changes in the Autodocs!
*	30.11.1994 -	Fix the bug from 13.11. in M2 and Oberon code.
*	04.12.1994 -	Small fixes in the C-Autodocs.
*	12.12.1994 -	Adding WeekdayText(), MonthText() and internal
*			max().
*	13.12.1994 -	Optimizing WeekdayText() and MonthText()
*	14.12.1994 -	Adding WeekdayShortText() and MonthShortText(),
*			and fixing the french text.
*	17.12.1994 -	Two small changes in the copyright conditions!
*	18.12.1994 -	Fix for Amiga init library
*	10.01.1995 -	Installing TurboText 2.0
*	11.01.1995 -	Found a new (German) book!
*	13.01.1995 -	Introducing release history
*	14.01.1995 -	Introducing to do list
*	15.01.1995 -	Procedures: JDToJulian(), JDToGregorian(),
*			JDToHeis() as dummy, JulianEaster() initiated.
*			Procedure: OldGregorianEaster() removed.
*			Initiating an alternate GregorianEaster() and a
*			dummy HeisEaster().
*	16.01.1995 -	Procedure: GregorianMoonPhase initiated.
*			I decided not longer to support Modula-II and Oberon
*			version, until someone asks for it!
*	17.01.1995 -	Internal procedure: GregorianMoonPhaseHelp.
*			Adding a note to the background.
*			Correcting small bug in autodocs.
*	18.01.1995 -	Found a new (German) book!
*	20.01.1995 -	Rita Reichl found David F. Skoll's Reminder3.0 -
*			I was so impressed, that I could not continue my
*			work for one day ;-)
*	21.01.1995 -	I decided to distribute my TextEngine with the date
*			library, when I have finished it.
*	28.01.1995 -	Adding 'static' to GregorianMoonPhaseHelp.
*			Fixing a very small bug.
*	01.02.1995 -	Replacing JulianDaySmaller(), GregorianDaySmaller(),
*			HeisDaySmaller(), JulianDayGreater(),
*			GregorianDayGreater(), HeisDayGreater() with the new
*			CompareDates()!
*			Procedure: CompareTimes() initiated.
*	04.02.1995 -	Adding some things to the autodocs.
*	07.02.1995 -	Small fixes in the autodocs, and changing * to
*			*const for JulianDiffDate(), GregorianDiffDate(),
*			HeisDiffDate(),JDToTime(),SecToTime(),WeekdayText(),
*			MonthText(),WeekdayShortText(),MonthShortText(),
*			JulianEaster(),GregorianEaster(),HeisEaster(),
*			JDToJulian(),JDToGregorian(),JDToHeis().
*			Adding const to WeekdayText(),MonthText(),
*			WeekdayShortText(),MonthShortText(), maximum().
*			Adding C++ support to SecToTime(), JDToTime(),
*			JDToJulian(), JDToGregorian(), JDToHeis(),
*			JulianEaster(), GregorianEaster(), HeisEaster(),
*			JulianDiffDate(), GregorianDiffDate(),HeisDiffDate(),
*			GregorianMoonPhase()
*			Changing the order of #ifdef headers.
*			Fixing type conversion bugs (found with C++)
*	17.02.1995 -	I good a hint about Jean-Michel Leon's 'K-lendars'
*			nice thing ;-)
*	18.02.1995 -	More languages for WeekdayText(), WeekdayShortText(),
*			MonthText(), MonthShortText()
*			Procedures DateText() ValidTime() initiated.
*			Bug in WeekdayText(), WeekdayShortText(),
*			MonthText(), MonthShortText() fixed
*			Procedures: ValidJulianDate(), ValidGregorianDate(),
*			ValidHeisDate() as dummys initiated.
*	19.02.1995 -	Procedures: ValidJulianDate(), ValidGregorianDate(),
*			ValidHeisDate() finished.
*			Procedure SetCountry() initiated.
*	24.02.1995 -	Rita Reichl corrects my bad English - again *THANX*
*	26.02.1995 -	Adding Polish and Finnish support (not public)
*	27.02.1995 -	Renaming CompareDates() to Compare2Dates() and
*			CompareTimes() to Compare2Times() because there is an
*			conflict with AmigaDOS!
*	28.02.1995 -	To-Do list is not longer internal.
*	07.03.1995 -	I got the three magic books :) thanx to Rita Reichl!
*	09.03.1995
*	12.03.1995 -	These two days I was at CeBit in Hannover!
*			Whatever I observed and whatever material I acquired
*			will change some things for commercial distribution
*			(I was so uninformed and naive ;-)
*	16.03.1995 -	Some work and corrections on the autodocs.
*	20.03.1995 -	Compiled with SAS C 6.55
*	21.03.1995 -	Fixing C++ abs() problem!
*			(I don't know why SAS means that this is a problem!)
*	23.03.1995 -	Fixing following things:
*			Adding 'L' to the constant in JDToGregorian()
*			Removing three conditions from ValidTime().
*			maximum() is only needed for Amiga code!
*			GregorianJHSB(), GregorianSB() is not longer needed.
*			Thanx to Christian Schaefer for finding this
*			things with Borland C++!
*	24.03.1995 -	I read, that the Julian Calendar is stabel from
*			8 on and not from -7, so I corrected the autodocs!
*	31.03.1995 -	Some work on DateText().
*			Reformating the DISCLAIMER to autodoc style.
*	01.04.1995 -	Moving TimeToJD(), JDToTime(), TimeZoneFactor(),
*			LMT(), TimeToSec(), SecToTime(), Compare2Times(),
*			ValidTime() to Date_Time.c (this is no April fool ;-)
*	06.04.1995 -	Minor work on the autodocs.
*	07.04.1995 -	Adding prototype for _DateCleanup() to Date.h.
*			GregorianSZ() is not longer needed.
*			Thanks to Christian Schaefer for reporting this bugs!
*	14.05.1995 -	New copyright notice!
*	19.05.1995 -	Rita Reichl corrects my bad English.
*	23.05.1995 -	Writing announcement.
*	01.06.1995 -	Correcting announcement and including it in the
*			autodocs.
*	03.06.1995 -	Procedures: TimeDiff(), DiffTime() initiated.
*			Fixing small bugs in datetest.c and implementing
*			C++ support
*	09.06.1995 -	Writing Installer script (Amiga only)
*	14.06.1995 -	Small fixes in GregorianEaster(), GregorianEP(),
*			GSYearToJD(), GregorianWeekday(), GregorianDayDiff(),
*			HeisDayDiff()
*	18.06.1995 -	Again small fixes in GregorianDayDiff(),
*			HeisDayDiff()
*	28.06.1995 -	Small Autodoc fixes
*	08.07.1995 -	Fixing bug in DiffTime()
*	14.07.1995 -	Workaround, for a SAS C++ problem.
*			Thanks to James Cooper for the hint.
*	18.07.1995 -	Fixing 'is long constant' warnings in Date_Time.h
*			Fixing two missed enum's for the C++ workaround.
*	28.07.1995 -	Shortening the year of the version-string to 95,
*			because the Amiga 'version' command is buggy!
*	29.07.1995 -	Expanding announcement for DateClass.
*
*****************************************************************************
*
*
*/

/*
******* Date/--release-- ****************************************************
*
*   NAME
*	release -- This is the release history of the Date module
*
*   RELEASE
*	13.04.1994 : 33.087 -	V1.0 First release on Aminet3 & SaarAG 707
*	13.08.1994 : 33.088 -	V1.1 Second release on Aminet4, SaarAG 793,
*				     Fred Fish & SimTel
*	18.12.1994 : 33.093 -	V1.2 Third release on Aminet
*	06.02.1995 : 33.100 -	V1.3 Fourth release on Aminet, Amiga-PD-1
*	01.08.1995 : 33.158 -	V1.4 Fifth release on Aminet, SaarAG,
*				     Fred Fish & SimTel
*
*****************************************************************************
*
*
*/

/*
******* Date/--todo-- *******************************************************
*
*   NAME
*	todo -- This is the 'To-Do' list of the Date module
*
*   TODO
*	DateText() plural strings
*	Country strings for TextEngine
*	(Local catalog (Amiga only))
*	A function to compare date/time of different time zones!
*	DATE/ECHO like shell command
*	Country dependend for 1582
*	Rising/setting of moon and sun
*	Parser for datestrings
*	EVAL like shell command
*	Tcl interface
*	Other calenders, like the Islamic and the Jewish
*
*****************************************************************************
*
*
*/

/*
******* Date/--announce-- ***************************************************
*
*   TITLE
*	date.library
*
*   VERSION
*	33.158
*
*   RELEASE DATE
*	01.08.1995
*
*   AUTHOR
*	Kai Hofmann (i07m@zfn.uni-bremen.de)
*	            (http://www.informatik.uni-bremen.de/~i07m)
*
*   DESCRIPTION
*	A portable ANSI-C/C++ library that gives you low level functions for
*	date calculations.
*	Includes the following features:
*
*	- Support for six different date/time measurement systems:
*	  Julian, Gregorian, Heis, Julian Day, Modified Julian Day,
*	  Scaliger Year (other systems will follow).
*	- Month/Weekday and other date/time string support for 12 languages.
*	- Support for different countries (implementation not finished!).
*	- Calculating leap years.
*	- Functions to calculate the days of a month or a year or between
*	  two dates.
*	- Functions to calculate the weeknumber and the weekday.
*	- Check the validity of a date.
*	- Calculating Easter.
*	- Comparing dates.
*	- Powerfull functions to handle differences between dates.
*	- Transformations from one time measurement system to the others.
*	- Calculating your local time zone out of your position on the earth.
*	- Calculating the age of the moon and the moon phase.
*	- Check the validity of a time.
*	- Comparing times.
*	- Transforming 24h time format into seconds and back.
*	- Transforming 24h time format to Julian Day time format and back.
*	- Powerfull textengine for creating date/time strings in different
*	  languages, that supports nearly all features of the date library.
*	- A C++ class concept, which makes it very easy to use the complex
*	  functionality of the date library.
*	- Autodoc describing all functions in the library.
*	- Including ANSI-C/C++ sources and test example.
*
*   NEW FEATURES
*	- Better code
*	- Bug fixes
*	- More C++ support
*	- Fixing type conversion bugs
*	- Better Autodocs
*	- Supporting more languages
*	- Functions for checking validity of dates/times
*	- Julian calendar is stable since 8 and NOT since -7!
*	- Textengine
*	- DateClass (basic concept)
*
*   SPECIAL REQUIREMENTS
*	ANSI-C or/and C++ Compiler.
*
*   AVAILABILITY
*	ftp://wuarchive.wustl.edu/pub/aminet/dev/c/date.lha
*	And all other Aminet sites.
*
*	ftp://OAK.Oakland.Edu/pub/SimTel/msdos/c/kh-date.zip
*	And all other SimTel sites.
*
*	Actual beta versions (for all systems) are available from:
*	ftp://ftp.uni-bremen.de/pub/amiga/date/
*
*   PRICE
*	For NON-COMMERCIAL USE this is Giftware!
*	(Non-commercial includes Giftware and Shareware!)
*
*	Permission for COMMERCIAL USE is only given by an extra available
*	commercial license that must be validated!
*	Contact me directly for this license, because it will be individually
*	handed out per your needs!
*
*	But in both cases you have to follow the two guidelines below:
*
*	1) You *must* include the following notice in your product and in
*	   your documentation:
*	   "This software uses the date library that is copyrighted 1994-95
*	    by Kai Hofmann"
*
*	2) You "must" send me a full version of your product at no cost
*	   including free updates!
*
*   DISTRIBUTION
*	You can copy and distribute this library as long as you do not take
*	more than $5 for one disk or $40 for one CD!
*
*****************************************************************************
*
*
*/

/*
******* Date/--compiling-- **************************************************
*
*   NAME
*	compiling -- Specials for compiling the date library.
*
*   COMPILING
*	- You could compile this code as normal C or as C++
*	- _AMIGA, __SASC_650, __MakeLib are Amiga only pp defines!
*	- _ISO8859_Latin1 should be defined if your system supports this
*	  font encoding technology!
*	- Date_Time.c will be included automatically!
*
*****************************************************************************
*
*
*/

/*
******* Date/--background-- *************************************************
*
*   NAME
*	Date -- This module was designed in helping calc.calendar dates (V33)
*
*   FUNCTION
*	This module has been designed to become a useful and portable library
*	and to help developers calculate calendar dates!
*
*   NOTES
*	A tropical year is 365.2422 days! / 365d, 5h, 48min, 46sec
*	A moon month is 29.53059 days! / 29d, 12h, 44min, 2.9 sec
*	A moon phase is 7.38265 days!
*	The calculations are historical and NOT astronomical!
*
*	(German) Books which were consulted in creating this library:
*	    Kleine Naturwissenschaftliche Bibliothek, Band 23
*	    Ewige Kalender
*	    A.W. Butkewitsch & M.S. Selikson
*	    5. Auflage
*	    Teubner, Leipzig 1974
*	    ISBN 3-322-00393-0
*
*	    Tag und Woche, Monat und Jahr: eine Kulturgeschichte des
*	    Kalenders
*	    Rudolf Wendorff
*	    Westdeutscher, Opladen 1993
*	    ISBN 3-531-12417-X
*
*	    Kalender und Chronologie: Bekanntes & Unbekanntes aus der
*	    Kalenderwissenschaft
*	    Heinz Zemanek
*	    4. Auflage
*	    Oldenbourg, Mnchen 1987
*	    ISBN 3-486-20447-5
*
*	    Meyers Handbuch
*	    ber das Weltall
*	    Karl Schaifers & Gerhard Traving
*	    5. Auflage
*	    Bibliographisches Institut, Mannheim 1973
*	    ISBN 3-411-00940-3
*
*	    Astronomische Algorithmen
*	    Jean Meeus
*	    2. Auflage
*	    Johann Ambrosius Barth, Berlin 1994
*	    ISBN 3-335-00400-0
*
*	    Astronomie mit dem Personal Computer
*	    Oliver Montenbruck & Thomas Pfleger
*	    2. Auflage
*	    Springer, Berlin 1994
*	    ISBN 3-540-57701-7
*
*	    Handbuch der mathematischen und technischen Chronologie
*	    Das Zeitrechnungswesen der Vlker
*	    Band I
*	    F. K. Ginzel
*	    1. Auflage
*	    J. C. Hinrichs'sche Buchhandlung, Leipzig 1906
*
*	    Handbuch der mathematischen und technischen Chronologie
*	    Das Zeitrechnungswesen der Vlker
*	    Band II
*	    F. K. Ginzel
*	    1. Auflage
*	    J. C. Hinrichs'sche Buchhandlung, Leipzig 1911
*
*	    Handbuch der mathematischen und technischen Chronologie
*	    Das Zeitrechnungswesen der Vlker
*	    Band III
*	    F. K. Ginzel
*	    1. Auflage
*	    J. C. Hinrichs'sche Buchhandlung, Leipzig 1914
*
*	(English) Books which were consulted in creating this library:
*	    Mathematical Astronomy with a Pocket Calculator
*	    Aubrey Jones Fras
*	    Unknown (first) Edition
*	    David & Charles Newton Abbot, London 1978
*	    ISBN 0-7153-7675-6
*
*	    Astronomical Algorithms
*	    Jean Meeus
*	    Unknown Edition (I use the German second edition ;-)
*	    Willmann-Bell, Inc., Ruchmond, Virginia (USA) 1991
*	    ISBN 0-943396-35-2
*
*   COPYRIGHT
*	This software is copyrighted 1994-95 by Kai Hofmann.
*	All rights reserved!
*
*	- Permission for COMMERCIAL USE is only given by an extra available
*	  commercial license that must be validated!
*	  Contact me directly for this license, because it will be
*	  individually handed out per your needs!
*
*	- Permission is hereby granted, without written agreement and without
*	  license, to USE this software and its documentation for any
*	  NON-COMMERCIAL purpose, provided that the above copyright notice
*	  and the following paragraph appear in all copies of this software
*	  (Non-commercial includes Giftware and Shareware!).
*
*	  You *must* include the following notice in your product and in your
*	  documentation:
*	  "This software uses the date library that is copyrighted 1994-95 by
*	   Kai Hofmann"
*
*	  You "must" send me a full version of your product at no cost
*	  including free updates!
*	  Extra money is welcome (For Bank Account see below - but *ONLY*
*	  send in DM to this Bank Account!).
*
*	- THERE IS *NO PERMISSION* GIVEN TO MODIFY THIS SOFTWARE!
*
*	  If you need only parts of this software, you should not worry,
*	  because it's the job of the optimizer from your C compiler to
*	  include only the needed parts in your executable!
*
*   DISCLAIMER
*	THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY
*	APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
*	HOLDER AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
*	WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
*	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*	A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND
*	PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE
*	DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR
*	CORRECTION.
*
*	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
*	WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY REDISTRIBUTE
*	THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
*	INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
*	ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING
*	BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR
*	LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM
*	TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER
*	PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
*	THE AUTHOR HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
*	UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*
*   DISTRIBUTION
*	Permission is hereby granted, without written agreement and without
*	license or royalty fees, to copy and distribute this software and its
*	documentation for any purpose, provided that the above copyright
*	notice and the following paragraphs appear in all copies of this
*	software, to:
*	- All who will distribute this software for free!
*	- All free accessible INTERNET servers and PHONE boxes!
*	- All Aminet sites
*	- All SimTel sites
*	- Fred Fish for his great Amiga-Software-Library
*	- The German SAAR AG PD-Library
*	- All others who do NOT take more than $5.- for one disk that
*	  includes this software!
*	- ALL others who do NOT take more than $40.- for one CD that includes
*	  this software!
*
*   ADDITIONAL INFORMATIONS
*	I have tried to make portable/useful and I hope bugfree software
*	for eternity - but this seems to be impossible (sorry!) :)
*	So I hope you will pay a fee for this.
*
*	Kindly send US - dollars to a friend of mine in the USA who will
*	forward it to me in a timely manner.  Please send checks or money
*	orders only.
*	Contact me via email for more!
*
*   AUTHOR
*	Kai Hofmann
*	Arberger Heerstrae 92
*	28307 Bremen
*	Germany
*
*	Phone: (+49)-(0)421/480780
*	       (Remember that my parents don't speak english!)
*	EMail: i07m@zfn.uni-bremen.de
*	       i07m@informatik.uni-bremen.de
*	IRC  : PowerStat@#AmigaGer
*	WWW  : http://www.informatik.uni-bremen.de/~i07m
*
*	Bank account : 1203 7503
*	Account owner: Kai Hofmann
*	Bank code    : 290 501 01
*	Bank name    : Sparkasse in Bremen/Germany
*
*    THANKS
*	Thank you's are going to the following people:
*	Daniel Amor		- For his hint about the Oberon-2 SHORT
*				  command
*	Rita Reichl		- For correcting my bad english (very often)
*				  and for the three magic books *kiss*
*	Jim Rickman		- For reporting a bug
*	Christian Schaefer	- For spending time on this lib with his
*				  Borland C++ 4.5 compiler
*	Heinz Zemanek		- For his great book
*	Jacco van Weert &
*	Frans Slothouber	- For the 'Robodoc' utility
*	James Cooper and the
*	other Amiga people at
*	SAS Intitute		- For spending their unpaid free time with
*				  continuation of the Amiga SAS C/C++
*				  support :)
*
*****************************************************************************
*
*
*/


 #include <stdlib.h> /* abs()   */
 #include <math.h>   /* floor() */
 #include <string.h> /* strcpy(), strlen() */
 #ifndef __SASC_650
   #undef __MakeLib
 #endif
 #ifdef _AMIGA
   #define _ISO8859_Latin1
   #include <proto/exec.h>
   #include <proto/locale.h>
 #endif
 #include "date.h"


 #ifdef _AMIGA
   #ifdef __SASC_650
     extern struct Library *LocaleBase;
   #else
     static struct Library *LocaleBase = NULL;
   #endif
   static struct Locale  *locale   = NULL;
   static unsigned short  wlen     = 0, abwlen = 0,
                          mlen     = 0, abmlen = 0;
   static ULONG           DAYS[]   = {DAY_1,DAY_2,DAY_3,DAY_4,DAY_5,DAY_6,DAY_7},
                          MONS[]   = {MON_1,MON_2,MON_3,MON_4,MON_5,MON_6,MON_7,MON_8,MON_9,MON_10,MON_11,MON_12},
                          ABDAYS[] = {ABDAY_1,ABDAY_2,ABDAY_3,ABDAY_4,ABDAY_5,ABDAY_6,ABDAY_7},
                          ABMONS[] = {ABMON_1,ABMON_2,ABMON_3,ABMON_4,ABMON_5,ABMON_6,ABMON_7,ABMON_8,ABMON_9,ABMON_10,ABMON_11,ABMON_12};
   #ifdef __MakeLib
     #include <exec/libraries.h>

     void __regargs __chkabort(void)
      {}

     void __regargs _CXBRK(void)
      {}
   #endif
 #endif


 static Countries Country = unknown;

 static unsigned short	BeforeGregorianDay = 4,
			BeforeGregorianMonth = 10,
			AfterGregorianDay = 15,
			AfterGregorianMonth = 10,
			StartHeisDay = 1,
			StartHeisMonth = 1;
 static int		BeforeGregorianYear = 1582,
			AfterGregorianYear = 1582,
			StartHeisYear = 3200;

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   bool JulianLeapYear(const int year)
 #else
   bool __saveds __asm JulianLeapYear(register __d0 const int year)
 #endif

/*
******* Date/JulianLeapYear *************************************************
*
*   NAME
*	JulianLeapYear -- Checks if a year is a leap year. (V33)
*
*   SYNOPSIS
*	leapyear = JulianLeapYear(year);
*	   d0			   d0
*
*	bool JulianLeapYear(const int year);
*
*   FUNCTION
*	JulianLeapYear checks if a year is a leap year in the Julian calendar
*	For years after Chr. it checks if the year is devideable by 4.
*	For years before Chr. a leap year must have a modulo 4 value of 1
*
*   INPUTS
*	year - The year which should be checked (from -32768 to 32767)
*	    I think only values from 8 to 32767 are valid, because of
*	    the variant that was done by Augustus!
*
*   RESULT
*	leapyear - TRUE if the year is a leap year, otherwise false.
*
*   EXAMPLE
*	...
*	if (JulianLeapYear(1994))
*	  printf("leap year!\n");
*	else
*	  printf("no leap year!\n");
*	...
*
*   NOTES
*	A year is 365.25 days long!
*	Use this function only for values from 8 to 1582!
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	GregorianLeapYear(),HeisLeapYear()
*
*****************************************************************************
*
*
*/

  {
   if (year <= 0)
     return((bool)((-year) % 4 == 1));
   else
     return((bool)(year % 4 == 0));
  }


 #ifndef __MakeLib
   bool GregorianLeapYear(const int year)
 #else
   bool __saveds __asm GregorianLeapYear(register __d0 const int year)
 #endif

/*
******* Date/GregorianLeapYear **********************************************
*
*   NAME
*	GregorianLeapYear -- Checks if a year is a leap year. (V33)
*
*   SYNOPSIS
*	leapyear = GregorianLeapYear(year);
*	   d0			      d0
*
*	bool GregorianLeapYear(const int year);
*
*   FUNCTION
*	GregorianLeapYear checks if a year is a leap year.
*	For years after 1582 all years devideable by 4 are leap years,
*	without years devideable by 100, but years devideable by 400
*	are leap years again!
*	For years before 1582 see JulianLeapYear().
*
*   INPUTS
*	year - The year which should be checked (from -32768 to 32767)
*	    I think only values from 8 to 3200 are valid, because of
*	    the variant that was done by Augustus!
*
*   RESULT
*	leapyear - TRUE if the year is a leap year, otherwise false.
*
*   EXAMPLE
*	...
*	if (GregorianLeapYear(1994))
*	  printf("leap year!\n");
*	else
*	  printf("no leap year!\n");
*	...
*
*   NOTES
*	A year is 365.2425 days long!
*	Use this function only for values from 8 to 3199!
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	JulianLeapYear(),HeisLeapYear()
*
*****************************************************************************
*
*
*/

  {
   if (year < BeforeGregorianYear)
     {/* Year of the Gregorian reform */
      return(JulianLeapYear(year));
     }
   else
     {/* AfterGregorianYear reform */
      return((bool)((year % 4 == 0) && ((year % 100 > 0) || (year % 400 == 0))));
     }
  }


 #ifndef __MakeLib
   bool HeisLeapYear(const int year)
 #else
   bool __saveds __asm HeisLeapYear(register __d0 const int year)
 #endif

/*
******* Date/HeisLeapYear ***************************************************
*
*   NAME
*	HeisLeapYear -- Checks if a year is a leap year. (V33)
*
*   SYNOPSIS
*	leapyear = HeisLeapYear(year);
*	   d0			 d0
*
*	bool HeisLeapYear(const int year);
*
*   FUNCTION
*	HeisLeapYear checks if a year is a leap year.
*	For years after 1582 see GregorianLeapYear(),
*	The correction from N. Heis says, that all years devideable by
*	3200 are no longer leap years!
*	For years before 1582 see JulianLeapYear().
*
*   INPUTS
*	year - The year which should be checked (from -32768 to 32767)
*	    I think only values from 8 to 32767 are valid, because of
*	    the variant that was done by Augustus!
*
*   RESULT
*	leapyear - TRUE if the year is a leap year, otherwise false.
*
*   EXAMPLE
*	...
*	if (HeisLeapYear(1994))
*	  printf("leap year!\n");
*	else
*	  printf("no leap year!\n");
*	...
*
*   NOTES
*	A year is now 365.2421875 days!
*	Use this function only for values from 8 to 8000!
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	JulianLeapYear(),GregorianLeapYear()
*
*****************************************************************************
*
*
*/

  {
   if (year < BeforeGregorianYear)
     {/* Year of the Gregorian reform */
      return(JulianLeapYear(year));
     }
   else
     {/* year >= AfterGregorianYear */
      if (year % 3200 == 0)
        {/* Correction from N. Heis */
         return(false);
        }
      else
        {/* (no leap year all 3200 years) */
         return(GregorianLeapYear(year));
        }
     }
  }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   unsigned short JulianMonthDays(const unsigned short month, const int year)
 #else
   unsigned short __saveds __asm JulianMonthDays(register __d0 const unsigned short month, register __d1 const int year)
 #endif

/*
******* Date/JulianMonthDays ************************************************
*
*   NAME
*	JulianMonthDays -- Returns the number of days of a month. (V33)
*
*   SYNOPSIS
*	days = JulianMonthDays(month,year);
*	 d0			d0    d1
*
*	unsigned short JulianMonthDays(const unsigned short month,
*	    const int year);
*
*   FUNCTION
*	JulianMonthDays gives returns the number of days a month in
*	a specified year has.
*
*   INPUTS
*	month - The month from which you want to get the number of days.
*	year  - The year in which the month is.
*
*   RESULT
*	days - The number of days the month uses, or 0 if you use
*	    an incorrect month.
*
*   EXAMPLE
*	...
*	days = JulianMonthDays(1,1994);
*	printf("Days of January 1994 : %d\n",days);
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 09.1582!
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	JulianLeapYear(),GregorianMonthDays(),HeisMonthDays()
*
*****************************************************************************
*
*
*/

  {
   switch (month)
     {case  1 :
      case  3 :
      case  5 :
      case  7 :
      case  8 :
      case 10 :
      case 12 : return(31);
      case  4 :
      case  6 :
      case  9 :
      case 11 : return(30);
      case  2 : if (JulianLeapYear(year))
                  return(29);
                else
                  if (!JulianLeapYear(year))
                    return(28);
      default : return(0);
     }
  }


 #ifndef __MakeLib
   unsigned short GregorianMonthDays(const unsigned short month, const int year)
 #else
   unsigned short __saveds __asm GregorianMonthDays(register __d0 const unsigned short month, register __d1 const int year)
 #endif

/*
******* Date/GregorianMonthDays *********************************************
*
*   NAME
*	GregorianMonthDays -- Returns the number of days of a month. (V33)
*
*   SYNOPSIS
*	days = GregorianMonthDays(month,year);
*	 d0			   d0    d1
*
*	unsigned short GregorianMonthDays(const unsigned short month,
*	    const int year);
*
*   FUNCTION
*	GregorianMonthDays returns the number of days a month in
*	a specified year has.
*	For the year 1582 and the month 10 there are only 21 days,
*	because of the Gregorian-reform 10 days are deleted from
*	the month (for more - look out for books about this!)
*
*   INPUTS
*	month - The month from which you want to get the number of days.
*	year  - The year in which the month is.
*
*   RESULT
*	days - The number of days the month uses, or 0 if you use
*	    an incorrect month.
*
*   EXAMPLE
*	...
*	days = GregorianMonthDays(1,1994);
*	printf("Days of January 1994 : %d\n",days);
*	...
*
*   NOTES
*	Use this function only for years from 8 to 3199!
*
*   BUGS
*	none.
*
*   SEE ALSO
*	GregorianLeapYear(),JulianMonthDays(),HeisMonthDays()
*
*****************************************************************************
*
*
*/

  {
   if ((year == AfterGregorianYear) && (month == AfterGregorianMonth))
     {/* 10 days canceled by Gregor XIII
				in countries who chnaged later are more days */
      return((unsigned short)(31-((AfterGregorianDay-BeforeGregorianDay)-1)));
     }
   else
     if ((month == 2) && GregorianLeapYear(year))
       return(29);
     else
       if ((month == 2) && (!GregorianLeapYear(year)))
         return(28);
       else
         {/* use Julian function for other calcs. */
          return(JulianMonthDays(month,year));
         }
  }


 #ifndef __MakeLib
   unsigned short HeisMonthDays(const unsigned short month, const int year)
 #else
   unsigned short __saveds __asm HeisMonthDays(register __d0 const unsigned short month, register __d1 const int year)
 #endif

/*
******* Date/HeisMonthDays **************************************************
*
*   NAME
*	HeisMonthDays -- Returns the number of days of a month. (V33)
*
*   SYNOPSIS
*	days = HeisMonthDays(month,year);
*	 d0		      d0    d1
*
*	unsigned short HeisMonthDays(const unsigned short month,
*	    const int year);
*
*   FUNCTION
*	HeisMonthDays returns the number of days a month in
*	a specified year has.
*	For the year 1582 and the month 10 there are only 21 days,
*	because of the Gregorian-reform 10 days are deleted from
*	the month (for more - look out for books about this!)
*
*   INPUTS
*	month - The month from which you want to get the number of days.
*	year  - The year in which the month is.
*
*   RESULT
*	days - The number of days the month uses, or 0 if you use
*	    an incorrect month.
*
*   EXAMPLE
*	...
*	days = HeisMonthDays(1,1994);
*	printf("Days of January 1994 : %d\n",days);
*	...
*
*   NOTES
*	Use this function only for years from 8 to 8000!
*
*   BUGS
*	See GregorianMonthDays!
*
*   SEE ALSO
*	HeisLeapYear(),JulianMonthDays(),GregorianMonthDays()
*
*****************************************************************************
*
*
*/

  {
   if ((month == 2) && HeisLeapYear(year))
     return(29);
   else
     if ((month == 2) && (!HeisLeapYear(year)))
       return(28);
     else
       {/* use Gregorian function for other calcs */
        return(GregorianMonthDays(month,year));
       }
  }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   unsigned int JulianYearDays(const int year)
 #else
   unsigned int __saveds __asm JulianYearDays(register __d0 const int year)
 #endif

/*
******* Date/JulianYearDays *************************************************
*
*   NAME
*	JulianYearDays -- Gives back the number of days in a year. (V33)
*
*   SYNOPSIS
*	days = JulianYearDays(year);
*	 d0		       d0
*
*	unsigned int JulianYearDays(const int year);
*
*   FUNCTION
*	JulianYearDays gives you back the number of days in
*	a specified year.
*
*   INPUTS
*	year  - The year in which to count the days.
*
*   RESULT
*	days - The number of days the year uses.
*
*   EXAMPLE
*	...
*	days = JulianYearDays(1994);
*	printf("Days of 1994 : %d\n",days);
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 1581!
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	JulianMonthDays(),GregorianYearDays(),HeisYearDays()
*
*****************************************************************************
*
*
*/

 {
  unsigned short month;
  unsigned int days=0;

  for (month=1;month<=12;month++)
    {/* add the days of all 12 month */
     days += JulianMonthDays(month,year);
    }
  return(days);
 }


 #ifndef __MakeLib
   unsigned int GregorianYearDays(const int year)
 #else
   unsigned int __saveds __asm GregorianYearDays(register __d0 const int year)
 #endif

/*
******* Date/GregorianYearDays **********************************************
*
*   NAME
*	GregorianYearDays -- Gives back the number of days in a year. (V33)
*
*   SYNOPSIS
*	days = GregorianYearDays(year);
*	 d0			  d0
*
*	unsigned int GregorianYearDays(const int year);
*
*   FUNCTION
*	GregorianYearDays gives you back the number of days in
*	a specified year.
*
*   INPUTS
*	year  - The year in which to count the days.
*
*   RESULT
*	days - The number of days the year uses.
*
*   EXAMPLE
*	...
*	days = GregorianYearDays(1994);
*	printf("Days of 1994 : %d\n",days);
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 3199!
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	GregorianMonthDays(),JulianYearDays(),HeisYearDays()
*
*****************************************************************************
*
*
*/

 {
  unsigned short month;
  unsigned int days=0;

  for (month=1;month<=12;month++)
    {/* add the days of all 12 month */
     days += GregorianMonthDays(month,year);
    }
  return(days);
 }


 #ifndef __MakeLib
   unsigned int HeisYearDays(const int year)
 #else
   unsigned int __saveds __asm HeisYearDays(register __d0 const int year)
 #endif

/*
******* Date/HeisYearDays ***************************************************
*
*   NAME
*	HeisYearDays -- Gives back the number of days in a year. (V33)
*
*   SYNOPSIS
*	days = HeisYearDays(year);
*	 d0		     d0
*
*	unsigned int HeisYearDays(const int year);
*
*   FUNCTION
*	HeisYearDays gives you back the number of days in
*	a specified year.
*
*   INPUTS
*	year  - The year in which to count the days.
*
*   RESULT
*	days - The number of days the year uses.
*
*   EXAMPLE
*	...
*	days = HeisYearDays(1994);
*	printf("Days of 1994 : %d\n",days);
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 8000!
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	HeisMonthDays(),JulianYearDays(),GregorianYearDays()
*
*****************************************************************************
*
*
*/

 {unsigned short month;
  unsigned int days=0;

  for (month=1;month<=12;month++)
    {/* add the days of all 12 month */
     days += HeisMonthDays(month,year);
    }
  return(days);
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   short Compare2Dates(const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, const int year2)
 #else
   short __saveds __asm Compare2Dates(register __d0 const unsigned short day1, register __d1 const unsigned short month1, register __d2 const int year1, register __d3 const unsigned short day2, register __d4 const unsigned short month2, register __d5 const int year2)
 #endif

/*
******* Date/Compare2Dates **************************************************
*
*   NAME
*	Compare2Dates -- Compares date1 with date2. (V33.100)
*
*   SYNOPSIS
*	compare = Compare2Dates(day1,month1,year1,day2,month2,year2);
*	  d0			 d0    d1    d2    d3    d4    d5
*
*	short Compare2Dates(const unsigned short day1,
*	    const unsigned short month1, const int year1,
*	    const unsigned short day2, const unsigned short month2,
*	    const int year2);
*
*   FUNCTION
*	Compare2Dates compares date1 with date2.
*
*   INPUTS
*	day1   - day of the first date
*	month1 - month of the first date
*	year1  - year of the first date
*	day2   - day of the second date
*	month2 - month of the second month
*	year2  - year of the second date
*
*   RESULT
*	compare - -1 : date1 < date2
*		   0 : date1 = date2
*		   1 : date1 > date2
*
*   EXAMPLE
*	...
*	if (Compare2Dates(18,9,1970,22,1,1994) == -1)
*	  printf("<\n");
*	else
*	  printf(">=\n");
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 8000!
*	There is no need for different versions for Julian, Gregorian and
*	Heis dates!
*
*   BUGS
*	There is no check if the dates are valid!
*
*   SEE ALSO
*	Compare2Times()
*
*****************************************************************************
*
*
*/

 {
  if (year1 < year2)
    return(-1);
  else if (year1 > year2)
    return(1);
  else if (month1 < month2)
    return(-1);
  else if (month1 > month2)
    return(1);
  else if (day1 < day2)
    return(-1);
  else if (day1 > day2)
    return(1);
  else
    return(0);
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   bool JulianDaySmaller(const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, const int year2)
 #else
   bool __saveds __asm JulianDaySmaller(register __d0 const unsigned short day1, register __d1 const unsigned short month1, register __d2 const int year1, register __d3 const unsigned short day2, register __d4 const unsigned short month2, register __d5 const int year2)
 #endif

/*
*****i* Date/JulianDaySmaller ***********************************************
*
*   NAME
*	JulianDaySmaller -- Checks if date1 is smaller than date2. (V33)
*
*   SYNOPSIS
*	smaller = JulianDaySmaller(day1,month1,year1,day2,month2,year2);
*	  d0			    d0    d1    d2    d3    d4    d5
*
*	bool JulianDaySmaller(const unsigned short day1,
*	    const unsigned short month1, const int year1,
*	    const unsigned short day2, const unsigned short month2,
*	    const int year2);
*
*   FUNCTION
*	JulianDaySmaller test if date1 is smaller than date2.
*
*   INPUTS
*	day1   - day of the first date
*	month1 - month of the first date
*	year1  - year of the first date
*	day2   - day of the second date
*	month2 - month of the second month
*	year2  - year of the second date
*
*   RESULT
*	smaller - This is TRUE is date1 < date2 otherwise it's FALSE.
*
*   EXAMPLE
*	...
*	if (JulianDaySmaller(18,9,1970,22,1,1994))
*	  printf("<\n");
*	else
*	  printf(">=\n");
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 1582!
*	This function is not longer needed - use CompareDates() !
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	GregorianDaySmaller(),HeisDaySmaller(),CompareDates()
*
*****************************************************************************
*
*
*/

 {
  return((bool)(Compare2Dates(day1,month1,year1,day2,month2,year2) == -1));
 }


 #ifndef __MakeLib
   bool GregorianDaySmaller(const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, const int year2)
 #else
   bool __saveds __asm GregorianDaySmaller(register __d0 const unsigned short day1, register __d1 const unsigned short month1, register __d2 const int year1, register __d3 const unsigned short day2, register __d4 const unsigned short month2, register __d5 const int year2)
 #endif

/*
*****i* Date/GregorianDaySmaller ********************************************
*
*   NAME
*	GregorianDaySmaller -- Checks if date1 is smaller than date2. (V33)
*
*   SYNOPSIS
*	smaller = GregorianDaySmaller(day1,month1,year1,day2,month2,year2);
*	  d0			       d0    d1    d2    d3    d4    d5
*
*	bool GregorianDaySmaller(const unsigned short day1,
*	    const unsigned short month1, const int year1,
*	    const unsigned short day2, const unsigned short month2,
*	    const int year2);
*
*   FUNCTION
*	GregorianDaySmaller test if date1 is smaller than date2.
*
*   INPUTS
*	day1   - day of the first date
*	month1 - month of the first date
*	year1  - year of the first date
*	day2   - day of the second date
*	month2 - month of the second month
*	year2  - year of the second date
*
*   RESULT
*	smaller - This is TRUE is date1 < date2 otherwise it's FALSE.
*
*   EXAMPLE
*	...
*	if (GregorianDaySmaller(18,9,1970,22,1,1994))
*	  printf("<\n");
*	else
*	  printf(">=\n");
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 3200!
*	This function is not longer needed - use CompareDates() !
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	JulianDaySmaller(),HeisDaySmaller(),CompareDates()
*
*****************************************************************************
*
*
*/

 {
  return((bool)(Compare2Dates(day1,month1,year1,day2,month2,year2) == -1));
 }


 #ifndef __MakeLib
   bool HeisDaySmaller(const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, const int year2)
 #else
   bool __saveds __asm HeisDaySmaller(register __d0 const unsigned short day1, register __d1 const unsigned short month1, register __d2 const int year1, register __d3 const unsigned short day2, register __d4 const unsigned short month2, register __d5 const int year2)
 #endif

/*
*****i* Date/HeisDaySmaller *************************************************
*
*   NAME
*	HeisDaySmaller -- Checks if date1 is smaller than date2. (V33)
*
*   SYNOPSIS
*	smaller = HeisDaySmaller(day1,month1,year1,day2,month2,year2);
*	  d0			  d0    d1    d2    d3    d4    d5
*
*	bool HeisDaySmaller(const unsigned short day1,
*	    const unsigned short month1, const int year1,
*	    const unsigned short day2, const unsigned short month2,
*	    const int year2);
*
*   FUNCTION
*	HeisDaySmaller test if date1 is smaller than date2.
*
*   INPUTS
*	day1   - day of the first date
*	month1 - month of the first date
*	year1  - year of the first date
*	day2   - day of the second date
*	month2 - month of the second month
*	year2  - year of the second date
*
*   RESULT
*	smaller - This is TRUE is date1 < date2 otherwise it's FALSE.
*
*   EXAMPLE
*	...
*	if (HeisDaySmaller(18,9,1970,22,1,1994))
*	  printf("<\n");
*	else
*	  printf(">=\n");
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 8000!
*	This function is not longer needed - use CompareDates() !
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	JulianDaySmaller(),GregorianDaySmaller(),CompareDates()
*
*****************************************************************************
*
*
*/

 {
  return((bool)(Compare2Dates(day1,month1,year1,day2,month2,year2) == -1));
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   bool JulianDayGreater(const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, const int year2)
 #else
   bool __saveds __asm JulianDayGreater(register __d0 const unsigned short day1, register __d1 const unsigned short month1, register __d2 const int year1, register __d3 const unsigned short day2, register __d4 const unsigned short month2, register __d5 const int year2)
 #endif

/*
*****i* Date/JulianDayGreater ***********************************************
*
*   NAME
*	JulianDayGreater -- Checks if date1 is greater than date2. (V33)
*
*   SYNOPSIS
*	greater = JulianDayGreater(day1,month1,year1,day2,month2,year2);
*	  d0			    d0    d1    d2    d3    d4    d5
*
*	bool JulianDayGreater(const unsigned short day1,
*	    const unsigned short month1, const int year1,
*	    const unsigned short day2, const unsigned short month2,
*	    const int year2);
*
*   FUNCTION
*	JulianDayGreater test if date1 is greater than date2.
*
*   INPUTS
*	day1   - day of the first date
*	month1 - month of the first date
*	year1  - year of the first date
*	day2   - day of the second date
*	month2 - month of the second month
*	year2  - year of the second date
*
*   RESULT
*	greater - This is TRUE is date1 > date2 otherwise it's FALSE.
*
*   EXAMPLE
*	...
*	if (JulianDayGreater(18,9,1970,22,1,1994))
*	  printf(">\n");
*	else
*	  printf("<=\n");
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 1582!
*	This function is not longer needed - use CompareDates() !
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	GregorianDayGreater(),HeisDayGreater(),CompareDates()
*
*****************************************************************************
*
*
*/

 {
  return((bool)(Compare2Dates(day1,month1,year1,day2,month2,year2) == 1));
 }


 #ifndef __MakeLib
   bool GregorianDayGreater(const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, const int year2)
 #else
   bool __saveds __asm GregorianDayGreater(register __d0 const unsigned short day1, register __d1 const unsigned short month1, register __d2 const int year1, register __d3 const unsigned short day2, register __d4 const unsigned short month2, register __d5 const int year2)
 #endif

/*
*****i* Date/GregorianDayGreater ********************************************
*
*   NAME
*	GregorianDayGreater -- Checks if date1 is greater than date2. (V33)
*
*   SYNOPSIS
*	greater = GregorianDayGreater(day1,month1,year1,day2,month2,year2);
*	  d0			       d0    d1    d2    d3    d4    d5
*
*	bool GregorianDayGreater(const unsigned short day1,
*	    const unsigned short month1, const int year1,
*	    const unsigned short day2, const unsigned short month2,
*	    const int year2);
*
*   FUNCTION
*	GregorianDayGreater test if date1 is greater than date2.
*
*   INPUTS
*	day1   - day of the first date
*	month1 - month of the first date
*	year1  - year of the first date
*	day2   - day of the second date
*	month2 - month of the second month
*	year2  - year of the second date
*
*   RESULT
*	greater - This is TRUE is date1 > date2 otherwise it's FALSE.
*
*   EXAMPLE
*	...
*	if (GregorianDayGreater(18,9,1970,22,1,1994))
*	  printf("<\n");
*	else
*	  printf(">=\n");
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 3200!
*	This function is not longer needed - use CompareDates() !
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	JulianDayGreater(),HeisDayGreater(),CompareDates()
*
*****************************************************************************
*
*
*/

 {
  return((bool)(Compare2Dates(day1,month1,year1,day2,month2,year2) == 1));
 }


 #ifndef __MakeLib
   bool HeisDayGreater(const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, const int year2)
 #else
   bool __saveds __asm HeisDayGreater(register __d0 const unsigned short day1, register __d1 const unsigned short month1, register __d2 const int year1, register __d3 const unsigned short day2, register __d4 const unsigned short month2, register __d5 const int year2)
 #endif

/*
*****i* Date/HeisDayGreater *************************************************
*
*   NAME
*	HeisDayGreater -- Checks if date1 is greater than date2. (V33)
*
*   SYNOPSIS
*	greater = HeisDayGreater(day1,month1,year1,day2,month2,year2);
*	  d0			  d0    d1    d2    d3    d4    d5
*
*	bool HeisDayGreater(const unsigned short day1,
*	    const unsigned short month1, const int year1,
*	    const unsigned short day2, const unsigned short month2,
*	    const int year2);
*
*   FUNCTION
*	HeisDayGreater test if date1 is greater than date2.
*
*   INPUTS
*	day1   - day of the first date
*	month1 - month of the first date
*	year1  - year of the first date
*	day2   - day of the second date
*	month2 - month of the second month
*	year2  - year of the second date
*
*   RESULT
*	greater - This is TRUE is date1 > date2 otherwise it's FALSE.
*
*   EXAMPLE
*	...
*	if (HeisDayGreater(18,9,1970,22,1,1994))
*	  printf(">\n");
*	else
*	  printf("<=\n");
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 8000!
*	This function is not longer needed - use CompareDates() !
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	JulianDayGreater(),GregorianDayGreater(),CompareDates()
*
*****************************************************************************
*
*
*/

 {
  return((bool)(Compare2Dates(day1,month1,year1,day2,month2,year2) == 1));
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   long JulianDayDiff(const unsigned short day1, unsigned short month1, int year1, const unsigned short day2, unsigned short month2, int year2)
 #else
   long __saveds __asm JulianDayDiff(register __d0 const unsigned short day1, register __d1 unsigned short month1, register __d2 int year1, register __d3 const unsigned short day2, register __d4 unsigned short month2, register __d5 int year2)
 #endif

/*
******* Date/JulianDayDiff **************************************************
*
*   NAME
*	JulianDayDiff -- Calculates the days between 2 dates. (V33)
*
*   SYNOPSIS
*	days = JulianDayDiff(day1,month1,year1,day2,month2,year2);
*	 d0		      d0    d1    d2    d3    d4    d5
*
*	long JulianDayDiff(const unsigned short day1, unsigned short month1,
*	    int year1, const unsigned short day2, unsigned short month2,
*	    int year2);
*
*   FUNCTION
*	JulianDayDiff gives you back the number of days between
*	two specified dates.
*
*   INPUTS
*	day1   - day of the first date
*	month1 - month of the first date
*	year1  - year of the first date
*	day2   - day of the second date
*	month2 - month of the second month
*	year2  - year of the second date
*
*   RESULT
*	days - The number of days between the two dates
*	    (positive if date1 <= date2).
*
*   EXAMPLE
*	...
*	days = JulianDayDiff(18,9,1970,22,1,1994);
*	printf("Age of Kai Hofmann in days : %d\n",days);
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 1582!
*
*   BUGS
*	No known bugs.
*
*   SEE ALSO
*	JulianLeapYear(),JulianMonthDays(),JulianYearDays(),
*	GregorianDayDiff(),HeisDayDiff()
*
*****************************************************************************
*
*
*/

 {
  unsigned long t1=day1,t2=day2; /* set days left in the actual month */

  while (month1 > 1)
    {/* calc days left by the gone month of the year1 */
     month1--;
     t1 += JulianMonthDays(month1,year1);
    }
  while (month2 > 1)
    {/* calc days left by the gone month of the year2 */
     month2--;
     t2 += JulianMonthDays(month2,year2);
    }
  while (year1 > year2)
    {/* calc days of diff years */
     year1--;
     t1 += JulianYearDays(year1);
    }
  while (year1 < year2)
    {/* calc days of diff years */
     year2--;
     t2 += JulianYearDays(year2);
    }
  return((long)t2-(long)t1);
 }


 #ifndef __MakeLib
   long GregorianDayDiff(const unsigned short day1, unsigned short month1, int year1, const unsigned short day2, unsigned short month2, int year2)
 #else
   long __saveds __asm GregorianDayDiff(register __d0 const unsigned short day1, register __d1 unsigned short month1, register __d2 int year1, register __d3 const unsigned short day2, register __d4 unsigned short month2, register __d5 int year2)
 #endif

/*
******* Date/GregorianDayDiff ***********************************************
*
*   NAME
*	GregorianDayDiff -- Calculates the days between 2 dates. (V33)
*
*   SYNOPSIS
*	days = GregorianDayDiff(day1,month1,year1,day2,month2,year2);
*	 d0		         d0    d1    d2    d3    d4    d5
*
*	long GregorianDayDiff(const unsigned short day1,
*	    unsigned short month1, int year1, const unsigned short day2,
*	    unsigned short month2, int year2);
*
*   FUNCTION
*	GregorianDayDiff gives you back the number of days between
*	two specified dates.
*
*   INPUTS
*	day1   - day of the first date
*	month1 - month of the first date
*	year1  - year of the first date
*	day2   - day of the second date
*	month2 - month of the second month
*	year2  - year of the second date
*
*   RESULT
*	days - The number of days between the two dates
*	    (positive if date1 <= date2).
*
*   EXAMPLE
*	...
*	days = GregorianDayDiff(18,9,1970,22,1,1994);
*	printf("Age of Kai Hofmann in days : %d\n",days);
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 02.3200!
*
*   BUGS
*	If you use one of the dates 5.10.1582 to 14.10.1582 you will get an
*	incorrect output because these days don't exist!
*
*   SEE ALSO
*	GregorianLeapYear(),GregorianMonthDays(),GregorianYearDays(),
*	JulianDayDiff(),HeisDayDiff()
*
*****************************************************************************
*
*
*/

 {
  long t1=day1,t2=day2; /* set days left in the actual month */

  if ((year1 == BeforeGregorianYear) && (month1 == BeforeGregorianMonth))
   {
    if ((day1 <= BeforeGregorianDay) && GregorianDaySmaller(day1,month1,year1,day2,month2,year2) && GregorianDaySmaller(day2,month2,year2,1,AfterGregorianMonth+1,AfterGregorianYear) && GregorianDayGreater(day2,month2,year2,AfterGregorianDay-1,AfterGregorianMonth,AfterGregorianYear))
      t2 -= 10;
    if (day1 >= AfterGregorianDay)
     {
      if (GregorianDaySmaller(day1,month1,year1,day2,month2,year2) && GregorianDayGreater(day2,month2,year2,31,AfterGregorianMonth,AfterGregorianYear))
        t2 += 10;
      if (GregorianDayGreater(day1,month1,year1,day2,month2,year2) && GregorianDaySmaller(day2,month2,year2,BeforeGregorianDay+1,BeforeGregorianMonth,BeforeGregorianYear))
        t1 -= 10;
     }
   }
  if ((year2 == AfterGregorianYear) && (month2 == AfterGregorianMonth) && (day2 >= AfterGregorianDay))
   {
    if (GregorianDaySmaller(day2,month2,year2,day1,month1,year1) && GregorianDayGreater(day1,month1,year1,31,AfterGregorianMonth,AfterGregorianYear))
      t1 += 10;
    if (GregorianDayGreater(day2,month2,year2,day1,month1,year1) && GregorianDaySmaller(day1,month1,year1,1,BeforeGregorianMonth,BeforeGregorianYear))
      t2 -= 10;
   }
  while (month1 > 1)
    {/* calc days left by the gone month of the year1 */
     month1--;
     t1 += GregorianMonthDays(month1,year1);
    }
  while (month2 > 1)
    {/* calc days left by the gone month of the year2 */
     month2--;
     t2 += GregorianMonthDays(month2,year2);
    }
  while (year1 > year2)
    {/* calc days of diff years */
     year1--;
     t1 += GregorianYearDays(year1);
    }
  while (year1 < year2)
    {/* calc days of diff years */
     year2--;
     t2 += GregorianYearDays(year2);
    }
  return(t2-t1);
 }


 #ifndef __MakeLib
   long HeisDayDiff(const unsigned short day1, unsigned short month1, int year1, const unsigned short day2, unsigned short month2, int year2)
 #else
   long __saveds __asm HeisDayDiff(register __d0 const unsigned short day1, register __d1 unsigned short month1, register __d2 int year1, register __d3 const unsigned short day2, register __d4 unsigned short month2, register __d5 int year2)
 #endif

/*
******* Date/HeisDayDiff ****************************************************
*
*   NAME
*	HeisDayDiff -- Calculates the days between 2 dates. (V33)
*
*   SYNOPSIS
*	days = HeisDayDiff(day1,month1,year1,day2,month2,year2);
*	 d0		    d0    d1    d2    d3    d4    d5
*
*	long HeisDayDiff(const unsigned short day1, unsigned short month1,
*	    int year1, const unsigned short day2, unsigned short month2,
*	    int year2);
*
*   FUNCTION
*	HeisDayDiff gives you back the number of days between
*	two specified dates.
*
*   INPUTS
*	day1   - day of the first date
*	month1 - month of the first date
*	year1  - year of the first date
*	day2   - day of the second date
*	month2 - month of the second month
*	year2  - year of the second date
*
*   RESULT
*	days - The number of days between the two dates
*	    (positive if date1 <= date2).
*
*   EXAMPLE
*	...
*	days = HeisDayDiff(18,9,1970,22,1,1994);
*	printf("Age of Kai Hofmann in days : %d\n",days);
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 8000!
*
*   BUGS
*	If you use on of the dates 5.10.1582 to 14.10.1582 you will get an
*	incorrect output because these days don't exist!
*
*   SEE ALSO
*	HeisLeapYear(),HeisMonthDays(),HeisYearDays(),
*	JulianDayDiff(),GregorianDayDiff()
*
*****************************************************************************
*
*
*/

 {
  long t1=day1,t2=day2; /* set days left in the actual month */

  if ((year1 == BeforeGregorianYear) && (month1 == BeforeGregorianMonth))
   {
    if ((day1 <= BeforeGregorianDay) && HeisDaySmaller(day1,month1,year1,day2,month2,year2) && HeisDaySmaller(day2,month2,year2,1,AfterGregorianMonth+1,AfterGregorianYear) && HeisDayGreater(day2,month2,year2,AfterGregorianDay-1,AfterGregorianMonth,AfterGregorianYear))
      t2 -= 10;
    if (day1 >= AfterGregorianDay)
     {
      if (HeisDaySmaller(day1,month1,year1,day2,month2,year2) && HeisDayGreater(day2,month2,year2,31,AfterGregorianMonth,AfterGregorianYear))
        t2 += 10;
      if (HeisDayGreater(day1,month1,year1,day2,month2,year2) && HeisDaySmaller(day2,month2,year2,BeforeGregorianDay+1,BeforeGregorianMonth,BeforeGregorianYear))
        t1 -= 10;
     }
   }
  if ((year2 == AfterGregorianYear) && (month2 == AfterGregorianMonth) && (day2 >= AfterGregorianDay))
   {
    if (HeisDaySmaller(day2,month2,year2,day1,month1,year1) && HeisDayGreater(day1,month1,year1,31,AfterGregorianMonth,AfterGregorianYear))
      t1 += 10;
    if (HeisDayGreater(day2,month2,year2,day1,month1,year1) && HeisDaySmaller(day1,month1,year1,1,BeforeGregorianMonth,BeforeGregorianYear))
      t2 -= 10;
   }
  while (month1 > 1)
    {/* calc days left by the gone month of the year1 */
     month1--;
     t1 += HeisMonthDays(month1,year1);
    }
  while (month2 > 1)
    {/* calc days left by the gone month of the year2 */
     month2--;
     t2 += HeisMonthDays(month2,year2);
    }
  while (year1 > year2)
    {/* calc days of diff years */
     year1--;
     t1 += HeisYearDays(year1);
    }
  while (year1 < year2)
    {/* calc days of diff years */
     year2--;
     t2 += HeisYearDays(year2);
    }
  return(t2-t1);
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   Weekdays JulianWeekday(const unsigned short day, unsigned short month, int year)
 #else
   Weekdays __saveds __asm JulianWeekday(register __d0 const unsigned short day, register __d1 unsigned short month, register __d2 int year)
 #endif

/*
******* Date/JulianWeekday **************************************************
*
*   NAME
*	JulianWeekday -- Gets the weekday of a specified date. (V33)
*
*   SYNOPSIS
*	weekday = JulianWeekday(day,month,year);
*	  d0			 d0   d1   d2
*
*	Weekdays JulianWeekday(const unsigned short day,
*	    unsigned short month, int year);
*
*   FUNCTION
*	JulianWeekday gets the weekday for a specified date.
*
*   INPUTS
*	day   - day of the date
*	month - month of the date
*	year  - year of the date
*
*   RESULT
*	weekday - This result is of type:
*	    Weekdays = (dayerr,Monday,Tuesday,Wednesday,Thursday,Friday,
*	    Saturday,Sunday);
*	    dayerr will show you, that an error occurs!
*
*   EXAMPLE
*	...
*	weekday = JulianWeekday(4,10,1582);
*	if (weekday == dayerr)
*	  {
*	   ...
*	  }
*	...
*
*   NOTES
*	It is better only to use this function for years from 1 to 02.1582!
*	In this version no dayerr will occur!
*
*   BUGS
*	For years <= 0 errors could occur, or systemcrashs(?).
*
*   SEE ALSO
*	GregorianWeekday(),HeisWeekday()
*
*****************************************************************************
*
*
*/

 {
  unsigned short decade,wday;

  /* January and february dates must be 13 and 14 of the year before! */
  switch (month)
    {
     case 1 :
     case 2 : month += 12;
              year--;
    }
  decade = (unsigned short)(year - ((year / 100) * 100));
  /* Formula from Ch. Zeller in 1877 */
  wday = (unsigned short)((day + (((month+1) * 26) / 10) + decade +
			(decade / 4) + 5 - (unsigned short)(year / 100)) % 7);
  /* Convert (1-su 2-mo 3-tu 4-we 5-th 6-fr 7/0-sa) to normal days */
  if (wday == 0)
    wday = 6;
  else
    {
     wday--;
     if (wday == 0)
       wday = 7;
    }
  return((Weekdays)wday);
 }


 #ifndef __MakeLib
   Weekdays GregorianWeekday(const unsigned short day, unsigned short month, int year)
 #else
   Weekdays __saveds __asm GregorianWeekday(register __d0 const unsigned short day, register __d1 unsigned short month, register __d2 int year)
 #endif

/*
******* Date/GregorianWeekday ***********************************************
*
*   NAME
*	GregorianWeekday -- Gets the weekday of a specified date. (V33)
*
*   SYNOPSIS
*	weekday = GregorianWeekday(day,month,year);
*	  d0			    d0   d1   d2
*
*	Weekdays GregorianWeekday(const unsigned short day,
*	    unsigned short month, int year);
*
*   FUNCTION
*	GregorianWeekday gets the weekday for a specified date.
*
*   INPUTS
*	day   - day of the date
*	month - month of the date
*	year  - year of the date
*
*   RESULT
*	weekday - This result is of type:
*	    Weekdays = (dayerr,Monday,Tuesday,Wednesday,Thursday,Friday,
*	    Saturday,Sunday);
*	    dayerr will show you, that an error occurs!
*
*   EXAMPLE
*	...
*	weekday = GregorianWeekday(22,1,1994);
*	if (weekday == dayerr)
*	  {
*	   ...
*	  }
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 3200!
*	In this version dayerr will only occur for the lost days :)
*
*   BUGS
*	It's not possible to use years < 0 (for more see JulianWeekday()).
*
*   SEE ALSO
*	JulianWeekday(),HeisWeekday()
*
*****************************************************************************
*
*
*/

 {
  Weekdays weekday;
  unsigned int wd;

  if (GregorianDaySmaller(day,month,year,BeforeGregorianDay+1,BeforeGregorianMonth,BeforeGregorianYear))
    return(JulianWeekday(day,month,year));
  else
    {
     if (GregorianDaySmaller(day,month,year,AfterGregorianDay,AfterGregorianMonth,AfterGregorianYear))
       return(dayerr);
     else
      {
       if (year == AfterGregorianYear)
         return((Weekdays)((unsigned short)((GregorianDayDiff(AfterGregorianDay,AfterGregorianMonth,AfterGregorianYear,day,month,year)+4)%7)+1));
       else
        {/* Formula from J. I. Perelman 1909 */
         wd = year + (year / 4) - (year / 100) + (year / 400)
				+ (int)GregorianDayDiff(1,1,year,day,month,year);
         if (GregorianLeapYear(year))
           wd--;
         weekday = (Weekdays)(wd % 7);
         if (weekday == dayerr)
           weekday = Sunday;
         return(weekday);
        }
      }
    }
 }


 #ifndef __MakeLib
   Weekdays HeisWeekday(const unsigned short day, unsigned short month, int year)
 #else
   Weekdays __saveds __asm HeisWeekday(register __d0 const unsigned short day, register __d1 unsigned short month, register __d2 int year)
 #endif

/*
******* Date/HeisWeekday ****************************************************
*
*   NAME
*	HeisWeekday -- Gets the weekday of a specified date. (V33)
*
*   SYNOPSIS
*	weekday = HeisWeekday(day,month,year);
*	  d0		       d0   d1   d2
*
*	Weekdays HeisWeekday(const unsigned short day, unsigned short month,
*	    int year);
*
*   FUNCTION
*	HeisWeekday gets the weekday for a specified date.
*
*   INPUTS
*	day   - day of the date
*	month - month of the date
*	year  - year of the date
*
*   RESULT
*	weekday - This result is of type:
*	    Weekdays = (dayerr,Monday,Tuesday,Wednesday,Thursday,Friday,
*	    Saturday,Sunday);
*	    dayerr will show you, that an error occurs!
*
*   EXAMPLE
*	...
*	weekday = HeisWeekday(22,1,1994);
*	if (weekday == dayerr)
*	  {
*	   ...
*	  }
*	...
*
*   NOTES
*	It is better only to use this function for years from 8 to 8000!
*	In this version dayerr will only occur for the lost days :)
*
*   BUGS
*	It is not possible to use year < 0 (see JulianWeekday() for more).
*
*   SEE ALSO
*	JulianWeekday(),GregorianWeekday()
*
*****************************************************************************
*
*
*/

 {
  Weekdays weekday;
  unsigned int wd;

  if (HeisDaySmaller(day,month,year,StartHeisDay,StartHeisMonth,StartHeisYear))
    return(GregorianWeekday(day,month,year));
  else
    {/* Formula from J. I. Perelman 1909 - extended for N.Heis in 01.1994
	by Kai Hofmann */
     wd = year + (year / 4) - (year / 100) + (year / 400)
		- (year / 3200) + (int)HeisDayDiff(1,1,year,day,month,year);
     if (HeisLeapYear(year))
       wd--;
     weekday = (Weekdays)(wd % 7);
     if (weekday == dayerr)
       weekday = Sunday;
     return(weekday);
    }
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   unsigned short JulianDaysBeforeWeekday(const unsigned short day, const unsigned short month, const int year, const Weekdays weekday)
 #else
   unsigned short __saveds __asm JulianDaysBeforeWeekday(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year, register __d3 const Weekdays weekday)
 #endif

/*
******* Date/JulianDaysBeforeWeekday ****************************************
*
*   NAME
*	JulianDaysBeforeWeekday -- Returns the diff to the wday before. (V33)
*
*   SYNOPSIS
*	days = JulianDaysBeforeWeekday(day,month,year,weekday);
*	 d0				d0  d1    d2    d3
*
*	unsigned short JulianDaysBeforeWeekday(const unsigned short day,
*	    const unsigned short month, const int year,
*	    const Weekdays weekday);
*
*   FUNCTION
*	Returns the days to the weekday before the specified date.
*	If you specify the 22.1.1994 (Saturday) and Thursday
*	you get back 2!
*	If you specify the 22.1.1994 and Saturday you get back 0
*	(the same day)!
*
*   INPUTS
*	day     - day of the date
*	month   - month of the date
*	year    - year of the date
*	weekday - weekday to search for building difference
*
*   RESULT
*	days - The days gets you back to the searched weekday (0-6)
*	    If you get back an 8 an error occurs!
*
*   EXAMPLE
*	...
*	days = JulianDaysBeforeWeekday(22,1,1994,Thursday);
*	...
*
*   NOTES
*	It is better to use this function only from 8 to 02.1582!
*
*   BUGS
*	See JulianWeekday()!
*
*   SEE ALSO
*	JulianWeekday(),GregorianDaysBeforeWeekday(),HeisDaysBeforeWeekday()
*
*****************************************************************************
*
*
*/

 {
  Weekdays wday;

  if (weekday == dayerr)
    return(8);
  else
    {
     wday = JulianWeekday(day,month,year);
     if (wday >= weekday)
       return((unsigned short)(wday-weekday));
     else
       {/* wday < weekday */
        return((unsigned short)(7-weekday+wday));
       }
    }
 }


 #ifndef __MakeLib
   unsigned short GregorianDaysBeforeWeekday(const unsigned short day, const unsigned short month, const int year, const Weekdays weekday)
 #else
   unsigned short __saveds __asm GregorianDaysBeforeWeekday(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year, register __d3 const Weekdays weekday)
 #endif

/*
******* Date/GregorianDaysBeforeWeekday *************************************
*
*   NAME
*	GregorianDaysBeforeWeekday -- Returns the diff to wday before. (V33)
*
*   SYNOPSIS
*	days = GregorianDaysBeforeWeekday(day,month,year,weekday);
*	 d0				   d0  d1    d2    d3
*
*	unsigned short GregorianDaysBeforeWeekday(const unsigned short day,
*	    const unsigned short month, const int year,
*	    const Weekdays weekday);
*
*   FUNCTION
*	Returns the days to the weekday before the specified date.
*	If you specify the 22.1.1994 (Saturday) and Thursday
*	you get back 2!
*	If you specify the 22.1.1994 and Saturday you get back 0
*	(the same day)!
*
*   INPUTS
*	day     - day of the date
*	month   - month of the date
*	year    - year of the date
*	weekday - weekday to search for building difference
*
*   RESULT
*	days - The days gets you back to the searched weekday (1-7)
*	    If you get back an 8 an error occurs!
*
*   EXAMPLE
*	...
*	days = GregorianDaysBeforeWeekday(22,1,1994,Thursday);
*	...
*
*   NOTES
*	It is better to use this function only from 8 to 3200!
*
*   BUGS
*	See GregorianWeekday()!
*
*   SEE ALSO
*	GregorianWeekday(),JulianDaysBeforeWeekday(),HeisDaysBeforeWeekday()
*
*****************************************************************************
*
*
*/

 {
  Weekdays wday;

  if (weekday == dayerr)
    return(8);
  else
    {
     wday = GregorianWeekday(day,month,year);
     if (wday >= weekday)
       return((unsigned short)(wday-weekday));
     else
       {/* wday < weekday */
        return((unsigned short)(7-weekday+wday));
       }
    }
 }


 #ifndef __MakeLib
   unsigned short HeisDaysBeforeWeekday(const unsigned short day, const unsigned short month, const int year, const Weekdays weekday)
 #else
   unsigned short __saveds __asm HeisDaysBeforeWeekday(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year, register __d3 const Weekdays weekday)
 #endif

/*
******* Date/HeisDaysBeforeWeekday ******************************************
*
*   NAME
*	HeisDaysBeforeWeekday -- Returns the diff to wday before. (V33)
*
*   SYNOPSIS
*	days = HeisDaysBeforeWeekday(day,month,year,weekday);
*	 d0			      d0  d1    d2    d3
*
*	unsigned short HeisDaysBeforeWeekday(const unsigned short day,
*	    const unsigned short month, const int year,
*	    const Weekdays weekday);
*
*   FUNCTION
*	Returns the days to the weekday before the specified date.
*	If you specify the 22.1.1994 (Saturday) and Thursday
*	you get back 2!
*	If you specify the 22.1.1994 and Saturday you get back 0
*	(the same day)!
*
*   INPUTS
*	day     - day of the date
*	month   - month of the date
*	year    - year of the date
*	weekday - weekday to search for building difference
*
*   RESULT
*	days - The days gets you back to the searched weekday (1-7)
*	    If you get back an 8 an error occurs!
*
*   EXAMPLE
*	...
*	days = HeisDaysBeforeWeekday(22,1,1994,Thursday);
*	...
*
*   NOTES
*	It is better to use this function only from 8 to 8000!
*
*   BUGS
*	See HeisWeekday()!
*
*   SEE ALSO
*	HeisWeekday(),JulianDaysBeforeWeekday(),GregorianDaysBeforeWeekday()
*
*****************************************************************************
*
*
*/

 {
  Weekdays wday;

  if (weekday == dayerr)
    return(8);
  else
    {
     wday = HeisWeekday(day,month,year);
     if (wday >= weekday)
       return((unsigned short)(wday-weekday));
     else
       {/* wday < weekday */
        return((unsigned short)(7-weekday+wday));
       }
    }
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   unsigned short JulianDaysAfterWeekday(const unsigned short day, const unsigned short month, const int year, const Weekdays weekday)
 #else
   unsigned short __saveds __asm JulianDaysAfterWeekday(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year, register __d3 const Weekdays weekday)
 #endif

/*
******* Date/JulianDaysAfterWeekday *****************************************
*
*   NAME
*	JulianDaysAfterWeekday -- Returns the diff to the wday after. (V33)
*
*   SYNOPSIS
*	days = JulianDaysAfterWeekday(day,month,year,weekday);
*	 d0			       d0   d1   d2     d3
*
*	unsigned short JulianDaysAfterWeekday(const unsigned short day,
*	    const unsigned short month, const int year,
*	    const Weekdays weekday);
*
*   FUNCTION
*	Returns the days to the weekday after the specified date.
*	If you specify the 22.1.1994 (Saturday) and Thursday
*	you get back 5!
*	If you specify the 22.1.1994 and Saturday you get back 0
*	(the same day)!
*
*   INPUTS
*	day     - day of the date
*	month   - month of the date
*	year    - year of the date
*	weekday - weekday to search for building difference
*
*   RESULT
*	days - The days after to the searched weekday.
*
*   EXAMPLE
*	...
*	days = JulianDaysAfterWeekday(22,1,1994,Thursday);
*	...
*
*   NOTES
*	It is better to use this function only from 8 to 1582!
*
*   BUGS
*	See JulianWeekday()!
*
*   SEE ALSO
*	JulianWeekday(),GregorianDaysAfterWeekday(),HeisDaysAfterWeekday()
*
*****************************************************************************
*
*
*/

 {
  Weekdays wday;

  if (weekday == dayerr)
    return(8);
  else
    {
     wday = JulianWeekday(day,month,year);
     if (wday <= weekday)
       return((unsigned short)(weekday-wday));
     else
       {/* wday > weekday */
        return((unsigned short)(7-wday+weekday));
       }
    }
 }


 #ifndef __MakeLib
   unsigned short GregorianDaysAfterWeekday(const unsigned short day, const unsigned short month, const int year, const Weekdays weekday)
 #else
   unsigned short __saveds __asm GregorianDaysAfterWeekday(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year, register __d3 const Weekdays weekday)
 #endif

/*
******* Date/GregorianDaysAfterWeekday **************************************
*
*   NAME
*	GregorianDaysAfterWeekday -- Returns the diff to wday after. (V33)
*
*   SYNOPSIS
*	days = GregorianDaysAfterWeekday(day,month,year,weekday);
*	 d0			          d0   d1   d2     d3
*
*	unsigned short GregorianDaysAfterWeekday(const unsigned short day,
*	    const unsigned short month, const int year,
*	    const Weekdays weekday);
*
*   FUNCTION
*	Returns the days to the weekday after the specified date.
*	If you specify the 22.1.1994 (Saturday) and Thursday
*	you get back 5!
*	If you specify the 22.1.1994 and Saturday you get back 0
*	(the same day)!
*
*   INPUTS
*	day     - day of the date
*	month   - month of the date
*	year    - year of the date
*	weekday - weekday to search for building difference
*
*   RESULT
*	days - The days after to the searched weekday.
*
*   EXAMPLE
*	...
*	days = GregorianDaysAfterWeekday(22,1,1994,Thursday);
*	...
*
*   NOTES
*	It is better to use this function only from 8 to 3200!
*
*   BUGS
*	See GregorianWeekday()!
*
*   SEE ALSO
*	GregorianWeekday(),JulianDaysAfterWeekday(),HeisDaysAfterWeekday()
*
*****************************************************************************
*
*
*/

 {
  Weekdays wday;

  if (weekday == dayerr)
    return(8);
  else
    {
     wday = GregorianWeekday(day,month,year);
     if (wday <= weekday)
       return((unsigned short)(weekday-wday));
     else
       {/* wday > weekday */
        return((unsigned short)(7-wday+weekday));
       }
    }
 }


 #ifndef __MakeLib
   unsigned short HeisDaysAfterWeekday(const unsigned short day, const unsigned short month, const int year, const Weekdays weekday)
 #else
   unsigned short __saveds __asm HeisDaysAfterWeekday(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year, register __d3 const Weekdays weekday)
 #endif

/*
******* Date/HeisDaysAfterWeekday *******************************************
*
*   NAME
*	HeisDaysAfterWeekday -- Returns the diff to the wday after. (V33)
*
*   SYNOPSIS
*	days = HeisDaysAfterWeekday(day,month,year,weekday);
*	 d0			     d0   d1   d2     d3
*
*	unsigned short HeisDaysAfterWeekday(const unsigned short day,
*	    const unsigned short month, const int year,
*	    const Weekdays weekday);
*
*   FUNCTION
*	Returns the days to the weekday after the specified date.
*	If you specify the 22.1.1994 (Saturday) and Thursday
*	you get back 5!
*	If you specify the 22.1.1994 and Saturday you get back 0
*	(the same day)!
*
*   INPUTS
*	day     - day of the date
*	month   - month of the date
*	year    - year of the date
*	weekday - weekday to search for building difference
*
*   RESULT
*	days - The days after to the searched weekday.
*
*   EXAMPLE
*	...
*	days = HeisDaysAfterWeekday(22,1,1994,Thursday);
*	...
*
*   NOTES
*	It is better to use this function only from 8 to 8000!
*
*   BUGS
*	See HeisWeekday()!
*
*   SEE ALSO
*	HeisWeekday(),JulianDaysAfterWeekday(),GregorianDaysAfterWeekday()
*
*****************************************************************************
*
*
*/

 {
  Weekdays wday;

  if (weekday == dayerr)
    return(8);
  else
    {
     wday = HeisWeekday(day,month,year);
     if (wday <= weekday)
       return((unsigned short)(weekday-wday));
     else
       {/* wday > weekday */
        return((unsigned short)(7-wday+weekday));
       }
    }
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   #ifndef __cplusplus
     void JulianDiffDate(const unsigned short day, const unsigned short month, const int year, int days, unsigned short *const dday, unsigned short *const dmonth, int *const dyear)
   #else
     void JulianDiffDate(const unsigned short day, const unsigned short month, const int year, int days, unsigned short &dday, unsigned short &dmonth, int &dyear)
   #endif
 #else
   void __saveds __asm JulianDiffDate(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year, register __d3 int days, register __a0 unsigned short *const dday, register __a1 unsigned short *const dmonth, register __a2 int *const dyear)
 #endif

/*
******* Date/JulianDiffDate *************************************************
*
*   NAME
*	JulianDiffDate -- Returns the date for a diff to another date. (V33)
*
*   SYNOPSIS
*	JulianDiffDate(day,month,year,diffdays,dday,dmonth,dyear);
*			d0   d1   d2     d3     a0    a1    a2
*
*	void JulianDiffDate(const unsigned short day,
*	    const unsigned short month, const int year, int days,
*	    unsigned short *const dday, unsigned short *const dmonth,
*	    int *const dyear);
*
*	void JulianDiffDate(const unsigned short day,
*	    const unsigned short month, const int year, int days,
*	    unsigned short &dday, unsigned short &dmonth, int &dyear);
*
*   FUNCTION
*	Returns the date which lies diffdays before/after the specified date.
*
*   INPUTS
*	day      - day of the date
*	month    - month of the date
*	year     - year of the date
*	diffdays - difference to the date in days
*
*   RESULT
*	dday   - Destination day
*	dmonth - Destination month
*	dyear  - Destination year
*
*   EXAMPLE
*	...
*	JulianDiffDate(23,1,1994,7,&dday,&dmonth,&dyear);
*	...
*
*   NOTES
*	It is better to use this function only from 8 to 1582!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	JulianDayDiff(),JulianMonthDays(),GregorianDiffDate(),HeisDiffDate()
*
*****************************************************************************
*
*
*/

 {
  int ddays;

  #ifndef __cplusplus
    *dday = day;
    *dmonth = month;
    *dyear = year;
    if (days >= 0)
      {/* add */
       ddays = (int)JulianDayDiff(*dday,*dmonth,*dyear,1,1,(*dyear)+1);
       while (days >= ddays)
         {/* years */
          *dday = 1;
          *dmonth = 1;
          (*dyear)++;
          days -= ddays;
          ddays = (int)JulianDayDiff(*dday,*dmonth,*dyear,1,1,(*dyear)+1);
         }
       ddays = (int)JulianDayDiff(*dday,*dmonth,*dyear,1,(*dmonth)+1,*dyear);
       while (days >= ddays)
         {/* months */
          *dday = 1;
          (*dmonth)++;
          days -= ddays;
          ddays = (int)JulianDayDiff(*dday,*dmonth,*dyear,1,(*dmonth)+1,*dyear);
         }
       if (days > 0)
         {/* days */
          *dday += (unsigned short)days;
         }
      }
    else
      {/* sub */
       ddays = (int)JulianDayDiff(*dday,*dmonth,*dyear,31,12,(*dyear)-1);
       while (days <= ddays)
         {/* years */
          *dday = 31;
          *dmonth = 12;
          (*dyear)--;
          days -= ddays;
          ddays = (int)JulianDayDiff(*dday,*dmonth,*dyear,31,12,(*dyear)-1);
         }
       ddays = (int)JulianDayDiff(*dday,*dmonth,*dyear,JulianMonthDays((*dmonth)-1,*dyear),(*dmonth)-1,*dyear);
       while (days <= ddays)
         {/* months */
          *dday = JulianMonthDays((*dmonth)-1,*dyear);
          (*dmonth)--;
          days -= ddays;
          ddays = (int)JulianDayDiff(*dday,*dmonth,*dyear,JulianMonthDays((*dmonth)-1,*dyear),(*dmonth)-1,*dyear);
         }
       if (days < 0)
           *dday -= (unsigned short)abs(days);
      }
  #else
    dday = day;
    dmonth = month;
    dyear = year;
    if (days >= 0)
      {/* add */
       ddays = (int)JulianDayDiff(dday,dmonth,dyear,1,1,dyear+1);
       while (days >= ddays)
         {/* years */
          dday = 1;
          dmonth = 1;
          dyear++;
          days -= ddays;
          ddays = (int)JulianDayDiff(dday,dmonth,dyear,1,1,dyear+1);
         }
       ddays = (int)JulianDayDiff(dday,dmonth,dyear,1,dmonth+1,dyear);
       while (days >= ddays)
         {/* months */
          dday = 1;
          dmonth++;
          days -= ddays;
          ddays = (int)JulianDayDiff(dday,dmonth,dyear,1,dmonth+1,dyear);
         }
       if (days > 0)
         {/* days */
          dday += (unsigned short)days;
         }
      }
    else
      {/* sub */
       ddays = (int)JulianDayDiff(dday,dmonth,dyear,31,12,dyear-1);
       while (days <= ddays)
         {/* years */
          dday = 31;
          dmonth = 12;
          dyear--;
          days -= ddays;
          ddays = (int)JulianDayDiff(dday,dmonth,dyear,31,12,dyear-1);
         }
       ddays = (int)JulianDayDiff(dday,dmonth,dyear,JulianMonthDays(dmonth-1,dyear),dmonth-1,dyear);
       while (days <= ddays)
         {/* months */
          dday = JulianMonthDays(dmonth-1,dyear);
          dmonth--;
          days -= ddays;
          ddays = (int)JulianDayDiff(dday,dmonth,dyear,JulianMonthDays(dmonth-1,dyear),dmonth-1,dyear);
         }
       if (days < 0)
         dday -= (unsigned short)(days < 0 ? -days : days);
      }
  #endif
 }


 #ifndef __MakeLib
   #ifndef __cplusplus
     void GregorianDiffDate(const unsigned short day, const unsigned short month, const int year, int days, unsigned short *const dday, unsigned short *const dmonth, int *const dyear)
   #else
     void GregorianDiffDate(const unsigned short day, const unsigned short month, const int year, int days, unsigned short &dday, unsigned short &dmonth, int &dyear)
   #endif
 #else
   void __saveds __asm GregorianDiffDate(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year, register __d3 int days, register __a0 unsigned short *const dday, register __a1 unsigned short *const dmonth, register __a2 int *const dyear)
 #endif

/*
******* Date/GregorianDiffDate **********************************************
*
*   NAME
*	GregorianDiffDate -- Returns the diff date to another date. (V33)
*
*   SYNOPSIS
*	GregorianDiffDate(day,month,year,diffdays,dday,dmonth,dyear);
*			   d0   d1   d2     d3     a0    a1    a2
*
*	void GregorianDiffDate(const unsigned short day,
*	    const unsigned short month, const int year, int days,
*	    unsigned short *const dday, unsigned short *const dmonth,
*	    int *const dyear);
*
*	void GregorianDiffDate(const unsigned short day,
*	    const unsigned short month, const int year, int days,
*	    unsigned short &dday, unsigned short &dmonth, int &dyear);
*
*   FUNCTION
*	Returns the date which lies diffdays before/after the specified date.
*
*   INPUTS
*	day      - day of the date
*	month    - month of the date
*	year     - year of the date
*	diffdays - difference to the date in days
*
*   RESULT
*	dday   - Destination day
*	dmonth - Destination month
*	dyear  - Destination year
*
*   EXAMPLE
*	...
*	GregorianDiffDate(23,1,1994,7,&dday,&dmonth,&dyear);
*	...
*
*   NOTES
*	It is better to use this function only from 8 to 3200!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	GregorianDayDiff(),GregorianMonthDays(),JulianDiffDate(),
*	HeisDiffDate()
*
*****************************************************************************
*
*
*/

 {
  int ddays;

  #ifndef __cplusplus
    *dday = day;
    *dmonth = month;
    *dyear = year;
    if (days >= 0)
      {/* add */
       ddays = (int)GregorianDayDiff(*dday,*dmonth,*dyear,1,1,(*dyear)+1);
       while (days >= ddays)
         {/* years */
          *dday = 1;
          *dmonth = 1;
          (*dyear)++;
          days -= ddays;
          ddays = (int)GregorianDayDiff(*dday,*dmonth,*dyear,1,1,(*dyear)+1);
         }
       ddays = (int)GregorianDayDiff(*dday,*dmonth,*dyear,1,(*dmonth)+1,*dyear);
       while (days >= ddays)
         {/* months */
          *dday = 1;
          (*dmonth)++;
          days -= ddays;
          ddays = (int)GregorianDayDiff(*dday,*dmonth,*dyear,1,(*dmonth)+1,*dyear);
         }
       if (days > 0)
         {/* days */
          *dday += (unsigned short)days;
         }
      }
    else
      {/* sub */
       ddays = (int)GregorianDayDiff(*dday,*dmonth,*dyear,31,12,(*dyear)-1);
       while (days <= ddays)
         {/* years */
          *dday = 31;
          *dmonth = 12;
          (*dyear)--;
          days -= ddays;
          ddays = (int)GregorianDayDiff(*dday,*dmonth,*dyear,31,12,(*dyear)-1);
         }
       ddays = (int)GregorianDayDiff(*dday,*dmonth,*dyear,GregorianMonthDays((*dmonth)-1,*dyear),(*dmonth-1),*dyear);
       while (days <= ddays)
         {/* months */
          *dday = GregorianMonthDays((*dmonth-1),*dyear);
          (*dmonth)--;
          days -= ddays;
          ddays = (int)GregorianDayDiff(*dday,*dmonth,*dyear,GregorianMonthDays((*dmonth)-1,*dyear),(*dmonth)-1,*dyear);
         }
       if (days < 0)
         *dday -= (unsigned short)abs(days);
      }
  #else
    dday = day;
    dmonth = month;
    dyear = year;
    if (days >= 0)
      {/* add */
       ddays = (int)GregorianDayDiff(dday,dmonth,dyear,1,1,dyear+1);
       while (days >= ddays)
         {/* years */
          dday = 1;
          dmonth = 1;
          dyear++;
          days -= ddays;
          ddays = (int)GregorianDayDiff(dday,dmonth,dyear,1,1,dyear+1);
         }
       ddays = (int)GregorianDayDiff(dday,dmonth,dyear,1,dmonth+1,dyear);
       while (days >= ddays)
         {/* months */
          dday = 1;
          dmonth++;
          days -= ddays;
          ddays = (int)GregorianDayDiff(dday,dmonth,dyear,1,dmonth+1,dyear);
         }
       if (days > 0)
         {/* days */
          dday += (unsigned short)days;
         }
      }
    else
      {/* sub */
       ddays = (int)GregorianDayDiff(dday,dmonth,dyear,31,12,dyear-1);
       while (days <= ddays)
         {/* years */
          dday = 31;
          dmonth = 12;
          dyear--;
          days -= ddays;
          ddays = (int)GregorianDayDiff(dday,dmonth,dyear,31,12,dyear-1);
         }
       ddays = (int)GregorianDayDiff(dday,dmonth,dyear,GregorianMonthDays(dmonth-1,dyear),dmonth-1,dyear);
       while (days <= ddays)
         {/* months */
          dday = GregorianMonthDays(dmonth-1,dyear);
          dmonth--;
          days -= ddays;
          ddays = (int)GregorianDayDiff(dday,dmonth,dyear,GregorianMonthDays(dmonth-1,dyear),dmonth-1,dyear);
         }
       if (days < 0)
         dday -= (unsigned short)(days < 0 ? -days : days);
      }
  #endif
 }


 #ifndef __MakeLib
   #ifndef __cplusplus
     void HeisDiffDate(const unsigned short day, const unsigned short month, const int year, int days, unsigned short *const dday, unsigned short *const dmonth, int *const dyear)
   #else
     void HeisDiffDate(const unsigned short day, const unsigned short month, const int year, int days, unsigned short &dday, unsigned short &dmonth, int &dyear)
   #endif
 #else
   void __saveds __asm HeisDiffDate(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year, register __d3 int days, register __a0 unsigned short *dday, register __a1 unsigned short *dmonth, register __a2 int *dyear)
 #endif

/*
******* Date/HeisDiffDate ***************************************************
*
*   NAME
*	HeisDiffDate -- Returns the date for a diff to another date. (V33)
*
*   SYNOPSIS
*	HeisDiffDate(day,month,year,diffdays,dday,dmonth,dyear);
*		      d0   d1   d2     d3     a0    a1    a2
*
*	void HeisDiffDate(const unsigned short day,
*	    const unsigned short month, const int year, int days,
*	    unsigned short *const dday, unsigned short *const dmonth,
*	    int *const dyear);
*
*	void HeisDiffDate(const unsigned short day,
*	    const unsigned short month, const int year, int days,
*	    unsigned short &dday, unsigned short &dmonth, int &dyear);
*
*   FUNCTION
*	Returns the date which lies diffdays before/after the specified date.
*
*   INPUTS
*	day      - day of the date
*	month    - month of the date
*	year     - year of the date
*	diffdays - difference to the date in days
*
*   RESULT
*	dday   - Destination day
*	dmonth - Destination month
*	dyear  - Destination year
*
*   EXAMPLE
*	...
*	HeisDiffDate(23,1,1994,7,&dday,&dmonth,&dyear);
*	...
*
*   NOTES
*	It is better to use this function only from 8 to 8000!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	HeisDayDiff(),HeisMonthDays(),JulianDiffDate(),GregorianDiffDate()
*
*****************************************************************************
*
*
*/

 {
  int ddays;

  #ifndef __cplusplus
    *dday = day;
    *dmonth = month;
    *dyear = year;
    if (days >= 0)
      {/* add */
       ddays = (int)HeisDayDiff(*dday,*dmonth,*dyear,1,1,(*dyear)+1);
       while (days >= ddays)
         {/* years */
          *dday = 1;
          *dmonth = 1;
          (*dyear)++;
          days -= ddays;
          ddays = (int)HeisDayDiff(*dday,*dmonth,*dyear,1,1,(*dyear)+1);
         }
       ddays = (int)HeisDayDiff(*dday,*dmonth,*dyear,1,(*dmonth+1),*dyear);
       while (days >= ddays)
         {/* months */
          *dday = 1;
          (*dmonth)++;
          days -= ddays;
          ddays = (int)HeisDayDiff(*dday,*dmonth,*dyear,1,(*dmonth)+1,*dyear);
         }
       if (days > 0)
         {/* days */
          *dday += (unsigned short)days;
         }
      }
    else
      {/* sub */
       ddays = (int)HeisDayDiff(*dday,*dmonth,*dyear,31,12,(*dyear)-1);
       while (days <= ddays)
         {/* years */
          *dday = 31;
          *dmonth = 12;
          (*dyear)--;
          days -= ddays;
          ddays = (int)HeisDayDiff(*dday,*dmonth,*dyear,31,12,(*dyear)-1);
         }
       ddays = (int)HeisDayDiff(*dday,*dmonth,*dyear,HeisMonthDays((*dmonth)-1,*dyear),(*dmonth)-1,*dyear);
       while (days <= ddays)
         {/* months */
          *dday = HeisMonthDays((*dmonth)-1,*dyear);
          (*dmonth)--;
          days -= ddays;
          ddays = (int)HeisDayDiff(*dday,*dmonth,*dyear,HeisMonthDays((*dmonth)-1,*dyear),(*dmonth)-1,*dyear);
         }
       if (days < 0)
         *dday -= (unsigned short)abs(days);
      }
  #else
    dday = day;
    dmonth = month;
    dyear = year;
    if (days >= 0)
      {/* add */
       ddays = (int)HeisDayDiff(dday,dmonth,dyear,1,1,dyear+1);
       while (days >= ddays)
         {/* years */
          dday = 1;
          dmonth = 1;
          dyear++;
          days -= ddays;
          ddays = (int)HeisDayDiff(dday,dmonth,dyear,1,1,dyear+1);
         }
       ddays = (int)HeisDayDiff(dday,dmonth,dyear,1,dmonth+1,dyear);
       while (days >= ddays)
         {/* months */
          dday = 1;
          dmonth++;
          days -= ddays;
          ddays = (int)HeisDayDiff(dday,dmonth,dyear,1,dmonth+1,dyear);
         }
       if (days > 0)
         {/* days */
          dday += (unsigned short)days;
         }
      }
    else
      {/* sub */
       ddays = (int)HeisDayDiff(dday,dmonth,dyear,31,12,dyear-1);
       while (days <= ddays)
         {/* years */
          dday = 31;
          dmonth = 12;
          dyear--;
          days -= ddays;
          ddays = (int)HeisDayDiff(dday,dmonth,dyear,31,12,dyear-1);
         }
       ddays = (int)HeisDayDiff(dday,dmonth,dyear,HeisMonthDays(dmonth-1,dyear),dmonth-1,dyear);
       while (days <= ddays)
         {/* months */
          dday = HeisMonthDays(dmonth-1,dyear);
          dmonth--;
          days -= ddays;
          ddays = (int)HeisDayDiff(dday,dmonth,dyear,HeisMonthDays(dmonth-1,dyear),dmonth-1,dyear);
         }
       if (days < 0)
         dday -= (unsigned short)(days < 0 ? -days : days);
      }
  #endif
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   unsigned int JYearToScaliger(const int year)
 #else
   unsigned int __saveds __asm JYearToScaliger(register __d0 const int year)
 #endif

/*
******* Date/JYearToScaliger ************************************************
*
*   NAME
*	JYearToScaliger -- Returns the year as Scaliger year. (V33)
*
*   SYNOPSIS
*	syear = JYearToScaliger(year);
*	 d0			 d0
*
*	unsigned int JYearToScaliger(const int year);
*
*   FUNCTION
*	Returns the Scaliger year.
*
*   INPUTS
*	year     - Julian year
*
*   RESULT
*	syear - The Scaliger year
*
*   EXAMPLE
*	...
*	syear = JYearToScaliger(1582);
*	...
*
*   NOTES
*	It is better to use this function only from 8 to 1582!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	GYearToScaliger(),HYearToScaliger()
*
*****************************************************************************
*
*
*/

 {
  if ((year < 0) && (year > -4714))
    return((unsigned int)(4714+year));
  else
    if ((year > 0) && (year < 3268))
      return((unsigned int)(4713+year));
    else
      return(0);
 }


 #ifndef __MakeLib
   unsigned int GYearToScaliger(const int year)
 #else
   unsigned int __saveds __asm GYearToScaliger(register __d0 const int year)
 #endif

/*
******* Date/GYearToScaliger ************************************************
*
*   NAME
*	GYearToScaliger -- Returns the year as Scaliger year. (V33)
*
*   SYNOPSIS
*	syear = GYearToScaliger(year);
*	 d0			 d0
*
*	unsigned int GYearToScaliger(const int year);
*
*   FUNCTION
*	Returns the Scaliger year.
*
*   INPUTS
*	year     - Gregorian year
*
*   RESULT
*	syear - The Scaliger year
*
*   EXAMPLE
*	...
*	syear = GYearToScaliger(1994);
*	...
*
*   NOTES
*	It is better to use this function only from 8 to 3200!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	JYearToScaliger(),HYearToScaliger()
*
*****************************************************************************
*
*
*/

 {/* if other calcs are better use here! */
  return(JYearToScaliger(year));
 }


 #ifndef __MakeLib
   unsigned int HYearToScaliger(const int year)
 #else
   unsigned int __saveds __asm HYearToScaliger(register __d0 const int year)
 #endif

/*
******* Date/HYearToScaliger ************************************************
*
*   NAME
*	HYearToScaliger -- Returns the year as Scaliger year. (V33)
*
*   SYNOPSIS
*	syear = HYearToScaliger(year);
*	 d0			 d0
*
*	unsigned int HYearToScaliger(const int year);
*
*   FUNCTION
*	Returns the Scaliger year.
*
*   INPUTS
*	year     - Heis year
*
*   RESULT
*	syear - The Scaliger year
*
*   EXAMPLE
*	...
*	syear = HYearToScaliger(1994);
*	...
*
*   NOTES
*	It is better to use this function only from 8 to 8000!
*
*   BUGS
*	The Scaliger period is defined to 3268!!!.
*
*   SEE ALSO
*	JYearToScaliger(),GYearToScaliger()
*
*****************************************************************************
*
*
*/

 {/* for compatiblities if GYearToScaliger will be changed */
  return(GYearToScaliger(year));
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   int ScaligerYearToJ(const unsigned int syear)
 #else
   int __saveds __asm ScaligerYearToJ(register __d0 const unsigned int syear)
 #endif

/*
******* Date/ScaligerYearToJ ************************************************
*
*   NAME
*	ScaligerYearToJ -- Returns the Scaliger year as Julian year. (V33)
*
*   SYNOPSIS
*	year = ScaligerYearToJ(syear);
*	 d0			d0
*
*	int ScaligerYearToJ(const unsigned int syear);
*
*   FUNCTION
*	Returns the Julian year of a Scaliger year.
*
*   INPUTS
*	syear     - Scaliger year
*
*   RESULT
*	year - The Julian year
*
*   EXAMPLE
*	...
*	year = ScaligerYearToJ(4800);
*	...
*
*   NOTES
*	It is better to use this function only from 4707 to 6295!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	ScaligerYearToG(),ScaligerYearToH()
*
*****************************************************************************
*
*
*/

 {
  if (syear < 4714)
    return((int)(4714+syear));
  else
    return((int)(syear-4713));
 }


 #ifndef __MakeLib
   int ScaligerYearToG(const unsigned int syear)
 #else
   int __saveds __asm ScaligerYearToG(register __d0 const unsigned int syear)
 #endif

/*
******* Date/ScaligerYearToG ************************************************
*
*   NAME
*	ScaligerYearToG -- Returns the Scaliger year as Gregorian year. (V33)
*
*   SYNOPSIS
*	year = ScaligerYearToG(syear);
*	 d0			d0
*
*	int ScaligerYearToG(const unsigned int syear);
*
*   FUNCTION
*	Returns the Gregorian year of a Scaliger year.
*
*   INPUTS
*	syear     - Scaliger year
*
*   RESULT
*	year - The Gregorian year
*
*   EXAMPLE
*	...
*	year = ScaligerYearToG(6400);
*	...
*
*   NOTES
*	It is better to use this function only from 4707 to 7981!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	ScaligerYearToJ(),ScaligerYearToH()
*
*****************************************************************************
*
*
*/

 {
  return(ScaligerYearToJ(syear));
 }


 #ifndef __MakeLib
   int ScaligerYearToH(const unsigned int syear)
 #else
   int __saveds __asm ScaligerYearToH(register __d0 const unsigned int syear)
 #endif

/*
******* Date/ScaligerYearToH ************************************************
*
*   NAME
*	ScaligerYearToH -- Returns the Scaliger year as Heis year. (V33)
*
*   SYNOPSIS
*	year = ScaligerYearToH(syear);
*	 d0			d0
*
*	int ScaligerYearToH(const unsigned int syear);
*
*   FUNCTION
*	Returns the Heis year of a Scaliger year.
*
*   INPUTS
*	syear     - Scaliger year
*
*   RESULT
*	year - The Heis year
*
*   EXAMPLE
*	...
*	year = ScaligerYearToH(7000);
*	...
*
*   NOTES
*	It is better to use this function only from 4707 to 7981!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	ScaligerYearToJ(),ScaligerYearToG()
*
*****************************************************************************
*
*
*/

 {/* for compatibilitie if ScaligerYearToG is changed! */
  return(ScaligerYearToG(syear));
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   unsigned long JSYearToJD(const unsigned int syear)
 #else
   unsigned long __saveds __asm JSYearToJD(register __d0 const unsigned int syear)
 #endif

/*
******* Date/JSYearToJD *****************************************************
*
*   NAME
*	JSYearToJD -- Calcs the JD from a Scaliger year. (V33)
*
*   SYNOPSIS
*	jd = JSYearToJD(syear);
*	d0		 d0
*
*	unsigned long JSYearToJD(const unsigned int syear);
*
*   FUNCTION
*	Returns the Julianday of a Scaliger year.
*
*   INPUTS
*	syear     - Scaliger year
*
*   RESULT
*	jd - The Julianday
*
*   EXAMPLE
*	...
*	jd = JSYearToJD(4800);
*	...
*
*   NOTES
*	It is better to use this function only from 4707 to 6295!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	GSYearToJD(),HSYearToJD()
*
*****************************************************************************
*
*
*/

 {
  return(((unsigned long)syear-1)*365+((unsigned long)syear+2) / 4);
 }


 #ifndef __MakeLib
   unsigned long GSYearToJD(const unsigned int syear)
 #else
   unsigned long __saveds __asm GSYearToJD(register __d0 const unsigned int syear)
 #endif

/*
******* Date/GSYearToJD *****************************************************
*
*   NAME
*	GSYearToJD -- Calcs the JD from a Scaliger year. (V33)
*
*   SYNOPSIS
*	jd = GSYearToJD(syear);
*	d0		 d0
*
*	unsigned long GSYearToJD(const unsigned int syear);
*
*   FUNCTION
*	Returns the Julianday of a Scaliger year.
*
*   INPUTS
*	syear     - Scaliger year
*
*   RESULT
*	jd - The Julianday
*
*   EXAMPLE
*	...
*	jd = GSYearToJD(4800);
*	...
*
*   NOTES
*	It is better to use this function only from 4707 to 7981!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	JSYearToJD(),HSYearToJD()
*
*****************************************************************************
*
*
*/

 {
  if (syear < 6296)
    {/* 1583 */
     return(JSYearToJD(syear));
    }
  else
    return(JSYearToJD(6296)-10+(unsigned long)(GregorianDayDiff(1,1,AfterGregorianYear+1,1,1,ScaligerYearToG(syear))));
 }


 #ifndef __MakeLib
   unsigned long HSYearToJD(const unsigned int syear)
 #else
   unsigned long __saveds __asm HSYearToJD(register __d0 const unsigned int syear)
 #endif

/*
******* Date/HSYearToJD *****************************************************
*
*   NAME
*	HSYearToJD -- Calcs the JD from a Scaliger year. (V33)
*
*   SYNOPSIS
*	jd = HSYearToJD(syear);
*	d0		 d0
*
*	unsigned long HSYearToJD(const unsigned int syear);
*
*   FUNCTION
*	Returns the Julianday of a Scaliger year.
*
*   INPUTS
*	syear     - Scaliger year
*
*   RESULT
*	jd - The Julianday
*
*   EXAMPLE
*	...
*	jd = HSYearToJD(6700);
*	...
*
*   NOTES
*	It is better to use this function only from 4707 to 7981!
*	In this version only GSYearToJD() is called, because the
*	Scaliger period is only valid to 3268
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	JSYearToJD(),GSYearToJD()
*
*****************************************************************************
*
*
*/

 {/* for compatibilitie if GSYearToJD is changed! */
  return(GSYearToJD(syear));
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   unsigned long JDtoMJD(const unsigned long jd)
 #else
   unsigned long __saveds __asm JDtoMJD(register __d0 const unsigned long jd)
 #endif

/*
******* Date/JDtoMJD ********************************************************
*
*   NAME
*	JDtoMJD -- Switches from JD to MJD. (V33)
*
*   SYNOPSIS
*	mjd = JDtoMJD(jd);
*	d0	      d0
*
*	unsigned long JDtoMJD(const unsigned long jd);
*
*   FUNCTION
*	Returns the Modified Julianday of a Julianday.
*
*   INPUTS
*	jd - Julianday
*
*   RESULT
*	mjd - The Modified Julianday
*
*   EXAMPLE
*	...
*	mjd = JDtoMJD(2449354);
*	...
*
*   NOTES
*	none
*
*   BUGS
*	Only use this function for jd > 2400001, because mjd is only
*	defined for this, otherwise system will crash!
*
*   SEE ALSO
*	MJDtoJD()
*
*****************************************************************************
*
*
*/

 {
  return(jd-2400001L);
 }


 #ifndef __MakeLib
   unsigned long MJDtoJD(const unsigned long mjd)
 #else
   unsigned long __saveds __asm MJDtoJD(register __d0 const unsigned long mjd)
 #endif

/*
******* Date/MJDtoJD ********************************************************
*
*   NAME
*	MJDtoJD -- Switches from MJD to JD. (V33)
*
*   SYNOPSIS
*	jd = MJDtoJD(mjd);
*	d0	     d0
*
*	unsigned long MJDtoJD(const unsigned long mjd);
*
*   FUNCTION
*	Returns the Julianday of a Modified Julianday.
*
*   INPUTS
*	mjd - Modified Julianday
*
*   RESULT
*	jd - The Julianday
*
*   EXAMPLE
*	...
*	jd = MJDtoJD(49353);
*	...
*
*   NOTES
*	none
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	JDtoMJD()
*
*****************************************************************************
*
*
*/

 {
  return(mjd+2400001L);
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   unsigned long JulianToJD(const unsigned short day, const unsigned short month, const int year)
 #else
   unsigned long __saveds __asm JulianToJD(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year)
 #endif

/*
******* Date/JulianToJD *****************************************************
*
*   NAME
*	JulianToJD -- Returns the JD for a date. (V33)
*
*   SYNOPSIS
*	jd = JulianToJD(day,month,year);
*	d0		d0   d1    d2
*
*	unsigned long JulianToJD(const unsigned short day,
*	    const unsigned short month, const int year);
*
*   FUNCTION
*	Returns the JD for a Julian date.
*
*   INPUTS
*	day      - day of the date to convert
*	month    - month of the date to convert
*	year     - year of the date to convert
*
*   RESULT
*	jd - This is the JD
*
*   EXAMPLE
*	...
*	jd = JulianToJD(23,1,1994);
*	...
*
*   NOTES
*	It is better to use this function only from 8 to 1582!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	JSYearToJD(),JYearToScaliger(),JulianDayDiff(),GregorianToJD(),
*	HeisToJD()
*
*****************************************************************************
*
*
*/

 {
  return(JSYearToJD(JYearToScaliger(year))+(unsigned long)(JulianDayDiff(1,1,year,day,month,year)));
 }


 #ifndef __MakeLib
   unsigned long GregorianToJD(const unsigned short day, const unsigned short month, const int year)
 #else
   unsigned long __saveds __asm GregorianToJD(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year)
 #endif

/*
******* Date/GregorianToJD **************************************************
*
*   NAME
*	GregorianToJD -- Returns the JD for a date. (V33)
*
*   SYNOPSIS
*	jd = GregorianToJD(day,month,year);
*	d0		   d0   d1    d2
*
*	unsigned long GregorianToJD(const unsigned short day,
*	    const unsigned short month, const int year);
*
*   FUNCTION
*	Returns the JD for a Gregorian date.
*
*   INPUTS
*	day      - day of the date to convert
*	month    - month of the date to convert
*	year     - year of the date to convert
*
*   RESULT
*	jd - This is the JD
*
*   EXAMPLE
*	...
*	jd = GregorianToJD(23,1,1994);
*	...
*
*   NOTES
*	It is better to use this function only from 8 to 3200!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	GSYearToJD(),GYearToScaliger(),GregorianDayDiff(),JulianToJD(),
*	HeisToJD()
*
*****************************************************************************
*
*
*/

 {
  return(GSYearToJD(GYearToScaliger(year))+(unsigned long)(GregorianDayDiff(1,1,year,day,month,year)));
 }


 #ifndef __MakeLib
   unsigned long HeisToJD(const unsigned short day, const unsigned short month, const int year)
 #else
   unsigned long __saveds __asm HeisToJD(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year)
 #endif

/*
******* Date/HeisToJD *******************************************************
*
*   NAME
*	HeisToJD -- Returns the JD for a date. (V33)
*
*   SYNOPSIS
*	jd = HeisToJD(day,month,year);
*	d0	      d0   d1    d2
*
*	unsigned long HeisToJD(const unsigned short day,
*	    const unsigned short month, const int year);
*
*   FUNCTION
*	Returns the JD for a Heis date.
*
*   INPUTS
*	day      - day of the date to convert
*	month    - month of the date to convert
*	year     - year of the date to convert
*
*   RESULT
*	jd - This is the JD
*
*   EXAMPLE
*	...
*	jd = HeisToJD(23,1,1994);
*	...
*
*   NOTES
*	It is better to use this function only from 8 to 3268!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	HSYearToJD(),HYearToScaliger(),HeisDayDiff(),JulianToJD(),HeisToJD()
*
*****************************************************************************
*
*
*/

 {
  return(HSYearToJD(HYearToScaliger(year))+(unsigned long)(HeisDayDiff(1,1,year,day,month,year)));
 }

 /* ----internal----------------------------------------------------------- */
/*
 static unsigned short GregorianSZ(const unsigned int year)

/ *
*****i* Date/GregorianSZ ****************************************************
*
*   NAME
*	GregorianSZ -- Returns the 'Sonnenzirkel' (V33)
*
*   SYNOPSIS
*	sz = GregorianSZ(year);
*
*	unsigned short GregorianSZ(const unsigned int year);
*
*   FUNCTION
*	Returns the 'Sonnenzirkel' of a year.
*
*   INPUTS
*	year     - For this year the 'Sonnenzirkel' is calculated.
*
*   RESULT
*	sz - The 'Sonnenzirkel' for the specified year.
*
*   EXAMPLE
*	...
*	sz = GregorianSZ(1994);
*	...
*
*   NOTES
*	Use this only for 1582 to 4100!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	GYearToScaliger()
*
*****************************************************************************
*
*
* /

 {
  unsigned short gz;
  gz = (unsigned short)(GYearToScaliger(year) % 28);
  if (gz==0)
    gz = 28;
  return(gz);
 }
*/

 static unsigned short GregorianGZ(const unsigned int year)

/*
*****i* Date/GregorianGZ ****************************************************
*
*   NAME
*	GregorianGZ -- Returns the 'Goldene Zahl' (golden number) (V33)
*
*   SYNOPSIS
*	gz = GregorianGZ(year);
*
*	unsigned short GregorianGZ(const unsigned int year);
*
*   FUNCTION
*	Returns the 'Goldene Zahl' of a year.
*
*   INPUTS
*	year     - For this year the 'Goldene Zahl' is calculated.
*
*   RESULT
*	gz - The 'Goldene Zahl' for the specified year.
*
*   EXAMPLE
*	...
*	gz = GregorianGZ(1994);
*	...
*
*   NOTES
*	Use this only for 1582 to 4100!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	GYearToScaliger()
*
*****************************************************************************
*
*
*/

 {
  unsigned int syear;

  syear = GYearToScaliger(year) % 19;
  if (syear == 0)
    syear = 19;
  return((unsigned short)syear);
 }


 static unsigned short GEP(const unsigned int year)

/*
*****i* Date/GEP ************************************************************
*
*   NAME
*	GEP -- Internal function to help calculate the 'EP' (V33)
*
*   SYNOPSIS
*	hep = GEP(year);
*
*	unsigned short GEP(const unsigned int year);
*
*   FUNCTION
*	Internal function to help calculate the 'EP'
*
*   INPUTS
*	year - This is the year for which the help EP is to be
*	    calculated
*
*   RESULT
*	hep - The help value for the EP calculation.
*
*   EXAMPLE
*	...
*	hep = GEP(1994);
*	...
*
*   NOTES
*	Use this only for 1582 to 4200!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*
*
*****************************************************************************
*
*
*/

   {
    unsigned short	century,decade;
    int			ep;

    ep = 1; /* 1582 */
    century = (unsigned short)(year / 100);
    decade = (unsigned short)(year - century * 100);
    if (year < 1701)
      return(1);
    else
      if (year < 1800)
        return(0);
      else
        {
         ep -= (int)(((century) % 4) + (((century-16) / 4) * 3));
         if ((decade == 0) && ((century % 4) > 0))
           ep++;
         ep += (int)((century-18) / 3);
         if ((((century-18) % 3) > 0) || (decade > 0))
           ep++;
         if (ep > 29)
           ep %= 30;
         if (ep < 0)
           ep += 30;
         return((unsigned short)ep);
        }
   }


 static unsigned short GregorianEP(const unsigned int year)

/*
*****i* Date/GregorianEP ****************************************************
*
*   NAME
*	GregorianEP -- Returns the 'Epakte' (V33)
*
*   SYNOPSIS
*	ep = GregorianEP(year);
*
*	unsigned short GregorianEP(const unsigned int year);
*
*   FUNCTION
*	Returns the 'Epakte' of a year.
*
*   INPUTS
*	year     - For this year the 'Epakte' is calculated.
*
*   RESULT
*	ep - The 'Epakte' for the specified year.
*
*   EXAMPLE
*	...
*	ep = GregorianEP(1994);
*	...
*
*   NOTES
*	Use this only for 1582 to 4100!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	GEP(),GregorianGZ()
*
*****************************************************************************
*
*
*/

 {
  unsigned short ep;

  if (year >= AfterGregorianYear)
   {
    ep = (unsigned short)(((GregorianGZ(year)-1)*11 + GEP(year)) % 30);
    if (ep == 0)
      ep = 30;
    return(ep);
   }
  else
    return(31);
 }


 static unsigned short GregorianJHStartSB(const unsigned short century)

/*
*****i* Date/GregorianJHStartSB *********************************************
*
*   NAME
*	GregorianJHStartSB -- Returns the 'Sonntagsbuchstabe' (V33)
*
*   SYNOPSIS
*	csb = GregorianJHStartSB(century);
*
*	unsigned short GregorianJHStartSB(const unsigned short century);
*
*   FUNCTION
*	Returns start 'SB' for a century.
*
*   INPUTS
*	century - For this century the start 'SB' is calculated.
*
*   RESULT
*	csb - The start 'SB' for the specified century.
*
*   EXAMPLE
*	...
*	csb = GregorianJHStartSB(19);
*	...
*
*   NOTES
*	Use this only for 15 to 31!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	GregorianJHStartSB()
*
*****************************************************************************
*
*
*/

 {
  unsigned short sb;

  if (century == 15)
    return(4);
  else
   {
    sb = GregorianJHStartSB(century-1);
    if ((century % 4) > 0)
      sb++;
    sb %= 7;
    if (sb == 0)
      sb = 7;
    return(sb);
   }
 }

/*
 static unsigned short GregorianJHSB(const unsigned int year)

/ *
*****i* Date/GregorianSB ****************************************************
*
*   NAME
*	GregorianJHSB -- Returns the 'Sonntagsbuchstabe' (V33)
*
*   SYNOPSIS
*	sb = GregorianJHSB(year);
*
*	unsigned short GregorianJHSB(const unsigned int year);
*
*   FUNCTION
*	Returns the start 'SB' for a century year.
*
*   INPUTS
*	year - For this century year the start 'SB' is calculated.
*
*   RESULT
*	sb - The start 'SB' for the specified year.
*
*   EXAMPLE
*	...
*	sb = GregorianJHSB(1994);
*	...
*
*   NOTES
*	Use this only for 1583 to 3199!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	GregorianLeapYear(),GregorianJHStartSB()
*
*****************************************************************************
*
*
* /

 {
  if (((year % 100) == 0) && (!GregorianLeapYear((int)year)))
    return((unsigned short)(((year / 100) % 4) *2 +1));
  else
    return(GregorianJHStartSB(year / 100));
 }
*/
/*
 static unsigned short GregorianSB(const unsigned int year)

/ *
*****i* Date/GregorianSB ****************************************************
*
*   NAME
*	GregorianSB -- Returns the 'Sonntagsbuchstabe' (V33)
*
*   SYNOPSIS
*	sb = GregorianSB(year);
*
*	unsigned short GregorianSB(const unsigned int year);
*
*   FUNCTION
*	Returns the 'SB' for a year.
*
*   INPUTS
*	year - For this year the 'SB' is calculated.
*
*   RESULT
*	sb - The 'SB' for the specified year.
*	    This means the day the first Sunday lies on :)
*
*   EXAMPLE
*	...
*	sb = GregorianSB(1994);
*	...
*
*   NOTES
*	Use this only for 1583 to 3199!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	GregorianLeapYear(),GregorianSZ(),GregorianJHStartSB()
*
*****************************************************************************
*
*
* /

 {
  unsigned short sz,csb,i;

  if (((year % 100) == 0) && (!GregorianLeapYear((int)year)))
    return((unsigned short)(((year / 100) % 4) *2 +1));
  else
   {
    sz = GregorianSZ(year);
    csb = GregorianJHStartSB(year / 100);
    if (sz == 28)
      return(csb);
    else
     {
      for (i=27;i>=sz;i--)
       {
        csb++;
        if (csb == 8)
          csb = 1;
        if (((i-1) % 4) == 0)
         {
          csb++;
          if (csb == 8)
            csb =1;
         }
       }
      return(csb);
     }
   }
 }
*/

 static unsigned short MoonMonthAge(const unsigned short month, unsigned short ep, const int year)

/*
*****i* Date/MoonMonthAge ***************************************************
*
*   NAME
*	MoonMonthAge -- Calculates the age of the moon on month start (V33)
*
*   SYNOPSIS
*	ep = MoonMonthAge(month,ep);
*
*	unsigned short MoonMonthAge(const unsigned short month,
*	   unsigned short ep, const int year);
*
*   FUNCTION
*	Returns the age of the moon on the start of a month.
*
*   INPUTS
*	month - Month for which the age of the moon is needed.
*	ep    - 'Epakte' of the New Years day.
*
*   RESULT
*	ep - The moonage on the 1. of the specified month.
*
*   EXAMPLE
*	...
*	ep = MoonMonthAge(2,17); \* 17 is for 1994 *\
*	...
*
*   NOTES
*	This is only a experimental version!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	MoonMonthAge(),GregorianMonthDays()
*
*****************************************************************************
*
*
*/

   {
    if (month == 1)
      return(ep);
    else
      if (month % 2 == 0)
        ep = (unsigned short)((MoonMonthAge(month-1,ep,year) + GregorianMonthDays(month-1,year)) % 29);
      else
        ep = (unsigned short)((MoonMonthAge(month-1,ep,year) + GregorianMonthDays(month-1,year)) % 30);
      return(ep);
   }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   unsigned short GregorianMoonAge(const unsigned short day, const unsigned short month, const int year)
 #else
   unsigned short __saveds __asm GregorianMoonAge(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year)
 #endif

/*
******* Date/GregorianMoonAge ***********************************************
*
*   NAME
*	GregorianMoonAge -- Returns the age of the moon (V33)
*
*   SYNOPSIS
*	ep = GregorianMoonAge(day,month,year);
*	d0		       d0   d1   d2
*
*	unsigned short GregorianMoonAge(const unsigned short day,
*	    const unsigned short month, const int year);
*
*   FUNCTION
*	Returns the age of the moon on a specified date.
*
*   INPUTS
*	day   - For this day the age is calculated.
*	month - For this month the age is calculated.
*	year  - For this year the age is calculated.
*
*   RESULT
*	ep - The age of the moon on the specified date.
*
*   EXAMPLE
*	...
*	ep = GregorianMoonAge(18,9,1994);
*	...
*
*   NOTES
*	Use this only for 1582 to 4100!
*	This is only an experimental version!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	MoonMonthAge(),GregorianEP(),GregorianMoonPhase()
*
*****************************************************************************
*
*
*/

 {
  unsigned short ep;

  ep = GregorianEP(year);
  ep = MoonMonthAge(month,ep,year);
  ep += day -1;
  if (month > 1)
    if (month % 2 == 0)
      {
       ep %= 30;
       if (ep == 0)
         ep = 30;
      }
    else
      {
       ep %= 29;
       if (ep == 0)
         ep = 29;
      }
  else
    if (ep > 29)
      ep %= 29;
  return(ep);
 }


 #ifndef __MakeLib
   #ifndef __cplusplus
     void JulianEaster(const int year, unsigned short *const dday, unsigned short *const dmonth)
   #else
     void JulianEaster(const int year, unsigned short &dday, unsigned short &dmonth)
   #endif
 #else
   void __saveds __asm JulianEaster(register __d0 const int year, register __a0 unsigned short *const dday, register __a1 unsigned short *const dmonth)
 #endif

/*
******* Date/JulianEaster ***************************************************
*
*   NAME
*	JulianEaster -- Returns the date of Easter in a year (V33.097)
*
*   SYNOPSIS
*	JulianEaster(year,dday,dmonth);
*		      d0   a0    a1
*
*	void JulianEaster(const int year, unsigned short *const dday,
*	    unsigned short *const dmonth);
*
*	void JulianEaster(const int year, unsigned short &dday,
*	    unsigned short &dmonth);
*
*   FUNCTION
*	Returns the date of Easter for a specified year.
*
*   INPUTS
*	year  - Easter is calculated for this year
*
*   RESULT
*	dday   - day of Easter Sunday
*	dmonth - month of Easter Sunday
*
*   EXAMPLE
*	...
*	JulianEaster(1994,&dday,&dmonth);
*	...
*
*   NOTES
*	Use this only for 31 to 1582!
*
*   BUGS
*	None.
*
*   SEE ALSO
*	GregorianEaster(),HeisEaster()
*
*****************************************************************************
*
*
*/

 {
  unsigned short a,b,c;

  a = (unsigned short)((19*(year%19)+15)%30);
  b = (unsigned short)((2*(year%4)+4*(year%7)-a+34)%7);
  c = (unsigned short)(a+b+114);
  #ifndef __cplusplus
    *dday = (unsigned short)(c%31 +1);
    *dmonth = (unsigned short)(c/31);
  #else
    dday = (unsigned short)(c%31 +1);
    dmonth = (unsigned short)(c/31);
  #endif
 }

/*
 #ifndef __MakeLib
   void GregorianEaster(const int year, unsigned short *const dday, unsigned short *const dmonth)
 #else
   void __saveds __asm GregorianEaster(register __d0 const int year, register __a0 unsigned short *const dday, register __a1 unsigned short *const dmonth)
 #endif

/ *
*****i* Date/GregorianEaster ************************************************
*
*   NAME
*	GregorianEaster -- Returns the date of Easter in a year (V33)
*
*   SYNOPSIS
*	GregorianEaster(year,dday,dmonth);
*			 d0   a0    a1
*
*	void GregorianEaster(const int year, unsigned short *const dday,
*	    unsigned short *const dmonth);
*
*   FUNCTION
*	Returns the date of Easter for a specified year.
*
*   INPUTS
*	year  - Easter is calculated for this year
*
*   RESULT
*	dday   - day of Easter Sunday
*	dmonth - month of Easter Sunday
*
*   EXAMPLE
*	...
*	GregorianEaster(1994,&dday,&dmonth);
*	...
*
*   NOTES
*	Use this only for 1900 to 2099!
*	Tested for 1977-1994! But this formula is from Gau - so it must be
*	correct :) but extended by me (hope this will be a good thing too!)
*
*   BUGS
*	None.
*
*   SEE ALSO
*	GEP(),GregorianJHSB()
*
*****************************************************************************
*
*
* /

 {
  unsigned short a,d,e,f;
  short M,N;

  M = (short)((30 - GEP(year)) - 7);
  if (M < 0)
    M += 30;
  N = (short)(GregorianJHSB(year)-2);
  if (N<1)
    N += 7;
  a = (unsigned short)(year % 19);
  d = (unsigned short)((19*(unsigned int)a+M) % 30);
  e = (unsigned short)((2*(unsigned int)(year % 4)+4*(unsigned int)(year % 7)+6*(unsigned int)(d)+N) % 7);
  f = (unsigned short)(d+e);

  if (f < 10)
   {/ * mrz * /
    *dmonth = 3;
    *dday = (unsigned short)(22+f);
   }
  else
   {/ * april * /
    *dmonth = 4;
    *dday = (unsigned short)(f-9);
    if (*dday==26)
      *dday = 19;
    else
      if ((*dday==25) && (d==28) && (a>10))
        *dday = 18;
   }
 }
*/

 #ifndef __MakeLib
   #ifndef __cplusplus
     void GregorianEaster(const int year, unsigned short *const dday, unsigned short *const dmonth)
   #else
     void GregorianEaster(const int year, unsigned short &dday, unsigned short &dmonth)
   #endif
 #else
   void __saveds __asm GregorianEaster(register __d0 const int year, register __a0 unsigned short *const dday, register __a1 unsigned short *const dmonth)
 #endif

/*
******* Date/GregorianEaster ************************************************
*
*   NAME
*	GregorianEaster -- Returns the date of Easter in a year (V33)
*
*   SYNOPSIS
*	GregorianEaster(year,dday,dmonth);
*			 d0   a0    a1
*
*	void GregorianEaster(const int year, unsigned short *const dday,
*	    unsigned short *const dmonth);
*
*	void GregorianEaster(const int year, unsigned short &dday,
*	    unsigned short &dmonth);
*
*   FUNCTION
*	Returns the date of Easter for a specified year.
*
*   INPUTS
*	year  - Easter is calculated for this year
*
*   RESULT
*	dday   - day of Easter Sunday
*	dmonth - month of Easter Sunday
*
*   EXAMPLE
*	...
*	GregorianEaster(1994,&dday,&dmonth);
*	...
*
*   NOTES
*	Use this only for 31 to 2099!
*
*   BUGS
*	None.
*
*   SEE ALSO
*	JulianEaster(),HeisEaster()
*
*****************************************************************************
*
*
*/

 {
  unsigned short a,b,c,d,e;
  unsigned int f;

  if (year <= BeforeGregorianYear)
   {
    JulianEaster(year,dday,dmonth);
   }
  else
   {
    a = (unsigned short)(year % 19);
    b = (unsigned short)(year / 100);
    c = (unsigned short)(year % 100);
    d = (unsigned short)((19*a+b-(b/4)-((b-((b+8)/25)+1)/3)+15) % 30);
    e = (unsigned short)((32+2*(b%4)+2*(c/4)-d-(c%4)) % 7);
    f = d+e-7*((a+11*d+22*e)/451)+114;
    #ifndef __cplusplus
      *dday = (unsigned short)(f%31 +1);
      *dmonth = (unsigned short)(f/31);
    #else
      dday = (unsigned short)(f%31 +1);
      dmonth = (unsigned short)(f/31);
    #endif
   }
 }


 #ifndef __MakeLib
   #ifndef __cplusplus
     void HeisEaster(const int year, unsigned short *const dday, unsigned short *const dmonth)
   #else
     void HeisEaster(const int year, unsigned short &dday, unsigned short &dmonth)
   #endif
 #else
   void __saveds __asm HeisEaster(register __d0 const int year, register __a0 unsigned short *const dday, register __a1 unsigned short *const dmonth)
 #endif

/*
******* Date/HeisEaster *****************************************************
*
*   NAME
*	HeisEaster -- Returns the date of Easter in a year (V33)
*
*   SYNOPSIS
*	HeisEaster(year,dday,dmonth);
*		    d0   a0    a1
*
*	void HeisEaster(const int year, unsigned short *const dday,
*	    unsigned short *const dmonth);
*
*	void HeisEaster(const int year, unsigned short &dday,
*	    unsigned short &dmonth);
*
*   FUNCTION
*	Returns the date of Easter for a specified year.
*
*   INPUTS
*	year  - Easter is calculated for this year
*
*   RESULT
*	dday   - day of Easter Sunday
*	dmonth - month of Easter Sunday
*
*   EXAMPLE
*	...
*	HeisEaster(1994,&dday,&dmonth);
*	...
*
*   NOTES
*	This is only a dummy to GregorianEaster!
*	Use this only for 31 to 2099!
*
*   BUGS
*	Unknown.
*
*   SEE ALSO
*	JulianEaster(),GregorianEaster()
*
*****************************************************************************
*
*
*/

 {
  GregorianEaster(year,dday,dmonth);
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   unsigned short JulianWeek(const unsigned short day, const unsigned short month, const int year)
 #else
   unsigned short __saveds __asm JulianWeek(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year)
 #endif

/*
******* Date/JulianWeek *****************************************************
*
*   NAME
*	JulianWeek -- Gets the number of the week for a specified date. (V33)
*
*   SYNOPSIS
*	weeknr = JulianWeek(day,month,year);
*	  d0		    d0    d1   d2
*
*	unsigned short JulianWeek(const unsigned short day,
*	    const unsigned short month, const int year);
*
*   FUNCTION
*	JulianWeek gets the number of the week for a specified date.
*
*   INPUTS
*	day   - day of the date
*	month - month of the date
*	year  - year of the date
*
*   RESULT
*	week - This is the number of the week the specified date lies in.
*	    If the first day in a new year is a Friday, Saturday or
*	    Sunday, this would be the last week of the last year!
*	    If the 29.12. is a Monday, the 30.12. is a Monday or a Tuesday,
*	    the 31.12. is a Monday, Tuesday or a Wednesday this is the
*	    first week of the next year!
*
*   EXAMPLE
*	...
*	weeknr = JulianWeek(4,10,1582);
*	...
*
*   NOTES
*	It is is better only to use this function for years from 0 to 1582!
*
*   BUGS
*	For years < 0 errors could occur.
*
*   SEE ALSO
*	GregorianWeek(),HeisWeek(),JulianWeekday(),JulianDayDiff()
*
*****************************************************************************
*
*
*/

 {
  long days;
  Weekdays firstweekday;

   firstweekday = JulianWeekday(1,1,year);
   days = (JulianDayDiff(1,1,year,day,month,year) + (long)firstweekday -1) / 7;
   if (firstweekday > Thursday)
     {
      if (days == 0)
        days = JulianWeek(31,12,year-1);
      else
        if ((firstweekday == Sunday) && JulianLeapYear(year) && (month == 12) && (day == 31))
          days = 1;
      return((unsigned short)days);
     }
   else
     {
      if (!JulianDaySmaller(day,month,year,29,12,year))
        {
         firstweekday = JulianWeekday(day,12,year);
         switch (day)
           {
            case 31 : if (firstweekday == Wednesday)
                        days = 0;
            case 30 : if (firstweekday == Tuesday)
                        days = 0;
            case 29 : if (firstweekday == Monday)
                        days = 0;
                      break;
            default : ;
           }
        }
      return((unsigned short)(days +1));
     }
 }


 #ifndef __MakeLib
   unsigned short GregorianWeek(const unsigned short day, const unsigned short month, const int year)
 #else
   unsigned short __saveds __asm GregorianWeek(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year)
 #endif

/*
******* Date/GregorianWeek **************************************************
*
*   NAME
*	GregorianWeek -- Gets the weeknumber for a specified date. (V33)
*
*   SYNOPSIS
*	weeknr = GregorianWeek(day,month,year);
*	  d0			d0   d1   d2
*
*	unsigned short GregorianWeek(const unsigned short day,
*	    const unsigned short month, const int year);
*
*   FUNCTION
*	GregorianWeek gets the number of the week for a specified date.
*
*   INPUTS
*	day   - day of the date
*	month - month of the date
*	year  - year of the date
*
*   RESULT
*	week - This is the number of the week the specified date lies in.
*	    If the first day in a new year is a Friday, Saturday or
*	    Sunday, this would be the last week of the last year!
*	    If the 29.12. is a Monday, the 30.12. is a Monday or a Tuesday,
*	    the 31.12. is a Monday, Tuesday or a Wednesday this is the
*	    first week of the next year!
*
*   EXAMPLE
*	...
*	weeknr = GregorianWeek(4,10,1582);
*	...
*
*   NOTES
*	It is better only to use this function for years from 0 to 3000!
*
*   BUGS
*	For years < 0 errors could occur.
*
*   SEE ALSO
*	JulianWeek(),HeisWeek(),GregorianWeekday(),GregorianDayDiff()
*
*****************************************************************************
*
*
*/

 {
  long days;
  Weekdays firstweekday;

   firstweekday = GregorianWeekday(1,1,year);
   days = (GregorianDayDiff(1,1,year,day,month,year) + (long)firstweekday -1) / 7;
   if (firstweekday > Thursday)
     {
      if (days == 0)
        days = GregorianWeek(31,12,year-1);
      else
        if ((firstweekday == Sunday) && GregorianLeapYear(year) && (month == 12) && (day == 31))
          days = 1;
      return((unsigned short)days);
     }
   else
     {
      if (!GregorianDaySmaller(day,month,year,29,12,year))
        {
         firstweekday = GregorianWeekday(day,12,year);
         switch (day)
           {
            case 31 : if (firstweekday == Wednesday)
                        days = 0;
            case 30 : if (firstweekday == Tuesday)
                        days = 0;
            case 29 : if (firstweekday == Monday)
                        days = 0;
                      break;
            default : ;
           }
        }
      return((unsigned short)(days +1));
     }
 }


 #ifndef __MakeLib
   unsigned short HeisWeek(const unsigned short day, const unsigned short month, const int year)
 #else
   unsigned short __saveds __asm HeisWeek(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year)
 #endif

/*
******* Date/HeisWeek *******************************************************
*
*   NAME
*	HeisWeek -- Gets the number of the week for a specified date. (V33)
*
*   SYNOPSIS
*	weeknr = HeisWeek(day,month,year);
*	  d0		   d0  d1    d2
*
*	unsigned short HeisWeek(const unsigned short day,
*	    const unsigned short month, const int year);
*
*   FUNCTION
*	HeisWeek gets the number of the week for a specified date.
*
*   INPUTS
*	day   - day of the date
*	month - month of the date
*	year  - year of the date
*
*   RESULT
*	week - This is the number of the week the specified date lies in.
*	    If the first day in a new year is a Friday, Saturday or
*	    Sunday, this would be the last week of the last year!
*	    If the 29.12. is a Monday, the 30.12. is a Monday or a Tuesday,
*	    the 31.12. is a Monday, Tuesday or a Wednesday this is the
*	    first week of the next year!
*
*   EXAMPLE
*	...
*	weeknr = HeisWeek(4,10,1582);
*	...
*
*   NOTES
*	It is better only to use this function for years from 0 to 8000!
*
*   BUGS
*	For years < 0 errors could occur.
*
*   SEE ALSO
*	JulianWeek(),GregorianWeek(),HeisWeekday(),HeisDayDiff()
*
*****************************************************************************
*
*
*/

 {
  long days;
  Weekdays firstweekday;

   firstweekday = HeisWeekday(1,1,year);
   days = (HeisDayDiff(1,1,year,day,month,year) + (long)firstweekday -1) / 7;
   if (firstweekday > Thursday)
     {
      if (days == 0)
        days = HeisWeek(31,12,year-1);
      else
        if ((firstweekday == Sunday) && HeisLeapYear(year) && (month == 12) && (day == 31))
          days = 1;
      return((unsigned short)days);
     }
   else
     {
      if (!HeisDaySmaller(day,month,year,29,12,year))
        {
         firstweekday = HeisWeekday(day,12,year);
         switch (day)
           {
            case 31 : if (firstweekday == Wednesday)
                        days = 0;
            case 30 : if (firstweekday == Tuesday)
                        days = 0;
            case 29 : if (firstweekday == Monday)
                        days = 0;
                      break;
            default : ;
           }
        }
      return((unsigned short)(days +1));
     }
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   unsigned short WeekdayText(const Weekdays wday, char *const wtext, Languages lang)
 #else
   unsigned short __saveds __asm WeekdayText(register __d0 const Weekdays wday, register __a0 char *const wtext, register __d1 Languages lang)
 #endif

/*
******* Date/WeekdayText ****************************************************
*
*   NAME
*	WeekdayText -- Get the weekday as text string. (V33.091)
*
*   SYNOPSIS
*	maxlen = WeekdayText(wday,wtext,lang);
*	  d0                  d0   a0    d1
*
*	unsigned short WeekdayText(const Weekdays wday, char *const wtext,
*	    Languages lang);
*
*   FUNCTION
*	This function gets the text string for the weekday-number.
*
*   INPUTS
*	wday  - Weekday to transform into a string.
*	wtext - Pointer to a string to fill in the weekday-text.
*	lang  - Language for wich you want the weekday-text.
*
*   RESULT
*	maxlen - Maximum possible length for the weekday-string, this should
*	    help you if you want to justify the string right or if you
*	    want to center it!
*	    0 indicates an error!
*
*   EXAMPLE
*	...
*	char wtxt[20];
*	...
*	maxlen = WeekdayText(Monday,&wtxt,English);
*	...
*
*   NOTES
*	Available languages:
*	Locale    : This is an Amiga >= OS2.1 only feature, for <= OS2.0
*	            and other systems it will return English text!
*	English
*	Deutsch
*	franais  : For non ISO8859_Latin1-systems this is called francais!
*	espaol   : For non ISO8859_Latin1-systems this is called espanol!
*	portugus : For non ISO8859_Latin1-systems this is called portugues!
*	dansk
*	italiano
*	nederlands
*	norsk
*	svenska
*	polski
*	suomalainen
*
*   BUGS
*	In this version there is no check, if there is enough space in
*	wtext!
*
*   SEE ALSO
*	MonthText(),WeekdayShortText(),MonthShortText()
*
*****************************************************************************
*
*
*/

 {
  unsigned short len=0;
  const unsigned short WEEKDAYMAXLEN[13]   = {0,9,10,8,9,13,7,10,9,7,7,12,11};
  const char           WEEKDAYS[13][8][14] = {{"","","","","","","",""},
                                              {"","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"},
                                              {"","Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag","Sonntag"},
                                              {"","Lundi","Mardi","Mercredi","Jeudi","Vendredi","Samedi","Dimanche"},
                                              {"","lunes","martes",
                                               #ifdef _ISO8859_Latin1
                                                 "mircoles"
                                               #else
                                                 "miercoles"
                                               #endif
                                               ,"jueves","viernes",
                                               #ifdef _ISO8859_Latin1
                                                 "sbado"
                                               #else
                                                 "sabado"
                                               #endif
                                               ,"domingo"},
                                              {"","Segunda-feira","Tera-feira","Quarta-feira","Quinta-feira","Sexta-feira","Sbado","Domingo"},
                                              {"","Mandag","Tirsdag","Onsdag","Torsdag","Fredag",
                                               #ifdef _ISO8859_Latin1
                                                 "Lordag","Sondag"
                                               #else
                                                 "Lordag","Sondag"
                                               #endif
                                              },
                                              {"",
                                               #ifdef _ISO8859_Latin1
                                                 "Luned","Marted","Mercoled","Gioved","Venerd"
                                               #else
                                                 "Lunedi","Martedi","Mercoledi","Giovedi","Venerdi"
                                               #endif
                                               ,"Sabato","Domenica"},
                                              {"","maandag","dinsdag","woensdag","donderdag","vrijdag","zaterdag","zondag"},
                                              {"","Mandag","Tirsdag","Onsdag","Torsdag","Fredag",
                                               #ifdef _ISO8859_Latin1
                                                 "Lordag","Sondag"
                                               #else
                                                 "Lordag","Sondag"
                                               #endif
                                              },
                                              {"",
                                               #ifdef _ISO8859_Latin1
                                                 "Mndag"
                                               #else
                                                 "Mandag"
                                               #endif
                                               ,"Tisdag","Onsdag","Torsdag","Fredag",
                                               #ifdef _ISO8859_Latin1
                                                 "Lrdag","Sndag"
                                               #else
                                                 "Lordag","Sondag"
                                               #endif
                                              },
                                              {"",
                                               #ifdef _ISO8859_Latin1
                                                 "Poniedzia?ek"
                                               #else
                                                 "Poniedzialek"
                                               #endif
                                               ,"Wtorek",
                                               #ifdef _ISO8859_Latin1
                                                 "?roda"
                                               #else
                                                 "Sroda"
                                               #endif
                                               ,"Czwartek",
                                               #ifdef _ISO8859_Latin1
                                                 "Pi?tek"
                                               #else
                                                 "Piatek"
                                               #endif
					       ,"Sobota","Niedziela"},
					      {"","maanantai","tiistai","keskiviikko","torstai","perjantai","lauantai","sunnuntai"}
                                             };

  if (wtext != NULL)
   {
    wtext[0] = '\0';
    switch (lang)
     {
      case Locale :
      #ifdef _AMIGA
                    if (locale != NULL)
                     {
                      len = wlen;
                      switch (wday)
                       {
                        case Sunday : strcpy(wtext,GetLocaleStr(locale,DAY_1));
                                      break;
                        case dayerr : len = 0;
                                      break;
                        default     : strcpy(wtext,GetLocaleStr(locale,DAYS[(unsigned short)wday]));
                       }
                      break;
                     }
      #endif
                    lang = English;
      default     : len = WEEKDAYMAXLEN[(unsigned short)lang];
                    if (wday == dayerr)
                      len = 0;
                    else
                      strcpy(wtext,WEEKDAYS[(unsigned short)lang][(unsigned short)wday]);
     }
   }
  return(len);
 }


 #ifndef __MakeLib
   unsigned short MonthText(const unsigned short month, char *const mtext, Languages lang)
 #else
   unsigned short __saveds __asm MonthText(register __d0 const unsigned short month, register __a0 char *const mtext, register __d1 Languages lang)
 #endif

/*
******* Date/MonthText ******************************************************
*
*   NAME
*	MonthText -- Get the month as text string. (V33.091)
*
*   SYNOPSIS
*	maxlen = MonthText(month,mtext,lang);
*	 d0                 d0   a0    d1
*
*	unsigned short MonthText(const unsigned short month,
*	    char *const mtext, Languages lang);
*
*   FUNCTION
*	This function gets the text string for the month-number.
*
*   INPUTS
*	month - Month to transform into a string.
*	mtext - Pointer to a string to fill in the month-text.
*	lang  - Language for which you want the month-text.
*
*   RESULT
*	maxlen - Maximum possible length for the month-string, this should
*	    help you if you want to justify the string right or if you
*	    want to center it!
*	    0 indicates an error!
*
*   EXAMPLE
*	...
*	char mtxt[20];
*	...
*	maxlen = MonthText(12,&mtxt,English);
*	...
*
*   NOTES
*	Available languages:
*	Locale    : This is an Amiga >= OS2.1 only feature, for <= OS2.0
*	            and other systems it will return English text!
*	English
*	Deutsch
*	franais  : For non ISO8859_Latin1-systems this is called francais!
*	espaol   : For non ISO8859_Latin1-systems this is called espanol!
*	portugus : For non ISO8859_Latin1-systems this is called portugues!
*	dansk
*	italiano
*	nederlands
*	norsk
*	svenska
*	polski
*	suomalainen
*
*   BUGS
*	In this version there is no check, if there is enough space in
*	wtext!
*
*   SEE ALSO
*	WeekdayText(),WeekdayShortText(),MonthShortText()
*
*****************************************************************************
*
*
*/

 {
  unsigned short len=0;
  const unsigned short MONTHMAXLEN[13]    = {0,9,9,9,10,9,9,9,9,9,9,11,9};
  const char           MONTHS[13][13][12] = {{"","","","","","","","","","","","",""},
                                             {"","January","February","March","April","May","June","July","August","September","October","November","December"},
                                             {"","Januar","Februar",
                                              #ifdef _ISO8859_Latin1
                                                "Mrz"
                                              #else
                                                "Maerz"
                                              #endif
                                              ,"April","Mai","Juni","Juli","August","September","Oktober","November","Dezember"},
                                             {"","Janvier",
                                              #ifdef _ISO8859_Latin1
                                                "Fvrier"
                                              #else
                                                "Fevrier"
                                              #endif
                                              ,"Mars","Avril","Mai","Juin","Juillet",
                                              #ifdef _ISO8859_Latin1
                                                "Aot"
                                              #else
                                                "Aout"
                                              #endif
                                              ,"Septembre","Octobre","Novembre",
                                              #ifdef _ISO8859_Latin1
                                                "Dcembre"
                                              #else
                                                "Decembre"
                                              #endif
                                             },
                                             {"","enero","febrero","marzo","abril","mayo","junio","julio","agosto","septiembre","octubre","noviembre","diciembre"},
                                             {"","Janeiro","Fevereiro",
                                              #ifdef _ISO8859_Latin1
                                                "Maro"
                                              #else
                                                "Marco"
                                              #endif
                                              ,"Abril","Maio","Junho","Julho","Agosto","Setembro","Outubro","Novembro","Dezembro"},
                                             {"","Januar","Februar","Marts","April","Maj","Juni","Juli","August","September","Oktober","November","December"},
                                             {"","Gennaio","Febbraio","Marzo","Aprile","Maggio","Giugno","Luglio","Agosto","Settembre","Ottobre","Novembre","Dicembre"},
                                             {"","januari","februari","maart","april","mei","juni","juli","augustus","september","oktober","november","december"},
                                             {"","Januar","Februar","Mars","April","Mai","Juni","Juli","August","September","Oktober","November","Desember"},
                                             {"","Januari","Februari","Mars","April","Maj","Juni","Juli","Augusti","September","Oktober","November","December"},
                                             {"",
                                              #ifdef _ISO8859_Latin1
                                                "Stycze?"
                                              #else
                                                "Styczen"
                                              #endif
                                              ,"Luty","Marzec",
                                              #ifdef _ISO8859_Latin1
                                                "Kwiecie?"
                                              #else
                                                "Kwiecien"
                                              #endif
                                              ,"Maj","Czerwiec","Lipiec",
                                              #ifdef _ISO8859_Latin1
                                                "Sierpie?","Wrzesie?","Pa?dziernik"
                                              #else
                                                "Sierpien","Wrzesien","Pazdziernik"
                                              #endif
                                              ,"Listopad",
                                              #ifdef _ISO8859_Latin1
                                                "Grudzie?"
                                              #else
                                                "Grudzien"
                                              #endif
                                             },
                                             {"","tammikuu","helmikuu","maaliskuu","huhtikuu","toukokuu",
                                              #ifdef _ISO8859_Latin1
                                                "kes?kuu","hein?kuu"
                                              #else
                                                "kesakuu","heinakuu"
                                              #endif
                                              ,"elokuu","syyskuu","lokakuu","marraskuu","joulukuu"}
                                            };

  if (mtext != NULL)
   {
    mtext[0] = '\0';
    if (!((month > 0) && (month < 13)))
      return(0);
    switch (lang)
     {
      case Locale  :
      #ifdef _AMIGA
                     if (locale != NULL)
                      {
                       len = mlen;
                       strcpy(mtext,GetLocaleStr(locale,MONS[month-1]));
                       break;
                      }
      #endif
                     lang = English;
      default      : len = MONTHMAXLEN[(unsigned short)lang];
                     strcpy(mtext,MONTHS[(unsigned short)lang][month]);
     }
   }
  return(len);
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   unsigned short WeekdayShortText(const Weekdays wday, char *const wtext, Languages lang)
 #else
   unsigned short __saveds __asm WeekdayShortText(register __d0 const Weekdays wday, register __a0 char *const wtext, register __d1 Languages lang)
 #endif

/*
******* Date/WeekdayShortText ***********************************************
*
*   NAME
*	WeekdayShortText -- Get the weekday as short text string. (V33.092)
*
*   SYNOPSIS
*	maxlen = WeekdayShortText(wday,wtext,lang);
*	d0                         d0   a0    d1
*
*	unsigned short WeekdayShortText(const Weekdays wday,
	    char *const wtext, Languages lang);
*
*   FUNCTION
*	This function gets the short text string for the weekday-number.
*
*   INPUTS
*	wday  - Weekday to transform into a string.
*	wtext - Pointer to a string to fill in the short weekday-text.
*	lang  - Language for wich you want the short weekday-text.
*
*   RESULT
*	maxlen - Maximum possible length for the weekday-string, this should
*	    help you if you want to justify the string right or if you
*	    want to center it! (Normal it's two or three!)
*	    0 indicates an error!
*
*   EXAMPLE
*	...
*	char wtxt[3];
*	...
*	maxlen = WeekdayShortText(Monday,&wtxt,English);
*	...
*
*   NOTES
*	Available languages:
*	Locale    : This is an Amiga >= OS2.1 only feature, for <= OS2.0
*	            and other systems it will return English text!
*	English
*	Deutsch
*	franais  : For non ISO8859_Latin1-systems this is called francais!
*	espaol   : For non ISO8859_Latin1-systems this is called espanol!
*	portugus : For non ISO8859_Latin1-systems this is called portugues!
*	dansk
*	italiano
*	nederlands
*	norsk
*	svenska
*	polski
*	suomalainen
*
*   BUGS
*	In this version there is no check, if there is enough space in
*	wtext!
*
*   SEE ALSO
*	WeekdayText(),MonthText(),MonthShortText()
*
*****************************************************************************
*
*
*/

 {
  unsigned short len=0;
  const unsigned short WEEKDAYMAXLEN[13]  = {0,3,2,3,3,3,
                                             #ifdef _ISO8859_Latin1
                                               3
                                             #else
                                               4
                                             #endif
                                             ,3,2,
                                             #ifdef _ISO8859_Latin1
                                               3,3
                                             #else
                                               4,4
                                             #endif
                                             ,3,3
                                            };
  const char           WEEKDAYS[13][8][5] = {{"","","","","","","",""},
                                             {"","Mon","Tue","Wed","Thu","Fri","Sat","Sun"},
                                             {"","Mo","Di","Mi","Do","Fr","Sa","So"},
                                             {"","Lun","Mar","Mer","Jeu","Ven","Sam","Dim"},
                                             {"","lun","mar","mie","jue","vie","sab","dom"},
                                             {"","Seg","Ter","Qua","Qui","Sex","Sab","Dom"},
                                             {"","Man","Tir","Ons","Tor","Fre",
                                              #ifdef _ISO8859_Latin1
                                                "Lor","Son"
                                              #else
                                                "Lo/r","So/n"
                                              #endif
                                             },
                                             {"","Lun","Mar","Mer","Gio","Ven","Sab","Dom"},
                                             {"","ma","di","wo","do","vr","za","zo"},
                                             {"","Man","Tir","Ons","Tor","Fre",
                                              #ifdef _ISO8859_Latin1
                                                "Lor","Son"
                                              #else
                                                "Lo/r","So/n"
                                              #endif
                                             },
                                             {"",
                                              #ifdef _ISO8859_Latin1
                                                "Mn"
                                              #else
                                                "Ma?n"
                                              #endif
                                              ,"Tis","Ons","Tor","Fre",
                                              #ifdef _ISO8859_Latin1
                                                "Lr","Sn"
                                              #else
                                                "Lo?r","So?n"
                                              #endif
                                             },
                                             {"","Pon","Wto",
                                              #ifdef _ISO8859_Latin1
                                                "?ro"
                                              #else
                                                "Sro"
                                              #endif
                                              ,"Czw",
                                              #ifdef _ISO8859_Latin1
                                                "Pi?"
                                              #else
                                                "Pia"
                                              #endif
                                              ,"Sob","Nie"},
                                             {"","maa","tii","kes","tor","per","lau","sun"}
                                            };

  if (wtext != NULL)
   {
    wtext[0] = '\0';
    switch (lang)
     {
      case Locale :
      #ifdef _AMIGA
                    if (locale != NULL)
                     {
                      len = abwlen;
                      switch (wday)
                       {
                        case Sunday : strcpy(wtext,GetLocaleStr(locale,ABDAY_1));
                                      break;
                        case dayerr : len = 0;
                                      break;
                        default     : strcpy(wtext,GetLocaleStr(locale,ABDAYS[(unsigned short)wday]));
                       }
                      break;
                     }
      #endif
                    lang = English;
      default     : len = WEEKDAYMAXLEN[(unsigned short)lang];
                    if (wday == dayerr)
                      len = 0;
                    else
                      strcpy(wtext,WEEKDAYS[(unsigned short)lang][(unsigned short)wday]);
     }
   }
  return(len);
 }


 #ifndef __MakeLib
   unsigned short MonthShortText(const unsigned short month, char *const mtext, Languages lang)
 #else
   unsigned short __saveds __asm MonthShortText(register __d0 const unsigned short month, register __a0 char *const mtext, register __d1 Languages lang)
 #endif

/*
******* Date/MonthShortText *************************************************
*
*   NAME
*	MonthShortText -- Get the month as short text string. (V33.092)
*
*   SYNOPSIS
*	maxlen = MonthShortText(month,mtext,lang);
*	 d0                       d0   a0    d1
*
*	unsigned short MonthShortText(const unsigned short month,
*	    char *const mtext, Languages lang);
*
*   FUNCTION
*	This function gets the short text string for the month-number.
*
*   INPUTS
*	month - Month to transform into a string.
*	mtext - Pointer to a string to fill in the short month-text.
*	lang  - Language for which you want the short month-text.
*
*   RESULT
*	maxlen - Maximum possible length for the short month-string, this
*	    should help you if you want to justify the string right or if
*	    you want to center it (Normal is three!).
*	    0 indicates an error!
*
*   EXAMPLE
*	...
*	char mtxt[4];
*	...
*	maxlen = MonthShortText(12,&mtxt,English);
*	...
*
*   NOTES
*	Available languages:
*	Locale    : This is an Amiga >= OS2.1 only feature, for <= OS2.0
*	            and other systems it will return English text!
*	English
*	Deutsch
*	franais  : For non ISO8859_Latin1-systems this is called francais!
*	espaol   : For non ISO8859_Latin1-systems this is called espanol!
*	portugus : For non ISO8859_Latin1-systems this is called portugues!
*	dansk
*	italiano
*	nederlands
*	norsk
*	svenska
*	polski
*	suomalainen
*
*   BUGS
*	In this version there is no check, if there is enough space in
*	wtext!
*
*   SEE ALSO
*	WeekdayText(),WeekdayShortText(),MonthText()
*
*****************************************************************************
*
*
*/

 {
  unsigned short len=0;
  const unsigned short MONTHMAXLEN[13]   = {0,3,3,
                                            #ifdef _ISO8859_Latin1
                                              4
                                            #else
                                              5
                                            #endif
                                             ,3,3,3,3,3,3,3,3,3};
  const char           MONTHS[13][13][6] = {{"","","","","","","","","","","","",""},
                                            {"","Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"},
                                            {"","Jan","Feb",
                                             #ifdef _ISO8859_Latin1
                                               "Mr"
                                             #else
                                               "Maer"
                                             #endif
                                             ,"Apr","Mai","Jun","Jul","Aug","Sep","Okt","Nov","Dez"},
                                            {"","Jan",
                                             #ifdef _ISO8859_Latin1
                                               "Fv"
                                             #else
                                               "Fe'v"
                                             #endif
                                             ,"Mars","Avr","Mai","Juin","Juil",
                                             #ifdef _ISO8859_Latin1
                                               "Aot"
                                             #else
                                               "Aou^t"
                                             #endif
                                             ,"Sep","Oct","Nov",
                                             #ifdef _ISO8859_Latin1
                                               "Dc"
                                             #else
                                               "De'c"
                                             #endif
                                            },
                                            {"","ene","feb","mar","abr","may","jun","jul","ago","sep","oct","nov","dic"},
                                            {"","Jan","Fev","Mar","Abr","Mai","Jun","Jul","Ago","Set","Out","Nov","Dez"},
                                            {"","Jan","Feb","Mar","Apr","Maj","Jun","Jul","Aug","Sep","Okt","Nov","Dec"},
                                            {"","Gen","Feb","Mar","Apr","Mag","Giu","Lug","Ago","Set","Ott","Nov","Dic"},
                                            {"","jan","feb","maa","apr","mei","jun","jul","aug","sep","oct","nov","dec"},
                                            {"","Jan","Feb","Mar","Apr","Mai","Jun","Jul","Aug","Sep","Okt","Nov","Des"},
                                            {"","Jan","Feb","Mar","Apr","Maj","Jun","Jul","Aug","Sep","Okt","Nov","Dec"},
                                            {"","Sty","Lut","Mar","Kwi","Maj","Cze","Lip","Sie","Wrz","Pa?","Lis","Gru"},
                                            {"","tam","hel","maa","huh","tou","kes","hei","elo","syy","lok","mar","jou"}
                                           };

  if (mtext != NULL)
   {
    mtext[0] = '\0';
    if (!((month > 0) && (month < 13)))
      return(0);
    switch (lang)
     {
      case Locale  :
      #ifdef _AMIGA
                     if (locale != NULL)
                      {
                       len = abmlen;
                       strcpy(mtext,GetLocaleStr(locale,ABMONS[month-1]));
                       break;
                      }
      #endif
                     lang = English;
      default      : len = MONTHMAXLEN[(unsigned short)lang];
                     strcpy(mtext,MONTHS[(unsigned short)lang][month]);
     }
   }
  return(len);
 }


 #ifndef __MakeLib
   void DateText(const DateTexts dt, char *const text, Languages lang, const bool plural)
 #else
   void __saveds __asm DateText(register __d0 const DateTexts dt, register __a0 char *const text, register __d1 Languages lang, register __d2 const bool plural)
 #endif

/*
******* Date/DateText *******************************************************
*
*   NAME
*	DateText -- Get a date text string. (V33.130)
*
*   SYNOPSIS
*	DateText(dt,mtext,lang,plural);
*	         d0  a0    d1    d2
*
*	void DateText(const DateTexts dt, char *const text,
*	    Languages lang, const bool plural);
*
*   FUNCTION
*	This function gets a date specified text in each supported language
*
*   INPUTS
*	dt     - The text you want.
*	text   - Pointer to a string to fill in the text.
*	lang   - Language for which you want the text.
*	plural - false: The singular form is given.
*	         true : The plural form is given.
*
*   RESULT
*	None
*
*   EXAMPLE
*	...
*	char txt[20];
*	...
*	DateText(day,&txt,English,false);
*	...
*
*   NOTES
*	Available languages:
*	Locale    : This is an Amiga >= OS2.1 only feature, for <= OS2.0
*	            and other systems it will return English text!
*	English
*	Deutsch
*	franais  : For non ISO8859_Latin1-systems this is called francais!
*	espaol   : For non ISO8859_Latin1-systems this is called espanol!
*	portugus : For non ISO8859_Latin1-systems this is called portugues!
*	dansk
*	italiano
*	nederlands
*	norsk
*	svenska
*	polski
*	suomalainen
*
*	Available strings:
*	DAY,MONTH,YEAR,WEEK,WEEKDAY,HOUR,MINUTE,SECOND,YESTERDAY,TODAY,
*	TOMORROW
*
*	In the moment there is only the singular text available!!!
*
*   BUGS
*	In this version there is no check, if there is enough space in
*	text!
*
*   SEE ALSO
*	WeekdayText(),WeekdayShortText(),MonthText(),MonthShortText()
*
*****************************************************************************
*
*
*/

 {
  const char           DATETEXTS[13][11][17] = {{"","","","","","","","","","",""},
                                                {"day","month","year","week","weekday","hour","minute","second","yesterday","today","tomorrow"},
                                                {"Tag","Monat","Jahr","Woche","Wochentag","Stunde","Minute","Sekunde","gestern","heute","morgen"},
                                                {"jour","mois","an","semaine","jour de semaine","heure","minute","seconde","hier","aujourd'hui","demain"},
                                                {
                                                 #ifdef _ISO8859_Latin1
                                                   "da"
                                                 #else
                                                   "dia"
                                                 #endif
                                                 ,"mes",
                                                 #ifdef _ISO8859_Latin1
                                                   "ao"
                                                 #else
                                                   "ano"
                                                 #endif
                                                 ,"semana",
                                                 #ifdef _ISO8859_Latin1
                                                   "da de semana"
                                                 #else
                                                   "dia de semana"
                                                 #endif
                                                 ,"hora","minuto","segundo","ayer","hoy",
                                                 #ifdef _ISO8859_Latin1
                                                   "maana"
                                                 #else
                                                   "manana"
                                                 #endif
                                                },
                                                {"dia",
                                                 #ifdef _ISO8859_Latin1
                                                   "m?s"
                                                 #else
                                                   "mes"
                                                 #endif
                                                 ,"ano","semana","dia da semana","hora","minuto","segundo","ontem","hoje",
                                                 #ifdef _ISO8859_Latin1
                                                   "amann?"
                                                 #else
                                                   "amanna"
                                                 #endif
                                                },
                                                {"dag",
                                                 #ifdef _ISO8859_Latin1
                                                   "m?ned","?r"
                                                 #else
                                                   "maned","ar"
                                                 #endif
                                                 ,"uge","hverdag","time","minut","sekund",
                                                 #ifdef _ISO8859_Latin1
                                                   "i g?r"
                                                 #else
                                                   "i gar"
                                                 #endif
                                                 ,"i dag","i morgen"},
                                                {"giomo","mese","anno","settimana","giomo lavorativo","ora","minuto","secondo","ieri","oggi","domani"},
                                                {"dag","maand","jaar","week","weekdag","ure","minuut","seconde","gisteren","vandaag","morgen"},
                                                {"dag",
                                                 #ifdef _ISO8859_Latin1
                                                   "m?ned","?r"
                                                 #else
                                                   "maned","ar"
                                                 #endif
                                                 ,"uke","ukedag","time","minutt","sekund",
                                                 #ifdef _ISO8859_Latin1
                                                   "i g?r"
                                                 #else
                                                   "i gar"
                                                 #endif
                                                 ,"i dag","i morgen"},
                                                {"dag",
                                                 #ifdef _ISO8859_Latin1
                                                   "m?nad","?r"
                                                 #else
                                                   "manad","ar"
                                                 #endif
                                                 ,"vecka","vardag","timme","minut","sekund",
                                                 #ifdef _ISO8859_Latin1
                                                   "i g?r"
                                                 #else
                                                   "i gar"
                                                 #endif
                                                 ,"i dag","i morgen"},
                                                {"dzien",
                                                 #ifdef _ISO8859_Latin1
                                                   "miesi?c"
                                                 #else
                                                   "miesiac"
                                                 #endif
                                                 ,"lat","tydzien","dzien poweszdni","godzin","minuta","sekunda","wczorja","dzisiaj","jutro"},
                                                {
                                                 #ifdef _ISO8859_Latin1
                                                   "piv"
                                                 #else
                                                   "paiva"
                                                 #endif
                                                 ,"kuukausi","vuosi","viikko",
                                                 #ifdef _ISO8859_Latin1
                                                   "arkipiv"
                                                 #else
                                                   "arkipaiva"
                                                 #endif
                                                 ,"tunti","minuutti","sekunti","eilinen",
                                                 #ifdef _ISO8859_Latin1
                                                   "tnn"
                                                 #else
                                                   "tanaan"
                                                 #endif
                                                 ,"huomenna"}
                                               };

  if (text != NULL)
   {
    text[0] = '\0';
    switch (lang)
     {
      case Locale  :
      #ifdef _AMIGA
                     if (locale != NULL)
                      {
                       char localestr[33];

                       strcpy(localestr,locale->loc_LanguageName);
                       localestr[strchr(localestr,'.')-localestr] = '\x0';
                       if (strcmp(localestr,"deutsch") == 0)
                         lang = Deutsch;
                       else if (strcmp(localestr,"franais") == 0)
                         lang = franais;
                       else if (strcmp(localestr,"espaol") == 0)
                         lang = espaol;
                       else if (strcmp(localestr,"portugus") == 0)
                         lang = portugus;
                       else if (strcmp(localestr,"dansk") == 0)
                         lang = dansk;
                       else if (strcmp(localestr,"italiano") == 0)
                         lang = italiano;
                       else if (strcmp(localestr,"nederlands") == 0)
                         lang = nederlands;
                       else if (strcmp(localestr,"norsk") == 0)
                         lang = norsk;
                       else if (strcmp(localestr,"svenska") == 0)
                         lang = svenska;
                       else /* if (strcmp(localestr,"english") == 0) */
                         lang = English;
                      }
                     else
      #endif
                       lang = English;
      default      : if (!plural)
                       strcpy(text,DATETEXTS[(unsigned short)lang][dt]);
     }
   }
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   #ifndef __cplusplus
     void JDToJulian(const unsigned long jd, unsigned short *const day, unsigned short *const month, int *const year)
   #else
     void JDToJulian(const unsigned long jd, unsigned short &day, unsigned short &month, int &year)
   #endif
 #else
   void __saveds __asm JDToJulian(register __d0 const unsigned long jd, register __a0 unsigned short *const day, register __a1 unsigned short *const month, register __a2 int *const year)
 #endif

/*
******* Date/JDToJulian *****************************************************
*
*   NAME
*	JDToJulian -- Returns the Julian date for a JD. (V33.095)
*
*   SYNOPSIS
*	JDToJulian(jd,day,month,year);
*		   d0 a0   a1    a2
*
*	void JDToJulian(const unsigned long jd, unsigned short *const day,
*	    unsigned short *const month, int *const year);
*
*	void JDToJulian(const unsigned long jd, unsigned short &day,
*	    unsigned short &month, int &year);
*
*   FUNCTION
*	Returns the Julian date for a JD.
*
*   INPUTS
*	jd	- This is the given JD.
*
*   RESULT
*	day	- Day of the date.
*	month	- Month of the date.
*	year	- Year of the date.
*
*   EXAMPLE
*	...
*	JDToJulian(2299160,&day,&month,&year);
*	...
*
*   NOTES
*	It is better to use this function only from 1718867 to 2299160!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	JDToGregorian(),JDToHeis()
*
*****************************************************************************
*
*
*/

 {
  unsigned long a;
  unsigned int  b,c;
  unsigned short d;

  a = jd+1524;
  b = (unsigned int)((a-122.1)/365.25);
  c = (unsigned int)(a-(unsigned long)(365.25*b));
  d = (unsigned short)(c/30.6001);
  #ifndef __cplusplus
    *day = (unsigned short)(c-(unsigned int)(30.6001*d));
    *month = (unsigned short)(d<14 ? d-1 : d-13);
    *year = (int)((*month)>2 ? b-4716 : b-4715);
    if ((*year) < 1)
      (*year)--;
  #else
    day = (unsigned short)(c-(unsigned int)(30.6001*d));
    month = (unsigned short)(d<14 ? d-1 : d-13);
    year = (int)(month>2 ? b-4716 : b-4715);
    if (year < 1)
      year--;
  #endif
 }


 #ifndef __MakeLib
   #ifndef __cplusplus
     void JDToGregorian(const unsigned long jd, unsigned short *const day, unsigned short *const month, int *const year)
   #else
     void JDToGregorian(const unsigned long jd, unsigned short &day, unsigned short &month, int &year)
   #endif
 #else
   void __saveds __asm JDToGregorian(register __d0 const unsigned long jd, register __a0 unsigned short *const day, register __a1 unsigned short *month, register __a2 int *const year)
 #endif

/*
******* Date/JDToGregorian **************************************************
*
*   NAME
*	JDToGregorian -- Returns the Gregorian date for a JD. (V33.095)
*
*   SYNOPSIS
*	JDToGregorian(jd,day,month,year);
*		      d0 a0   a1    a2
*
*	void JDToGregorian(const unsigned long jd, unsigned short *const day,
*	    unsigned short *const month, int *const year);
*
*	void JDToGregorian(const unsigned long jd, unsigned short &day,
*	    unsigned short &month, int &year);
*
*   FUNCTION
*	Returns the Gregorian date for a JD.
*
*   INPUTS
*	jd	- This is the given JD.
*
*   RESULT
*	day	- Day of the date.
*	month	- Month of the date.
*	year	- Year of the date.
*
*   EXAMPLE
*	...
*	JDToGregorian(2299161,&day,&month,&year);
*	...
*
*   NOTES
*	It is better to use this function only from 1718867 to 2889835!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	JDToJulian(),JDToHeis()
*
*****************************************************************************
*
*
*/

 {
  unsigned long a;
  unsigned int  b,c;
  unsigned short d,e;

  if (jd < 2299161L)
   {
    JDToJulian(jd,day,month,year);
   }
  else
   {
    e = (unsigned short)((jd-1867216.25)/36524.25);
    a = jd+1524+1+ e - e/4;
    b = (unsigned int)((a-122.1)/365.25);
    c = (unsigned int)(a-(unsigned long)(365.25*b));
    d = (unsigned short)(c/30.6001);
    #ifndef __cplusplus
      *day = (unsigned short)(c-(unsigned int)(30.6001*d));
      *month = (unsigned short)(d<14 ? d-1 : d-13);
      *year = (int)((*month)>2 ? b-4716 : b-4715);
      if ((*year) < 1)
        (*year)--;
    #else
      day = (unsigned short)(c-(unsigned int)(30.6001*d));
      month = (unsigned short)(d<14 ? d-1 : d-13);
      year = (int)(month>2 ? b-4716 : b-4715);
      if (year < 1)
        year--;
    #endif
   }
 }


 #ifndef __MakeLib
   #ifndef __cplusplus
     void JDToHeis(const unsigned long jd, unsigned short *const day, unsigned short *const month, int *const year)
   #else
     void JDToHeis(const unsigned long jd, unsigned short &day, unsigned short &month, int &year)
   #endif
 #else
   void __saveds __asm JDToHeis(register __d0 const unsigned long jd, register __a0 unsigned short *const day, register __a1 unsigned short *const month, register __a2 int *const year)
 #endif

/*
******* Date/JDToHeis *******************************************************
*
*   NAME
*	JDToHeis -- Returns the Heis date for a JD. (V33.095)
*
*   SYNOPSIS
*	JDToHeis(jd,day,month,year);
*		 d0 a0   a1    a2
*
*	void JDToHeis(const unsigned long jd, unsigned short *const day,
*	    unsigned short *const month, int *const year);
*
*	void JDToHeis(const unsigned long jd, unsigned short &day,
*	    unsigned short &month, int &year);
*
*   FUNCTION
*	Returns the Heis date for a JD.
*
*   INPUTS
*	jd	- This is the given JD.
*
*   RESULT
*	day	- Day of the date.
*	month	- Month of the date.
*	year	- Year of the date.
*
*   EXAMPLE
*	...
*	JDToHeis(2299161,&day,&month,&year);
*	...
*
*   NOTES
*	At the moment this is only a dummy to JDToGregorian, so:
*	It is better to use this function only from 1718867 to 2889835!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	JDToJulian(), JDToGregorian()
*
*****************************************************************************
*
*
*/

 {
  JDToGregorian(jd,day,month,year);
 }

 /* ----------------------------------------------------------------------- */

 static unsigned long GregorianMoonPhaseHelp(const unsigned short day, const unsigned short month, const int year, const MoonPhases phase)

/*
*****i* Date/GregorianMoonPhaseHelp *****************************************
*
*   NAME
*	GregorianMoonPhaseHelp -- Searches for the next moon phase (V33.099)
*
*   SYNOPSIS
*	jd = GregorianMoonPhaseHelp(day,month,year,phase);
*	d0		             d0   d1    d2   d3
*
*	unsigned long GregorianMoonPhaseHelp(const unsigned short day,
*	    const unsigned short month, const int year,
*	    const MoonPhases phase);
*
*   FUNCTION
*	Returns the next moon phase you are searching for after
*	an specified date.
*
*   INPUTS
*	day   - Start day for the search.
*	month - Start month for the search.
*	year  - Start year for the search.
*	phase - The moon phase you want to know.
*
*   RESULT
*	jd - The day (as JD) on wich the moon phase was found.
*
*   EXAMPLE
*	...
*	jd = GregorianMoonPhaseHelp(18,9,1994,FullMoon);
*	JDToGregorian(jd,&day,&month,&year);
*	...
*
*   NOTES
*	The range of this function is unknown for me!
*	So use it only from 1583 to 2500.
*	This is only an experimental version!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	GregorianMoonPhase()
*
*****************************************************************************
*
*
*/

 {
  double y,k,t,t2,jd;

  y = year+(GregorianDayDiff(1,1,year,day,month,year)/(double)GregorianYearDays(year));
  k = floor((y-2000)*12.3685);
  switch (phase)
   {
    case NewMoon      : /* k += 0; */
                        break;
    case FirstQuarter : k += 0.25;
                        break;
    case FullMoon     : k += 0.5;
                        break;
    case LastQuarter  : k += 0.75;
                        /* break; */
   }
  t = k/1236.85;
  t2 = t*t;
  jd = 2451550.09765+29.530588853*k+0.0001337*t2-0.00000015*t2*t+0.00000000073*t2*t2;
  return((unsigned long)jd);
 }


 #ifndef __MakeLib
   unsigned long GregorianMoonPhase(const unsigned short day, const unsigned short month, const int year, const MoonPhases phase)
 #else
   unsigned long __saveds __asm GregorianMoonPhase(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year, register __d3 const MoonPhases phase)
 #endif

/*
******* Date/GregorianMoonPhase *********************************************
*
*   NAME
*	GregorianMoonPhase -- Searches for the next moon phase (V33.098)
*
*   SYNOPSIS
*	jd = GregorianMoonPhase(day,month,year,phase);
*	d0		        d0   d1    d2   d3
*
*	unsigned long GregorianMoonPhase(const unsigned short day,
*	    const unsigned short month, const int year,
*	    const MoonPhases phase);
*
*   FUNCTION
*	Returns the next moon phase you are searching for after
*	a specified date.
*
*   INPUTS
*	day   - Start day for the search.
*	month - Start month for the search.
*	year  - Start year for the search.
*	phase - The moon phase you want to know.
*
*   RESULT
*	jd - The day (as JD) on wich the moon phase was found.
*
*   EXAMPLE
*	...
*	jd = GregorianMoonPhase(18,9,1994,FullMoon);
*	JDToGregorian(jd,&day,&month,&year);
*	...
*
*   NOTES
*	The range of this function is unknown to me!
*	So use it only from 1583 to 2500.
*	This is only an experimental version!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	MoonMonthAge()
*
*****************************************************************************
*
*
*/

 {
  unsigned long jd;

  jd = GregorianMoonPhaseHelp(day,month,year,phase);
  if (jd >= GregorianToJD(day,month,year))
   {
    return(jd);
   }
  else
   {
    unsigned short d,m;
    int y;

    #ifndef __cplusplus
      GregorianDiffDate(day,month,year,25,&d,&m,&y);
    #else
      GregorianDiffDate(day,month,year,25,d,m,y);
    #endif
    jd = GregorianMoonPhaseHelp(d,m,y,phase);
    return(jd);
   }
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   bool ValidJulianDate(const unsigned short day, const unsigned short month, const int year)
 #else
   bool __saveds __asm ValidJulianDate(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year)
 #endif

/*
******* Date/ValidJulianDate ************************************************
*
*   NAME
*	ValidJulianDate -- Checks if the date is a valid date (V33.135)
*
*   SYNOPSIS
*	valid = ValidJulianDate(day,month,year);
*	  d0		         d0   d1  d2
*
*	bool ValidJulianDate(const unsigned short day,
*	    const unsigned short month, const int year);
*
*   FUNCTION
*	ValidJulianDate checks if the date is valid.
*
*   INPUTS
*	day   - Day of the date.
*	month - Month of the date.
*	year  - Year of the date.
*
*   RESULT
*	valid - true  : The date is ok.
*		false : This is not a correct date!
*
*   EXAMPLE
*	...
*	if (ValidJulianDate(29,2,2000))
*	  printf("ok\n");
*	else
*	  printf("wrong date!!!\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	None.
*
*   SEE ALSO
*	ValidTime(),ValidGregorianDate(),ValidHeisDate()
*
*****************************************************************************
*
*
*/

 {
  if ((year >= 8) && (month >= 1) && (month <= 12) && (day >= 1) && (day <= JulianMonthDays(month,year)))
    return(true);
  else
    return(false);
 }


 #ifndef __MakeLib
   bool ValidGregorianDate(const unsigned short day, const unsigned short month, const int year)
 #else
   bool __saveds __asm ValidGregorianDate(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year)
 #endif

/*
******* Date/ValidGregorianDate *********************************************
*
*   NAME
*	ValidGregorianDate -- Checks if the date is a valid date (V33.135)
*
*   SYNOPSIS
*	valid = ValidGregorianDate(day,month,year);
*	  d0		         d0   d1  d2
*
*	bool ValidGregorianDate(const unsigned short day,
*	    const unsigned short month, const int year);
*
*   FUNCTION
*	ValidGregorianDate checks if the date is valid.
*
*   INPUTS
*	day   - Day of the date.
*	month - Month of the date.
*	year  - Year of the date.
*
*   RESULT
*	valid - true  : The date is ok.
*		false : This is not a correct date!
*
*   EXAMPLE
*	...
*	if (ValidGregorianDate(29,2,2000))
*	  printf("ok\n");
*	else
*	  printf("wrong date!!!\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	None.
*
*   SEE ALSO
*	ValidTime(),ValidJulianDate(),ValidHeisDate()
*
*****************************************************************************
*
*
*/

 {
  if ((year == BeforeGregorianYear) && (month == BeforeGregorianMonth))
    if (((day >= 1) && (day <= BeforeGregorianDay)) || ((day >= AfterGregorianDay) && (day <= 31)))
      return(true);
    else
      return(false);
  else if ((year >= 8) && (month >= 1) && (month <= 12) && (day >= 1) && (day <= GregorianMonthDays(month,year)))
    return(true);
  else
    return(false);
 }


 #ifndef __MakeLib
   bool ValidHeisDate(const unsigned short day, const unsigned short month, const int year)
 #else
   bool __saveds __asm ValidHeisDate(register __d0 const unsigned short day, register __d1 const unsigned short month, register __d2 const int year)
 #endif

/*
******* Date/ValidHeisDate **************************************************
*
*   NAME
*	ValidHeisDate -- Checks if the date is a valid date (V33.135)
*
*   SYNOPSIS
*	valid = ValidHeisDate(day,month,year);
*	  d0		         d0   d1  d2
*
*	bool ValidHeisDate(const unsigned short day,
*	    const unsigned short month, const int year);
*
*   FUNCTION
*	ValidHeisDate checks if the date is valid.
*
*   INPUTS
*	day   - Day of the date.
*	month - Month of the date.
*	year  - Year of the date.
*
*   RESULT
*	valid - true  : The date is ok.
*		false : This is not a correct date!
*
*   EXAMPLE
*	...
*	if (ValidHeisDate(29,2,2000))
*	  printf("ok\n");
*	else
*	  printf("wrong date!!!\n");
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	None.
*
*   SEE ALSO
*	ValidTime(),ValidJulianDate(),ValidGregorianDate()
*
*****************************************************************************
*
*
*/

 {
  if (year <= BeforeGregorianYear)
    return(ValidGregorianDate(day,month,year));
  if ((month >= 1) && (month <= 12) && (day >= 1) && (day <= HeisMonthDays(month,year)))
    return(true);
  else
    return(false);
 }

 /* ----------------------------------------------------------------------- */

 #ifndef __MakeLib
   void SetCountry(const Countries country)
 #else
   void __saveds __asm SetCountry(register __d0 const Countries country)
 #endif

/*
******* Date/SetCountry *****************************************************
*
*   NAME
*	SetCountry -- Sets the country defaults for the date lib. (V33.140)
*
*   SYNOPSIS
*	SetCountry(country);
*		     d0
*
*	void SetCountry(const Countries country);
*
*   FUNCTION
*	SetCountry sets the defaults for your country.
*	Like: correct start of gregorian calendar.
*
*   INPUTS
*	country - Country to set.
*
*   RESULT
*	None.
*
*   EXAMPLE
*	...
*	SetCountry(unknown);
*	...
*
*   NOTES
*	Will *not* work correct if something other than 'unknown' is set
*	in the moment!
*
*   BUGS
*	None.
*
*   SEE ALSO
*
*
*****************************************************************************
*
*
*/

 {
  Country = country;
  switch (country)
   {
    case Deutschland  :
    case Schweiz      :
    case Danmark      :
    case Nederland    : BeforeGregorianDay = 17;
                        BeforeGregorianMonth = 2;
                        BeforeGregorianYear = 1700;
                        AfterGregorianDay = 2;
                        AfterGregorianMonth = 3;
                        AfterGregorianYear = 1700;
                        break;
    case GreatBritain : BeforeGregorianDay = 1;
                        BeforeGregorianMonth = 9;
                        BeforeGregorianYear = 1752;
                        AfterGregorianDay = 15;
                        AfterGregorianMonth = 9;
                        AfterGregorianYear = 1752;
                        break;
    /* case Schweden  : BeforeGregorianDay = 16;
                        BeforeGregorianMonth = 2;
                        BeforeGregorianYear = 1753;
                        AfterGregorianDay = 2;
                        AfterGregorianMonth = 3;
                        AfterGregorianYear = 1753;
                        break; */
    case unknown      :
    case Italia       :
    default           : BeforeGregorianDay = 4;
                        BeforeGregorianMonth = 10;
                        BeforeGregorianYear = 1582;
                        AfterGregorianDay = 15;
                        AfterGregorianMonth = 10;
                        AfterGregorianYear = 1582;
   }
 }

 /* ----------------------------------------------------------------------- */

 #include "datetime.c"

 /* ----------------------------------------------------------------------- */
 /* ----------------------------------------------------------------------- */

 #ifdef _AMIGA
   static unsigned short maximum(const unsigned short a, const unsigned short b)

/*
*****i* Date/maximum ********************************************************
*
*   NAME
*	maximum -- Procedure to find the maximum of a and b (V33)
*
*   SYNOPSIS
*	max = maximum(a,b);
*
*	unsigned short maximum(const unsigned short a,
*	    const unsigned short b);
*
*   FUNCTION
*	Calculating the maximum of a and b.
*
*   INPUTS
*	a - First number.
*	b - Second number.
*
*   RESULT
*	max - The maximum of a and b.
*
*   EXAMPLE
*	...
*	max = maximum(10,15); \* Should be 15 *\
*	...
*
*   NOTES
*	None.
*
*   BUGS
*	none.
*
*   SEE ALSO
*
*
*****************************************************************************
*
*
*/

   {
    if (a > b)
      return(a);
    else
     return(b);
   }
 #endif

 /* ----------------------------------------------------------------------- */

 #ifndef __SASC_650
   void _DateInit(void)
 #else
   #ifndef __MakeLib
     void _STI_600__DateInit(void)
   #else
     int __saveds __UserLibInit(struct Library *libbase)
   #endif
 #endif

/*
******* Date/_DateInit ******************************************************
*
*   NAME
*	_DateInit -- Procedure to initialize this module! (V33)
*
*   SYNOPSIS
*	_DateInit();
*
*	void _DateInit(void);
*
*   FUNCTION
*	Initialize this module, like the modulebody in Modula-II or Oberon-2
*
*   INPUTS
*	None.
*
*   RESULT
*	None.
*
*   EXAMPLE
*	...
*	_DateInit();
*	...
*
*   NOTES
*	This function is only needed/available if you do not compile this
*	with a SAS C Compiler (using Autoinitialization!)
*	If you are not using SASC - don't forget to init this module with
*	this function - or you will get into trouble!!!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	_DateCleanup()
*
*****************************************************************************
*
*
*/

 {/* Dates of Gregorian reform in
     Rom:
       5.10.1582-14.10.1582
     Deutschland, Niederlande, Schweiz, Dnemark:
       18.02.1700-01.03.1700
     Grobritannien
       02.09.1752-14.09.1752
     Schweden
       17.02.1753-01.03.1753
     Ruland
       ? (oktober Revolution)
     Griechenland
       ??.??.1923-??.??.1923 */
  /* Bremen/Arbergen = 8 55' 23" East, 53 4' 8" North */
  #ifdef _AMIGA
    #ifndef __SASC_650
      LocaleBase = OpenLibrary("locale.library",0);
    #endif
    if (LocaleBase != NULL)
     {
      locale = OpenLocale(NULL);
      if (locale != NULL)
       {
        unsigned short i;

        wlen = (unsigned short)strlen(GetLocaleStr(locale,DAY_1));
        abwlen = (unsigned short)strlen(GetLocaleStr(locale,ABDAY_1));
        for (i=1;i<7;i++)
         {
          wlen = maximum(wlen,strlen(GetLocaleStr(locale,DAYS[i])));
          abwlen = maximum(abwlen,strlen(GetLocaleStr(locale,ABDAYS[i])));
         }
        mlen = (unsigned short)strlen(GetLocaleStr(locale,MON_1));
        abmlen = (unsigned short)strlen(GetLocaleStr(locale,ABMON_1));
        for (i=1;i<12;i++)
         {
          mlen = maximum(mlen,strlen(GetLocaleStr(locale,MONS[i])));
          abmlen = maximum(abmlen,strlen(GetLocaleStr(locale,ABMONS[i])));
         }
       }
     }
  #endif
  #ifdef __MakeLib
    return(0);
  #endif
 }


 #ifndef _SASC_650
   void _DateCleanup(void)
 #else
   #ifndef __MakeLib
     void _STD_600__DateCleanup(void)
   #else
     void __saveds __UserLibCleanup(struct Library *libbase)
   #endif
 #endif

/*
******* Date/_DateCleanup ***************************************************
*
*   NAME
*	_DateCleanup -- Procedure to cleanup this module! (V33)
*
*   SYNOPSIS
*	_DateCleanup();
*
*	void _DateCleanup(void);
*
*   FUNCTION
*	Cleanup this module, after using!
*
*   INPUTS
*	None.
*
*   RESULT
*	None.
*
*   EXAMPLE
*	...
*	_DateCleanup();
*	...
*
*   NOTES
*	This function is only needed/available if you do not compile this
*	with a SAS C Compiler (using Autoinitialization!)
*	If you are not using SASC - don't forget to cleanup this module with
*	this function - or you will get into trouble!!!
*
*   BUGS
*	unknown.
*
*   SEE ALSO
*	_DateInit()
*
*****************************************************************************
*
*
*/

 {
  #ifdef _AMIGA
  if (locale != NULL)
    CloseLocale(locale);
    #ifndef __SASC_650
      if (LocaleBase != NULL)
        CloseLibrary(LocaleBase);
    #endif
  #endif
 }
