/* mycopy.h                     freeware                   xhunga@tiscali.fr  */

/* ------------------------------ FUNCTION -------------------------- mcopy() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int copymF(
pmatrix mIn,
pmatrix mOut)
{
  int i,j;
  if (mIn->rows != mOut->rows || mIn-> cols != mOut->cols)
    {
     printf("\n copym() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (i = 0 ; i < mIn->rows ; i++)
    for ( j = 0; j < mIn->cols ; j++)
      *(mOut->pblock + i *mOut->cols + j) = *(mIn->pblock + i *mIn->cols + j);
  return(0);
}


/* ------------------------------ FUNCTION ------------------------- copyrow() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int copyrowF(
pmatrix mIn,
    int rowIn,
pmatrix mOut,
    int rowOut)
{
int j;

  if (mIn-> cols != mOut->cols)
    {
     printf("\n copyrow() error - columns different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }

    for ( j = 0; j < mIn->cols ; j++)
            *(mOut->pblock + rowOut *mOut->cols + j) = \
            *(mIn->pblock  + rowIn   *mIn->cols + j);

  return(0);
}

/* ------------------------------ FUNCTION ------------------------ copycol() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int copycolF(
pmatrix mIn,
    int colIn,
pmatrix mOut,
    int colOut)
{
int i;

  if (mIn-> rows != mOut->rows)
    {
     printf("\n copycol() error - rows different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }

    for ( i = 0; i < mIn->rows ; i++)
      {
            *(mOut->pblock + i *mOut->cols + colOut * 2 )      = \
            *(mIn->pblock  + i *mIn->cols  + colIn  * 2 );
            *(mOut->pblock + i *mOut->cols + colOut * 2 + 1 ) = \
            *(mIn->pblock  + i *mIn->cols  + colIn  * 2 + 1 );
      }
  return(0);
}


