/*
 * XMODEM file transfer module for LAPTALK...
 *
 * Copyright 1991-1994 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile with DDS MICRO-C compiler in 8086 TINY model.
 *
 * Compile command: cc xmodem -fop
 */
#include <stdio.h>
#include <window.h>
#include <comm.h>

/* Transfer status codes */
#define	INIT		0		/* Initializing line */
#define	RX			1		/* Receive packet */
#define	TX			2		/* Transmitting packet */
#define	TIMEOUT		3		/* Timeout occured */
#define	RNAK		4		/* Nak received */
#define	ERROR		5		/* Checksum/CRC error */
#define ABORT		6		/* Abort request */
#define	ENDF		7		/* End of file */
#define	DUP			8		/* Duplicate packet */
#define	SEQ			9		/* Out of sequence */

/* Line control codes */
#define SOH			0x01	/* start of header */
#define ACK			0x06	/* Acknowledge */
#define NAK			0x15	/* Negative acknowledge */
#define CAN			0x18	/* Cancel */
#define EOT			0x04	/* end of text */

char *baudtext[] = {
	"110", "300", "1200", "2400", "4800", "9600", "19200", "38400" };

unsigned baudvalue[] = {
	_110, _300, _1200, _2400, _4800, _9600, _19200, _38400 };

unsigned baud=3, block_num = 0, rx_block, last_stat = 0,
	size = 128, port = 1, ccount = 3;

char *status_text[] = {
	"Initiate", "RX packet", "TX packet", "Timeout", "NAK received",
	"Bad Packet", "Abort", "End of file", "Duplicate", "Sequence error" };

char *filename = 0, upload = -1, pause = 0, crc = -1, last_crc = -2,
	fill = 'Z'-0x40;

FILE *fp;

unsigned crctable[256] = {
    0x0000,  0x1021,  0x2042,  0x3063,  0x4084,  0x50a5,  0x60c6,  0x70e7,
    0x8108,  0x9129,  0xa14a,  0xb16b,  0xc18c,  0xd1ad,  0xe1ce,  0xf1ef,
    0x1231,  0x0210,  0x3273,  0x2252,  0x52b5,  0x4294,  0x72f7,  0x62d6,
    0x9339,  0x8318,  0xb37b,  0xa35a,  0xd3bd,  0xc39c,  0xf3ff,  0xe3de,
    0x2462,  0x3443,  0x0420,  0x1401,  0x64e6,  0x74c7,  0x44a4,  0x5485,
    0xa56a,  0xb54b,  0x8528,  0x9509,  0xe5ee,  0xf5cf,  0xc5ac,  0xd58d,
    0x3653,  0x2672,  0x1611,  0x0630,  0x76d7,  0x66f6,  0x5695,  0x46b4,
    0xb75b,  0xa77a,  0x9719,  0x8738,  0xf7df,  0xe7fe,  0xd79d,  0xc7bc,
    0x48c4,  0x58e5,  0x6886,  0x78a7,  0x0840,  0x1861,  0x2802,  0x3823,
    0xc9cc,  0xd9ed,  0xe98e,  0xf9af,  0x8948,  0x9969,  0xa90a,  0xb92b,
    0x5af5,  0x4ad4,  0x7ab7,  0x6a96,  0x1a71,  0x0a50,  0x3a33,  0x2a12,
    0xdbfd,  0xcbdc,  0xfbbf,  0xeb9e,  0x9b79,  0x8b58,  0xbb3b,  0xab1a,
    0x6ca6,  0x7c87,  0x4ce4,  0x5cc5,  0x2c22,  0x3c03,  0x0c60,  0x1c41,
    0xedae,  0xfd8f,  0xcdec,  0xddcd,  0xad2a,  0xbd0b,  0x8d68,  0x9d49,
    0x7e97,  0x6eb6,  0x5ed5,  0x4ef4,  0x3e13,  0x2e32,  0x1e51,  0x0e70,
    0xff9f,  0xefbe,  0xdfdd,  0xcffc,  0xbf1b,  0xaf3a,  0x9f59,  0x8f78,
    0x9188,  0x81a9,  0xb1ca,  0xa1eb,  0xd10c,  0xc12d,  0xf14e,  0xe16f,
    0x1080,  0x00a1,  0x30c2,  0x20e3,  0x5004,  0x4025,  0x7046,  0x6067,
    0x83b9,  0x9398,  0xa3fb,  0xb3da,  0xc33d,  0xd31c,  0xe37f,  0xf35e,
    0x02b1,  0x1290,  0x22f3,  0x32d2,  0x4235,  0x5214,  0x6277,  0x7256,
    0xb5ea,  0xa5cb,  0x95a8,  0x8589,  0xf56e,  0xe54f,  0xd52c,  0xc50d,
    0x34e2,  0x24c3,  0x14a0,  0x0481,  0x7466,  0x6447,  0x5424,  0x4405,
    0xa7db,  0xb7fa,  0x8799,  0x97b8,  0xe75f,  0xf77e,  0xc71d,  0xd73c,
    0x26d3,  0x36f2,  0x0691,  0x16b0,  0x6657,  0x7676,  0x4615,  0x5634,
    0xd94c,  0xc96d,  0xf90e,  0xe92f,  0x99c8,  0x89e9,  0xb98a,  0xa9ab,
    0x5844,  0x4865,  0x7806,  0x6827,  0x18c0,  0x08e1,  0x3882,  0x28a3,
    0xcb7d,  0xdb5c,  0xeb3f,  0xfb1e,  0x8bf9,  0x9bd8,  0xabbb,  0xbb9a,
    0x4a75,  0x5a54,  0x6a37,  0x7a16,  0x0af1,  0x1ad0,  0x2ab3,  0x3a92,
    0xfd2e,  0xed0f,  0xdd6c,  0xcd4d,  0xbdaa,  0xad8b,  0x9de8,  0x8dc9,
    0x7c26,  0x6c07,  0x5c64,  0x4c45,  0x3ca2,  0x2c83,  0x1ce0,  0x0cc1,
    0xef1f,  0xff3e,  0xcf5d,  0xdf7c,  0xaf9b,  0xbfba,  0x8fd9,  0x9ff8,
    0x6e17,  0x7e36,  0x4e55,  0x5e74,  0x2e93,  0x3eb2,  0x0ed1,  0x1ef0 };

/*
 * Main routine
 */
main(argc, argv)
	int argc;
	char *argv[];
{
	int i, j;
	char *ptr, *buffer;

	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++)<<8)|toupper(*ptr++)) {
			case '-D' : upload = 0;	break;
			case '-P' :	pause = -1;	break;
			case '-C' :	crc = 0;	break;
			case 'R=' :	size = atoi(ptr);	break;
			case 'P=' : port = atoi(ptr);	break;
			case 'F=' :	fill = atoi(ptr);	break;
			case 'S=' :		/* Speed */
				for(j=0; j < (sizeof(baudtext)/2); ++j) {
					if(!strcmp(ptr, baudtext[j])) {
						baud = j;
						goto gobreak; } }
				abort("XMODEM: Unknown baud rate");
			default :
				if(filename)
					abort("XMODEM: Too many operands");
				filename = argv[i];
			gobreak: } }

	if(!filename)
		abort("\nUse: XMODEM <filename> [-C -D -P R=size P=port F=value S=speed]\n\nCopyright 1991-1994 Dave Dunfield\nAll rights reserved.\n");

	buffer = malloc(size);

	wopen(15, 6, 50, 13, WSAVE|WCOPEN|WBOX1|0x70);
	wcursor_off();

	wgotoxy(1, 1); printf("XMODEM %s of %s", upload ? "Upload" : "Download", filename);

	if(!(fp = fopen(filename, upload ? "rb" : "wb"))) {
		wgotoxy(8, 5); wputs(" ** Unable to access file! **");
		pause = -1;
		goto doexit1; }

	Copen(port, baudvalue[baud], PAR_NO|STOP_1|DATA_8, SET_RTS|SET_DTR|OUTPUT_2);

	disable();
	Cflags |= TRANSPARENT;
	enable();

	wgotoxy(1, 3); printf("Record size    : %u", size);
	wgotoxy(1, 5); printf("Blockcheck     :");
	wgotoxy(1, 7); printf("Transfer status: %s", status_text[0]);
	wgotoxy(1, 9); printf("Record count   : %u", block_num);

	if(!upload) {
		Cputc(crc ? 'C' : NAK);
upld:
		update_status(i = get_record(buffer));
		switch(i) {
			case RX :
				if(rx_block == (++block_num & 255)) {
					fwrite(buffer, size, fp);
					Cputc(ACK);
					wgotoxy(18, 9); wprintf("%u", block_num);
					goto upld; }
				if(rx_block == (--block_num & 255)) {
					Cputc(ACK);
					update_status(DUP);
					goto upld;}
				update_status(SEQ);
			case ERROR :
				do {
					if((i = get_char(1)) == -2)
						goto doabort; }
				while(i != -1);
				Cputc(NAK);
				goto upld;
			case TIMEOUT :
				if(!block_num) {
					if(crc && ccount) {
						--ccount;
						Cputc('C');
						goto upld; }
					crc = 0; }
				Cputc(NAK);
			default:
				goto upld;
			case ENDF :
				Cputc(ACK);
			doabort:
			case ABORT: } }

	else {
/* First, handshake for CRC option */
		if(!crc)
			goto dnl1;
		crc = 0;
dnl0:	switch(get_char(10)) {
			default: goto dnl0;	
			case 'C' :
				crc = -1;
				break;
			case -2: Cputc(CAN); goto doexit;
			case NAK :
				crc = 0; }
dnl1:	if(j = fread(buffer, size, fp)) {
			for(i=j; i < size; ++i)
				buffer[i] = fill;
dnl2:		update_status(i = send_record(buffer));
			switch(i) {
				case TX :
					wgotoxy(18, 9); wprintf("%u", ++block_num);
					goto dnl1;
				case RNAK :
				case TIMEOUT :
					goto dnl2;
				case ABORT :
					Cputc(CAN);
					goto doexit;
			default: } }
		else
			update_status(ENDF);
dnl3:	Cputc(EOT);
dnl4:	switch(i = get_char(1)) {
			case NAK :
			case -1 : goto dnl3;
			default : goto dnl4;
			case -2 :
			case ACK: } }

doexit:
	fclose(fp);
	Cclose();

doexit1:
	if(pause) {
		wgotoxy(10, 10);
		wputs("<Press any key to proceed>");
		wgetc(); }

	wclose();
}

/*
 * Update the status message
 */
update_status(msg)
	int msg;
{
	if(msg != last_stat) {
		wgotoxy(18, 7);
		wputs(status_text[last_stat = msg]);
		wcleol(); }
	if(crc != last_crc) {
		wgotoxy(18, 5);
		wputs((last_crc = crc) ? "Crc" : "Checksum");
		wcleol(); }
}


/*
 * Send an XMODEM record
 */
send_record(data)
	char *data;
{
	unsigned i, c, chk;

	Cputc(SOH);
	Cputc(block_num+1);
	Cputc(~(block_num+1));
	for(i=chk=0; i < size; ++i) {
		Cputc(c = *data++);
		chk = crc ? crctable[chk >> 8] ^ (chk << 8) ^ c : chk + c; }
	if(crc)
		Cputc(chk >> 8);
	Cputc(chk);

	for(;;) switch(get_char(1)) {
		case -1	 : return TIMEOUT;
		case -2  :
		case CAN : return ABORT;
		case NAK : return RNAK;
		case ACK : return TX;
		case 'C' :
			if(!block_num) {
				crc = -1;
				return RNAK; } }
}

/*
 * Get an XMODEM record
 */
get_record(data)
	char *data;
{
	unsigned i, j, chk;

get1:switch(get_char(3)) {
		case -1  : return TIMEOUT;
		case -2  :
		case CAN : return ABORT;
		case NAK : return RNAK;
		case EOT : return ENDF;
		case 'C' :
			if(!block_num) {
				crc = -1;
				return RNAK; }
		default  : goto get1;
		case SOH : }
	switch(rx_block = get_char(1)) {
		case -1 : return TIMEOUT;
		case -2 : return ABORT; }
	switch((i = get_char(1))) {
		case -1 : return TIMEOUT;
		case -2 : return ABORT; }
	if(rx_block != (255 & ~i))
		return ERROR;
	for(chk = i = 0; i < size; ++i) {
		switch(j = get_char(1)) {
			case -1 : return TIMEOUT;
			case -2 : return ABORT; }
		*data++ = j;
		chk = (crc) ? crctable[chk >> 8] ^ (chk << 8) ^ j : chk + j; }
	switch(i = get_char(1)) {
		case -1 : return TIMEOUT;
		case -2 : return ABORT; }
	if(crc) {
		switch(j = get_char(1)) {
			case -1 : return TIMEOUT;
			case -2 : return ABORT; }
		if(chk != ((i << 8) + j))
			return ERROR;
		return RX; }
	if(i != (chk & 0xFF))
		return ERROR;
	return RX;
}

/*
 * Get a character from the comm port with timeout
 */
get_char(timeout)
	int timeout;
{
	int c, j, s, os;

	os = -1;
	timeout += 2;
	do {
		if((c = Ctestc()) != -1)
			return c;
		if(wtstc() == 0x1B) {
			return -2; }
		get_time(&j, &j, &s);
		if(s != os) {
			os = s;
			--timeout; } }
	while(timeout);
	return -1;
}
