/*
 * sample 9
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mgui.h"

void ExitCB(MOBJECT obj, void *a, void *b)
{
	MShellDestroy(MObjectShell(obj));
	MGUITerm();
	exit(0);
}

void AppTimerCB(TIMEOUT_ID id, void *sbar)
{
	static int perc;
	char str[128];

	perc += 10;
	sprintf(str, "%d %%", perc);
	MObjectSetText((MOBJECT )sbar, str);
	MStatusBarSetPos((MOBJECT )sbar, perc);
	if (perc < 100)
		MAddTimeout(500L, AppTimerCB, sbar);
	else
		MObjectSetSensitive((MOBJECT)MObjectGetUserData(sbar));
}

void MGUIMain(int argc, char **argv)
{
	MOBJECT shell, pb, statusbar;

	shell = MCreateShell("Sample 9", 0);

	statusbar = MCreateStatusBar(shell, "0 %", 100, DEFAULT_FONT);
	pb = MCreatePButton(shell, "Quit", TIMES_L_FONT);
	MPButtonSetCallback(pb, ExitCB, statusbar);
	MObjectSetUnsensitive(pb);
	MObjectSetUserData(statusbar, pb);

	MAddTimeout(500L, AppTimerCB, statusbar);

	MShellRealize(shell);

	MMainLoop();
}
