/*
 *    File objman.c
 *      Demonstrates the Object hierarchy manipulation
 *      and Object mapping/unmapping
 */

#include <stdio.h>

#include "mgui.h"

/*
 *    Callback for closing and destroying a generic dialog
 */
extern void CloseDialogCB(MOBJECT p, void *s, void *v);

extern MTColor black, white, darkblue, cadetblue, seagreen;

/*****************************************************
 *	This Callback maps the Object pointed to by
 *	the user data.
 *****************************************************/
void 
MapObjectCB(MOBJECT p, void *s, void *object)
{
    MObjectMap((MOBJECT) object);
}

/*****************************************************
 *	This Callback unmaps the Object pointed to by
 *	the callback application data.
 *****************************************************/
void 
UnmapObjectCB(MOBJECT p, void *s, void *object)
{
    extern MOBJECT mainshell;

    MObjectUnmap((MOBJECT) object);
}

/*****************************************************
 *	This Callback creates a LABEL Object as child
 *	of the form pointed to by the callback application data.
 *****************************************************/
void 
AddChildCB(MOBJECT p, void *s, void *form)
{
    char str[32];
    static int nc;

    sprintf(str, "Label # %d", ++nc);
    MCreateLabel((MOBJECT) form, str, FIXED_MEDIUM);
}

/*****************************************************
 *	This Callback moves the Object caller 'p' to the
 *	position occupied by the Object 'ins'.
 *****************************************************/
void 
MoveChildCB(MOBJECT p, void *s, void *ins)
{
    MOBJECT parent = MObjectParent(p);

    MDeleteObject(p, False);
    MInsertObject(parent, p, (MOBJECT) ins, False);
}

/*****************************************************
 *	This Callback causes the Object caller 'p' to
 *	change parent.
 *****************************************************/
void 
ReparentChildCB(MOBJECT p, void *s, void *parent)
{
    MReparentObject((MOBJECT) parent, p, NULL);
}

/*****************************************************
 *	This Callback causes the parent of the Object
 *	caller 'p' to change parent.
 *****************************************************/
void 
ReparentFormCB(MOBJECT p, void *s, void *parent)
{
    MReparentObject((MOBJECT) parent, MObjectParent(p), NULL);
}

/*****************************************************
 *	This Callback causes the Object caller 'p' to
 *	be removed from the hierachy and destroyed
 *****************************************************/
void 
DelChildCB(MOBJECT p, void *s, void *a)
{
    MObjectDestroy(p);
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void 
ObjectManageCB(MOBJECT o, void *o_data, void *a_data)
{
    MOBJECT shell, form, sform;
    MOBJECT pbutton, pbak, sfile;

    shell = MCreateShell("Test Object Management", 0);

    form = MCreateColForm(shell);

    sform = MCreateScrolledRowForm(form, 180, 150);
    MObjectSetName(sform, "Scrolled Form");
    MObjectSetName(MObjectParent(sform), "Scrolled Form Parent");

    sfile = MCreateSFile(form, __FILE__, FIXED_MEDIUM, 10, 54);
    MObjectSetColor(sfile, darkblue, white);

    form = MCreateRowForm(shell);

    pbutton = MCreatePButton(form, "Move Me Last 1", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, MoveChildCB, 0L);
    pbak = pbutton;
    pbutton = MCreatePButton(form, "Move Me First 1", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, MoveChildCB, pbak);
    pbutton = MCreatePButton(form, "Move Me Last 2 ", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, MoveChildCB, 0L);
    pbak = pbutton;
    pbutton = MCreatePButton(form, "Move Me First 2", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, MoveChildCB, pbak);

    form = MCreateColForm(shell);
    MObjectSetName(form, "Buttons Form");
    MObjectSetName(MObjectParent(form), "Parent of the Buttons Form");

    pbutton = MCreatePButton(form, "&Add Child SForm", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, AddChildCB, sform);
    pbutton = MCreatePButton(form, "Add Child &Shell", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, AddChildCB, shell);
    pbutton = MCreatePButton(form, "Delete Me (Alt+D)", TIMES_MEDIUM);
    MButtonSetAccelerator(pbutton, A_D);
    MObjectSetName(pbutton, "Button Delete Me");
    MPButtonSetCallback(pbutton, DelChildCB, 0L);
    pbutton = MCreatePButton(form, "Reparent\nMe (Ctrl+R)", TIMES_MEDIUM);
    MButtonSetAccelerator(pbutton, C_R);
    MObjectSetName(pbutton, "Button Reparent Me");
    MPButtonSetCallback(pbutton, ReparentChildCB, sform);
    pbutton = MCreatePButton(form, "Reparent\n&My Parent", TIMES_MEDIUM);
    MObjectSetName(pbutton, "Button Reparent My Parent");
    MPButtonSetCallback(pbutton, ReparentFormCB, sform);
    pbutton = MCreatePButton(form, "Close (C)", TIMES_MEDIUM);
    MButtonSetAccelerator(pbutton, 'c');
    MPButtonSetCallback(pbutton, CloseDialogCB, 0L);

    pbak = form;
    form = MCreateColForm(shell);

    pbutton = MCreatePButton(form, "Map Button Form", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, MapObjectCB, pbak);
    pbutton = MCreatePButton(form, "Unmap Button Form", TIMES_MEDIUM);
    MPButtonSetCallback(pbutton, UnmapObjectCB, pbak);

    MShellRealize(shell);
}
