/* xcpivot.h                   freeware                   xhunga@tiscali.fr  */

/* ------------------------------ FUNCTION -------------------- pivotntzero() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int pivotntzeroF(
pmatrix mA,
int row1,
int row2)
{
   int sign = 1;
double pivot;
double t;

  pivot = *(mA->pblock + row1 *mA->cols + row2 * TWOCOL);
  if(!pivot)
  {
   row2 = row1 + 1;
   do
   {
    t = *(mA->pblock + row2 *mA->cols + row1 * TWOCOL);
    if(t)
    {
     swaprowF(mA,row1,row2);
     row2 = mA->rows;
     sign = -1;
    }
    row2++;
   }
   while(row2 < mA->rows);
  }
return(sign);
}

/* ------------------------------ FUNCTION --------------------- pivotbestF() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int pivotbestFdenom(
pmatrix m,
    int row,
    int col)
{
fraction      pivot;
fraction belowpivot;
   int  sign =       1;
   int  row2 = row + 1;

      frowminiF(m,row);

  pivot.numer = (*(m->pblock + row *m->cols + col  * TWOCOL    ));
  pivot.denom = (*(m->pblock + row *m->cols + col  * TWOCOL + 1));

   while(row2 < m->rows)
   {
    frowminiF(m,row2);
    belowpivot.numer = *(m->pblock + row2 *m->cols + col * TWOCOL    );
    belowpivot.denom = *(m->pblock + row2 *m->cols + col * TWOCOL + 1);

       if(fabs(belowpivot.denom) < fabs(pivot.denom))
         {
          if(belowpivot.numer)
            {
             swaprowF(m,row,row2);
        pivot.numer = belowpivot.numer;
        pivot.denom = belowpivot.denom;
              sign *= -1;
            }
         }

       if(fabs(belowpivot.denom) == fabs(pivot.denom))
         {
          if(belowpivot.numer)
           {
           if(fabs(belowpivot.numer) < fabs(pivot.numer))
            {
             swaprowF(m,row,row2);
        pivot.numer = belowpivot.numer;
        pivot.denom = belowpivot.denom;
             sign *= -1;
            }
          }
         }
    row2++;
   }

return(sign);
}


/* ------------------------------ FUNCTION --------------------- pivotbestF() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int pivotbestFnumermax(
pmatrix m,
    int row,
    int col)
{
fraction      pivot;
fraction belowpivot;
   int  sign =       1;
   int  row2 = row + 1;

      frowminiF(m,row);

  pivot.numer = (*(m->pblock + row *m->cols + col  * TWOCOL    ));
  pivot.denom = (*(m->pblock + row *m->cols + col  * TWOCOL + 1));

   while(row2 < m->rows)
   {
    frowminiF(m,row2);
    belowpivot.numer = *(m->pblock + row2 *m->cols + col * TWOCOL    );
    belowpivot.denom = *(m->pblock + row2 *m->cols + col * TWOCOL + 1);

       if(fabs(belowpivot.numer) > fabs(pivot.numer))
         {
            {
             swaprowF(m,row,row2);
        pivot.numer = belowpivot.numer;
        pivot.denom = belowpivot.denom;
              sign *= -1;
            }
         }

       if(fabs(belowpivot.numer) == fabs(pivot.numer))
         {
           if(fabs(belowpivot.denom) > fabs(pivot.denom))
            {
             swaprowF(m,row,row2);
        pivot.numer = belowpivot.numer;
        pivot.denom = belowpivot.denom;
             sign *= -1;
            }
         }
    row2++;
   }

return(sign);
}

/* ------------------------------ FUNCTION --------------------- pivotbestF() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
int pivotbestFnumer(
pmatrix m,
    int row,
    int col)
{
fraction      pivot;
fraction belowpivot;
   int  sign =       1;
   int  row2 = row + 1;

      frowminiF(m,row);

  pivot.numer = (*(m->pblock + row *m->cols + col  * TWOCOL    ));
  pivot.denom = (*(m->pblock + row *m->cols + col  * TWOCOL + 1));

   while(row2 < m->rows)
   {
    frowminiF(m,row2);
    belowpivot.numer = *(m->pblock + row2 *m->cols + col * TWOCOL    );
    belowpivot.denom = *(m->pblock + row2 *m->cols + col * TWOCOL + 1);

       if(fabs(belowpivot.numer) < fabs(pivot.numer))
         {
          if(belowpivot.numer)
            {
             swaprowF(m,row,row2);
        pivot.numer = belowpivot.numer;
        pivot.denom = belowpivot.denom;
              sign *= -1;
            }
         }

       if(fabs(belowpivot.numer) == fabs(pivot.numer))
         {
           if(fabs(belowpivot.denom) < fabs(pivot.denom))
            {
             swaprowF(m,row,row2);
        pivot.numer = belowpivot.numer;
        pivot.denom = belowpivot.denom;
             sign *= -1;
            }
         }
    row2++;
   }

return(sign);
}



/* ------------------------------ FUNCTION -------------------- pivotntzero() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void pivotminiF(
pmatrix mA)
{
   int row;
fraction f;

  for (row = 0 ; row < mA->rows ; row++)
   {
   f.numer =  (*(mA->pblock + row *mA->cols + row * TWOCOL     ));
   f.denom =  (*(mA->pblock + row *mA->cols + row * TWOCOL  + 1));

    if((f.numer))
      {
         f = invF(f);
         mulrowF(mA,row,f);
       frowminiF(mA,row);
      }
   }
}


/* ------------------------------ FUNCTION ------------------------- addrow() */
/* returns a copy of the matrix m in which row r2 is replaced  by (s*r1 + r2) */
/* -------------------------------------------------------------------------- */
void pivotworkF(
pmatrix mA,
int     row1,
int     row2)
{
int      j;
double   t;
fraction f;
fraction fr2;
fraction pivot;

   fr2.numer = -(*(mA->pblock + row2 *mA->cols + row1 * TWOCOL     ));
   fr2.denom =   *(mA->pblock + row2 *mA->cols + row1 * TWOCOL  + 1);

 pivot.numer =  (*(mA->pblock + row1 *mA->cols + row1 * TWOCOL     ));
 pivot.denom =   *(mA->pblock + row1 *mA->cols + row1 * TWOCOL  + 1);


 for ( j = 0 ; j < mA->cols ; j++,j++ )
    {
/* ---------------------------------------------------------------- numerator */
                                                          f.numer = \
                       (
                   fr2.numer * *(mA->pblock + row1 *mA->cols + j     )\
                               * \
                 pivot.denom * *(mA->pblock + row2 *mA->cols + j  + 1)\
                        )
                        + \
                        (
                 pivot.numer * *(mA->pblock + row2 *mA->cols + j      )\
                             * \
                  fr2.denom  * *(mA->pblock + row1 *mA->cols + j  + 1 )
                         );
/* -------------------------------------------------------------- denominator */
                                                       f.denom = \
           fr2.denom * *(mA->pblock + row1 *mA->cols + j   + 1)  * \
         pivot.denom * *(mA->pblock + row2 *mA->cols + j   + 1);

          if(!f.numer){ f.denom = 1;}

          f = miniF(f);

    *(mA->pblock + row2 *mA->cols + j    ) = f.numer;
    *(mA->pblock + row2 *mA->cols + j + 1) = f.denom;
    }
}

