/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"
#define mxr 5
#define mxc 5

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
amnsb_C(int n,int p)
{
int      i;
int      j;
fraction a;
fraction b;
fraction amnsb;

double pbC     [mxr][mxc*TWOCOL];matrix mC     ={mxr,mxc*TWOCOL,&pbC    [0][0]};
double pbaC    [mxr][mxc*TWOCOL];matrix maC    ={mxr,mxc*TWOCOL,&pbaC   [0][0]};
double pbbC    [mxr][mxc*TWOCOL];matrix mbC    ={mxr,mxc*TWOCOL,&pbbC   [0][0]};

double pamnsb_C [mxr][mxc*TWOCOL];
matrix mamnsb_C={mxr, mxc*TWOCOL,&pamnsb_C[0][0]};
double paCmnsbC [mxr][mxc*TWOCOL];
matrix maCmnsbC={mxr, mxc*TWOCOL,&paCmnsbC[0][0]};

double pamnsb_C_mns_aCmnsbC   [mxr][mxc*TWOCOL];
matrix mamnsb_C_mns_aCmnsbC    ={mxr,mxc*TWOCOL,&pamnsb_C_mns_aCmnsbC   [0][0]};

                    mC.rows=n;                   mC.cols=p*TWOCOL;
                    maC.rows=n;                  maC.cols=p*TWOCOL;
                    mbC.rows=n;                  mbC.cols=p*TWOCOL;
               mamnsb_C.rows=n;             mamnsb_C.cols=p*TWOCOL;
               maCmnsbC.rows=n;             maCmnsbC.cols=p*TWOCOL;

               mamnsb_C_mns_aCmnsbC.rows=n;
               mamnsb_C_mns_aCmnsbC.cols=p*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  a.numer = (int)     (randF(9)+1);
  a.denom = (int) fabs(randF(9)+1);
  b.numer = (int)     (randF(9)+1);
  b.denom = (int) fabs(randF(9)+1);

  randmF(&mC,10,9);

  clrscrn();
  printf("                                                      ");
  printf("a = %.0f/%.0f\n\n",
          a.numer,
          a.denom);
  printf("                                                      ");
  printf("b = %.0f/%.0f\n\n",
          b.numer,
          b.denom);
  printf("                                                      C  :");
  printmF4(&mC);
  getchar();

  clrscrn();
  amnsb = subF(a,b);
  printf("                                      ");
  printf(" a - b = %.0f/%.0f - (%.0f/%.0f) = %.0f/%.0f\n\n",
              a.numer,    a.denom,
              b.numer,    b.denom,
          amnsb.numer,amnsb.denom);
  printf("                                                       C :");
  printmF4( &mC);
  printf("                                                 (a-b)C :\n");
  smultmF(amnsb,&mC,&mamnsb_C);
  printmF4(         &mamnsb_C);
  getchar();

  clrscrn();
  printf("                                                      ");
  printf("a = %.0f/%.0f\n\n",
          a.numer,
          a.denom);
  printf("                                                       C :");
  printmF4( &mC);
  printf("                                                      aC :\n");
  smultmF(a,&mC,&maC);
  printmF4(     &maC);
  getchar();

  clrscrn();
  printf("                                                      ");
  printf("b = %.0f/%.0f\n\n",
          b.numer,
          b.denom);
  printf("                                                       C :");
  printmF4( &mC);
  printf("                                                      bC :\n");
  smultmF(b,&mC,&mbC);
  printmF4(     &mbC);
  getchar();


  clrscrn();
  printf("                                                     aC  :");
  printmF4(&maC);
  printf("                                                     bC  :");
  printmF4(&mbC);
  printf("\n                                                 (aC-bC) :");
  submF(&maC,&mbC,&maCmnsbC);
  printmF4(       &maCmnsbC);
  getchar();

  clrscrn();
  printf("                                                 (a-c)C  :");
  printmF4(&mamnsb_C);
  printf("\n                                                 (aC-bC) :");
  printmF4(       &maCmnsbC);
  printf("\n                                      ((a-c)C) - (aC-bC) :");
  submF(&mamnsb_C,&maCmnsbC,&mamnsb_C_mns_aCmnsbC);
  printmF4(                 &mamnsb_C_mns_aCmnsbC);
}


void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            (a-c)C = aC-bC                        ");
  printf("\n            **************                      \n");
  printf("\n The size of  mC         : 1x1 ... 5x5.         \n");
  printf("\n     ex : \"pkf.exe\"                           \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"pkf.exe 2 3\" -> 2x3                  ");
  printf("\n          \"pkf.exe 1 5\" -> 1x5                  ");
  printf("\n          \"pkf.exe 4 2\" -> 4x2                  ");
  printf("\n          \"pkf.exe 5 5\" -> 5x5                  ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;

  srand(time(&t));
  hello();

do
{
if( argc == 3 && atoi(argv[1])&& atoi(argv[2]) )
 {
  n = atoi(argv[1]);
  p = atoi(argv[2]);

  if( n < 1){n=1;}
  if( n > 5){n=5;}
  if( p < 1){p=1;}
  if( p > 5){p=5;}
 }
else
 {
  n = (int) fabs(randF(5)+1);
  p = (int) fabs(randF(5)+1);
 }

  amnsb_C(n,p);

  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}












